# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AttachmentAccepterArgs', 'AttachmentAccepter']

@pulumi.input_type
class AttachmentAccepterArgs:
    def __init__(__self__, *,
                 attachment_id: pulumi.Input[builtins.str],
                 attachment_type: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a AttachmentAccepter resource.
        :param pulumi.Input[builtins.str] attachment_id: ID of the attachment.
        :param pulumi.Input[builtins.str] attachment_type: Type of attachment. Valid values: `CONNECT`, `DIRECT_CONNECT_GATEWAY`, `SITE_TO_SITE_VPN`, `TRANSIT_GATEWAY_ROUTE_TABLE`, `VPC`.
        """
        pulumi.set(__self__, "attachment_id", attachment_id)
        pulumi.set(__self__, "attachment_type", attachment_type)

    @property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the attachment.
        """
        return pulumi.get(self, "attachment_id")

    @attachment_id.setter
    def attachment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "attachment_id", value)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Input[builtins.str]:
        """
        Type of attachment. Valid values: `CONNECT`, `DIRECT_CONNECT_GATEWAY`, `SITE_TO_SITE_VPN`, `TRANSIT_GATEWAY_ROUTE_TABLE`, `VPC`.
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "attachment_type", value)


@pulumi.input_type
class _AttachmentAccepterState:
    def __init__(__self__, *,
                 attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 attachment_policy_rule_number: Optional[pulumi.Input[builtins.int]] = None,
                 attachment_type: Optional[pulumi.Input[builtins.str]] = None,
                 core_network_arn: Optional[pulumi.Input[builtins.str]] = None,
                 core_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 edge_location: Optional[pulumi.Input[builtins.str]] = None,
                 edge_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 owner_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[builtins.str]] = None,
                 segment_name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AttachmentAccepter resources.
        :param pulumi.Input[builtins.str] attachment_id: ID of the attachment.
        :param pulumi.Input[builtins.int] attachment_policy_rule_number: Policy rule number associated with the attachment.
        :param pulumi.Input[builtins.str] attachment_type: Type of attachment. Valid values: `CONNECT`, `DIRECT_CONNECT_GATEWAY`, `SITE_TO_SITE_VPN`, `TRANSIT_GATEWAY_ROUTE_TABLE`, `VPC`.
        :param pulumi.Input[builtins.str] core_network_arn: ARN of the core network.
        :param pulumi.Input[builtins.str] core_network_id: ID of the core network.
        :param pulumi.Input[builtins.str] edge_location: Region where the edge is located. This is returned for all attachment types except Direct Connect gateway attachments, which instead return `edge_locations`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] edge_locations: Edge locations that the Direct Connect gateway is associated with. This is returned only for Direct Connect gateway attachments. All other attachment types return `edge_location`.
        :param pulumi.Input[builtins.str] owner_account_id: ID of the attachment account owner.
        :param pulumi.Input[builtins.str] resource_arn: Attachment resource ARN.
        :param pulumi.Input[builtins.str] segment_name: Name of the segment attachment.
        :param pulumi.Input[builtins.str] state: State of the attachment.
        """
        if attachment_id is not None:
            pulumi.set(__self__, "attachment_id", attachment_id)
        if attachment_policy_rule_number is not None:
            pulumi.set(__self__, "attachment_policy_rule_number", attachment_policy_rule_number)
        if attachment_type is not None:
            pulumi.set(__self__, "attachment_type", attachment_type)
        if core_network_arn is not None:
            pulumi.set(__self__, "core_network_arn", core_network_arn)
        if core_network_id is not None:
            pulumi.set(__self__, "core_network_id", core_network_id)
        if edge_location is not None:
            pulumi.set(__self__, "edge_location", edge_location)
        if edge_locations is not None:
            pulumi.set(__self__, "edge_locations", edge_locations)
        if owner_account_id is not None:
            pulumi.set(__self__, "owner_account_id", owner_account_id)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)
        if segment_name is not None:
            pulumi.set(__self__, "segment_name", segment_name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the attachment.
        """
        return pulumi.get(self, "attachment_id")

    @attachment_id.setter
    def attachment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attachment_id", value)

    @property
    @pulumi.getter(name="attachmentPolicyRuleNumber")
    def attachment_policy_rule_number(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Policy rule number associated with the attachment.
        """
        return pulumi.get(self, "attachment_policy_rule_number")

    @attachment_policy_rule_number.setter
    def attachment_policy_rule_number(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "attachment_policy_rule_number", value)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of attachment. Valid values: `CONNECT`, `DIRECT_CONNECT_GATEWAY`, `SITE_TO_SITE_VPN`, `TRANSIT_GATEWAY_ROUTE_TABLE`, `VPC`.
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attachment_type", value)

    @property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the core network.
        """
        return pulumi.get(self, "core_network_arn")

    @core_network_arn.setter
    def core_network_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "core_network_arn", value)

    @property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the core network.
        """
        return pulumi.get(self, "core_network_id")

    @core_network_id.setter
    def core_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "core_network_id", value)

    @property
    @pulumi.getter(name="edgeLocation")
    def edge_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where the edge is located. This is returned for all attachment types except Direct Connect gateway attachments, which instead return `edge_locations`.
        """
        return pulumi.get(self, "edge_location")

    @edge_location.setter
    def edge_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edge_location", value)

    @property
    @pulumi.getter(name="edgeLocations")
    def edge_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Edge locations that the Direct Connect gateway is associated with. This is returned only for Direct Connect gateway attachments. All other attachment types return `edge_location`.
        """
        return pulumi.get(self, "edge_locations")

    @edge_locations.setter
    def edge_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "edge_locations", value)

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the attachment account owner.
        """
        return pulumi.get(self, "owner_account_id")

    @owner_account_id.setter
    def owner_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_account_id", value)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Attachment resource ARN.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_arn", value)

    @property
    @pulumi.getter(name="segmentName")
    def segment_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the segment attachment.
        """
        return pulumi.get(self, "segment_name")

    @segment_name.setter
    def segment_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "segment_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        State of the attachment.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("aws:networkmanager/attachmentAccepter:AttachmentAccepter")
class AttachmentAccepter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 attachment_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an AWS Network Manager Attachment Accepter.

        Use this resource to accept cross-account attachments in AWS Network Manager. When an attachment is created in one account and needs to be accepted by another account that owns the core network, this resource handles the acceptance process.

        ## Example Usage

        ### VPC Attachment

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.AttachmentAccepter("example",
            attachment_id=example_aws_networkmanager_vpc_attachment["id"],
            attachment_type=example_aws_networkmanager_vpc_attachment["attachmentType"])
        ```

        ### Site-to-Site VPN Attachment

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.AttachmentAccepter("example",
            attachment_id=example_aws_networkmanager_site_to_site_vpn_attachment["id"],
            attachment_type=example_aws_networkmanager_site_to_site_vpn_attachment["attachmentType"])
        ```

        ### Connect Attachment

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.AttachmentAccepter("example",
            attachment_id=example_aws_networkmanager_connect_attachment["id"],
            attachment_type=example_aws_networkmanager_connect_attachment["attachmentType"])
        ```

        ### Transit Gateway Route Table Attachment

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.AttachmentAccepter("example",
            attachment_id=example_aws_networkmanager_transit_gateway_route_table_attachment["id"],
            attachment_type=example_aws_networkmanager_transit_gateway_route_table_attachment["attachmentType"])
        ```

        ### Direct Connect Gateway Attachment

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.AttachmentAccepter("example",
            attachment_id=example_aws_networkmanager_dx_gateway_attachment["id"],
            attachment_type=example_aws_networkmanager_dx_gateway_attachment["attachmentType"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] attachment_id: ID of the attachment.
        :param pulumi.Input[builtins.str] attachment_type: Type of attachment. Valid values: `CONNECT`, `DIRECT_CONNECT_GATEWAY`, `SITE_TO_SITE_VPN`, `TRANSIT_GATEWAY_ROUTE_TABLE`, `VPC`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AttachmentAccepterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Network Manager Attachment Accepter.

        Use this resource to accept cross-account attachments in AWS Network Manager. When an attachment is created in one account and needs to be accepted by another account that owns the core network, this resource handles the acceptance process.

        ## Example Usage

        ### VPC Attachment

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.AttachmentAccepter("example",
            attachment_id=example_aws_networkmanager_vpc_attachment["id"],
            attachment_type=example_aws_networkmanager_vpc_attachment["attachmentType"])
        ```

        ### Site-to-Site VPN Attachment

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.AttachmentAccepter("example",
            attachment_id=example_aws_networkmanager_site_to_site_vpn_attachment["id"],
            attachment_type=example_aws_networkmanager_site_to_site_vpn_attachment["attachmentType"])
        ```

        ### Connect Attachment

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.AttachmentAccepter("example",
            attachment_id=example_aws_networkmanager_connect_attachment["id"],
            attachment_type=example_aws_networkmanager_connect_attachment["attachmentType"])
        ```

        ### Transit Gateway Route Table Attachment

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.AttachmentAccepter("example",
            attachment_id=example_aws_networkmanager_transit_gateway_route_table_attachment["id"],
            attachment_type=example_aws_networkmanager_transit_gateway_route_table_attachment["attachmentType"])
        ```

        ### Direct Connect Gateway Attachment

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.AttachmentAccepter("example",
            attachment_id=example_aws_networkmanager_dx_gateway_attachment["id"],
            attachment_type=example_aws_networkmanager_dx_gateway_attachment["attachmentType"])
        ```

        :param str resource_name: The name of the resource.
        :param AttachmentAccepterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AttachmentAccepterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachment_id: Optional[pulumi.Input[builtins.str]] = None,
                 attachment_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AttachmentAccepterArgs.__new__(AttachmentAccepterArgs)

            if attachment_id is None and not opts.urn:
                raise TypeError("Missing required property 'attachment_id'")
            __props__.__dict__["attachment_id"] = attachment_id
            if attachment_type is None and not opts.urn:
                raise TypeError("Missing required property 'attachment_type'")
            __props__.__dict__["attachment_type"] = attachment_type
            __props__.__dict__["attachment_policy_rule_number"] = None
            __props__.__dict__["core_network_arn"] = None
            __props__.__dict__["core_network_id"] = None
            __props__.__dict__["edge_location"] = None
            __props__.__dict__["edge_locations"] = None
            __props__.__dict__["owner_account_id"] = None
            __props__.__dict__["resource_arn"] = None
            __props__.__dict__["segment_name"] = None
            __props__.__dict__["state"] = None
        super(AttachmentAccepter, __self__).__init__(
            'aws:networkmanager/attachmentAccepter:AttachmentAccepter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachment_id: Optional[pulumi.Input[builtins.str]] = None,
            attachment_policy_rule_number: Optional[pulumi.Input[builtins.int]] = None,
            attachment_type: Optional[pulumi.Input[builtins.str]] = None,
            core_network_arn: Optional[pulumi.Input[builtins.str]] = None,
            core_network_id: Optional[pulumi.Input[builtins.str]] = None,
            edge_location: Optional[pulumi.Input[builtins.str]] = None,
            edge_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            owner_account_id: Optional[pulumi.Input[builtins.str]] = None,
            resource_arn: Optional[pulumi.Input[builtins.str]] = None,
            segment_name: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None) -> 'AttachmentAccepter':
        """
        Get an existing AttachmentAccepter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] attachment_id: ID of the attachment.
        :param pulumi.Input[builtins.int] attachment_policy_rule_number: Policy rule number associated with the attachment.
        :param pulumi.Input[builtins.str] attachment_type: Type of attachment. Valid values: `CONNECT`, `DIRECT_CONNECT_GATEWAY`, `SITE_TO_SITE_VPN`, `TRANSIT_GATEWAY_ROUTE_TABLE`, `VPC`.
        :param pulumi.Input[builtins.str] core_network_arn: ARN of the core network.
        :param pulumi.Input[builtins.str] core_network_id: ID of the core network.
        :param pulumi.Input[builtins.str] edge_location: Region where the edge is located. This is returned for all attachment types except Direct Connect gateway attachments, which instead return `edge_locations`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] edge_locations: Edge locations that the Direct Connect gateway is associated with. This is returned only for Direct Connect gateway attachments. All other attachment types return `edge_location`.
        :param pulumi.Input[builtins.str] owner_account_id: ID of the attachment account owner.
        :param pulumi.Input[builtins.str] resource_arn: Attachment resource ARN.
        :param pulumi.Input[builtins.str] segment_name: Name of the segment attachment.
        :param pulumi.Input[builtins.str] state: State of the attachment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AttachmentAccepterState.__new__(_AttachmentAccepterState)

        __props__.__dict__["attachment_id"] = attachment_id
        __props__.__dict__["attachment_policy_rule_number"] = attachment_policy_rule_number
        __props__.__dict__["attachment_type"] = attachment_type
        __props__.__dict__["core_network_arn"] = core_network_arn
        __props__.__dict__["core_network_id"] = core_network_id
        __props__.__dict__["edge_location"] = edge_location
        __props__.__dict__["edge_locations"] = edge_locations
        __props__.__dict__["owner_account_id"] = owner_account_id
        __props__.__dict__["resource_arn"] = resource_arn
        __props__.__dict__["segment_name"] = segment_name
        __props__.__dict__["state"] = state
        return AttachmentAccepter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attachmentId")
    def attachment_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the attachment.
        """
        return pulumi.get(self, "attachment_id")

    @property
    @pulumi.getter(name="attachmentPolicyRuleNumber")
    def attachment_policy_rule_number(self) -> pulumi.Output[builtins.int]:
        """
        Policy rule number associated with the attachment.
        """
        return pulumi.get(self, "attachment_policy_rule_number")

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of attachment. Valid values: `CONNECT`, `DIRECT_CONNECT_GATEWAY`, `SITE_TO_SITE_VPN`, `TRANSIT_GATEWAY_ROUTE_TABLE`, `VPC`.
        """
        return pulumi.get(self, "attachment_type")

    @property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the core network.
        """
        return pulumi.get(self, "core_network_arn")

    @property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the core network.
        """
        return pulumi.get(self, "core_network_id")

    @property
    @pulumi.getter(name="edgeLocation")
    def edge_location(self) -> pulumi.Output[builtins.str]:
        """
        Region where the edge is located. This is returned for all attachment types except Direct Connect gateway attachments, which instead return `edge_locations`.
        """
        return pulumi.get(self, "edge_location")

    @property
    @pulumi.getter(name="edgeLocations")
    def edge_locations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Edge locations that the Direct Connect gateway is associated with. This is returned only for Direct Connect gateway attachments. All other attachment types return `edge_location`.
        """
        return pulumi.get(self, "edge_locations")

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the attachment account owner.
        """
        return pulumi.get(self, "owner_account_id")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[builtins.str]:
        """
        Attachment resource ARN.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter(name="segmentName")
    def segment_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the segment attachment.
        """
        return pulumi.get(self, "segment_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        State of the attachment.
        """
        return pulumi.get(self, "state")

