# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeviceArgs', 'Device']

@pulumi.input_type
class DeviceArgs:
    def __init__(__self__, *,
                 global_network_id: pulumi.Input[builtins.str],
                 aws_location: Optional[pulumi.Input['DeviceAwsLocationArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input['DeviceLocationArgs']] = None,
                 model: Optional[pulumi.Input[builtins.str]] = None,
                 serial_number: Optional[pulumi.Input[builtins.str]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vendor: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Device resource.
        :param pulumi.Input[builtins.str] global_network_id: ID of the global network.
               
               The following arguments are optional:
        :param pulumi.Input['DeviceAwsLocationArgs'] aws_location: AWS location of the device. Documented below.
        :param pulumi.Input[builtins.str] description: Description of the device.
        :param pulumi.Input['DeviceLocationArgs'] location: Location of the device. Documented below.
        :param pulumi.Input[builtins.str] model: Model of device.
        :param pulumi.Input[builtins.str] serial_number: Serial number of the device.
        :param pulumi.Input[builtins.str] site_id: ID of the site.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value tags for the device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] type: Type of device.
        :param pulumi.Input[builtins.str] vendor: Vendor of the device.
        """
        pulumi.set(__self__, "global_network_id", global_network_id)
        if aws_location is not None:
            pulumi.set(__self__, "aws_location", aws_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter(name="globalNetworkId")
    def global_network_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the global network.

        The following arguments are optional:
        """
        return pulumi.get(self, "global_network_id")

    @global_network_id.setter
    def global_network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "global_network_id", value)

    @property
    @pulumi.getter(name="awsLocation")
    def aws_location(self) -> Optional[pulumi.Input['DeviceAwsLocationArgs']]:
        """
        AWS location of the device. Documented below.
        """
        return pulumi.get(self, "aws_location")

    @aws_location.setter
    def aws_location(self, value: Optional[pulumi.Input['DeviceAwsLocationArgs']]):
        pulumi.set(self, "aws_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the device.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['DeviceLocationArgs']]:
        """
        Location of the device. Documented below.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['DeviceLocationArgs']]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Model of device.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Serial number of the device.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "serial_number", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the site.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value tags for the device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of device.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def vendor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Vendor of the device.
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vendor", value)


@pulumi.input_type
class _DeviceState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 aws_location: Optional[pulumi.Input['DeviceAwsLocationArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 global_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input['DeviceLocationArgs']] = None,
                 model: Optional[pulumi.Input[builtins.str]] = None,
                 serial_number: Optional[pulumi.Input[builtins.str]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vendor: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Device resources.
        :param pulumi.Input[builtins.str] arn: ARN of the device.
        :param pulumi.Input['DeviceAwsLocationArgs'] aws_location: AWS location of the device. Documented below.
        :param pulumi.Input[builtins.str] description: Description of the device.
        :param pulumi.Input[builtins.str] global_network_id: ID of the global network.
               
               The following arguments are optional:
        :param pulumi.Input['DeviceLocationArgs'] location: Location of the device. Documented below.
        :param pulumi.Input[builtins.str] model: Model of device.
        :param pulumi.Input[builtins.str] serial_number: Serial number of the device.
        :param pulumi.Input[builtins.str] site_id: ID of the site.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value tags for the device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] type: Type of device.
        :param pulumi.Input[builtins.str] vendor: Vendor of the device.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if aws_location is not None:
            pulumi.set(__self__, "aws_location", aws_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if global_network_id is not None:
            pulumi.set(__self__, "global_network_id", global_network_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the device.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="awsLocation")
    def aws_location(self) -> Optional[pulumi.Input['DeviceAwsLocationArgs']]:
        """
        AWS location of the device. Documented below.
        """
        return pulumi.get(self, "aws_location")

    @aws_location.setter
    def aws_location(self, value: Optional[pulumi.Input['DeviceAwsLocationArgs']]):
        pulumi.set(self, "aws_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the device.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="globalNetworkId")
    def global_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the global network.

        The following arguments are optional:
        """
        return pulumi.get(self, "global_network_id")

    @global_network_id.setter
    def global_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "global_network_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['DeviceLocationArgs']]:
        """
        Location of the device. Documented below.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['DeviceLocationArgs']]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Model of device.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Serial number of the device.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "serial_number", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the site.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value tags for the device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of device.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def vendor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Vendor of the device.
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vendor", value)


@pulumi.type_token("aws:networkmanager/device:Device")
class Device(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_location: Optional[pulumi.Input[Union['DeviceAwsLocationArgs', 'DeviceAwsLocationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 global_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[Union['DeviceLocationArgs', 'DeviceLocationArgsDict']]] = None,
                 model: Optional[pulumi.Input[builtins.str]] = None,
                 serial_number: Optional[pulumi.Input[builtins.str]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vendor: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Network Manager Device.

        Use this resource to create a device in a global network. If you specify both a site ID and a location, the location of the site is used for visualization in the Network Manager console.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.Device("example",
            global_network_id=example_aws_networkmanager_global_network["id"],
            site_id=example_aws_networkmanager_site["id"])
        ```

        ## Import

        Using `pulumi import`, import `aws_networkmanager_device` using the device ARN. For example:

        ```sh
        $ pulumi import aws:networkmanager/device:Device example arn:aws:networkmanager::123456789012:device/global-network-0d47f6t230mz46dy4/device-07f6fd08867abc123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DeviceAwsLocationArgs', 'DeviceAwsLocationArgsDict']] aws_location: AWS location of the device. Documented below.
        :param pulumi.Input[builtins.str] description: Description of the device.
        :param pulumi.Input[builtins.str] global_network_id: ID of the global network.
               
               The following arguments are optional:
        :param pulumi.Input[Union['DeviceLocationArgs', 'DeviceLocationArgsDict']] location: Location of the device. Documented below.
        :param pulumi.Input[builtins.str] model: Model of device.
        :param pulumi.Input[builtins.str] serial_number: Serial number of the device.
        :param pulumi.Input[builtins.str] site_id: ID of the site.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value tags for the device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] type: Type of device.
        :param pulumi.Input[builtins.str] vendor: Vendor of the device.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeviceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Network Manager Device.

        Use this resource to create a device in a global network. If you specify both a site ID and a location, the location of the site is used for visualization in the Network Manager console.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.Device("example",
            global_network_id=example_aws_networkmanager_global_network["id"],
            site_id=example_aws_networkmanager_site["id"])
        ```

        ## Import

        Using `pulumi import`, import `aws_networkmanager_device` using the device ARN. For example:

        ```sh
        $ pulumi import aws:networkmanager/device:Device example arn:aws:networkmanager::123456789012:device/global-network-0d47f6t230mz46dy4/device-07f6fd08867abc123
        ```

        :param str resource_name: The name of the resource.
        :param DeviceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeviceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_location: Optional[pulumi.Input[Union['DeviceAwsLocationArgs', 'DeviceAwsLocationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 global_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[Union['DeviceLocationArgs', 'DeviceLocationArgsDict']]] = None,
                 model: Optional[pulumi.Input[builtins.str]] = None,
                 serial_number: Optional[pulumi.Input[builtins.str]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vendor: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeviceArgs.__new__(DeviceArgs)

            __props__.__dict__["aws_location"] = aws_location
            __props__.__dict__["description"] = description
            if global_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'global_network_id'")
            __props__.__dict__["global_network_id"] = global_network_id
            __props__.__dict__["location"] = location
            __props__.__dict__["model"] = model
            __props__.__dict__["serial_number"] = serial_number
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["vendor"] = vendor
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Device, __self__).__init__(
            'aws:networkmanager/device:Device',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            aws_location: Optional[pulumi.Input[Union['DeviceAwsLocationArgs', 'DeviceAwsLocationArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            global_network_id: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[Union['DeviceLocationArgs', 'DeviceLocationArgsDict']]] = None,
            model: Optional[pulumi.Input[builtins.str]] = None,
            serial_number: Optional[pulumi.Input[builtins.str]] = None,
            site_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            vendor: Optional[pulumi.Input[builtins.str]] = None) -> 'Device':
        """
        Get an existing Device resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the device.
        :param pulumi.Input[Union['DeviceAwsLocationArgs', 'DeviceAwsLocationArgsDict']] aws_location: AWS location of the device. Documented below.
        :param pulumi.Input[builtins.str] description: Description of the device.
        :param pulumi.Input[builtins.str] global_network_id: ID of the global network.
               
               The following arguments are optional:
        :param pulumi.Input[Union['DeviceLocationArgs', 'DeviceLocationArgsDict']] location: Location of the device. Documented below.
        :param pulumi.Input[builtins.str] model: Model of device.
        :param pulumi.Input[builtins.str] serial_number: Serial number of the device.
        :param pulumi.Input[builtins.str] site_id: ID of the site.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value tags for the device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] type: Type of device.
        :param pulumi.Input[builtins.str] vendor: Vendor of the device.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeviceState.__new__(_DeviceState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["aws_location"] = aws_location
        __props__.__dict__["description"] = description
        __props__.__dict__["global_network_id"] = global_network_id
        __props__.__dict__["location"] = location
        __props__.__dict__["model"] = model
        __props__.__dict__["serial_number"] = serial_number
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["type"] = type
        __props__.__dict__["vendor"] = vendor
        return Device(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the device.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsLocation")
    def aws_location(self) -> pulumi.Output[Optional['outputs.DeviceAwsLocation']]:
        """
        AWS location of the device. Documented below.
        """
        return pulumi.get(self, "aws_location")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the device.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="globalNetworkId")
    def global_network_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the global network.

        The following arguments are optional:
        """
        return pulumi.get(self, "global_network_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional['outputs.DeviceLocation']]:
        """
        Location of the device. Documented below.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def model(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Model of device.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Serial number of the device.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ID of the site.
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value tags for the device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Type of device.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def vendor(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Vendor of the device.
        """
        return pulumi.get(self, "vendor")

