# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DxGatewayAttachmentArgs', 'DxGatewayAttachment']

@pulumi.input_type
class DxGatewayAttachmentArgs:
    def __init__(__self__, *,
                 core_network_id: pulumi.Input[builtins.str],
                 direct_connect_gateway_arn: pulumi.Input[builtins.str],
                 edge_locations: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['DxGatewayAttachmentTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a DxGatewayAttachment resource.
        :param pulumi.Input[builtins.str] core_network_id: ID of the Cloud WAN core network to which the Direct Connect gateway attachment should be attached.
        :param pulumi.Input[builtins.str] direct_connect_gateway_arn: ARN of the Direct Connect gateway attachment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] edge_locations: One or more core network edge locations to associate with the Direct Connect gateway attachment.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "core_network_id", core_network_id)
        pulumi.set(__self__, "direct_connect_gateway_arn", direct_connect_gateway_arn)
        pulumi.set(__self__, "edge_locations", edge_locations)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the Cloud WAN core network to which the Direct Connect gateway attachment should be attached.
        """
        return pulumi.get(self, "core_network_id")

    @core_network_id.setter
    def core_network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "core_network_id", value)

    @property
    @pulumi.getter(name="directConnectGatewayArn")
    def direct_connect_gateway_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the Direct Connect gateway attachment.
        """
        return pulumi.get(self, "direct_connect_gateway_arn")

    @direct_connect_gateway_arn.setter
    def direct_connect_gateway_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "direct_connect_gateway_arn", value)

    @property
    @pulumi.getter(name="edgeLocations")
    def edge_locations(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        One or more core network edge locations to associate with the Direct Connect gateway attachment.

        The following arguments are optional:
        """
        return pulumi.get(self, "edge_locations")

    @edge_locations.setter
    def edge_locations(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "edge_locations", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DxGatewayAttachmentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DxGatewayAttachmentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _DxGatewayAttachmentState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 attachment_policy_rule_number: Optional[pulumi.Input[builtins.int]] = None,
                 attachment_type: Optional[pulumi.Input[builtins.str]] = None,
                 core_network_arn: Optional[pulumi.Input[builtins.str]] = None,
                 core_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 direct_connect_gateway_arn: Optional[pulumi.Input[builtins.str]] = None,
                 edge_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 owner_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 segment_name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['DxGatewayAttachmentTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering DxGatewayAttachment resources.
        :param pulumi.Input[builtins.str] arn: ARN of the attachment.
        :param pulumi.Input[builtins.int] attachment_policy_rule_number: Policy rule number associated with the attachment.
        :param pulumi.Input[builtins.str] attachment_type: Type of attachment.
        :param pulumi.Input[builtins.str] core_network_arn: ARN of the core network for the attachment.
        :param pulumi.Input[builtins.str] core_network_id: ID of the Cloud WAN core network to which the Direct Connect gateway attachment should be attached.
        :param pulumi.Input[builtins.str] direct_connect_gateway_arn: ARN of the Direct Connect gateway attachment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] edge_locations: One or more core network edge locations to associate with the Direct Connect gateway attachment.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] owner_account_id: ID of the attachment account owner.
        :param pulumi.Input[builtins.str] segment_name: Name of the segment attachment.
        :param pulumi.Input[builtins.str] state: State of the attachment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if attachment_policy_rule_number is not None:
            pulumi.set(__self__, "attachment_policy_rule_number", attachment_policy_rule_number)
        if attachment_type is not None:
            pulumi.set(__self__, "attachment_type", attachment_type)
        if core_network_arn is not None:
            pulumi.set(__self__, "core_network_arn", core_network_arn)
        if core_network_id is not None:
            pulumi.set(__self__, "core_network_id", core_network_id)
        if direct_connect_gateway_arn is not None:
            pulumi.set(__self__, "direct_connect_gateway_arn", direct_connect_gateway_arn)
        if edge_locations is not None:
            pulumi.set(__self__, "edge_locations", edge_locations)
        if owner_account_id is not None:
            pulumi.set(__self__, "owner_account_id", owner_account_id)
        if segment_name is not None:
            pulumi.set(__self__, "segment_name", segment_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the attachment.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="attachmentPolicyRuleNumber")
    def attachment_policy_rule_number(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Policy rule number associated with the attachment.
        """
        return pulumi.get(self, "attachment_policy_rule_number")

    @attachment_policy_rule_number.setter
    def attachment_policy_rule_number(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "attachment_policy_rule_number", value)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of attachment.
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attachment_type", value)

    @property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the core network for the attachment.
        """
        return pulumi.get(self, "core_network_arn")

    @core_network_arn.setter
    def core_network_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "core_network_arn", value)

    @property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the Cloud WAN core network to which the Direct Connect gateway attachment should be attached.
        """
        return pulumi.get(self, "core_network_id")

    @core_network_id.setter
    def core_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "core_network_id", value)

    @property
    @pulumi.getter(name="directConnectGatewayArn")
    def direct_connect_gateway_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Direct Connect gateway attachment.
        """
        return pulumi.get(self, "direct_connect_gateway_arn")

    @direct_connect_gateway_arn.setter
    def direct_connect_gateway_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "direct_connect_gateway_arn", value)

    @property
    @pulumi.getter(name="edgeLocations")
    def edge_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more core network edge locations to associate with the Direct Connect gateway attachment.

        The following arguments are optional:
        """
        return pulumi.get(self, "edge_locations")

    @edge_locations.setter
    def edge_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "edge_locations", value)

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the attachment account owner.
        """
        return pulumi.get(self, "owner_account_id")

    @owner_account_id.setter
    def owner_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_account_id", value)

    @property
    @pulumi.getter(name="segmentName")
    def segment_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the segment attachment.
        """
        return pulumi.get(self, "segment_name")

    @segment_name.setter
    def segment_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "segment_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        State of the attachment.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DxGatewayAttachmentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DxGatewayAttachmentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:networkmanager/dxGatewayAttachment:DxGatewayAttachment")
class DxGatewayAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 core_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 direct_connect_gateway_arn: Optional[pulumi.Input[builtins.str]] = None,
                 edge_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['DxGatewayAttachmentTimeoutsArgs', 'DxGatewayAttachmentTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Network Manager Direct Connect Gateway Attachment.

        Use this resource to create and manage a Direct Connect Gateway attachment to a Cloud WAN core network.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.networkmanager.DxGatewayAttachment("test",
            core_network_id=test_aws_networkmanager_core_network_policy_attachment["coreNetworkId"],
            direct_connect_gateway_arn=f"arn:aws:directconnect::{current['accountId']}:dx-gateway/{test_aws_dx_gateway['id']}",
            edge_locations=[current_aws_region["region"]])
        ```

        ## Import

        Using `pulumi import`, import Network Manager DX Gateway Attachment using the `id`. For example:

        ```sh
        $ pulumi import aws:networkmanager/dxGatewayAttachment:DxGatewayAttachment example attachment-1a2b3c4d5e6f7g
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] core_network_id: ID of the Cloud WAN core network to which the Direct Connect gateway attachment should be attached.
        :param pulumi.Input[builtins.str] direct_connect_gateway_arn: ARN of the Direct Connect gateway attachment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] edge_locations: One or more core network edge locations to associate with the Direct Connect gateway attachment.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DxGatewayAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Network Manager Direct Connect Gateway Attachment.

        Use this resource to create and manage a Direct Connect Gateway attachment to a Cloud WAN core network.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.networkmanager.DxGatewayAttachment("test",
            core_network_id=test_aws_networkmanager_core_network_policy_attachment["coreNetworkId"],
            direct_connect_gateway_arn=f"arn:aws:directconnect::{current['accountId']}:dx-gateway/{test_aws_dx_gateway['id']}",
            edge_locations=[current_aws_region["region"]])
        ```

        ## Import

        Using `pulumi import`, import Network Manager DX Gateway Attachment using the `id`. For example:

        ```sh
        $ pulumi import aws:networkmanager/dxGatewayAttachment:DxGatewayAttachment example attachment-1a2b3c4d5e6f7g
        ```

        :param str resource_name: The name of the resource.
        :param DxGatewayAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DxGatewayAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 core_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 direct_connect_gateway_arn: Optional[pulumi.Input[builtins.str]] = None,
                 edge_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['DxGatewayAttachmentTimeoutsArgs', 'DxGatewayAttachmentTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DxGatewayAttachmentArgs.__new__(DxGatewayAttachmentArgs)

            if core_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'core_network_id'")
            __props__.__dict__["core_network_id"] = core_network_id
            if direct_connect_gateway_arn is None and not opts.urn:
                raise TypeError("Missing required property 'direct_connect_gateway_arn'")
            __props__.__dict__["direct_connect_gateway_arn"] = direct_connect_gateway_arn
            if edge_locations is None and not opts.urn:
                raise TypeError("Missing required property 'edge_locations'")
            __props__.__dict__["edge_locations"] = edge_locations
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["attachment_policy_rule_number"] = None
            __props__.__dict__["attachment_type"] = None
            __props__.__dict__["core_network_arn"] = None
            __props__.__dict__["owner_account_id"] = None
            __props__.__dict__["segment_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["tags_all"] = None
        super(DxGatewayAttachment, __self__).__init__(
            'aws:networkmanager/dxGatewayAttachment:DxGatewayAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            attachment_policy_rule_number: Optional[pulumi.Input[builtins.int]] = None,
            attachment_type: Optional[pulumi.Input[builtins.str]] = None,
            core_network_arn: Optional[pulumi.Input[builtins.str]] = None,
            core_network_id: Optional[pulumi.Input[builtins.str]] = None,
            direct_connect_gateway_arn: Optional[pulumi.Input[builtins.str]] = None,
            edge_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            owner_account_id: Optional[pulumi.Input[builtins.str]] = None,
            segment_name: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['DxGatewayAttachmentTimeoutsArgs', 'DxGatewayAttachmentTimeoutsArgsDict']]] = None) -> 'DxGatewayAttachment':
        """
        Get an existing DxGatewayAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the attachment.
        :param pulumi.Input[builtins.int] attachment_policy_rule_number: Policy rule number associated with the attachment.
        :param pulumi.Input[builtins.str] attachment_type: Type of attachment.
        :param pulumi.Input[builtins.str] core_network_arn: ARN of the core network for the attachment.
        :param pulumi.Input[builtins.str] core_network_id: ID of the Cloud WAN core network to which the Direct Connect gateway attachment should be attached.
        :param pulumi.Input[builtins.str] direct_connect_gateway_arn: ARN of the Direct Connect gateway attachment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] edge_locations: One or more core network edge locations to associate with the Direct Connect gateway attachment.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] owner_account_id: ID of the attachment account owner.
        :param pulumi.Input[builtins.str] segment_name: Name of the segment attachment.
        :param pulumi.Input[builtins.str] state: State of the attachment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DxGatewayAttachmentState.__new__(_DxGatewayAttachmentState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["attachment_policy_rule_number"] = attachment_policy_rule_number
        __props__.__dict__["attachment_type"] = attachment_type
        __props__.__dict__["core_network_arn"] = core_network_arn
        __props__.__dict__["core_network_id"] = core_network_id
        __props__.__dict__["direct_connect_gateway_arn"] = direct_connect_gateway_arn
        __props__.__dict__["edge_locations"] = edge_locations
        __props__.__dict__["owner_account_id"] = owner_account_id
        __props__.__dict__["segment_name"] = segment_name
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return DxGatewayAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the attachment.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="attachmentPolicyRuleNumber")
    def attachment_policy_rule_number(self) -> pulumi.Output[builtins.int]:
        """
        Policy rule number associated with the attachment.
        """
        return pulumi.get(self, "attachment_policy_rule_number")

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of attachment.
        """
        return pulumi.get(self, "attachment_type")

    @property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the core network for the attachment.
        """
        return pulumi.get(self, "core_network_arn")

    @property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the Cloud WAN core network to which the Direct Connect gateway attachment should be attached.
        """
        return pulumi.get(self, "core_network_id")

    @property
    @pulumi.getter(name="directConnectGatewayArn")
    def direct_connect_gateway_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Direct Connect gateway attachment.
        """
        return pulumi.get(self, "direct_connect_gateway_arn")

    @property
    @pulumi.getter(name="edgeLocations")
    def edge_locations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        One or more core network edge locations to associate with the Direct Connect gateway attachment.

        The following arguments are optional:
        """
        return pulumi.get(self, "edge_locations")

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the attachment account owner.
        """
        return pulumi.get(self, "owner_account_id")

    @property
    @pulumi.getter(name="segmentName")
    def segment_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the segment attachment.
        """
        return pulumi.get(self, "segment_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        State of the attachment.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.DxGatewayAttachmentTimeouts']]:
        return pulumi.get(self, "timeouts")

