# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetConnectionsResult',
    'AwaitableGetConnectionsResult',
    'get_connections',
    'get_connections_output',
]

@pulumi.output_type
class GetConnectionsResult:
    """
    A collection of values returned by getConnections.
    """
    def __init__(__self__, device_id=None, global_network_id=None, id=None, ids=None, tags=None):
        if device_id and not isinstance(device_id, str):
            raise TypeError("Expected argument 'device_id' to be a str")
        pulumi.set(__self__, "device_id", device_id)
        if global_network_id and not isinstance(global_network_id, str):
            raise TypeError("Expected argument 'global_network_id' to be a str")
        pulumi.set(__self__, "global_network_id", global_network_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="globalNetworkId")
    def global_network_id(self) -> builtins.str:
        return pulumi.get(self, "global_network_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[builtins.str]:
        """
        IDs of the connections.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags")


class AwaitableGetConnectionsResult(GetConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionsResult(
            device_id=self.device_id,
            global_network_id=self.global_network_id,
            id=self.id,
            ids=self.ids,
            tags=self.tags)


def get_connections(device_id: Optional[builtins.str] = None,
                    global_network_id: Optional[builtins.str] = None,
                    tags: Optional[Mapping[str, builtins.str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionsResult:
    """
    Provides details about existing Network Manager connections.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.networkmanager.get_connections(global_network_id=global_network_id,
        tags={
            "Env": "test",
        })
    ```


    :param builtins.str device_id: ID of the device of the connections to retrieve.
    :param builtins.str global_network_id: ID of the Global Network of the connections to retrieve.
    :param Mapping[str, builtins.str] tags: Restricts the list to the connections with these tags.
    """
    __args__ = dict()
    __args__['deviceId'] = device_id
    __args__['globalNetworkId'] = global_network_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:networkmanager/getConnections:getConnections', __args__, opts=opts, typ=GetConnectionsResult).value

    return AwaitableGetConnectionsResult(
        device_id=pulumi.get(__ret__, 'device_id'),
        global_network_id=pulumi.get(__ret__, 'global_network_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        tags=pulumi.get(__ret__, 'tags'))
def get_connections_output(device_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           global_network_id: Optional[pulumi.Input[builtins.str]] = None,
                           tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectionsResult]:
    """
    Provides details about existing Network Manager connections.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.networkmanager.get_connections(global_network_id=global_network_id,
        tags={
            "Env": "test",
        })
    ```


    :param builtins.str device_id: ID of the device of the connections to retrieve.
    :param builtins.str global_network_id: ID of the Global Network of the connections to retrieve.
    :param Mapping[str, builtins.str] tags: Restricts the list to the connections with these tags.
    """
    __args__ = dict()
    __args__['deviceId'] = device_id
    __args__['globalNetworkId'] = global_network_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:networkmanager/getConnections:getConnections', __args__, opts=opts, typ=GetConnectionsResult)
    return __ret__.apply(lambda __response__: GetConnectionsResult(
        device_id=pulumi.get(__response__, 'device_id'),
        global_network_id=pulumi.get(__response__, 'global_network_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        tags=pulumi.get(__response__, 'tags')))
