# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetGlobalNetworkResult',
    'AwaitableGetGlobalNetworkResult',
    'get_global_network',
    'get_global_network_output',
]

@pulumi.output_type
class GetGlobalNetworkResult:
    """
    A collection of values returned by getGlobalNetwork.
    """
    def __init__(__self__, arn=None, description=None, global_network_id=None, id=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if global_network_id and not isinstance(global_network_id, str):
            raise TypeError("Expected argument 'global_network_id' to be a str")
        pulumi.set(__self__, "global_network_id", global_network_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the global network.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the global network.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="globalNetworkId")
    def global_network_id(self) -> builtins.str:
        return pulumi.get(self, "global_network_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Map of resource tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetGlobalNetworkResult(GetGlobalNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGlobalNetworkResult(
            arn=self.arn,
            description=self.description,
            global_network_id=self.global_network_id,
            id=self.id,
            tags=self.tags)


def get_global_network(global_network_id: Optional[builtins.str] = None,
                       tags: Optional[Mapping[str, builtins.str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGlobalNetworkResult:
    """
    Provides details about an existing Network Manager global network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.networkmanager.get_global_network(global_network_id=global_network_id)
    ```


    :param builtins.str global_network_id: ID of the specific global network to retrieve.
    :param Mapping[str, builtins.str] tags: Map of resource tags.
    """
    __args__ = dict()
    __args__['globalNetworkId'] = global_network_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:networkmanager/getGlobalNetwork:getGlobalNetwork', __args__, opts=opts, typ=GetGlobalNetworkResult).value

    return AwaitableGetGlobalNetworkResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        global_network_id=pulumi.get(__ret__, 'global_network_id'),
        id=pulumi.get(__ret__, 'id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_global_network_output(global_network_id: Optional[pulumi.Input[builtins.str]] = None,
                              tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGlobalNetworkResult]:
    """
    Provides details about an existing Network Manager global network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.networkmanager.get_global_network(global_network_id=global_network_id)
    ```


    :param builtins.str global_network_id: ID of the specific global network to retrieve.
    :param Mapping[str, builtins.str] tags: Map of resource tags.
    """
    __args__ = dict()
    __args__['globalNetworkId'] = global_network_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:networkmanager/getGlobalNetwork:getGlobalNetwork', __args__, opts=opts, typ=GetGlobalNetworkResult)
    return __ret__.apply(lambda __response__: GetGlobalNetworkResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        global_network_id=pulumi.get(__response__, 'global_network_id'),
        id=pulumi.get(__response__, 'id'),
        tags=pulumi.get(__response__, 'tags')))
