# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetGlobalNetworksResult',
    'AwaitableGetGlobalNetworksResult',
    'get_global_networks',
    'get_global_networks_output',
]

@pulumi.output_type
class GetGlobalNetworksResult:
    """
    A collection of values returned by getGlobalNetworks.
    """
    def __init__(__self__, id=None, ids=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[builtins.str]:
        """
        IDs of the global networks.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags")


class AwaitableGetGlobalNetworksResult(GetGlobalNetworksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGlobalNetworksResult(
            id=self.id,
            ids=self.ids,
            tags=self.tags)


def get_global_networks(tags: Optional[Mapping[str, builtins.str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGlobalNetworksResult:
    """
    Provides details about existing Network Manager global networks.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.networkmanager.get_global_networks(tags={
        "Env": "test",
    })
    ```


    :param Mapping[str, builtins.str] tags: Restricts the list to the global networks with these tags.
    """
    __args__ = dict()
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:networkmanager/getGlobalNetworks:getGlobalNetworks', __args__, opts=opts, typ=GetGlobalNetworksResult).value

    return AwaitableGetGlobalNetworksResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        tags=pulumi.get(__ret__, 'tags'))
def get_global_networks_output(tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGlobalNetworksResult]:
    """
    Provides details about existing Network Manager global networks.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.networkmanager.get_global_networks(tags={
        "Env": "test",
    })
    ```


    :param Mapping[str, builtins.str] tags: Restricts the list to the global networks with these tags.
    """
    __args__ = dict()
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:networkmanager/getGlobalNetworks:getGlobalNetworks', __args__, opts=opts, typ=GetGlobalNetworksResult)
    return __ret__.apply(lambda __response__: GetGlobalNetworksResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        tags=pulumi.get(__response__, 'tags')))
