# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ChannelAssociationArgs', 'ChannelAssociation']

@pulumi.input_type
class ChannelAssociationArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[builtins.str],
                 notification_configuration_arn: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ChannelAssociation resource.
        :param pulumi.Input[builtins.str] arn: ARN of the channel to associate with the notification configuration. This can be an email contact ARN.
        :param pulumi.Input[builtins.str] notification_configuration_arn: ARN of the notification configuration to associate the channel with.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "notification_configuration_arn", notification_configuration_arn)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the channel to associate with the notification configuration. This can be an email contact ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="notificationConfigurationArn")
    def notification_configuration_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the notification configuration to associate the channel with.
        """
        return pulumi.get(self, "notification_configuration_arn")

    @notification_configuration_arn.setter
    def notification_configuration_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "notification_configuration_arn", value)


@pulumi.input_type
class _ChannelAssociationState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 notification_configuration_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ChannelAssociation resources.
        :param pulumi.Input[builtins.str] arn: ARN of the channel to associate with the notification configuration. This can be an email contact ARN.
        :param pulumi.Input[builtins.str] notification_configuration_arn: ARN of the notification configuration to associate the channel with.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if notification_configuration_arn is not None:
            pulumi.set(__self__, "notification_configuration_arn", notification_configuration_arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the channel to associate with the notification configuration. This can be an email contact ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="notificationConfigurationArn")
    def notification_configuration_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the notification configuration to associate the channel with.
        """
        return pulumi.get(self, "notification_configuration_arn")

    @notification_configuration_arn.setter
    def notification_configuration_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notification_configuration_arn", value)


@pulumi.type_token("aws:notifications/channelAssociation:ChannelAssociation")
class ChannelAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 notification_configuration_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS User Notifications Channel Association. This resource associates a channel (such as an email contact) with a notification configuration.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.notifications.NotificationConfiguration("example",
            name="example-notification-config",
            description="Example notification configuration")
        example_contacts_email_contact = aws.notifications.ContactsEmailContact("example",
            name="example-contact",
            email_address="example@example.com")
        example_channel_association = aws.notifications.ChannelAssociation("example",
            arn=example_contacts_email_contact.arn,
            notification_configuration_arn=example.arn)
        ```

        ## Import

        Using `pulumi import`, import User Notifications Channel Association using the `notification_configuration_arn,channel_arn` format. For example:

        ```sh
        $ pulumi import aws:notifications/channelAssociation:ChannelAssociation example arn:aws:notifications:us-west-2:123456789012:configuration:example-notification-config,arn:aws:notificationscontacts:us-west-2:123456789012:emailcontact:example-contact
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the channel to associate with the notification configuration. This can be an email contact ARN.
        :param pulumi.Input[builtins.str] notification_configuration_arn: ARN of the notification configuration to associate the channel with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChannelAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS User Notifications Channel Association. This resource associates a channel (such as an email contact) with a notification configuration.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.notifications.NotificationConfiguration("example",
            name="example-notification-config",
            description="Example notification configuration")
        example_contacts_email_contact = aws.notifications.ContactsEmailContact("example",
            name="example-contact",
            email_address="example@example.com")
        example_channel_association = aws.notifications.ChannelAssociation("example",
            arn=example_contacts_email_contact.arn,
            notification_configuration_arn=example.arn)
        ```

        ## Import

        Using `pulumi import`, import User Notifications Channel Association using the `notification_configuration_arn,channel_arn` format. For example:

        ```sh
        $ pulumi import aws:notifications/channelAssociation:ChannelAssociation example arn:aws:notifications:us-west-2:123456789012:configuration:example-notification-config,arn:aws:notificationscontacts:us-west-2:123456789012:emailcontact:example-contact
        ```

        :param str resource_name: The name of the resource.
        :param ChannelAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 notification_configuration_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelAssociationArgs.__new__(ChannelAssociationArgs)

            if arn is None and not opts.urn:
                raise TypeError("Missing required property 'arn'")
            __props__.__dict__["arn"] = arn
            if notification_configuration_arn is None and not opts.urn:
                raise TypeError("Missing required property 'notification_configuration_arn'")
            __props__.__dict__["notification_configuration_arn"] = notification_configuration_arn
        super(ChannelAssociation, __self__).__init__(
            'aws:notifications/channelAssociation:ChannelAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            notification_configuration_arn: Optional[pulumi.Input[builtins.str]] = None) -> 'ChannelAssociation':
        """
        Get an existing ChannelAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the channel to associate with the notification configuration. This can be an email contact ARN.
        :param pulumi.Input[builtins.str] notification_configuration_arn: ARN of the notification configuration to associate the channel with.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ChannelAssociationState.__new__(_ChannelAssociationState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["notification_configuration_arn"] = notification_configuration_arn
        return ChannelAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the channel to associate with the notification configuration. This can be an email contact ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="notificationConfigurationArn")
    def notification_configuration_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the notification configuration to associate the channel with.
        """
        return pulumi.get(self, "notification_configuration_arn")

