# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'LinkLinkConfiguration',
    'LinkLinkConfigurationLogGroupConfiguration',
    'LinkLinkConfigurationMetricConfiguration',
    'GetLinkLinkConfigurationResult',
    'GetLinkLinkConfigurationLogGroupConfigurationResult',
    'GetLinkLinkConfigurationMetricConfigurationResult',
]

@pulumi.output_type
class LinkLinkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupConfiguration":
            suggest = "log_group_configuration"
        elif key == "metricConfiguration":
            suggest = "metric_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkLinkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkLinkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkLinkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_configuration: Optional['outputs.LinkLinkConfigurationLogGroupConfiguration'] = None,
                 metric_configuration: Optional['outputs.LinkLinkConfigurationMetricConfiguration'] = None):
        """
        :param 'LinkLinkConfigurationLogGroupConfigurationArgs' log_group_configuration: Configuration for filtering which log groups are to send log events from the source account to the monitoring account. See `log_group_configuration` Block for details.
        :param 'LinkLinkConfigurationMetricConfigurationArgs' metric_configuration: Configuration for filtering which metric namespaces are to be shared from the source account to the monitoring account. See `metric_configuration` Block for details.
        """
        if log_group_configuration is not None:
            pulumi.set(__self__, "log_group_configuration", log_group_configuration)
        if metric_configuration is not None:
            pulumi.set(__self__, "metric_configuration", metric_configuration)

    @property
    @pulumi.getter(name="logGroupConfiguration")
    def log_group_configuration(self) -> Optional['outputs.LinkLinkConfigurationLogGroupConfiguration']:
        """
        Configuration for filtering which log groups are to send log events from the source account to the monitoring account. See `log_group_configuration` Block for details.
        """
        return pulumi.get(self, "log_group_configuration")

    @property
    @pulumi.getter(name="metricConfiguration")
    def metric_configuration(self) -> Optional['outputs.LinkLinkConfigurationMetricConfiguration']:
        """
        Configuration for filtering which metric namespaces are to be shared from the source account to the monitoring account. See `metric_configuration` Block for details.
        """
        return pulumi.get(self, "metric_configuration")


@pulumi.output_type
class LinkLinkConfigurationLogGroupConfiguration(dict):
    def __init__(__self__, *,
                 filter: builtins.str):
        """
        :param builtins.str filter: Filter string that specifies which log groups are to share their log events with the monitoring account. See [LogGroupConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_LogGroupConfiguration.html) for details.
        """
        pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def filter(self) -> builtins.str:
        """
        Filter string that specifies which log groups are to share their log events with the monitoring account. See [LogGroupConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_LogGroupConfiguration.html) for details.
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class LinkLinkConfigurationMetricConfiguration(dict):
    def __init__(__self__, *,
                 filter: builtins.str):
        """
        :param builtins.str filter: Filter string that specifies  which metrics are to be shared with the monitoring account. See [MetricConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_MetricConfiguration.html) for details.
        """
        pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def filter(self) -> builtins.str:
        """
        Filter string that specifies  which metrics are to be shared with the monitoring account. See [MetricConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_MetricConfiguration.html) for details.
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class GetLinkLinkConfigurationResult(dict):
    def __init__(__self__, *,
                 log_group_configurations: Sequence['outputs.GetLinkLinkConfigurationLogGroupConfigurationResult'],
                 metric_configurations: Sequence['outputs.GetLinkLinkConfigurationMetricConfigurationResult']):
        """
        :param Sequence['GetLinkLinkConfigurationLogGroupConfigurationArgs'] log_group_configurations: Configuration for filtering which log groups are to send log events from the source account to the monitoring account. See `log_group_configuration` Block for details.
        :param Sequence['GetLinkLinkConfigurationMetricConfigurationArgs'] metric_configurations: Configuration for filtering which metric namespaces are to be shared from the source account to the monitoring account. See `metric_configuration` Block for details.
        """
        pulumi.set(__self__, "log_group_configurations", log_group_configurations)
        pulumi.set(__self__, "metric_configurations", metric_configurations)

    @property
    @pulumi.getter(name="logGroupConfigurations")
    def log_group_configurations(self) -> Sequence['outputs.GetLinkLinkConfigurationLogGroupConfigurationResult']:
        """
        Configuration for filtering which log groups are to send log events from the source account to the monitoring account. See `log_group_configuration` Block for details.
        """
        return pulumi.get(self, "log_group_configurations")

    @property
    @pulumi.getter(name="metricConfigurations")
    def metric_configurations(self) -> Sequence['outputs.GetLinkLinkConfigurationMetricConfigurationResult']:
        """
        Configuration for filtering which metric namespaces are to be shared from the source account to the monitoring account. See `metric_configuration` Block for details.
        """
        return pulumi.get(self, "metric_configurations")


@pulumi.output_type
class GetLinkLinkConfigurationLogGroupConfigurationResult(dict):
    def __init__(__self__, *,
                 filter: builtins.str):
        """
        :param builtins.str filter: Filter string that specifies  which metrics are to be shared with the monitoring account. See [MetricConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_MetricConfiguration.html) for details.
        """
        pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def filter(self) -> builtins.str:
        """
        Filter string that specifies  which metrics are to be shared with the monitoring account. See [MetricConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_MetricConfiguration.html) for details.
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class GetLinkLinkConfigurationMetricConfigurationResult(dict):
    def __init__(__self__, *,
                 filter: builtins.str):
        """
        :param builtins.str filter: Filter string that specifies  which metrics are to be shared with the monitoring account. See [MetricConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_MetricConfiguration.html) for details.
        """
        pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def filter(self) -> builtins.str:
        """
        Filter string that specifies  which metrics are to be shared with the monitoring account. See [MetricConfiguration](https://docs.aws.amazon.com/OAM/latest/APIReference/API_MetricConfiguration.html) for details.
        """
        return pulumi.get(self, "filter")


