# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetServerlessSecurityConfigResult',
    'AwaitableGetServerlessSecurityConfigResult',
    'get_serverless_security_config',
    'get_serverless_security_config_output',
]

@pulumi.output_type
class GetServerlessSecurityConfigResult:
    """
    A collection of values returned by getServerlessSecurityConfig.
    """
    def __init__(__self__, config_version=None, created_date=None, description=None, id=None, last_modified_date=None, region=None, saml_options=None, type=None):
        if config_version and not isinstance(config_version, str):
            raise TypeError("Expected argument 'config_version' to be a str")
        pulumi.set(__self__, "config_version", config_version)
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_modified_date and not isinstance(last_modified_date, str):
            raise TypeError("Expected argument 'last_modified_date' to be a str")
        pulumi.set(__self__, "last_modified_date", last_modified_date)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if saml_options and not isinstance(saml_options, list):
            raise TypeError("Expected argument 'saml_options' to be a list")
        pulumi.set(__self__, "saml_options", saml_options)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="configVersion")
    def config_version(self) -> builtins.str:
        """
        The version of the security configuration.
        """
        return pulumi.get(self, "config_version")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> builtins.str:
        """
        The date the configuration was created.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the security configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifiedDate")
    def last_modified_date(self) -> builtins.str:
        """
        The date the configuration was last modified.
        """
        return pulumi.get(self, "last_modified_date")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="samlOptions")
    def saml_options(self) -> Optional[Sequence['outputs.GetServerlessSecurityConfigSamlOptionResult']]:
        """
        SAML options for the security configuration.
        """
        return pulumi.get(self, "saml_options")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of security configuration.
        """
        return pulumi.get(self, "type")


class AwaitableGetServerlessSecurityConfigResult(GetServerlessSecurityConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerlessSecurityConfigResult(
            config_version=self.config_version,
            created_date=self.created_date,
            description=self.description,
            id=self.id,
            last_modified_date=self.last_modified_date,
            region=self.region,
            saml_options=self.saml_options,
            type=self.type)


def get_serverless_security_config(id: Optional[builtins.str] = None,
                                   region: Optional[builtins.str] = None,
                                   saml_options: Optional[Sequence[Union['GetServerlessSecurityConfigSamlOptionArgs', 'GetServerlessSecurityConfigSamlOptionArgsDict']]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerlessSecurityConfigResult:
    """
    Data source for managing an AWS OpenSearch Serverless Security Config.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.opensearch.get_serverless_security_config(id="saml/12345678912/example")
    ```


    :param builtins.str id: The unique identifier of the security configuration.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Sequence[Union['GetServerlessSecurityConfigSamlOptionArgs', 'GetServerlessSecurityConfigSamlOptionArgsDict']] saml_options: SAML options for the security configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    __args__['samlOptions'] = saml_options
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:opensearch/getServerlessSecurityConfig:getServerlessSecurityConfig', __args__, opts=opts, typ=GetServerlessSecurityConfigResult).value

    return AwaitableGetServerlessSecurityConfigResult(
        config_version=pulumi.get(__ret__, 'config_version'),
        created_date=pulumi.get(__ret__, 'created_date'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        last_modified_date=pulumi.get(__ret__, 'last_modified_date'),
        region=pulumi.get(__ret__, 'region'),
        saml_options=pulumi.get(__ret__, 'saml_options'),
        type=pulumi.get(__ret__, 'type'))
def get_serverless_security_config_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                          region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          saml_options: Optional[pulumi.Input[Optional[Sequence[Union['GetServerlessSecurityConfigSamlOptionArgs', 'GetServerlessSecurityConfigSamlOptionArgsDict']]]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerlessSecurityConfigResult]:
    """
    Data source for managing an AWS OpenSearch Serverless Security Config.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.opensearch.get_serverless_security_config(id="saml/12345678912/example")
    ```


    :param builtins.str id: The unique identifier of the security configuration.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Sequence[Union['GetServerlessSecurityConfigSamlOptionArgs', 'GetServerlessSecurityConfigSamlOptionArgsDict']] saml_options: SAML options for the security configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    __args__['samlOptions'] = saml_options
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:opensearch/getServerlessSecurityConfig:getServerlessSecurityConfig', __args__, opts=opts, typ=GetServerlessSecurityConfigResult)
    return __ret__.apply(lambda __response__: GetServerlessSecurityConfigResult(
        config_version=pulumi.get(__response__, 'config_version'),
        created_date=pulumi.get(__response__, 'created_date'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        last_modified_date=pulumi.get(__response__, 'last_modified_date'),
        region=pulumi.get(__response__, 'region'),
        saml_options=pulumi.get(__response__, 'saml_options'),
        type=pulumi.get(__response__, 'type')))
