# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetServerlessVpcEndpointResult',
    'AwaitableGetServerlessVpcEndpointResult',
    'get_serverless_vpc_endpoint',
    'get_serverless_vpc_endpoint_output',
]

@pulumi.output_type
class GetServerlessVpcEndpointResult:
    """
    A collection of values returned by getServerlessVpcEndpoint.
    """
    def __init__(__self__, created_date=None, id=None, name=None, region=None, security_group_ids=None, subnet_ids=None, vpc_endpoint_id=None, vpc_id=None):
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_endpoint_id and not isinstance(vpc_endpoint_id, str):
            raise TypeError("Expected argument 'vpc_endpoint_id' to be a str")
        pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> builtins.str:
        """
        The date the endpoint was created.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[builtins.str]:
        """
        The IDs of the security groups that define the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        The IDs of the subnets from which you access OpenSearch Serverless.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> builtins.str:
        return pulumi.get(self, "vpc_endpoint_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        The ID of the VPC from which you access OpenSearch Serverless.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetServerlessVpcEndpointResult(GetServerlessVpcEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerlessVpcEndpointResult(
            created_date=self.created_date,
            id=self.id,
            name=self.name,
            region=self.region,
            security_group_ids=self.security_group_ids,
            subnet_ids=self.subnet_ids,
            vpc_endpoint_id=self.vpc_endpoint_id,
            vpc_id=self.vpc_id)


def get_serverless_vpc_endpoint(region: Optional[builtins.str] = None,
                                vpc_endpoint_id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerlessVpcEndpointResult:
    """
    Data source for managing an AWS OpenSearch Serverless VPC Endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.opensearch.get_serverless_vpc_endpoint(vpc_endpoint_id="vpce-829a4487959e2a839")
    ```


    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str vpc_endpoint_id: The unique identifier of the endpoint.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['vpcEndpointId'] = vpc_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:opensearch/getServerlessVpcEndpoint:getServerlessVpcEndpoint', __args__, opts=opts, typ=GetServerlessVpcEndpointResult).value

    return AwaitableGetServerlessVpcEndpointResult(
        created_date=pulumi.get(__ret__, 'created_date'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        subnet_ids=pulumi.get(__ret__, 'subnet_ids'),
        vpc_endpoint_id=pulumi.get(__ret__, 'vpc_endpoint_id'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_serverless_vpc_endpoint_output(region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       vpc_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerlessVpcEndpointResult]:
    """
    Data source for managing an AWS OpenSearch Serverless VPC Endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.opensearch.get_serverless_vpc_endpoint(vpc_endpoint_id="vpce-829a4487959e2a839")
    ```


    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str vpc_endpoint_id: The unique identifier of the endpoint.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['vpcEndpointId'] = vpc_endpoint_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:opensearch/getServerlessVpcEndpoint:getServerlessVpcEndpoint', __args__, opts=opts, typ=GetServerlessVpcEndpointResult)
    return __ret__.apply(lambda __response__: GetServerlessVpcEndpointResult(
        created_date=pulumi.get(__response__, 'created_date'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        security_group_ids=pulumi.get(__response__, 'security_group_ids'),
        subnet_ids=pulumi.get(__response__, 'subnet_ids'),
        vpc_endpoint_id=pulumi.get(__response__, 'vpc_endpoint_id'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
