# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OutboundConnectionArgs', 'OutboundConnection']

@pulumi.input_type
class OutboundConnectionArgs:
    def __init__(__self__, *,
                 connection_alias: pulumi.Input[builtins.str],
                 local_domain_info: pulumi.Input['OutboundConnectionLocalDomainInfoArgs'],
                 remote_domain_info: pulumi.Input['OutboundConnectionRemoteDomainInfoArgs'],
                 accept_connection: Optional[pulumi.Input[builtins.bool]] = None,
                 connection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_properties: Optional[pulumi.Input['OutboundConnectionConnectionPropertiesArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a OutboundConnection resource.
        :param pulumi.Input[builtins.str] connection_alias: Specifies the connection alias that will be used by the customer for this connection.
        :param pulumi.Input['OutboundConnectionLocalDomainInfoArgs'] local_domain_info: Configuration block for the local Opensearch domain.
        :param pulumi.Input['OutboundConnectionRemoteDomainInfoArgs'] remote_domain_info: Configuration block for the remote Opensearch domain.
        :param pulumi.Input[builtins.bool] accept_connection: Accepts the connection.
        :param pulumi.Input[builtins.str] connection_mode: Specifies the connection mode. Accepted values are `DIRECT` or `VPC_ENDPOINT`.
        :param pulumi.Input['OutboundConnectionConnectionPropertiesArgs'] connection_properties: Configuration block for the outbound connection.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "connection_alias", connection_alias)
        pulumi.set(__self__, "local_domain_info", local_domain_info)
        pulumi.set(__self__, "remote_domain_info", remote_domain_info)
        if accept_connection is not None:
            pulumi.set(__self__, "accept_connection", accept_connection)
        if connection_mode is not None:
            pulumi.set(__self__, "connection_mode", connection_mode)
        if connection_properties is not None:
            pulumi.set(__self__, "connection_properties", connection_properties)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="connectionAlias")
    def connection_alias(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the connection alias that will be used by the customer for this connection.
        """
        return pulumi.get(self, "connection_alias")

    @connection_alias.setter
    def connection_alias(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "connection_alias", value)

    @property
    @pulumi.getter(name="localDomainInfo")
    def local_domain_info(self) -> pulumi.Input['OutboundConnectionLocalDomainInfoArgs']:
        """
        Configuration block for the local Opensearch domain.
        """
        return pulumi.get(self, "local_domain_info")

    @local_domain_info.setter
    def local_domain_info(self, value: pulumi.Input['OutboundConnectionLocalDomainInfoArgs']):
        pulumi.set(self, "local_domain_info", value)

    @property
    @pulumi.getter(name="remoteDomainInfo")
    def remote_domain_info(self) -> pulumi.Input['OutboundConnectionRemoteDomainInfoArgs']:
        """
        Configuration block for the remote Opensearch domain.
        """
        return pulumi.get(self, "remote_domain_info")

    @remote_domain_info.setter
    def remote_domain_info(self, value: pulumi.Input['OutboundConnectionRemoteDomainInfoArgs']):
        pulumi.set(self, "remote_domain_info", value)

    @property
    @pulumi.getter(name="acceptConnection")
    def accept_connection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Accepts the connection.
        """
        return pulumi.get(self, "accept_connection")

    @accept_connection.setter
    def accept_connection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "accept_connection", value)

    @property
    @pulumi.getter(name="connectionMode")
    def connection_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the connection mode. Accepted values are `DIRECT` or `VPC_ENDPOINT`.
        """
        return pulumi.get(self, "connection_mode")

    @connection_mode.setter
    def connection_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_mode", value)

    @property
    @pulumi.getter(name="connectionProperties")
    def connection_properties(self) -> Optional[pulumi.Input['OutboundConnectionConnectionPropertiesArgs']]:
        """
        Configuration block for the outbound connection.
        """
        return pulumi.get(self, "connection_properties")

    @connection_properties.setter
    def connection_properties(self, value: Optional[pulumi.Input['OutboundConnectionConnectionPropertiesArgs']]):
        pulumi.set(self, "connection_properties", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _OutboundConnectionState:
    def __init__(__self__, *,
                 accept_connection: Optional[pulumi.Input[builtins.bool]] = None,
                 connection_alias: Optional[pulumi.Input[builtins.str]] = None,
                 connection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_properties: Optional[pulumi.Input['OutboundConnectionConnectionPropertiesArgs']] = None,
                 connection_status: Optional[pulumi.Input[builtins.str]] = None,
                 local_domain_info: Optional[pulumi.Input['OutboundConnectionLocalDomainInfoArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 remote_domain_info: Optional[pulumi.Input['OutboundConnectionRemoteDomainInfoArgs']] = None):
        """
        Input properties used for looking up and filtering OutboundConnection resources.
        :param pulumi.Input[builtins.bool] accept_connection: Accepts the connection.
        :param pulumi.Input[builtins.str] connection_alias: Specifies the connection alias that will be used by the customer for this connection.
        :param pulumi.Input[builtins.str] connection_mode: Specifies the connection mode. Accepted values are `DIRECT` or `VPC_ENDPOINT`.
        :param pulumi.Input['OutboundConnectionConnectionPropertiesArgs'] connection_properties: Configuration block for the outbound connection.
        :param pulumi.Input[builtins.str] connection_status: Status of the connection request.
        :param pulumi.Input['OutboundConnectionLocalDomainInfoArgs'] local_domain_info: Configuration block for the local Opensearch domain.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['OutboundConnectionRemoteDomainInfoArgs'] remote_domain_info: Configuration block for the remote Opensearch domain.
        """
        if accept_connection is not None:
            pulumi.set(__self__, "accept_connection", accept_connection)
        if connection_alias is not None:
            pulumi.set(__self__, "connection_alias", connection_alias)
        if connection_mode is not None:
            pulumi.set(__self__, "connection_mode", connection_mode)
        if connection_properties is not None:
            pulumi.set(__self__, "connection_properties", connection_properties)
        if connection_status is not None:
            pulumi.set(__self__, "connection_status", connection_status)
        if local_domain_info is not None:
            pulumi.set(__self__, "local_domain_info", local_domain_info)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remote_domain_info is not None:
            pulumi.set(__self__, "remote_domain_info", remote_domain_info)

    @property
    @pulumi.getter(name="acceptConnection")
    def accept_connection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Accepts the connection.
        """
        return pulumi.get(self, "accept_connection")

    @accept_connection.setter
    def accept_connection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "accept_connection", value)

    @property
    @pulumi.getter(name="connectionAlias")
    def connection_alias(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the connection alias that will be used by the customer for this connection.
        """
        return pulumi.get(self, "connection_alias")

    @connection_alias.setter
    def connection_alias(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_alias", value)

    @property
    @pulumi.getter(name="connectionMode")
    def connection_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the connection mode. Accepted values are `DIRECT` or `VPC_ENDPOINT`.
        """
        return pulumi.get(self, "connection_mode")

    @connection_mode.setter
    def connection_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_mode", value)

    @property
    @pulumi.getter(name="connectionProperties")
    def connection_properties(self) -> Optional[pulumi.Input['OutboundConnectionConnectionPropertiesArgs']]:
        """
        Configuration block for the outbound connection.
        """
        return pulumi.get(self, "connection_properties")

    @connection_properties.setter
    def connection_properties(self, value: Optional[pulumi.Input['OutboundConnectionConnectionPropertiesArgs']]):
        pulumi.set(self, "connection_properties", value)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the connection request.
        """
        return pulumi.get(self, "connection_status")

    @connection_status.setter
    def connection_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_status", value)

    @property
    @pulumi.getter(name="localDomainInfo")
    def local_domain_info(self) -> Optional[pulumi.Input['OutboundConnectionLocalDomainInfoArgs']]:
        """
        Configuration block for the local Opensearch domain.
        """
        return pulumi.get(self, "local_domain_info")

    @local_domain_info.setter
    def local_domain_info(self, value: Optional[pulumi.Input['OutboundConnectionLocalDomainInfoArgs']]):
        pulumi.set(self, "local_domain_info", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="remoteDomainInfo")
    def remote_domain_info(self) -> Optional[pulumi.Input['OutboundConnectionRemoteDomainInfoArgs']]:
        """
        Configuration block for the remote Opensearch domain.
        """
        return pulumi.get(self, "remote_domain_info")

    @remote_domain_info.setter
    def remote_domain_info(self, value: Optional[pulumi.Input['OutboundConnectionRemoteDomainInfoArgs']]):
        pulumi.set(self, "remote_domain_info", value)


@pulumi.type_token("aws:opensearch/outboundConnection:OutboundConnection")
class OutboundConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_connection: Optional[pulumi.Input[builtins.bool]] = None,
                 connection_alias: Optional[pulumi.Input[builtins.str]] = None,
                 connection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_properties: Optional[pulumi.Input[Union['OutboundConnectionConnectionPropertiesArgs', 'OutboundConnectionConnectionPropertiesArgsDict']]] = None,
                 local_domain_info: Optional[pulumi.Input[Union['OutboundConnectionLocalDomainInfoArgs', 'OutboundConnectionLocalDomainInfoArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 remote_domain_info: Optional[pulumi.Input[Union['OutboundConnectionRemoteDomainInfoArgs', 'OutboundConnectionRemoteDomainInfoArgsDict']]] = None,
                 __props__=None):
        """
        Manages an AWS Opensearch Outbound Connection.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_region = aws.get_region()
        foo = aws.opensearch.OutboundConnection("foo",
            connection_alias="outbound_connection",
            connection_mode="DIRECT",
            local_domain_info={
                "owner_id": current.account_id,
                "region": current_get_region.region,
                "domain_name": local_domain["domainName"],
            },
            remote_domain_info={
                "owner_id": current.account_id,
                "region": current_get_region.region,
                "domain_name": remote_domain["domainName"],
            })
        ```

        ## Import

        Using `pulumi import`, import AWS Opensearch Outbound Connections using the Outbound Connection ID. For example:

        ```sh
        $ pulumi import aws:opensearch/outboundConnection:OutboundConnection foo connection-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] accept_connection: Accepts the connection.
        :param pulumi.Input[builtins.str] connection_alias: Specifies the connection alias that will be used by the customer for this connection.
        :param pulumi.Input[builtins.str] connection_mode: Specifies the connection mode. Accepted values are `DIRECT` or `VPC_ENDPOINT`.
        :param pulumi.Input[Union['OutboundConnectionConnectionPropertiesArgs', 'OutboundConnectionConnectionPropertiesArgsDict']] connection_properties: Configuration block for the outbound connection.
        :param pulumi.Input[Union['OutboundConnectionLocalDomainInfoArgs', 'OutboundConnectionLocalDomainInfoArgsDict']] local_domain_info: Configuration block for the local Opensearch domain.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['OutboundConnectionRemoteDomainInfoArgs', 'OutboundConnectionRemoteDomainInfoArgsDict']] remote_domain_info: Configuration block for the remote Opensearch domain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OutboundConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Opensearch Outbound Connection.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_region = aws.get_region()
        foo = aws.opensearch.OutboundConnection("foo",
            connection_alias="outbound_connection",
            connection_mode="DIRECT",
            local_domain_info={
                "owner_id": current.account_id,
                "region": current_get_region.region,
                "domain_name": local_domain["domainName"],
            },
            remote_domain_info={
                "owner_id": current.account_id,
                "region": current_get_region.region,
                "domain_name": remote_domain["domainName"],
            })
        ```

        ## Import

        Using `pulumi import`, import AWS Opensearch Outbound Connections using the Outbound Connection ID. For example:

        ```sh
        $ pulumi import aws:opensearch/outboundConnection:OutboundConnection foo connection-id
        ```

        :param str resource_name: The name of the resource.
        :param OutboundConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OutboundConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_connection: Optional[pulumi.Input[builtins.bool]] = None,
                 connection_alias: Optional[pulumi.Input[builtins.str]] = None,
                 connection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 connection_properties: Optional[pulumi.Input[Union['OutboundConnectionConnectionPropertiesArgs', 'OutboundConnectionConnectionPropertiesArgsDict']]] = None,
                 local_domain_info: Optional[pulumi.Input[Union['OutboundConnectionLocalDomainInfoArgs', 'OutboundConnectionLocalDomainInfoArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 remote_domain_info: Optional[pulumi.Input[Union['OutboundConnectionRemoteDomainInfoArgs', 'OutboundConnectionRemoteDomainInfoArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OutboundConnectionArgs.__new__(OutboundConnectionArgs)

            __props__.__dict__["accept_connection"] = accept_connection
            if connection_alias is None and not opts.urn:
                raise TypeError("Missing required property 'connection_alias'")
            __props__.__dict__["connection_alias"] = connection_alias
            __props__.__dict__["connection_mode"] = connection_mode
            __props__.__dict__["connection_properties"] = connection_properties
            if local_domain_info is None and not opts.urn:
                raise TypeError("Missing required property 'local_domain_info'")
            __props__.__dict__["local_domain_info"] = local_domain_info
            __props__.__dict__["region"] = region
            if remote_domain_info is None and not opts.urn:
                raise TypeError("Missing required property 'remote_domain_info'")
            __props__.__dict__["remote_domain_info"] = remote_domain_info
            __props__.__dict__["connection_status"] = None
        super(OutboundConnection, __self__).__init__(
            'aws:opensearch/outboundConnection:OutboundConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accept_connection: Optional[pulumi.Input[builtins.bool]] = None,
            connection_alias: Optional[pulumi.Input[builtins.str]] = None,
            connection_mode: Optional[pulumi.Input[builtins.str]] = None,
            connection_properties: Optional[pulumi.Input[Union['OutboundConnectionConnectionPropertiesArgs', 'OutboundConnectionConnectionPropertiesArgsDict']]] = None,
            connection_status: Optional[pulumi.Input[builtins.str]] = None,
            local_domain_info: Optional[pulumi.Input[Union['OutboundConnectionLocalDomainInfoArgs', 'OutboundConnectionLocalDomainInfoArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            remote_domain_info: Optional[pulumi.Input[Union['OutboundConnectionRemoteDomainInfoArgs', 'OutboundConnectionRemoteDomainInfoArgsDict']]] = None) -> 'OutboundConnection':
        """
        Get an existing OutboundConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] accept_connection: Accepts the connection.
        :param pulumi.Input[builtins.str] connection_alias: Specifies the connection alias that will be used by the customer for this connection.
        :param pulumi.Input[builtins.str] connection_mode: Specifies the connection mode. Accepted values are `DIRECT` or `VPC_ENDPOINT`.
        :param pulumi.Input[Union['OutboundConnectionConnectionPropertiesArgs', 'OutboundConnectionConnectionPropertiesArgsDict']] connection_properties: Configuration block for the outbound connection.
        :param pulumi.Input[builtins.str] connection_status: Status of the connection request.
        :param pulumi.Input[Union['OutboundConnectionLocalDomainInfoArgs', 'OutboundConnectionLocalDomainInfoArgsDict']] local_domain_info: Configuration block for the local Opensearch domain.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['OutboundConnectionRemoteDomainInfoArgs', 'OutboundConnectionRemoteDomainInfoArgsDict']] remote_domain_info: Configuration block for the remote Opensearch domain.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OutboundConnectionState.__new__(_OutboundConnectionState)

        __props__.__dict__["accept_connection"] = accept_connection
        __props__.__dict__["connection_alias"] = connection_alias
        __props__.__dict__["connection_mode"] = connection_mode
        __props__.__dict__["connection_properties"] = connection_properties
        __props__.__dict__["connection_status"] = connection_status
        __props__.__dict__["local_domain_info"] = local_domain_info
        __props__.__dict__["region"] = region
        __props__.__dict__["remote_domain_info"] = remote_domain_info
        return OutboundConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceptConnection")
    def accept_connection(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Accepts the connection.
        """
        return pulumi.get(self, "accept_connection")

    @property
    @pulumi.getter(name="connectionAlias")
    def connection_alias(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the connection alias that will be used by the customer for this connection.
        """
        return pulumi.get(self, "connection_alias")

    @property
    @pulumi.getter(name="connectionMode")
    def connection_mode(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the connection mode. Accepted values are `DIRECT` or `VPC_ENDPOINT`.
        """
        return pulumi.get(self, "connection_mode")

    @property
    @pulumi.getter(name="connectionProperties")
    def connection_properties(self) -> pulumi.Output['outputs.OutboundConnectionConnectionProperties']:
        """
        Configuration block for the outbound connection.
        """
        return pulumi.get(self, "connection_properties")

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> pulumi.Output[builtins.str]:
        """
        Status of the connection request.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="localDomainInfo")
    def local_domain_info(self) -> pulumi.Output['outputs.OutboundConnectionLocalDomainInfo']:
        """
        Configuration block for the local Opensearch domain.
        """
        return pulumi.get(self, "local_domain_info")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="remoteDomainInfo")
    def remote_domain_info(self) -> pulumi.Output['outputs.OutboundConnectionRemoteDomainInfo']:
        """
        Configuration block for the remote Opensearch domain.
        """
        return pulumi.get(self, "remote_domain_info")

