# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PipelineArgs', 'Pipeline']

@pulumi.input_type
class PipelineArgs:
    def __init__(__self__, *,
                 max_units: pulumi.Input[builtins.int],
                 min_units: pulumi.Input[builtins.int],
                 pipeline_configuration_body: pulumi.Input[builtins.str],
                 pipeline_name: pulumi.Input[builtins.str],
                 buffer_options: Optional[pulumi.Input['PipelineBufferOptionsArgs']] = None,
                 encryption_at_rest_options: Optional[pulumi.Input['PipelineEncryptionAtRestOptionsArgs']] = None,
                 log_publishing_options: Optional[pulumi.Input['PipelineLogPublishingOptionsArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['PipelineTimeoutsArgs']] = None,
                 vpc_options: Optional[pulumi.Input['PipelineVpcOptionsArgs']] = None):
        """
        The set of arguments for constructing a Pipeline resource.
        :param pulumi.Input[builtins.int] max_units: The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
        :param pulumi.Input[builtins.int] min_units: The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
        :param pulumi.Input[builtins.str] pipeline_configuration_body: The pipeline configuration in YAML format. This argument accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\n.
        :param pulumi.Input[builtins.str] pipeline_name: The name of the OpenSearch Ingestion pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.
               
               The following arguments are optional:
        :param pulumi.Input['PipelineBufferOptionsArgs'] buffer_options: Key-value pairs to configure persistent buffering for the pipeline. See `buffer_options` below.
        :param pulumi.Input['PipelineEncryptionAtRestOptionsArgs'] encryption_at_rest_options: Key-value pairs to configure encryption for data that is written to a persistent buffer. See `encryption_at_rest_options` below.
        :param pulumi.Input['PipelineLogPublishingOptionsArgs'] log_publishing_options: Key-value pairs to configure log publishing. See `log_publishing_options` below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['PipelineVpcOptionsArgs'] vpc_options: Container for the values required to configure VPC access for the pipeline. If you don't specify these values, OpenSearch Ingestion creates the pipeline with a public endpoint. See `vpc_options` below.
        """
        pulumi.set(__self__, "max_units", max_units)
        pulumi.set(__self__, "min_units", min_units)
        pulumi.set(__self__, "pipeline_configuration_body", pipeline_configuration_body)
        pulumi.set(__self__, "pipeline_name", pipeline_name)
        if buffer_options is not None:
            pulumi.set(__self__, "buffer_options", buffer_options)
        if encryption_at_rest_options is not None:
            pulumi.set(__self__, "encryption_at_rest_options", encryption_at_rest_options)
        if log_publishing_options is not None:
            pulumi.set(__self__, "log_publishing_options", log_publishing_options)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if vpc_options is not None:
            pulumi.set(__self__, "vpc_options", vpc_options)

    @property
    @pulumi.getter(name="maxUnits")
    def max_units(self) -> pulumi.Input[builtins.int]:
        """
        The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
        """
        return pulumi.get(self, "max_units")

    @max_units.setter
    def max_units(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_units", value)

    @property
    @pulumi.getter(name="minUnits")
    def min_units(self) -> pulumi.Input[builtins.int]:
        """
        The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
        """
        return pulumi.get(self, "min_units")

    @min_units.setter
    def min_units(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "min_units", value)

    @property
    @pulumi.getter(name="pipelineConfigurationBody")
    def pipeline_configuration_body(self) -> pulumi.Input[builtins.str]:
        """
        The pipeline configuration in YAML format. This argument accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\n.
        """
        return pulumi.get(self, "pipeline_configuration_body")

    @pipeline_configuration_body.setter
    def pipeline_configuration_body(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pipeline_configuration_body", value)

    @property
    @pulumi.getter(name="pipelineName")
    def pipeline_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the OpenSearch Ingestion pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.

        The following arguments are optional:
        """
        return pulumi.get(self, "pipeline_name")

    @pipeline_name.setter
    def pipeline_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pipeline_name", value)

    @property
    @pulumi.getter(name="bufferOptions")
    def buffer_options(self) -> Optional[pulumi.Input['PipelineBufferOptionsArgs']]:
        """
        Key-value pairs to configure persistent buffering for the pipeline. See `buffer_options` below.
        """
        return pulumi.get(self, "buffer_options")

    @buffer_options.setter
    def buffer_options(self, value: Optional[pulumi.Input['PipelineBufferOptionsArgs']]):
        pulumi.set(self, "buffer_options", value)

    @property
    @pulumi.getter(name="encryptionAtRestOptions")
    def encryption_at_rest_options(self) -> Optional[pulumi.Input['PipelineEncryptionAtRestOptionsArgs']]:
        """
        Key-value pairs to configure encryption for data that is written to a persistent buffer. See `encryption_at_rest_options` below.
        """
        return pulumi.get(self, "encryption_at_rest_options")

    @encryption_at_rest_options.setter
    def encryption_at_rest_options(self, value: Optional[pulumi.Input['PipelineEncryptionAtRestOptionsArgs']]):
        pulumi.set(self, "encryption_at_rest_options", value)

    @property
    @pulumi.getter(name="logPublishingOptions")
    def log_publishing_options(self) -> Optional[pulumi.Input['PipelineLogPublishingOptionsArgs']]:
        """
        Key-value pairs to configure log publishing. See `log_publishing_options` below.
        """
        return pulumi.get(self, "log_publishing_options")

    @log_publishing_options.setter
    def log_publishing_options(self, value: Optional[pulumi.Input['PipelineLogPublishingOptionsArgs']]):
        pulumi.set(self, "log_publishing_options", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['PipelineTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['PipelineTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="vpcOptions")
    def vpc_options(self) -> Optional[pulumi.Input['PipelineVpcOptionsArgs']]:
        """
        Container for the values required to configure VPC access for the pipeline. If you don't specify these values, OpenSearch Ingestion creates the pipeline with a public endpoint. See `vpc_options` below.
        """
        return pulumi.get(self, "vpc_options")

    @vpc_options.setter
    def vpc_options(self, value: Optional[pulumi.Input['PipelineVpcOptionsArgs']]):
        pulumi.set(self, "vpc_options", value)


@pulumi.input_type
class _PipelineState:
    def __init__(__self__, *,
                 buffer_options: Optional[pulumi.Input['PipelineBufferOptionsArgs']] = None,
                 encryption_at_rest_options: Optional[pulumi.Input['PipelineEncryptionAtRestOptionsArgs']] = None,
                 ingest_endpoint_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 log_publishing_options: Optional[pulumi.Input['PipelineLogPublishingOptionsArgs']] = None,
                 max_units: Optional[pulumi.Input[builtins.int]] = None,
                 min_units: Optional[pulumi.Input[builtins.int]] = None,
                 pipeline_arn: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_configuration_body: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['PipelineTimeoutsArgs']] = None,
                 vpc_options: Optional[pulumi.Input['PipelineVpcOptionsArgs']] = None):
        """
        Input properties used for looking up and filtering Pipeline resources.
        :param pulumi.Input['PipelineBufferOptionsArgs'] buffer_options: Key-value pairs to configure persistent buffering for the pipeline. See `buffer_options` below.
        :param pulumi.Input['PipelineEncryptionAtRestOptionsArgs'] encryption_at_rest_options: Key-value pairs to configure encryption for data that is written to a persistent buffer. See `encryption_at_rest_options` below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ingest_endpoint_urls: The list of ingestion endpoints for the pipeline, which you can send data to.
        :param pulumi.Input['PipelineLogPublishingOptionsArgs'] log_publishing_options: Key-value pairs to configure log publishing. See `log_publishing_options` below.
        :param pulumi.Input[builtins.int] max_units: The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
        :param pulumi.Input[builtins.int] min_units: The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
        :param pulumi.Input[builtins.str] pipeline_arn: Amazon Resource Name (ARN) of the pipeline.
        :param pulumi.Input[builtins.str] pipeline_configuration_body: The pipeline configuration in YAML format. This argument accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\n.
        :param pulumi.Input[builtins.str] pipeline_name: The name of the OpenSearch Ingestion pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['PipelineVpcOptionsArgs'] vpc_options: Container for the values required to configure VPC access for the pipeline. If you don't specify these values, OpenSearch Ingestion creates the pipeline with a public endpoint. See `vpc_options` below.
        """
        if buffer_options is not None:
            pulumi.set(__self__, "buffer_options", buffer_options)
        if encryption_at_rest_options is not None:
            pulumi.set(__self__, "encryption_at_rest_options", encryption_at_rest_options)
        if ingest_endpoint_urls is not None:
            pulumi.set(__self__, "ingest_endpoint_urls", ingest_endpoint_urls)
        if log_publishing_options is not None:
            pulumi.set(__self__, "log_publishing_options", log_publishing_options)
        if max_units is not None:
            pulumi.set(__self__, "max_units", max_units)
        if min_units is not None:
            pulumi.set(__self__, "min_units", min_units)
        if pipeline_arn is not None:
            pulumi.set(__self__, "pipeline_arn", pipeline_arn)
        if pipeline_configuration_body is not None:
            pulumi.set(__self__, "pipeline_configuration_body", pipeline_configuration_body)
        if pipeline_name is not None:
            pulumi.set(__self__, "pipeline_name", pipeline_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if vpc_options is not None:
            pulumi.set(__self__, "vpc_options", vpc_options)

    @property
    @pulumi.getter(name="bufferOptions")
    def buffer_options(self) -> Optional[pulumi.Input['PipelineBufferOptionsArgs']]:
        """
        Key-value pairs to configure persistent buffering for the pipeline. See `buffer_options` below.
        """
        return pulumi.get(self, "buffer_options")

    @buffer_options.setter
    def buffer_options(self, value: Optional[pulumi.Input['PipelineBufferOptionsArgs']]):
        pulumi.set(self, "buffer_options", value)

    @property
    @pulumi.getter(name="encryptionAtRestOptions")
    def encryption_at_rest_options(self) -> Optional[pulumi.Input['PipelineEncryptionAtRestOptionsArgs']]:
        """
        Key-value pairs to configure encryption for data that is written to a persistent buffer. See `encryption_at_rest_options` below.
        """
        return pulumi.get(self, "encryption_at_rest_options")

    @encryption_at_rest_options.setter
    def encryption_at_rest_options(self, value: Optional[pulumi.Input['PipelineEncryptionAtRestOptionsArgs']]):
        pulumi.set(self, "encryption_at_rest_options", value)

    @property
    @pulumi.getter(name="ingestEndpointUrls")
    def ingest_endpoint_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of ingestion endpoints for the pipeline, which you can send data to.
        """
        return pulumi.get(self, "ingest_endpoint_urls")

    @ingest_endpoint_urls.setter
    def ingest_endpoint_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ingest_endpoint_urls", value)

    @property
    @pulumi.getter(name="logPublishingOptions")
    def log_publishing_options(self) -> Optional[pulumi.Input['PipelineLogPublishingOptionsArgs']]:
        """
        Key-value pairs to configure log publishing. See `log_publishing_options` below.
        """
        return pulumi.get(self, "log_publishing_options")

    @log_publishing_options.setter
    def log_publishing_options(self, value: Optional[pulumi.Input['PipelineLogPublishingOptionsArgs']]):
        pulumi.set(self, "log_publishing_options", value)

    @property
    @pulumi.getter(name="maxUnits")
    def max_units(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
        """
        return pulumi.get(self, "max_units")

    @max_units.setter
    def max_units(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_units", value)

    @property
    @pulumi.getter(name="minUnits")
    def min_units(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
        """
        return pulumi.get(self, "min_units")

    @min_units.setter
    def min_units(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_units", value)

    @property
    @pulumi.getter(name="pipelineArn")
    def pipeline_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of the pipeline.
        """
        return pulumi.get(self, "pipeline_arn")

    @pipeline_arn.setter
    def pipeline_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pipeline_arn", value)

    @property
    @pulumi.getter(name="pipelineConfigurationBody")
    def pipeline_configuration_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The pipeline configuration in YAML format. This argument accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\n.
        """
        return pulumi.get(self, "pipeline_configuration_body")

    @pipeline_configuration_body.setter
    def pipeline_configuration_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pipeline_configuration_body", value)

    @property
    @pulumi.getter(name="pipelineName")
    def pipeline_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the OpenSearch Ingestion pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.

        The following arguments are optional:
        """
        return pulumi.get(self, "pipeline_name")

    @pipeline_name.setter
    def pipeline_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pipeline_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['PipelineTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['PipelineTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="vpcOptions")
    def vpc_options(self) -> Optional[pulumi.Input['PipelineVpcOptionsArgs']]:
        """
        Container for the values required to configure VPC access for the pipeline. If you don't specify these values, OpenSearch Ingestion creates the pipeline with a public endpoint. See `vpc_options` below.
        """
        return pulumi.get(self, "vpc_options")

    @vpc_options.setter
    def vpc_options(self, value: Optional[pulumi.Input['PipelineVpcOptionsArgs']]):
        pulumi.set(self, "vpc_options", value)


@pulumi.type_token("aws:opensearchingest/pipeline:Pipeline")
class Pipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 buffer_options: Optional[pulumi.Input[Union['PipelineBufferOptionsArgs', 'PipelineBufferOptionsArgsDict']]] = None,
                 encryption_at_rest_options: Optional[pulumi.Input[Union['PipelineEncryptionAtRestOptionsArgs', 'PipelineEncryptionAtRestOptionsArgsDict']]] = None,
                 log_publishing_options: Optional[pulumi.Input[Union['PipelineLogPublishingOptionsArgs', 'PipelineLogPublishingOptionsArgsDict']]] = None,
                 max_units: Optional[pulumi.Input[builtins.int]] = None,
                 min_units: Optional[pulumi.Input[builtins.int]] = None,
                 pipeline_configuration_body: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['PipelineTimeoutsArgs', 'PipelineTimeoutsArgsDict']]] = None,
                 vpc_options: Optional[pulumi.Input[Union['PipelineVpcOptionsArgs', 'PipelineVpcOptionsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS OpenSearch Ingestion Pipeline.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_region()
        example = aws.iam.Role("example", assume_role_policy=json.dumps({
            "Version": "2012-10-17",
            "Statement": [{
                "Action": "sts:AssumeRole",
                "Effect": "Allow",
                "Sid": "",
                "Principal": {
                    "Service": "osis-pipelines.amazonaws.com",
                },
            }],
        }))
        example_pipeline = aws.opensearchingest.Pipeline("example",
            pipeline_name="example",
            pipeline_configuration_body=example.arn.apply(lambda arn: f\"\"\"version: "2"
        example-pipeline:
          source:
            http:
              path: "/example"
          sink:
            - s3:
                aws:
                  sts_role_arn: "{arn}"
                  region: "{current.region}"
                bucket: "example"
                threshold:
                  event_collect_timeout: "60s"
                codec:
                  ndjson:
        \"\"\"),
            max_units=1,
            min_units=1)
        ```

        ### Using file function

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.opensearchingest.Pipeline("example",
            pipeline_name="example",
            pipeline_configuration_body=std.file(input="example.yaml").result,
            max_units=1,
            min_units=1)
        ```

        ## Import

        Using `pulumi import`, import OpenSearch Ingestion Pipeline using the `id`. For example:

        ```sh
        $ pulumi import aws:opensearchingest/pipeline:Pipeline example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PipelineBufferOptionsArgs', 'PipelineBufferOptionsArgsDict']] buffer_options: Key-value pairs to configure persistent buffering for the pipeline. See `buffer_options` below.
        :param pulumi.Input[Union['PipelineEncryptionAtRestOptionsArgs', 'PipelineEncryptionAtRestOptionsArgsDict']] encryption_at_rest_options: Key-value pairs to configure encryption for data that is written to a persistent buffer. See `encryption_at_rest_options` below.
        :param pulumi.Input[Union['PipelineLogPublishingOptionsArgs', 'PipelineLogPublishingOptionsArgsDict']] log_publishing_options: Key-value pairs to configure log publishing. See `log_publishing_options` below.
        :param pulumi.Input[builtins.int] max_units: The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
        :param pulumi.Input[builtins.int] min_units: The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
        :param pulumi.Input[builtins.str] pipeline_configuration_body: The pipeline configuration in YAML format. This argument accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\n.
        :param pulumi.Input[builtins.str] pipeline_name: The name of the OpenSearch Ingestion pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['PipelineVpcOptionsArgs', 'PipelineVpcOptionsArgsDict']] vpc_options: Container for the values required to configure VPC access for the pipeline. If you don't specify these values, OpenSearch Ingestion creates the pipeline with a public endpoint. See `vpc_options` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS OpenSearch Ingestion Pipeline.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_region()
        example = aws.iam.Role("example", assume_role_policy=json.dumps({
            "Version": "2012-10-17",
            "Statement": [{
                "Action": "sts:AssumeRole",
                "Effect": "Allow",
                "Sid": "",
                "Principal": {
                    "Service": "osis-pipelines.amazonaws.com",
                },
            }],
        }))
        example_pipeline = aws.opensearchingest.Pipeline("example",
            pipeline_name="example",
            pipeline_configuration_body=example.arn.apply(lambda arn: f\"\"\"version: "2"
        example-pipeline:
          source:
            http:
              path: "/example"
          sink:
            - s3:
                aws:
                  sts_role_arn: "{arn}"
                  region: "{current.region}"
                bucket: "example"
                threshold:
                  event_collect_timeout: "60s"
                codec:
                  ndjson:
        \"\"\"),
            max_units=1,
            min_units=1)
        ```

        ### Using file function

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.opensearchingest.Pipeline("example",
            pipeline_name="example",
            pipeline_configuration_body=std.file(input="example.yaml").result,
            max_units=1,
            min_units=1)
        ```

        ## Import

        Using `pulumi import`, import OpenSearch Ingestion Pipeline using the `id`. For example:

        ```sh
        $ pulumi import aws:opensearchingest/pipeline:Pipeline example example
        ```

        :param str resource_name: The name of the resource.
        :param PipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 buffer_options: Optional[pulumi.Input[Union['PipelineBufferOptionsArgs', 'PipelineBufferOptionsArgsDict']]] = None,
                 encryption_at_rest_options: Optional[pulumi.Input[Union['PipelineEncryptionAtRestOptionsArgs', 'PipelineEncryptionAtRestOptionsArgsDict']]] = None,
                 log_publishing_options: Optional[pulumi.Input[Union['PipelineLogPublishingOptionsArgs', 'PipelineLogPublishingOptionsArgsDict']]] = None,
                 max_units: Optional[pulumi.Input[builtins.int]] = None,
                 min_units: Optional[pulumi.Input[builtins.int]] = None,
                 pipeline_configuration_body: Optional[pulumi.Input[builtins.str]] = None,
                 pipeline_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['PipelineTimeoutsArgs', 'PipelineTimeoutsArgsDict']]] = None,
                 vpc_options: Optional[pulumi.Input[Union['PipelineVpcOptionsArgs', 'PipelineVpcOptionsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineArgs.__new__(PipelineArgs)

            __props__.__dict__["buffer_options"] = buffer_options
            __props__.__dict__["encryption_at_rest_options"] = encryption_at_rest_options
            __props__.__dict__["log_publishing_options"] = log_publishing_options
            if max_units is None and not opts.urn:
                raise TypeError("Missing required property 'max_units'")
            __props__.__dict__["max_units"] = max_units
            if min_units is None and not opts.urn:
                raise TypeError("Missing required property 'min_units'")
            __props__.__dict__["min_units"] = min_units
            if pipeline_configuration_body is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_configuration_body'")
            __props__.__dict__["pipeline_configuration_body"] = pipeline_configuration_body
            if pipeline_name is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_name'")
            __props__.__dict__["pipeline_name"] = pipeline_name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["vpc_options"] = vpc_options
            __props__.__dict__["ingest_endpoint_urls"] = None
            __props__.__dict__["pipeline_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Pipeline, __self__).__init__(
            'aws:opensearchingest/pipeline:Pipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            buffer_options: Optional[pulumi.Input[Union['PipelineBufferOptionsArgs', 'PipelineBufferOptionsArgsDict']]] = None,
            encryption_at_rest_options: Optional[pulumi.Input[Union['PipelineEncryptionAtRestOptionsArgs', 'PipelineEncryptionAtRestOptionsArgsDict']]] = None,
            ingest_endpoint_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            log_publishing_options: Optional[pulumi.Input[Union['PipelineLogPublishingOptionsArgs', 'PipelineLogPublishingOptionsArgsDict']]] = None,
            max_units: Optional[pulumi.Input[builtins.int]] = None,
            min_units: Optional[pulumi.Input[builtins.int]] = None,
            pipeline_arn: Optional[pulumi.Input[builtins.str]] = None,
            pipeline_configuration_body: Optional[pulumi.Input[builtins.str]] = None,
            pipeline_name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['PipelineTimeoutsArgs', 'PipelineTimeoutsArgsDict']]] = None,
            vpc_options: Optional[pulumi.Input[Union['PipelineVpcOptionsArgs', 'PipelineVpcOptionsArgsDict']]] = None) -> 'Pipeline':
        """
        Get an existing Pipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PipelineBufferOptionsArgs', 'PipelineBufferOptionsArgsDict']] buffer_options: Key-value pairs to configure persistent buffering for the pipeline. See `buffer_options` below.
        :param pulumi.Input[Union['PipelineEncryptionAtRestOptionsArgs', 'PipelineEncryptionAtRestOptionsArgsDict']] encryption_at_rest_options: Key-value pairs to configure encryption for data that is written to a persistent buffer. See `encryption_at_rest_options` below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ingest_endpoint_urls: The list of ingestion endpoints for the pipeline, which you can send data to.
        :param pulumi.Input[Union['PipelineLogPublishingOptionsArgs', 'PipelineLogPublishingOptionsArgsDict']] log_publishing_options: Key-value pairs to configure log publishing. See `log_publishing_options` below.
        :param pulumi.Input[builtins.int] max_units: The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
        :param pulumi.Input[builtins.int] min_units: The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
        :param pulumi.Input[builtins.str] pipeline_arn: Amazon Resource Name (ARN) of the pipeline.
        :param pulumi.Input[builtins.str] pipeline_configuration_body: The pipeline configuration in YAML format. This argument accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\n.
        :param pulumi.Input[builtins.str] pipeline_name: The name of the OpenSearch Ingestion pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['PipelineVpcOptionsArgs', 'PipelineVpcOptionsArgsDict']] vpc_options: Container for the values required to configure VPC access for the pipeline. If you don't specify these values, OpenSearch Ingestion creates the pipeline with a public endpoint. See `vpc_options` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineState.__new__(_PipelineState)

        __props__.__dict__["buffer_options"] = buffer_options
        __props__.__dict__["encryption_at_rest_options"] = encryption_at_rest_options
        __props__.__dict__["ingest_endpoint_urls"] = ingest_endpoint_urls
        __props__.__dict__["log_publishing_options"] = log_publishing_options
        __props__.__dict__["max_units"] = max_units
        __props__.__dict__["min_units"] = min_units
        __props__.__dict__["pipeline_arn"] = pipeline_arn
        __props__.__dict__["pipeline_configuration_body"] = pipeline_configuration_body
        __props__.__dict__["pipeline_name"] = pipeline_name
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["vpc_options"] = vpc_options
        return Pipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bufferOptions")
    def buffer_options(self) -> pulumi.Output[Optional['outputs.PipelineBufferOptions']]:
        """
        Key-value pairs to configure persistent buffering for the pipeline. See `buffer_options` below.
        """
        return pulumi.get(self, "buffer_options")

    @property
    @pulumi.getter(name="encryptionAtRestOptions")
    def encryption_at_rest_options(self) -> pulumi.Output[Optional['outputs.PipelineEncryptionAtRestOptions']]:
        """
        Key-value pairs to configure encryption for data that is written to a persistent buffer. See `encryption_at_rest_options` below.
        """
        return pulumi.get(self, "encryption_at_rest_options")

    @property
    @pulumi.getter(name="ingestEndpointUrls")
    def ingest_endpoint_urls(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of ingestion endpoints for the pipeline, which you can send data to.
        """
        return pulumi.get(self, "ingest_endpoint_urls")

    @property
    @pulumi.getter(name="logPublishingOptions")
    def log_publishing_options(self) -> pulumi.Output[Optional['outputs.PipelineLogPublishingOptions']]:
        """
        Key-value pairs to configure log publishing. See `log_publishing_options` below.
        """
        return pulumi.get(self, "log_publishing_options")

    @property
    @pulumi.getter(name="maxUnits")
    def max_units(self) -> pulumi.Output[builtins.int]:
        """
        The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
        """
        return pulumi.get(self, "max_units")

    @property
    @pulumi.getter(name="minUnits")
    def min_units(self) -> pulumi.Output[builtins.int]:
        """
        The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
        """
        return pulumi.get(self, "min_units")

    @property
    @pulumi.getter(name="pipelineArn")
    def pipeline_arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of the pipeline.
        """
        return pulumi.get(self, "pipeline_arn")

    @property
    @pulumi.getter(name="pipelineConfigurationBody")
    def pipeline_configuration_body(self) -> pulumi.Output[builtins.str]:
        """
        The pipeline configuration in YAML format. This argument accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\n.
        """
        return pulumi.get(self, "pipeline_configuration_body")

    @property
    @pulumi.getter(name="pipelineName")
    def pipeline_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the OpenSearch Ingestion pipeline to create. Pipeline names are unique across the pipelines owned by an account within an AWS Region.

        The following arguments are optional:
        """
        return pulumi.get(self, "pipeline_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.PipelineTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="vpcOptions")
    def vpc_options(self) -> pulumi.Output[Optional['outputs.PipelineVpcOptions']]:
        """
        Container for the values required to configure VPC access for the pipeline. If you don't specify these values, OpenSearch Ingestion creates the pipeline with a public endpoint. See `vpc_options` below.
        """
        return pulumi.get(self, "vpc_options")

