# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetOutpostInstanceTypeResult',
    'AwaitableGetOutpostInstanceTypeResult',
    'get_outpost_instance_type',
    'get_outpost_instance_type_output',
]

@pulumi.output_type
class GetOutpostInstanceTypeResult:
    """
    A collection of values returned by getOutpostInstanceType.
    """
    def __init__(__self__, arn=None, id=None, instance_type=None, preferred_instance_types=None, region=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_type and not isinstance(instance_type, str):
            raise TypeError("Expected argument 'instance_type' to be a str")
        pulumi.set(__self__, "instance_type", instance_type)
        if preferred_instance_types and not isinstance(preferred_instance_types, list):
            raise TypeError("Expected argument 'preferred_instance_types' to be a list")
        pulumi.set(__self__, "preferred_instance_types", preferred_instance_types)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> builtins.str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="preferredInstanceTypes")
    def preferred_instance_types(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "preferred_instance_types")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetOutpostInstanceTypeResult(GetOutpostInstanceTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOutpostInstanceTypeResult(
            arn=self.arn,
            id=self.id,
            instance_type=self.instance_type,
            preferred_instance_types=self.preferred_instance_types,
            region=self.region)


def get_outpost_instance_type(arn: Optional[builtins.str] = None,
                              instance_type: Optional[builtins.str] = None,
                              preferred_instance_types: Optional[Sequence[builtins.str]] = None,
                              region: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOutpostInstanceTypeResult:
    """
    Information about single Outpost Instance Type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.outposts.get_outpost_instance_type(arn=example_aws_outposts_outpost["arn"],
        preferred_instance_types=[
            "m5.large",
            "m5.4xlarge",
        ])
    example_ec2_instance = aws.index.Ec2Instance("example", instance_type=example.instance_type)
    ```


    :param builtins.str arn: Outpost ARN.
           
           The following arguments are optional:
    :param builtins.str instance_type: Desired instance type. Conflicts with `preferred_instance_types`.
    :param Sequence[builtins.str] preferred_instance_types: Ordered list of preferred instance types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. Conflicts with `instance_type`.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['instanceType'] = instance_type
    __args__['preferredInstanceTypes'] = preferred_instance_types
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:outposts/getOutpostInstanceType:getOutpostInstanceType', __args__, opts=opts, typ=GetOutpostInstanceTypeResult).value

    return AwaitableGetOutpostInstanceTypeResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        instance_type=pulumi.get(__ret__, 'instance_type'),
        preferred_instance_types=pulumi.get(__ret__, 'preferred_instance_types'),
        region=pulumi.get(__ret__, 'region'))
def get_outpost_instance_type_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                                     instance_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     preferred_instance_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                     region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOutpostInstanceTypeResult]:
    """
    Information about single Outpost Instance Type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.outposts.get_outpost_instance_type(arn=example_aws_outposts_outpost["arn"],
        preferred_instance_types=[
            "m5.large",
            "m5.4xlarge",
        ])
    example_ec2_instance = aws.index.Ec2Instance("example", instance_type=example.instance_type)
    ```


    :param builtins.str arn: Outpost ARN.
           
           The following arguments are optional:
    :param builtins.str instance_type: Desired instance type. Conflicts with `preferred_instance_types`.
    :param Sequence[builtins.str] preferred_instance_types: Ordered list of preferred instance types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. Conflicts with `instance_type`.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['instanceType'] = instance_type
    __args__['preferredInstanceTypes'] = preferred_instance_types
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:outposts/getOutpostInstanceType:getOutpostInstanceType', __args__, opts=opts, typ=GetOutpostInstanceTypeResult)
    return __ret__.apply(lambda __response__: GetOutpostInstanceTypeResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        instance_type=pulumi.get(__response__, 'instance_type'),
        preferred_instance_types=pulumi.get(__response__, 'preferred_instance_types'),
        region=pulumi.get(__response__, 'region')))
