# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetOutpostsResult',
    'AwaitableGetOutpostsResult',
    'get_outposts',
    'get_outposts_output',
]

@pulumi.output_type
class GetOutpostsResult:
    """
    A collection of values returned by getOutposts.
    """
    def __init__(__self__, arns=None, availability_zone=None, availability_zone_id=None, id=None, ids=None, owner_id=None, region=None, site_id=None):
        if arns and not isinstance(arns, list):
            raise TypeError("Expected argument 'arns' to be a list")
        pulumi.set(__self__, "arns", arns)
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_id and not isinstance(availability_zone_id, str):
            raise TypeError("Expected argument 'availability_zone_id' to be a str")
        pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if site_id and not isinstance(site_id, str):
            raise TypeError("Expected argument 'site_id' to be a str")
        pulumi.set(__self__, "site_id", site_id)

    @property
    @pulumi.getter
    def arns(self) -> Sequence[builtins.str]:
        """
        Set of Amazon Resource Names (ARNs).
        """
        return pulumi.get(self, "arns")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> builtins.str:
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> builtins.str:
        return pulumi.get(self, "availability_zone_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[builtins.str]:
        """
        Set of identifiers.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> builtins.str:
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> builtins.str:
        return pulumi.get(self, "site_id")


class AwaitableGetOutpostsResult(GetOutpostsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOutpostsResult(
            arns=self.arns,
            availability_zone=self.availability_zone,
            availability_zone_id=self.availability_zone_id,
            id=self.id,
            ids=self.ids,
            owner_id=self.owner_id,
            region=self.region,
            site_id=self.site_id)


def get_outposts(availability_zone: Optional[builtins.str] = None,
                 availability_zone_id: Optional[builtins.str] = None,
                 owner_id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 site_id: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOutpostsResult:
    """
    Provides details about multiple Outposts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.outposts.get_outposts(site_id=id)
    ```


    :param builtins.str availability_zone: Availability Zone name.
    :param builtins.str availability_zone_id: Availability Zone identifier.
    :param builtins.str owner_id: AWS Account identifier of the Outpost owner.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str site_id: Site identifier.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['availabilityZoneId'] = availability_zone_id
    __args__['ownerId'] = owner_id
    __args__['region'] = region
    __args__['siteId'] = site_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:outposts/getOutposts:getOutposts', __args__, opts=opts, typ=GetOutpostsResult).value

    return AwaitableGetOutpostsResult(
        arns=pulumi.get(__ret__, 'arns'),
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        availability_zone_id=pulumi.get(__ret__, 'availability_zone_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        region=pulumi.get(__ret__, 'region'),
        site_id=pulumi.get(__ret__, 'site_id'))
def get_outposts_output(availability_zone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        availability_zone_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        owner_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        site_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOutpostsResult]:
    """
    Provides details about multiple Outposts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.outposts.get_outposts(site_id=id)
    ```


    :param builtins.str availability_zone: Availability Zone name.
    :param builtins.str availability_zone_id: Availability Zone identifier.
    :param builtins.str owner_id: AWS Account identifier of the Outpost owner.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str site_id: Site identifier.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['availabilityZoneId'] = availability_zone_id
    __args__['ownerId'] = owner_id
    __args__['region'] = region
    __args__['siteId'] = site_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:outposts/getOutposts:getOutposts', __args__, opts=opts, typ=GetOutpostsResult)
    return __ret__.apply(lambda __response__: GetOutpostsResult(
        arns=pulumi.get(__response__, 'arns'),
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        availability_zone_id=pulumi.get(__response__, 'availability_zone_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        region=pulumi.get(__response__, 'region'),
        site_id=pulumi.get(__response__, 'site_id')))
