# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'KeyKeyAttribute',
    'KeyKeyAttributeKeyModesOfUse',
    'KeyTimeouts',
]

@pulumi.output_type
class KeyKeyAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyAlgorithm":
            suggest = "key_algorithm"
        elif key == "keyClass":
            suggest = "key_class"
        elif key == "keyUsage":
            suggest = "key_usage"
        elif key == "keyModesOfUses":
            suggest = "key_modes_of_uses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyKeyAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyKeyAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyKeyAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_algorithm: builtins.str,
                 key_class: builtins.str,
                 key_usage: builtins.str,
                 key_modes_of_uses: Optional[Sequence['outputs.KeyKeyAttributeKeyModesOfUse']] = None):
        """
        :param builtins.str key_algorithm: Key algorithm to be use during creation of an AWS Payment Cryptography key.
        :param builtins.str key_class: Type of AWS Payment Cryptography key to create.
        :param builtins.str key_usage: Cryptographic usage of an AWS Payment Cryptography key as defined in section A.5.2 of the TR-31 spec.
        :param Sequence['KeyKeyAttributeKeyModesOfUseArgs'] key_modes_of_uses: List of cryptographic operations that you can perform using the key.
        """
        pulumi.set(__self__, "key_algorithm", key_algorithm)
        pulumi.set(__self__, "key_class", key_class)
        pulumi.set(__self__, "key_usage", key_usage)
        if key_modes_of_uses is not None:
            pulumi.set(__self__, "key_modes_of_uses", key_modes_of_uses)

    @property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> builtins.str:
        """
        Key algorithm to be use during creation of an AWS Payment Cryptography key.
        """
        return pulumi.get(self, "key_algorithm")

    @property
    @pulumi.getter(name="keyClass")
    def key_class(self) -> builtins.str:
        """
        Type of AWS Payment Cryptography key to create.
        """
        return pulumi.get(self, "key_class")

    @property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> builtins.str:
        """
        Cryptographic usage of an AWS Payment Cryptography key as defined in section A.5.2 of the TR-31 spec.
        """
        return pulumi.get(self, "key_usage")

    @property
    @pulumi.getter(name="keyModesOfUses")
    def key_modes_of_uses(self) -> Optional[Sequence['outputs.KeyKeyAttributeKeyModesOfUse']]:
        """
        List of cryptographic operations that you can perform using the key.
        """
        return pulumi.get(self, "key_modes_of_uses")


@pulumi.output_type
class KeyKeyAttributeKeyModesOfUse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deriveKey":
            suggest = "derive_key"
        elif key == "noRestrictions":
            suggest = "no_restrictions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyKeyAttributeKeyModesOfUse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyKeyAttributeKeyModesOfUse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyKeyAttributeKeyModesOfUse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 decrypt: Optional[builtins.bool] = None,
                 derive_key: Optional[builtins.bool] = None,
                 encrypt: Optional[builtins.bool] = None,
                 generate: Optional[builtins.bool] = None,
                 no_restrictions: Optional[builtins.bool] = None,
                 sign: Optional[builtins.bool] = None,
                 unwrap: Optional[builtins.bool] = None,
                 verify: Optional[builtins.bool] = None,
                 wrap: Optional[builtins.bool] = None):
        """
        :param builtins.bool decrypt: Whether an AWS Payment Cryptography key can be used to decrypt data.
        :param builtins.bool derive_key: Whether an AWS Payment Cryptography key can be used to derive new keys.
        :param builtins.bool encrypt: Whether an AWS Payment Cryptography key can be used to encrypt data.
        :param builtins.bool generate: Whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
        :param builtins.bool no_restrictions: Whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by KeyUsage.
        :param builtins.bool sign: Whether an AWS Payment Cryptography key can be used for signing.
        :param builtins.bool unwrap: Whether an AWS Payment Cryptography key can be used to unwrap other keys.
        :param builtins.bool verify: Whether an AWS Payment Cryptography key can be used to verify signatures.
        :param builtins.bool wrap: Whether an AWS Payment Cryptography key can be used to wrap other keys.
        """
        if decrypt is not None:
            pulumi.set(__self__, "decrypt", decrypt)
        if derive_key is not None:
            pulumi.set(__self__, "derive_key", derive_key)
        if encrypt is not None:
            pulumi.set(__self__, "encrypt", encrypt)
        if generate is not None:
            pulumi.set(__self__, "generate", generate)
        if no_restrictions is not None:
            pulumi.set(__self__, "no_restrictions", no_restrictions)
        if sign is not None:
            pulumi.set(__self__, "sign", sign)
        if unwrap is not None:
            pulumi.set(__self__, "unwrap", unwrap)
        if verify is not None:
            pulumi.set(__self__, "verify", verify)
        if wrap is not None:
            pulumi.set(__self__, "wrap", wrap)

    @property
    @pulumi.getter
    def decrypt(self) -> Optional[builtins.bool]:
        """
        Whether an AWS Payment Cryptography key can be used to decrypt data.
        """
        return pulumi.get(self, "decrypt")

    @property
    @pulumi.getter(name="deriveKey")
    def derive_key(self) -> Optional[builtins.bool]:
        """
        Whether an AWS Payment Cryptography key can be used to derive new keys.
        """
        return pulumi.get(self, "derive_key")

    @property
    @pulumi.getter
    def encrypt(self) -> Optional[builtins.bool]:
        """
        Whether an AWS Payment Cryptography key can be used to encrypt data.
        """
        return pulumi.get(self, "encrypt")

    @property
    @pulumi.getter
    def generate(self) -> Optional[builtins.bool]:
        """
        Whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
        """
        return pulumi.get(self, "generate")

    @property
    @pulumi.getter(name="noRestrictions")
    def no_restrictions(self) -> Optional[builtins.bool]:
        """
        Whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by KeyUsage.
        """
        return pulumi.get(self, "no_restrictions")

    @property
    @pulumi.getter
    def sign(self) -> Optional[builtins.bool]:
        """
        Whether an AWS Payment Cryptography key can be used for signing.
        """
        return pulumi.get(self, "sign")

    @property
    @pulumi.getter
    def unwrap(self) -> Optional[builtins.bool]:
        """
        Whether an AWS Payment Cryptography key can be used to unwrap other keys.
        """
        return pulumi.get(self, "unwrap")

    @property
    @pulumi.getter
    def verify(self) -> Optional[builtins.bool]:
        """
        Whether an AWS Payment Cryptography key can be used to verify signatures.
        """
        return pulumi.get(self, "verify")

    @property
    @pulumi.getter
    def wrap(self) -> Optional[builtins.bool]:
        """
        Whether an AWS Payment Cryptography key can be used to wrap other keys.
        """
        return pulumi.get(self, "wrap")


@pulumi.output_type
class KeyTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


