# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['Smsvoicev2PhoneNumberArgs', 'Smsvoicev2PhoneNumber']

@pulumi.input_type
class Smsvoicev2PhoneNumberArgs:
    def __init__(__self__, *,
                 iso_country_code: pulumi.Input[builtins.str],
                 message_type: pulumi.Input[builtins.str],
                 number_capabilities: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 number_type: pulumi.Input[builtins.str],
                 deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 opt_out_list_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 registration_id: Optional[pulumi.Input[builtins.str]] = None,
                 self_managed_opt_outs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['Smsvoicev2PhoneNumberTimeoutsArgs']] = None,
                 two_way_channel_arn: Optional[pulumi.Input[builtins.str]] = None,
                 two_way_channel_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 two_way_channel_role: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Smsvoicev2PhoneNumber resource.
        :param pulumi.Input[builtins.str] iso_country_code: The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
        :param pulumi.Input[builtins.str] message_type: The type of message. Valid values are `TRANSACTIONAL` for messages that are critical or time-sensitive and `PROMOTIONAL` for messages that aren’t critical or time-sensitive.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] number_capabilities: Describes if the origination identity can be used for text messages, voice calls or both. valid values are `SMS` and `VOICE`.
        :param pulumi.Input[builtins.str] number_type: The type of phone number to request. Possible values are `LONG_CODE`, `TOLL_FREE`, `TEN_DLC`, or `SIMULATOR`.
        :param pulumi.Input[builtins.bool] deletion_protection_enabled: By default this is set to `false`. When set to true the phone number can’t be deleted.
        :param pulumi.Input[builtins.str] opt_out_list_name: The name of the opt-out list to associate with the phone number.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] registration_id: Use this field to attach your phone number for an external registration process.
        :param pulumi.Input[builtins.bool] self_managed_opt_outs_enabled: When set to `false` an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, AWS End User Messaging SMS and Voice automatically replies with a customizable message and adds the end recipient to the opt-out list. When set to true you’re responsible for responding to HELP and STOP requests. You’re also responsible for tracking and honoring opt-out request.
        :param pulumi.Input[builtins.str] two_way_channel_arn: The Amazon Resource Name (ARN) of the two way channel.
        :param pulumi.Input[builtins.bool] two_way_channel_enabled: By default this is set to `false`. When set to `true` you can receive incoming text messages from your end recipients.
        :param pulumi.Input[builtins.str] two_way_channel_role: IAM Role ARN for a service to assume, to be able to post inbound SMS messages.
        """
        pulumi.set(__self__, "iso_country_code", iso_country_code)
        pulumi.set(__self__, "message_type", message_type)
        pulumi.set(__self__, "number_capabilities", number_capabilities)
        pulumi.set(__self__, "number_type", number_type)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if opt_out_list_name is not None:
            pulumi.set(__self__, "opt_out_list_name", opt_out_list_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registration_id is not None:
            pulumi.set(__self__, "registration_id", registration_id)
        if self_managed_opt_outs_enabled is not None:
            pulumi.set(__self__, "self_managed_opt_outs_enabled", self_managed_opt_outs_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if two_way_channel_arn is not None:
            pulumi.set(__self__, "two_way_channel_arn", two_way_channel_arn)
        if two_way_channel_enabled is not None:
            pulumi.set(__self__, "two_way_channel_enabled", two_way_channel_enabled)
        if two_way_channel_role is not None:
            pulumi.set(__self__, "two_way_channel_role", two_way_channel_role)

    @property
    @pulumi.getter(name="isoCountryCode")
    def iso_country_code(self) -> pulumi.Input[builtins.str]:
        """
        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
        """
        return pulumi.get(self, "iso_country_code")

    @iso_country_code.setter
    def iso_country_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "iso_country_code", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of message. Valid values are `TRANSACTIONAL` for messages that are critical or time-sensitive and `PROMOTIONAL` for messages that aren’t critical or time-sensitive.
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter(name="numberCapabilities")
    def number_capabilities(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Describes if the origination identity can be used for text messages, voice calls or both. valid values are `SMS` and `VOICE`.
        """
        return pulumi.get(self, "number_capabilities")

    @number_capabilities.setter
    def number_capabilities(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "number_capabilities", value)

    @property
    @pulumi.getter(name="numberType")
    def number_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of phone number to request. Possible values are `LONG_CODE`, `TOLL_FREE`, `TEN_DLC`, or `SIMULATOR`.
        """
        return pulumi.get(self, "number_type")

    @number_type.setter
    def number_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "number_type", value)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        By default this is set to `false`. When set to true the phone number can’t be deleted.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter(name="optOutListName")
    def opt_out_list_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the opt-out list to associate with the phone number.
        """
        return pulumi.get(self, "opt_out_list_name")

    @opt_out_list_name.setter
    def opt_out_list_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "opt_out_list_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="registrationId")
    def registration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Use this field to attach your phone number for an external registration process.
        """
        return pulumi.get(self, "registration_id")

    @registration_id.setter
    def registration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registration_id", value)

    @property
    @pulumi.getter(name="selfManagedOptOutsEnabled")
    def self_managed_opt_outs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to `false` an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, AWS End User Messaging SMS and Voice automatically replies with a customizable message and adds the end recipient to the opt-out list. When set to true you’re responsible for responding to HELP and STOP requests. You’re also responsible for tracking and honoring opt-out request.
        """
        return pulumi.get(self, "self_managed_opt_outs_enabled")

    @self_managed_opt_outs_enabled.setter
    def self_managed_opt_outs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "self_managed_opt_outs_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['Smsvoicev2PhoneNumberTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['Smsvoicev2PhoneNumberTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="twoWayChannelArn")
    def two_way_channel_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the two way channel.
        """
        return pulumi.get(self, "two_way_channel_arn")

    @two_way_channel_arn.setter
    def two_way_channel_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "two_way_channel_arn", value)

    @property
    @pulumi.getter(name="twoWayChannelEnabled")
    def two_way_channel_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        By default this is set to `false`. When set to `true` you can receive incoming text messages from your end recipients.
        """
        return pulumi.get(self, "two_way_channel_enabled")

    @two_way_channel_enabled.setter
    def two_way_channel_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "two_way_channel_enabled", value)

    @property
    @pulumi.getter(name="twoWayChannelRole")
    def two_way_channel_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IAM Role ARN for a service to assume, to be able to post inbound SMS messages.
        """
        return pulumi.get(self, "two_way_channel_role")

    @two_way_channel_role.setter
    def two_way_channel_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "two_way_channel_role", value)


@pulumi.input_type
class _Smsvoicev2PhoneNumberState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 iso_country_code: Optional[pulumi.Input[builtins.str]] = None,
                 message_type: Optional[pulumi.Input[builtins.str]] = None,
                 monthly_leasing_price: Optional[pulumi.Input[builtins.str]] = None,
                 number_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 number_type: Optional[pulumi.Input[builtins.str]] = None,
                 opt_out_list_name: Optional[pulumi.Input[builtins.str]] = None,
                 phone_number: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 registration_id: Optional[pulumi.Input[builtins.str]] = None,
                 self_managed_opt_outs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['Smsvoicev2PhoneNumberTimeoutsArgs']] = None,
                 two_way_channel_arn: Optional[pulumi.Input[builtins.str]] = None,
                 two_way_channel_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 two_way_channel_role: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Smsvoicev2PhoneNumber resources.
        :param pulumi.Input[builtins.str] arn: ARN of the phone number.
        :param pulumi.Input[builtins.bool] deletion_protection_enabled: By default this is set to `false`. When set to true the phone number can’t be deleted.
        :param pulumi.Input[builtins.str] iso_country_code: The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
        :param pulumi.Input[builtins.str] message_type: The type of message. Valid values are `TRANSACTIONAL` for messages that are critical or time-sensitive and `PROMOTIONAL` for messages that aren’t critical or time-sensitive.
        :param pulumi.Input[builtins.str] monthly_leasing_price: The monthly price, in US dollars, to lease the phone number.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] number_capabilities: Describes if the origination identity can be used for text messages, voice calls or both. valid values are `SMS` and `VOICE`.
        :param pulumi.Input[builtins.str] number_type: The type of phone number to request. Possible values are `LONG_CODE`, `TOLL_FREE`, `TEN_DLC`, or `SIMULATOR`.
        :param pulumi.Input[builtins.str] opt_out_list_name: The name of the opt-out list to associate with the phone number.
        :param pulumi.Input[builtins.str] phone_number: The new phone number that was requested.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] registration_id: Use this field to attach your phone number for an external registration process.
        :param pulumi.Input[builtins.bool] self_managed_opt_outs_enabled: When set to `false` an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, AWS End User Messaging SMS and Voice automatically replies with a customizable message and adds the end recipient to the opt-out list. When set to true you’re responsible for responding to HELP and STOP requests. You’re also responsible for tracking and honoring opt-out request.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] two_way_channel_arn: The Amazon Resource Name (ARN) of the two way channel.
        :param pulumi.Input[builtins.bool] two_way_channel_enabled: By default this is set to `false`. When set to `true` you can receive incoming text messages from your end recipients.
        :param pulumi.Input[builtins.str] two_way_channel_role: IAM Role ARN for a service to assume, to be able to post inbound SMS messages.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if iso_country_code is not None:
            pulumi.set(__self__, "iso_country_code", iso_country_code)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if monthly_leasing_price is not None:
            pulumi.set(__self__, "monthly_leasing_price", monthly_leasing_price)
        if number_capabilities is not None:
            pulumi.set(__self__, "number_capabilities", number_capabilities)
        if number_type is not None:
            pulumi.set(__self__, "number_type", number_type)
        if opt_out_list_name is not None:
            pulumi.set(__self__, "opt_out_list_name", opt_out_list_name)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registration_id is not None:
            pulumi.set(__self__, "registration_id", registration_id)
        if self_managed_opt_outs_enabled is not None:
            pulumi.set(__self__, "self_managed_opt_outs_enabled", self_managed_opt_outs_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if two_way_channel_arn is not None:
            pulumi.set(__self__, "two_way_channel_arn", two_way_channel_arn)
        if two_way_channel_enabled is not None:
            pulumi.set(__self__, "two_way_channel_enabled", two_way_channel_enabled)
        if two_way_channel_role is not None:
            pulumi.set(__self__, "two_way_channel_role", two_way_channel_role)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the phone number.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        By default this is set to `false`. When set to true the phone number can’t be deleted.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @deletion_protection_enabled.setter
    def deletion_protection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection_enabled", value)

    @property
    @pulumi.getter(name="isoCountryCode")
    def iso_country_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
        """
        return pulumi.get(self, "iso_country_code")

    @iso_country_code.setter
    def iso_country_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iso_country_code", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of message. Valid values are `TRANSACTIONAL` for messages that are critical or time-sensitive and `PROMOTIONAL` for messages that aren’t critical or time-sensitive.
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter(name="monthlyLeasingPrice")
    def monthly_leasing_price(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The monthly price, in US dollars, to lease the phone number.
        """
        return pulumi.get(self, "monthly_leasing_price")

    @monthly_leasing_price.setter
    def monthly_leasing_price(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "monthly_leasing_price", value)

    @property
    @pulumi.getter(name="numberCapabilities")
    def number_capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Describes if the origination identity can be used for text messages, voice calls or both. valid values are `SMS` and `VOICE`.
        """
        return pulumi.get(self, "number_capabilities")

    @number_capabilities.setter
    def number_capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "number_capabilities", value)

    @property
    @pulumi.getter(name="numberType")
    def number_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of phone number to request. Possible values are `LONG_CODE`, `TOLL_FREE`, `TEN_DLC`, or `SIMULATOR`.
        """
        return pulumi.get(self, "number_type")

    @number_type.setter
    def number_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "number_type", value)

    @property
    @pulumi.getter(name="optOutListName")
    def opt_out_list_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the opt-out list to associate with the phone number.
        """
        return pulumi.get(self, "opt_out_list_name")

    @opt_out_list_name.setter
    def opt_out_list_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "opt_out_list_name", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The new phone number that was requested.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "phone_number", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="registrationId")
    def registration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Use this field to attach your phone number for an external registration process.
        """
        return pulumi.get(self, "registration_id")

    @registration_id.setter
    def registration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registration_id", value)

    @property
    @pulumi.getter(name="selfManagedOptOutsEnabled")
    def self_managed_opt_outs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to `false` an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, AWS End User Messaging SMS and Voice automatically replies with a customizable message and adds the end recipient to the opt-out list. When set to true you’re responsible for responding to HELP and STOP requests. You’re also responsible for tracking and honoring opt-out request.
        """
        return pulumi.get(self, "self_managed_opt_outs_enabled")

    @self_managed_opt_outs_enabled.setter
    def self_managed_opt_outs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "self_managed_opt_outs_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['Smsvoicev2PhoneNumberTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['Smsvoicev2PhoneNumberTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="twoWayChannelArn")
    def two_way_channel_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the two way channel.
        """
        return pulumi.get(self, "two_way_channel_arn")

    @two_way_channel_arn.setter
    def two_way_channel_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "two_way_channel_arn", value)

    @property
    @pulumi.getter(name="twoWayChannelEnabled")
    def two_way_channel_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        By default this is set to `false`. When set to `true` you can receive incoming text messages from your end recipients.
        """
        return pulumi.get(self, "two_way_channel_enabled")

    @two_way_channel_enabled.setter
    def two_way_channel_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "two_way_channel_enabled", value)

    @property
    @pulumi.getter(name="twoWayChannelRole")
    def two_way_channel_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IAM Role ARN for a service to assume, to be able to post inbound SMS messages.
        """
        return pulumi.get(self, "two_way_channel_role")

    @two_way_channel_role.setter
    def two_way_channel_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "two_way_channel_role", value)


@pulumi.type_token("aws:pinpoint/smsvoicev2PhoneNumber:Smsvoicev2PhoneNumber")
class Smsvoicev2PhoneNumber(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 iso_country_code: Optional[pulumi.Input[builtins.str]] = None,
                 message_type: Optional[pulumi.Input[builtins.str]] = None,
                 number_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 number_type: Optional[pulumi.Input[builtins.str]] = None,
                 opt_out_list_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 registration_id: Optional[pulumi.Input[builtins.str]] = None,
                 self_managed_opt_outs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['Smsvoicev2PhoneNumberTimeoutsArgs', 'Smsvoicev2PhoneNumberTimeoutsArgsDict']]] = None,
                 two_way_channel_arn: Optional[pulumi.Input[builtins.str]] = None,
                 two_way_channel_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 two_way_channel_role: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an AWS End User Messaging SMS phone number.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.pinpoint.Smsvoicev2PhoneNumber("example",
            iso_country_code="US",
            message_type="TRANSACTIONAL",
            number_type="TOLL_FREE",
            number_capabilities=["SMS"])
        ```

        ## Import

        Using `pulumi import`, import phone numbers using the `id`. For example:

        ```sh
        $ pulumi import aws:pinpoint/smsvoicev2PhoneNumber:Smsvoicev2PhoneNumber example phone-abcdef0123456789abcdef0123456789
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] deletion_protection_enabled: By default this is set to `false`. When set to true the phone number can’t be deleted.
        :param pulumi.Input[builtins.str] iso_country_code: The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
        :param pulumi.Input[builtins.str] message_type: The type of message. Valid values are `TRANSACTIONAL` for messages that are critical or time-sensitive and `PROMOTIONAL` for messages that aren’t critical or time-sensitive.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] number_capabilities: Describes if the origination identity can be used for text messages, voice calls or both. valid values are `SMS` and `VOICE`.
        :param pulumi.Input[builtins.str] number_type: The type of phone number to request. Possible values are `LONG_CODE`, `TOLL_FREE`, `TEN_DLC`, or `SIMULATOR`.
        :param pulumi.Input[builtins.str] opt_out_list_name: The name of the opt-out list to associate with the phone number.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] registration_id: Use this field to attach your phone number for an external registration process.
        :param pulumi.Input[builtins.bool] self_managed_opt_outs_enabled: When set to `false` an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, AWS End User Messaging SMS and Voice automatically replies with a customizable message and adds the end recipient to the opt-out list. When set to true you’re responsible for responding to HELP and STOP requests. You’re also responsible for tracking and honoring opt-out request.
        :param pulumi.Input[builtins.str] two_way_channel_arn: The Amazon Resource Name (ARN) of the two way channel.
        :param pulumi.Input[builtins.bool] two_way_channel_enabled: By default this is set to `false`. When set to `true` you can receive incoming text messages from your end recipients.
        :param pulumi.Input[builtins.str] two_way_channel_role: IAM Role ARN for a service to assume, to be able to post inbound SMS messages.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Smsvoicev2PhoneNumberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS End User Messaging SMS phone number.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.pinpoint.Smsvoicev2PhoneNumber("example",
            iso_country_code="US",
            message_type="TRANSACTIONAL",
            number_type="TOLL_FREE",
            number_capabilities=["SMS"])
        ```

        ## Import

        Using `pulumi import`, import phone numbers using the `id`. For example:

        ```sh
        $ pulumi import aws:pinpoint/smsvoicev2PhoneNumber:Smsvoicev2PhoneNumber example phone-abcdef0123456789abcdef0123456789
        ```

        :param str resource_name: The name of the resource.
        :param Smsvoicev2PhoneNumberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Smsvoicev2PhoneNumberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 iso_country_code: Optional[pulumi.Input[builtins.str]] = None,
                 message_type: Optional[pulumi.Input[builtins.str]] = None,
                 number_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 number_type: Optional[pulumi.Input[builtins.str]] = None,
                 opt_out_list_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 registration_id: Optional[pulumi.Input[builtins.str]] = None,
                 self_managed_opt_outs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['Smsvoicev2PhoneNumberTimeoutsArgs', 'Smsvoicev2PhoneNumberTimeoutsArgsDict']]] = None,
                 two_way_channel_arn: Optional[pulumi.Input[builtins.str]] = None,
                 two_way_channel_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 two_way_channel_role: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Smsvoicev2PhoneNumberArgs.__new__(Smsvoicev2PhoneNumberArgs)

            __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
            if iso_country_code is None and not opts.urn:
                raise TypeError("Missing required property 'iso_country_code'")
            __props__.__dict__["iso_country_code"] = iso_country_code
            if message_type is None and not opts.urn:
                raise TypeError("Missing required property 'message_type'")
            __props__.__dict__["message_type"] = message_type
            if number_capabilities is None and not opts.urn:
                raise TypeError("Missing required property 'number_capabilities'")
            __props__.__dict__["number_capabilities"] = number_capabilities
            if number_type is None and not opts.urn:
                raise TypeError("Missing required property 'number_type'")
            __props__.__dict__["number_type"] = number_type
            __props__.__dict__["opt_out_list_name"] = opt_out_list_name
            __props__.__dict__["region"] = region
            __props__.__dict__["registration_id"] = registration_id
            __props__.__dict__["self_managed_opt_outs_enabled"] = self_managed_opt_outs_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["two_way_channel_arn"] = two_way_channel_arn
            __props__.__dict__["two_way_channel_enabled"] = two_way_channel_enabled
            __props__.__dict__["two_way_channel_role"] = two_way_channel_role
            __props__.__dict__["arn"] = None
            __props__.__dict__["monthly_leasing_price"] = None
            __props__.__dict__["phone_number"] = None
            __props__.__dict__["tags_all"] = None
        super(Smsvoicev2PhoneNumber, __self__).__init__(
            'aws:pinpoint/smsvoicev2PhoneNumber:Smsvoicev2PhoneNumber',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            deletion_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            iso_country_code: Optional[pulumi.Input[builtins.str]] = None,
            message_type: Optional[pulumi.Input[builtins.str]] = None,
            monthly_leasing_price: Optional[pulumi.Input[builtins.str]] = None,
            number_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            number_type: Optional[pulumi.Input[builtins.str]] = None,
            opt_out_list_name: Optional[pulumi.Input[builtins.str]] = None,
            phone_number: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            registration_id: Optional[pulumi.Input[builtins.str]] = None,
            self_managed_opt_outs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['Smsvoicev2PhoneNumberTimeoutsArgs', 'Smsvoicev2PhoneNumberTimeoutsArgsDict']]] = None,
            two_way_channel_arn: Optional[pulumi.Input[builtins.str]] = None,
            two_way_channel_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            two_way_channel_role: Optional[pulumi.Input[builtins.str]] = None) -> 'Smsvoicev2PhoneNumber':
        """
        Get an existing Smsvoicev2PhoneNumber resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the phone number.
        :param pulumi.Input[builtins.bool] deletion_protection_enabled: By default this is set to `false`. When set to true the phone number can’t be deleted.
        :param pulumi.Input[builtins.str] iso_country_code: The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
        :param pulumi.Input[builtins.str] message_type: The type of message. Valid values are `TRANSACTIONAL` for messages that are critical or time-sensitive and `PROMOTIONAL` for messages that aren’t critical or time-sensitive.
        :param pulumi.Input[builtins.str] monthly_leasing_price: The monthly price, in US dollars, to lease the phone number.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] number_capabilities: Describes if the origination identity can be used for text messages, voice calls or both. valid values are `SMS` and `VOICE`.
        :param pulumi.Input[builtins.str] number_type: The type of phone number to request. Possible values are `LONG_CODE`, `TOLL_FREE`, `TEN_DLC`, or `SIMULATOR`.
        :param pulumi.Input[builtins.str] opt_out_list_name: The name of the opt-out list to associate with the phone number.
        :param pulumi.Input[builtins.str] phone_number: The new phone number that was requested.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] registration_id: Use this field to attach your phone number for an external registration process.
        :param pulumi.Input[builtins.bool] self_managed_opt_outs_enabled: When set to `false` an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, AWS End User Messaging SMS and Voice automatically replies with a customizable message and adds the end recipient to the opt-out list. When set to true you’re responsible for responding to HELP and STOP requests. You’re also responsible for tracking and honoring opt-out request.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] two_way_channel_arn: The Amazon Resource Name (ARN) of the two way channel.
        :param pulumi.Input[builtins.bool] two_way_channel_enabled: By default this is set to `false`. When set to `true` you can receive incoming text messages from your end recipients.
        :param pulumi.Input[builtins.str] two_way_channel_role: IAM Role ARN for a service to assume, to be able to post inbound SMS messages.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Smsvoicev2PhoneNumberState.__new__(_Smsvoicev2PhoneNumberState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["deletion_protection_enabled"] = deletion_protection_enabled
        __props__.__dict__["iso_country_code"] = iso_country_code
        __props__.__dict__["message_type"] = message_type
        __props__.__dict__["monthly_leasing_price"] = monthly_leasing_price
        __props__.__dict__["number_capabilities"] = number_capabilities
        __props__.__dict__["number_type"] = number_type
        __props__.__dict__["opt_out_list_name"] = opt_out_list_name
        __props__.__dict__["phone_number"] = phone_number
        __props__.__dict__["region"] = region
        __props__.__dict__["registration_id"] = registration_id
        __props__.__dict__["self_managed_opt_outs_enabled"] = self_managed_opt_outs_enabled
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["two_way_channel_arn"] = two_way_channel_arn
        __props__.__dict__["two_way_channel_enabled"] = two_way_channel_enabled
        __props__.__dict__["two_way_channel_role"] = two_way_channel_role
        return Smsvoicev2PhoneNumber(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the phone number.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        By default this is set to `false`. When set to true the phone number can’t be deleted.
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="isoCountryCode")
    def iso_country_code(self) -> pulumi.Output[builtins.str]:
        """
        The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
        """
        return pulumi.get(self, "iso_country_code")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of message. Valid values are `TRANSACTIONAL` for messages that are critical or time-sensitive and `PROMOTIONAL` for messages that aren’t critical or time-sensitive.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter(name="monthlyLeasingPrice")
    def monthly_leasing_price(self) -> pulumi.Output[builtins.str]:
        """
        The monthly price, in US dollars, to lease the phone number.
        """
        return pulumi.get(self, "monthly_leasing_price")

    @property
    @pulumi.getter(name="numberCapabilities")
    def number_capabilities(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Describes if the origination identity can be used for text messages, voice calls or both. valid values are `SMS` and `VOICE`.
        """
        return pulumi.get(self, "number_capabilities")

    @property
    @pulumi.getter(name="numberType")
    def number_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of phone number to request. Possible values are `LONG_CODE`, `TOLL_FREE`, `TEN_DLC`, or `SIMULATOR`.
        """
        return pulumi.get(self, "number_type")

    @property
    @pulumi.getter(name="optOutListName")
    def opt_out_list_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the opt-out list to associate with the phone number.
        """
        return pulumi.get(self, "opt_out_list_name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Output[builtins.str]:
        """
        The new phone number that was requested.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="registrationId")
    def registration_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Use this field to attach your phone number for an external registration process.
        """
        return pulumi.get(self, "registration_id")

    @property
    @pulumi.getter(name="selfManagedOptOutsEnabled")
    def self_managed_opt_outs_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        When set to `false` an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, AWS End User Messaging SMS and Voice automatically replies with a customizable message and adds the end recipient to the opt-out list. When set to true you’re responsible for responding to HELP and STOP requests. You’re also responsible for tracking and honoring opt-out request.
        """
        return pulumi.get(self, "self_managed_opt_outs_enabled")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.Smsvoicev2PhoneNumberTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="twoWayChannelArn")
    def two_way_channel_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the two way channel.
        """
        return pulumi.get(self, "two_way_channel_arn")

    @property
    @pulumi.getter(name="twoWayChannelEnabled")
    def two_way_channel_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        By default this is set to `false`. When set to `true` you can receive incoming text messages from your end recipients.
        """
        return pulumi.get(self, "two_way_channel_enabled")

    @property
    @pulumi.getter(name="twoWayChannelRole")
    def two_way_channel_role(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IAM Role ARN for a service to assume, to be able to post inbound SMS messages.
        """
        return pulumi.get(self, "two_way_channel_role")

