# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'PipeEnrichmentParameters',
    'PipeEnrichmentParametersHttpParameters',
    'PipeLogConfiguration',
    'PipeLogConfigurationCloudwatchLogsLogDestination',
    'PipeLogConfigurationFirehoseLogDestination',
    'PipeLogConfigurationS3LogDestination',
    'PipeSourceParameters',
    'PipeSourceParametersActivemqBrokerParameters',
    'PipeSourceParametersActivemqBrokerParametersCredentials',
    'PipeSourceParametersDynamodbStreamParameters',
    'PipeSourceParametersDynamodbStreamParametersDeadLetterConfig',
    'PipeSourceParametersFilterCriteria',
    'PipeSourceParametersFilterCriteriaFilter',
    'PipeSourceParametersKinesisStreamParameters',
    'PipeSourceParametersKinesisStreamParametersDeadLetterConfig',
    'PipeSourceParametersManagedStreamingKafkaParameters',
    'PipeSourceParametersManagedStreamingKafkaParametersCredentials',
    'PipeSourceParametersRabbitmqBrokerParameters',
    'PipeSourceParametersRabbitmqBrokerParametersCredentials',
    'PipeSourceParametersSelfManagedKafkaParameters',
    'PipeSourceParametersSelfManagedKafkaParametersCredentials',
    'PipeSourceParametersSelfManagedKafkaParametersVpc',
    'PipeSourceParametersSqsQueueParameters',
    'PipeTargetParameters',
    'PipeTargetParametersBatchJobParameters',
    'PipeTargetParametersBatchJobParametersArrayProperties',
    'PipeTargetParametersBatchJobParametersContainerOverrides',
    'PipeTargetParametersBatchJobParametersContainerOverridesEnvironment',
    'PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirement',
    'PipeTargetParametersBatchJobParametersDependsOn',
    'PipeTargetParametersBatchJobParametersRetryStrategy',
    'PipeTargetParametersCloudwatchLogsParameters',
    'PipeTargetParametersEcsTaskParameters',
    'PipeTargetParametersEcsTaskParametersCapacityProviderStrategy',
    'PipeTargetParametersEcsTaskParametersNetworkConfiguration',
    'PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfiguration',
    'PipeTargetParametersEcsTaskParametersOverrides',
    'PipeTargetParametersEcsTaskParametersOverridesContainerOverride',
    'PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironment',
    'PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFile',
    'PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirement',
    'PipeTargetParametersEcsTaskParametersOverridesEphemeralStorage',
    'PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverride',
    'PipeTargetParametersEcsTaskParametersPlacementConstraint',
    'PipeTargetParametersEcsTaskParametersPlacementStrategy',
    'PipeTargetParametersEventbridgeEventBusParameters',
    'PipeTargetParametersHttpParameters',
    'PipeTargetParametersKinesisStreamParameters',
    'PipeTargetParametersLambdaFunctionParameters',
    'PipeTargetParametersRedshiftDataParameters',
    'PipeTargetParametersSagemakerPipelineParameters',
    'PipeTargetParametersSagemakerPipelineParametersPipelineParameter',
    'PipeTargetParametersSqsQueueParameters',
    'PipeTargetParametersStepFunctionStateMachineParameters',
]

@pulumi.output_type
class PipeEnrichmentParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpParameters":
            suggest = "http_parameters"
        elif key == "inputTemplate":
            suggest = "input_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeEnrichmentParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeEnrichmentParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeEnrichmentParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_parameters: Optional['outputs.PipeEnrichmentParametersHttpParameters'] = None,
                 input_template: Optional[builtins.str] = None):
        """
        :param 'PipeEnrichmentParametersHttpParametersArgs' http_parameters: Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination. If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence. Detailed below.
        :param builtins.str input_template: Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. Maximum length of 8192 characters.
        """
        if http_parameters is not None:
            pulumi.set(__self__, "http_parameters", http_parameters)
        if input_template is not None:
            pulumi.set(__self__, "input_template", input_template)

    @property
    @pulumi.getter(name="httpParameters")
    def http_parameters(self) -> Optional['outputs.PipeEnrichmentParametersHttpParameters']:
        """
        Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination. If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence. Detailed below.
        """
        return pulumi.get(self, "http_parameters")

    @property
    @pulumi.getter(name="inputTemplate")
    def input_template(self) -> Optional[builtins.str]:
        """
        Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. Maximum length of 8192 characters.
        """
        return pulumi.get(self, "input_template")


@pulumi.output_type
class PipeEnrichmentParametersHttpParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerParameters":
            suggest = "header_parameters"
        elif key == "pathParameterValues":
            suggest = "path_parameter_values"
        elif key == "queryStringParameters":
            suggest = "query_string_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeEnrichmentParametersHttpParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeEnrichmentParametersHttpParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeEnrichmentParametersHttpParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_parameters: Optional[Mapping[str, builtins.str]] = None,
                 path_parameter_values: Optional[builtins.str] = None,
                 query_string_parameters: Optional[Mapping[str, builtins.str]] = None):
        if header_parameters is not None:
            pulumi.set(__self__, "header_parameters", header_parameters)
        if path_parameter_values is not None:
            pulumi.set(__self__, "path_parameter_values", path_parameter_values)
        if query_string_parameters is not None:
            pulumi.set(__self__, "query_string_parameters", query_string_parameters)

    @property
    @pulumi.getter(name="headerParameters")
    def header_parameters(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "header_parameters")

    @property
    @pulumi.getter(name="pathParameterValues")
    def path_parameter_values(self) -> Optional[builtins.str]:
        return pulumi.get(self, "path_parameter_values")

    @property
    @pulumi.getter(name="queryStringParameters")
    def query_string_parameters(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "query_string_parameters")


@pulumi.output_type
class PipeLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogsLogDestination":
            suggest = "cloudwatch_logs_log_destination"
        elif key == "firehoseLogDestination":
            suggest = "firehose_log_destination"
        elif key == "includeExecutionDatas":
            suggest = "include_execution_datas"
        elif key == "s3LogDestination":
            suggest = "s3_log_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 level: builtins.str,
                 cloudwatch_logs_log_destination: Optional['outputs.PipeLogConfigurationCloudwatchLogsLogDestination'] = None,
                 firehose_log_destination: Optional['outputs.PipeLogConfigurationFirehoseLogDestination'] = None,
                 include_execution_datas: Optional[Sequence[builtins.str]] = None,
                 s3_log_destination: Optional['outputs.PipeLogConfigurationS3LogDestination'] = None):
        """
        :param builtins.str level: The level of logging detail to include. Valid values `OFF`, `ERROR`, `INFO` and `TRACE`.
        :param 'PipeLogConfigurationCloudwatchLogsLogDestinationArgs' cloudwatch_logs_log_destination: Amazon CloudWatch Logs logging configuration settings for the pipe. Detailed below.
        :param 'PipeLogConfigurationFirehoseLogDestinationArgs' firehose_log_destination: Amazon Kinesis Data Firehose logging configuration settings for the pipe. Detailed below.
        :param Sequence[builtins.str] include_execution_datas: String list that specifies whether the execution data (specifically, the `payload`, `awsRequest`, and `awsResponse` fields) is included in the log messages for this pipe. This applies to all log destinations for the pipe. Valid values `ALL`.
        :param 'PipeLogConfigurationS3LogDestinationArgs' s3_log_destination: Amazon S3 logging configuration settings for the pipe. Detailed below.
        """
        pulumi.set(__self__, "level", level)
        if cloudwatch_logs_log_destination is not None:
            pulumi.set(__self__, "cloudwatch_logs_log_destination", cloudwatch_logs_log_destination)
        if firehose_log_destination is not None:
            pulumi.set(__self__, "firehose_log_destination", firehose_log_destination)
        if include_execution_datas is not None:
            pulumi.set(__self__, "include_execution_datas", include_execution_datas)
        if s3_log_destination is not None:
            pulumi.set(__self__, "s3_log_destination", s3_log_destination)

    @property
    @pulumi.getter
    def level(self) -> builtins.str:
        """
        The level of logging detail to include. Valid values `OFF`, `ERROR`, `INFO` and `TRACE`.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter(name="cloudwatchLogsLogDestination")
    def cloudwatch_logs_log_destination(self) -> Optional['outputs.PipeLogConfigurationCloudwatchLogsLogDestination']:
        """
        Amazon CloudWatch Logs logging configuration settings for the pipe. Detailed below.
        """
        return pulumi.get(self, "cloudwatch_logs_log_destination")

    @property
    @pulumi.getter(name="firehoseLogDestination")
    def firehose_log_destination(self) -> Optional['outputs.PipeLogConfigurationFirehoseLogDestination']:
        """
        Amazon Kinesis Data Firehose logging configuration settings for the pipe. Detailed below.
        """
        return pulumi.get(self, "firehose_log_destination")

    @property
    @pulumi.getter(name="includeExecutionDatas")
    def include_execution_datas(self) -> Optional[Sequence[builtins.str]]:
        """
        String list that specifies whether the execution data (specifically, the `payload`, `awsRequest`, and `awsResponse` fields) is included in the log messages for this pipe. This applies to all log destinations for the pipe. Valid values `ALL`.
        """
        return pulumi.get(self, "include_execution_datas")

    @property
    @pulumi.getter(name="s3LogDestination")
    def s3_log_destination(self) -> Optional['outputs.PipeLogConfigurationS3LogDestination']:
        """
        Amazon S3 logging configuration settings for the pipe. Detailed below.
        """
        return pulumi.get(self, "s3_log_destination")


@pulumi.output_type
class PipeLogConfigurationCloudwatchLogsLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupArn":
            suggest = "log_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeLogConfigurationCloudwatchLogsLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeLogConfigurationCloudwatchLogsLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeLogConfigurationCloudwatchLogsLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_arn: builtins.str):
        """
        :param builtins.str log_group_arn: Amazon Web Services Resource Name (ARN) for the CloudWatch log group to which EventBridge sends the log records.
        """
        pulumi.set(__self__, "log_group_arn", log_group_arn)

    @property
    @pulumi.getter(name="logGroupArn")
    def log_group_arn(self) -> builtins.str:
        """
        Amazon Web Services Resource Name (ARN) for the CloudWatch log group to which EventBridge sends the log records.
        """
        return pulumi.get(self, "log_group_arn")


@pulumi.output_type
class PipeLogConfigurationFirehoseLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryStreamArn":
            suggest = "delivery_stream_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeLogConfigurationFirehoseLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeLogConfigurationFirehoseLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeLogConfigurationFirehoseLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delivery_stream_arn: builtins.str):
        """
        :param builtins.str delivery_stream_arn: Amazon Resource Name (ARN) of the Kinesis Data Firehose delivery stream to which EventBridge delivers the pipe log records.
        """
        pulumi.set(__self__, "delivery_stream_arn", delivery_stream_arn)

    @property
    @pulumi.getter(name="deliveryStreamArn")
    def delivery_stream_arn(self) -> builtins.str:
        """
        Amazon Resource Name (ARN) of the Kinesis Data Firehose delivery stream to which EventBridge delivers the pipe log records.
        """
        return pulumi.get(self, "delivery_stream_arn")


@pulumi.output_type
class PipeLogConfigurationS3LogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketOwner":
            suggest = "bucket_owner"
        elif key == "outputFormat":
            suggest = "output_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeLogConfigurationS3LogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeLogConfigurationS3LogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeLogConfigurationS3LogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 bucket_owner: builtins.str,
                 output_format: Optional[builtins.str] = None,
                 prefix: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: Name of the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
        :param builtins.str bucket_owner: Amazon Web Services account that owns the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
        :param builtins.str output_format: EventBridge format for the log records. Valid values `json`, `plain` and `w3c`.
        :param builtins.str prefix: Prefix text with which to begin Amazon S3 log object names.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_owner", bucket_owner)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        Name of the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bucketOwner")
    def bucket_owner(self) -> builtins.str:
        """
        Amazon Web Services account that owns the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
        """
        return pulumi.get(self, "bucket_owner")

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[builtins.str]:
        """
        EventBridge format for the log records. Valid values `json`, `plain` and `w3c`.
        """
        return pulumi.get(self, "output_format")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        Prefix text with which to begin Amazon S3 log object names.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class PipeSourceParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activemqBrokerParameters":
            suggest = "activemq_broker_parameters"
        elif key == "dynamodbStreamParameters":
            suggest = "dynamodb_stream_parameters"
        elif key == "filterCriteria":
            suggest = "filter_criteria"
        elif key == "kinesisStreamParameters":
            suggest = "kinesis_stream_parameters"
        elif key == "managedStreamingKafkaParameters":
            suggest = "managed_streaming_kafka_parameters"
        elif key == "rabbitmqBrokerParameters":
            suggest = "rabbitmq_broker_parameters"
        elif key == "selfManagedKafkaParameters":
            suggest = "self_managed_kafka_parameters"
        elif key == "sqsQueueParameters":
            suggest = "sqs_queue_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activemq_broker_parameters: Optional['outputs.PipeSourceParametersActivemqBrokerParameters'] = None,
                 dynamodb_stream_parameters: Optional['outputs.PipeSourceParametersDynamodbStreamParameters'] = None,
                 filter_criteria: Optional['outputs.PipeSourceParametersFilterCriteria'] = None,
                 kinesis_stream_parameters: Optional['outputs.PipeSourceParametersKinesisStreamParameters'] = None,
                 managed_streaming_kafka_parameters: Optional['outputs.PipeSourceParametersManagedStreamingKafkaParameters'] = None,
                 rabbitmq_broker_parameters: Optional['outputs.PipeSourceParametersRabbitmqBrokerParameters'] = None,
                 self_managed_kafka_parameters: Optional['outputs.PipeSourceParametersSelfManagedKafkaParameters'] = None,
                 sqs_queue_parameters: Optional['outputs.PipeSourceParametersSqsQueueParameters'] = None):
        """
        :param 'PipeSourceParametersActivemqBrokerParametersArgs' activemq_broker_parameters: The parameters for using an Active MQ broker as a source. Detailed below.
        :param 'PipeSourceParametersDynamodbStreamParametersArgs' dynamodb_stream_parameters: The parameters for using a DynamoDB stream as a source.  Detailed below.
        :param 'PipeSourceParametersFilterCriteriaArgs' filter_criteria: The collection of event patterns used to [filter events](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-filtering.html). Detailed below.
        :param 'PipeSourceParametersKinesisStreamParametersArgs' kinesis_stream_parameters: The parameters for using a Kinesis stream as a source. Detailed below.
        :param 'PipeSourceParametersManagedStreamingKafkaParametersArgs' managed_streaming_kafka_parameters: The parameters for using an MSK stream as a source. Detailed below.
        :param 'PipeSourceParametersRabbitmqBrokerParametersArgs' rabbitmq_broker_parameters: The parameters for using a Rabbit MQ broker as a source. Detailed below.
        :param 'PipeSourceParametersSelfManagedKafkaParametersArgs' self_managed_kafka_parameters: The parameters for using a self-managed Apache Kafka stream as a source. Detailed below.
        :param 'PipeSourceParametersSqsQueueParametersArgs' sqs_queue_parameters: The parameters for using a Amazon SQS stream as a source. Detailed below.
        """
        if activemq_broker_parameters is not None:
            pulumi.set(__self__, "activemq_broker_parameters", activemq_broker_parameters)
        if dynamodb_stream_parameters is not None:
            pulumi.set(__self__, "dynamodb_stream_parameters", dynamodb_stream_parameters)
        if filter_criteria is not None:
            pulumi.set(__self__, "filter_criteria", filter_criteria)
        if kinesis_stream_parameters is not None:
            pulumi.set(__self__, "kinesis_stream_parameters", kinesis_stream_parameters)
        if managed_streaming_kafka_parameters is not None:
            pulumi.set(__self__, "managed_streaming_kafka_parameters", managed_streaming_kafka_parameters)
        if rabbitmq_broker_parameters is not None:
            pulumi.set(__self__, "rabbitmq_broker_parameters", rabbitmq_broker_parameters)
        if self_managed_kafka_parameters is not None:
            pulumi.set(__self__, "self_managed_kafka_parameters", self_managed_kafka_parameters)
        if sqs_queue_parameters is not None:
            pulumi.set(__self__, "sqs_queue_parameters", sqs_queue_parameters)

    @property
    @pulumi.getter(name="activemqBrokerParameters")
    def activemq_broker_parameters(self) -> Optional['outputs.PipeSourceParametersActivemqBrokerParameters']:
        """
        The parameters for using an Active MQ broker as a source. Detailed below.
        """
        return pulumi.get(self, "activemq_broker_parameters")

    @property
    @pulumi.getter(name="dynamodbStreamParameters")
    def dynamodb_stream_parameters(self) -> Optional['outputs.PipeSourceParametersDynamodbStreamParameters']:
        """
        The parameters for using a DynamoDB stream as a source.  Detailed below.
        """
        return pulumi.get(self, "dynamodb_stream_parameters")

    @property
    @pulumi.getter(name="filterCriteria")
    def filter_criteria(self) -> Optional['outputs.PipeSourceParametersFilterCriteria']:
        """
        The collection of event patterns used to [filter events](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-filtering.html). Detailed below.
        """
        return pulumi.get(self, "filter_criteria")

    @property
    @pulumi.getter(name="kinesisStreamParameters")
    def kinesis_stream_parameters(self) -> Optional['outputs.PipeSourceParametersKinesisStreamParameters']:
        """
        The parameters for using a Kinesis stream as a source. Detailed below.
        """
        return pulumi.get(self, "kinesis_stream_parameters")

    @property
    @pulumi.getter(name="managedStreamingKafkaParameters")
    def managed_streaming_kafka_parameters(self) -> Optional['outputs.PipeSourceParametersManagedStreamingKafkaParameters']:
        """
        The parameters for using an MSK stream as a source. Detailed below.
        """
        return pulumi.get(self, "managed_streaming_kafka_parameters")

    @property
    @pulumi.getter(name="rabbitmqBrokerParameters")
    def rabbitmq_broker_parameters(self) -> Optional['outputs.PipeSourceParametersRabbitmqBrokerParameters']:
        """
        The parameters for using a Rabbit MQ broker as a source. Detailed below.
        """
        return pulumi.get(self, "rabbitmq_broker_parameters")

    @property
    @pulumi.getter(name="selfManagedKafkaParameters")
    def self_managed_kafka_parameters(self) -> Optional['outputs.PipeSourceParametersSelfManagedKafkaParameters']:
        """
        The parameters for using a self-managed Apache Kafka stream as a source. Detailed below.
        """
        return pulumi.get(self, "self_managed_kafka_parameters")

    @property
    @pulumi.getter(name="sqsQueueParameters")
    def sqs_queue_parameters(self) -> Optional['outputs.PipeSourceParametersSqsQueueParameters']:
        """
        The parameters for using a Amazon SQS stream as a source. Detailed below.
        """
        return pulumi.get(self, "sqs_queue_parameters")


@pulumi.output_type
class PipeSourceParametersActivemqBrokerParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueName":
            suggest = "queue_name"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "maximumBatchingWindowInSeconds":
            suggest = "maximum_batching_window_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceParametersActivemqBrokerParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceParametersActivemqBrokerParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceParametersActivemqBrokerParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials: 'outputs.PipeSourceParametersActivemqBrokerParametersCredentials',
                 queue_name: builtins.str,
                 batch_size: Optional[builtins.int] = None,
                 maximum_batching_window_in_seconds: Optional[builtins.int] = None):
        """
        :param 'PipeSourceParametersActivemqBrokerParametersCredentialsArgs' credentials: The credentials needed to access the resource. Detailed below.
        :param builtins.str queue_name: The name of the destination queue to consume. Maximum length of 1000.
        :param builtins.int batch_size: The maximum number of records to include in each batch. Maximum value of 10000.
        :param builtins.int maximum_batching_window_in_seconds: The maximum length of a time to wait for events. Maximum value of 300.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "queue_name", queue_name)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)

    @property
    @pulumi.getter
    def credentials(self) -> 'outputs.PipeSourceParametersActivemqBrokerParametersCredentials':
        """
        The credentials needed to access the resource. Detailed below.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> builtins.str:
        """
        The name of the destination queue to consume. Maximum length of 1000.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records to include in each batch. Maximum value of 10000.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum length of a time to wait for events. Maximum value of 300.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")


@pulumi.output_type
class PipeSourceParametersActivemqBrokerParametersCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceParametersActivemqBrokerParametersCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceParametersActivemqBrokerParametersCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceParametersActivemqBrokerParametersCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth: builtins.str):
        """
        :param builtins.str basic_auth: The ARN of the Secrets Manager secret containing the credentials.
        """
        pulumi.set(__self__, "basic_auth", basic_auth)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> builtins.str:
        """
        The ARN of the Secrets Manager secret containing the credentials.
        """
        return pulumi.get(self, "basic_auth")


@pulumi.output_type
class PipeSourceParametersDynamodbStreamParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startingPosition":
            suggest = "starting_position"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "deadLetterConfig":
            suggest = "dead_letter_config"
        elif key == "maximumBatchingWindowInSeconds":
            suggest = "maximum_batching_window_in_seconds"
        elif key == "maximumRecordAgeInSeconds":
            suggest = "maximum_record_age_in_seconds"
        elif key == "maximumRetryAttempts":
            suggest = "maximum_retry_attempts"
        elif key == "onPartialBatchItemFailure":
            suggest = "on_partial_batch_item_failure"
        elif key == "parallelizationFactor":
            suggest = "parallelization_factor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceParametersDynamodbStreamParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceParametersDynamodbStreamParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceParametersDynamodbStreamParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 starting_position: builtins.str,
                 batch_size: Optional[builtins.int] = None,
                 dead_letter_config: Optional['outputs.PipeSourceParametersDynamodbStreamParametersDeadLetterConfig'] = None,
                 maximum_batching_window_in_seconds: Optional[builtins.int] = None,
                 maximum_record_age_in_seconds: Optional[builtins.int] = None,
                 maximum_retry_attempts: Optional[builtins.int] = None,
                 on_partial_batch_item_failure: Optional[builtins.str] = None,
                 parallelization_factor: Optional[builtins.int] = None):
        """
        :param builtins.str starting_position: The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
        :param builtins.int batch_size: The maximum number of records to include in each batch. Maximum value of 10000.
        :param 'PipeSourceParametersDynamodbStreamParametersDeadLetterConfigArgs' dead_letter_config: Define the target queue to send dead-letter queue events to. Detailed below.
        :param builtins.int maximum_batching_window_in_seconds: The maximum length of a time to wait for events. Maximum value of 300.
        :param builtins.int maximum_record_age_in_seconds: Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records. Maximum value of 604,800.
        :param builtins.int maximum_retry_attempts: Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source. Maximum value of 10,000.
        :param builtins.str on_partial_batch_item_failure: Define how to handle item process failures. AUTOMATIC_BISECT halves each batch and retry each half until all the records are processed or there is one failed message left in the batch. Valid values: AUTOMATIC_BISECT.
        :param builtins.int parallelization_factor: The number of batches to process concurrently from each shard. The default value is 1. Maximum value of 10.
        """
        pulumi.set(__self__, "starting_position", starting_position)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if maximum_record_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_record_age_in_seconds", maximum_record_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)
        if on_partial_batch_item_failure is not None:
            pulumi.set(__self__, "on_partial_batch_item_failure", on_partial_batch_item_failure)
        if parallelization_factor is not None:
            pulumi.set(__self__, "parallelization_factor", parallelization_factor)

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> builtins.str:
        """
        The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
        """
        return pulumi.get(self, "starting_position")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records to include in each batch. Maximum value of 10000.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional['outputs.PipeSourceParametersDynamodbStreamParametersDeadLetterConfig']:
        """
        Define the target queue to send dead-letter queue events to. Detailed below.
        """
        return pulumi.get(self, "dead_letter_config")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum length of a time to wait for events. Maximum value of 300.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @property
    @pulumi.getter(name="maximumRecordAgeInSeconds")
    def maximum_record_age_in_seconds(self) -> Optional[builtins.int]:
        """
        Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records. Maximum value of 604,800.
        """
        return pulumi.get(self, "maximum_record_age_in_seconds")

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[builtins.int]:
        """
        Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source. Maximum value of 10,000.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @property
    @pulumi.getter(name="onPartialBatchItemFailure")
    def on_partial_batch_item_failure(self) -> Optional[builtins.str]:
        """
        Define how to handle item process failures. AUTOMATIC_BISECT halves each batch and retry each half until all the records are processed or there is one failed message left in the batch. Valid values: AUTOMATIC_BISECT.
        """
        return pulumi.get(self, "on_partial_batch_item_failure")

    @property
    @pulumi.getter(name="parallelizationFactor")
    def parallelization_factor(self) -> Optional[builtins.int]:
        """
        The number of batches to process concurrently from each shard. The default value is 1. Maximum value of 10.
        """
        return pulumi.get(self, "parallelization_factor")


@pulumi.output_type
class PipeSourceParametersDynamodbStreamParametersDeadLetterConfig(dict):
    def __init__(__self__, *,
                 arn: Optional[builtins.str] = None):
        """
        :param builtins.str arn: ARN of this pipe.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        ARN of this pipe.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class PipeSourceParametersFilterCriteria(dict):
    def __init__(__self__, *,
                 filters: Optional[Sequence['outputs.PipeSourceParametersFilterCriteriaFilter']] = None):
        """
        :param Sequence['PipeSourceParametersFilterCriteriaFilterArgs'] filters: An array of up to 5 event patterns. Detailed below.
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.PipeSourceParametersFilterCriteriaFilter']]:
        """
        An array of up to 5 event patterns. Detailed below.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class PipeSourceParametersFilterCriteriaFilter(dict):
    def __init__(__self__, *,
                 pattern: builtins.str):
        """
        :param builtins.str pattern: The event pattern. At most 4096 characters.
        """
        pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter
    def pattern(self) -> builtins.str:
        """
        The event pattern. At most 4096 characters.
        """
        return pulumi.get(self, "pattern")


@pulumi.output_type
class PipeSourceParametersKinesisStreamParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startingPosition":
            suggest = "starting_position"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "deadLetterConfig":
            suggest = "dead_letter_config"
        elif key == "maximumBatchingWindowInSeconds":
            suggest = "maximum_batching_window_in_seconds"
        elif key == "maximumRecordAgeInSeconds":
            suggest = "maximum_record_age_in_seconds"
        elif key == "maximumRetryAttempts":
            suggest = "maximum_retry_attempts"
        elif key == "onPartialBatchItemFailure":
            suggest = "on_partial_batch_item_failure"
        elif key == "parallelizationFactor":
            suggest = "parallelization_factor"
        elif key == "startingPositionTimestamp":
            suggest = "starting_position_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceParametersKinesisStreamParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceParametersKinesisStreamParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceParametersKinesisStreamParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 starting_position: builtins.str,
                 batch_size: Optional[builtins.int] = None,
                 dead_letter_config: Optional['outputs.PipeSourceParametersKinesisStreamParametersDeadLetterConfig'] = None,
                 maximum_batching_window_in_seconds: Optional[builtins.int] = None,
                 maximum_record_age_in_seconds: Optional[builtins.int] = None,
                 maximum_retry_attempts: Optional[builtins.int] = None,
                 on_partial_batch_item_failure: Optional[builtins.str] = None,
                 parallelization_factor: Optional[builtins.int] = None,
                 starting_position_timestamp: Optional[builtins.str] = None):
        """
        :param builtins.str starting_position: The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
        :param builtins.int batch_size: The maximum number of records to include in each batch. Maximum value of 10000.
        :param 'PipeSourceParametersKinesisStreamParametersDeadLetterConfigArgs' dead_letter_config: Define the target queue to send dead-letter queue events to. Detailed below.
        :param builtins.int maximum_batching_window_in_seconds: The maximum length of a time to wait for events. Maximum value of 300.
        :param builtins.int maximum_record_age_in_seconds: Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records. Maximum value of 604,800.
        :param builtins.int maximum_retry_attempts: Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source. Maximum value of 10,000.
        :param builtins.str on_partial_batch_item_failure: Define how to handle item process failures. AUTOMATIC_BISECT halves each batch and retry each half until all the records are processed or there is one failed message left in the batch. Valid values: AUTOMATIC_BISECT.
        :param builtins.int parallelization_factor: The number of batches to process concurrently from each shard. The default value is 1. Maximum value of 10.
        :param builtins.str starting_position_timestamp: With StartingPosition set to AT_TIMESTAMP, the time from which to start reading, in Unix time seconds.
        """
        pulumi.set(__self__, "starting_position", starting_position)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if maximum_record_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_record_age_in_seconds", maximum_record_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)
        if on_partial_batch_item_failure is not None:
            pulumi.set(__self__, "on_partial_batch_item_failure", on_partial_batch_item_failure)
        if parallelization_factor is not None:
            pulumi.set(__self__, "parallelization_factor", parallelization_factor)
        if starting_position_timestamp is not None:
            pulumi.set(__self__, "starting_position_timestamp", starting_position_timestamp)

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> builtins.str:
        """
        The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
        """
        return pulumi.get(self, "starting_position")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records to include in each batch. Maximum value of 10000.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional['outputs.PipeSourceParametersKinesisStreamParametersDeadLetterConfig']:
        """
        Define the target queue to send dead-letter queue events to. Detailed below.
        """
        return pulumi.get(self, "dead_letter_config")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum length of a time to wait for events. Maximum value of 300.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @property
    @pulumi.getter(name="maximumRecordAgeInSeconds")
    def maximum_record_age_in_seconds(self) -> Optional[builtins.int]:
        """
        Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records. Maximum value of 604,800.
        """
        return pulumi.get(self, "maximum_record_age_in_seconds")

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[builtins.int]:
        """
        Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source. Maximum value of 10,000.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @property
    @pulumi.getter(name="onPartialBatchItemFailure")
    def on_partial_batch_item_failure(self) -> Optional[builtins.str]:
        """
        Define how to handle item process failures. AUTOMATIC_BISECT halves each batch and retry each half until all the records are processed or there is one failed message left in the batch. Valid values: AUTOMATIC_BISECT.
        """
        return pulumi.get(self, "on_partial_batch_item_failure")

    @property
    @pulumi.getter(name="parallelizationFactor")
    def parallelization_factor(self) -> Optional[builtins.int]:
        """
        The number of batches to process concurrently from each shard. The default value is 1. Maximum value of 10.
        """
        return pulumi.get(self, "parallelization_factor")

    @property
    @pulumi.getter(name="startingPositionTimestamp")
    def starting_position_timestamp(self) -> Optional[builtins.str]:
        """
        With StartingPosition set to AT_TIMESTAMP, the time from which to start reading, in Unix time seconds.
        """
        return pulumi.get(self, "starting_position_timestamp")


@pulumi.output_type
class PipeSourceParametersKinesisStreamParametersDeadLetterConfig(dict):
    def __init__(__self__, *,
                 arn: Optional[builtins.str] = None):
        """
        :param builtins.str arn: ARN of this pipe.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        ARN of this pipe.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class PipeSourceParametersManagedStreamingKafkaParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicName":
            suggest = "topic_name"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "consumerGroupId":
            suggest = "consumer_group_id"
        elif key == "maximumBatchingWindowInSeconds":
            suggest = "maximum_batching_window_in_seconds"
        elif key == "startingPosition":
            suggest = "starting_position"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceParametersManagedStreamingKafkaParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceParametersManagedStreamingKafkaParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceParametersManagedStreamingKafkaParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topic_name: builtins.str,
                 batch_size: Optional[builtins.int] = None,
                 consumer_group_id: Optional[builtins.str] = None,
                 credentials: Optional['outputs.PipeSourceParametersManagedStreamingKafkaParametersCredentials'] = None,
                 maximum_batching_window_in_seconds: Optional[builtins.int] = None,
                 starting_position: Optional[builtins.str] = None):
        """
        :param builtins.str topic_name: The name of the topic that the pipe will read from. Maximum length of 249.
        :param builtins.int batch_size: The maximum number of records to include in each batch. Maximum value of 10000.
        :param builtins.str consumer_group_id: The name of the destination queue to consume. Maximum value of 200.
        :param 'PipeSourceParametersManagedStreamingKafkaParametersCredentialsArgs' credentials: The credentials needed to access the resource. Detailed below.
        :param builtins.int maximum_batching_window_in_seconds: The maximum length of a time to wait for events. Maximum value of 300.
        :param builtins.str starting_position: The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
        """
        pulumi.set(__self__, "topic_name", topic_name)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if consumer_group_id is not None:
            pulumi.set(__self__, "consumer_group_id", consumer_group_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if starting_position is not None:
            pulumi.set(__self__, "starting_position", starting_position)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> builtins.str:
        """
        The name of the topic that the pipe will read from. Maximum length of 249.
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records to include in each batch. Maximum value of 10000.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> Optional[builtins.str]:
        """
        The name of the destination queue to consume. Maximum value of 200.
        """
        return pulumi.get(self, "consumer_group_id")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.PipeSourceParametersManagedStreamingKafkaParametersCredentials']:
        """
        The credentials needed to access the resource. Detailed below.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum length of a time to wait for events. Maximum value of 300.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> Optional[builtins.str]:
        """
        The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
        """
        return pulumi.get(self, "starting_position")


@pulumi.output_type
class PipeSourceParametersManagedStreamingKafkaParametersCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCertificateTlsAuth":
            suggest = "client_certificate_tls_auth"
        elif key == "saslScram512Auth":
            suggest = "sasl_scram512_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceParametersManagedStreamingKafkaParametersCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceParametersManagedStreamingKafkaParametersCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceParametersManagedStreamingKafkaParametersCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_certificate_tls_auth: Optional[builtins.str] = None,
                 sasl_scram512_auth: Optional[builtins.str] = None):
        """
        :param builtins.str client_certificate_tls_auth: The ARN of the Secrets Manager secret containing the credentials.
        :param builtins.str sasl_scram512_auth: The ARN of the Secrets Manager secret containing the credentials.
        """
        if client_certificate_tls_auth is not None:
            pulumi.set(__self__, "client_certificate_tls_auth", client_certificate_tls_auth)
        if sasl_scram512_auth is not None:
            pulumi.set(__self__, "sasl_scram512_auth", sasl_scram512_auth)

    @property
    @pulumi.getter(name="clientCertificateTlsAuth")
    def client_certificate_tls_auth(self) -> Optional[builtins.str]:
        """
        The ARN of the Secrets Manager secret containing the credentials.
        """
        return pulumi.get(self, "client_certificate_tls_auth")

    @property
    @pulumi.getter(name="saslScram512Auth")
    def sasl_scram512_auth(self) -> Optional[builtins.str]:
        """
        The ARN of the Secrets Manager secret containing the credentials.
        """
        return pulumi.get(self, "sasl_scram512_auth")


@pulumi.output_type
class PipeSourceParametersRabbitmqBrokerParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueName":
            suggest = "queue_name"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "maximumBatchingWindowInSeconds":
            suggest = "maximum_batching_window_in_seconds"
        elif key == "virtualHost":
            suggest = "virtual_host"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceParametersRabbitmqBrokerParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceParametersRabbitmqBrokerParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceParametersRabbitmqBrokerParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials: 'outputs.PipeSourceParametersRabbitmqBrokerParametersCredentials',
                 queue_name: builtins.str,
                 batch_size: Optional[builtins.int] = None,
                 maximum_batching_window_in_seconds: Optional[builtins.int] = None,
                 virtual_host: Optional[builtins.str] = None):
        """
        :param 'PipeSourceParametersRabbitmqBrokerParametersCredentialsArgs' credentials: The credentials needed to access the resource. Detailed below.
        :param builtins.str queue_name: The name of the destination queue to consume. Maximum length of 1000.
        :param builtins.int batch_size: The maximum number of records to include in each batch. Maximum value of 10000.
        :param builtins.int maximum_batching_window_in_seconds: The maximum length of a time to wait for events. Maximum value of 300.
        :param builtins.str virtual_host: The name of the virtual host associated with the source broker. Maximum length of 200.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "queue_name", queue_name)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if virtual_host is not None:
            pulumi.set(__self__, "virtual_host", virtual_host)

    @property
    @pulumi.getter
    def credentials(self) -> 'outputs.PipeSourceParametersRabbitmqBrokerParametersCredentials':
        """
        The credentials needed to access the resource. Detailed below.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> builtins.str:
        """
        The name of the destination queue to consume. Maximum length of 1000.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records to include in each batch. Maximum value of 10000.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum length of a time to wait for events. Maximum value of 300.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @property
    @pulumi.getter(name="virtualHost")
    def virtual_host(self) -> Optional[builtins.str]:
        """
        The name of the virtual host associated with the source broker. Maximum length of 200.
        """
        return pulumi.get(self, "virtual_host")


@pulumi.output_type
class PipeSourceParametersRabbitmqBrokerParametersCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceParametersRabbitmqBrokerParametersCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceParametersRabbitmqBrokerParametersCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceParametersRabbitmqBrokerParametersCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth: builtins.str):
        """
        :param builtins.str basic_auth: The ARN of the Secrets Manager secret containing the credentials.
        """
        pulumi.set(__self__, "basic_auth", basic_auth)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> builtins.str:
        """
        The ARN of the Secrets Manager secret containing the credentials.
        """
        return pulumi.get(self, "basic_auth")


@pulumi.output_type
class PipeSourceParametersSelfManagedKafkaParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicName":
            suggest = "topic_name"
        elif key == "additionalBootstrapServers":
            suggest = "additional_bootstrap_servers"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "consumerGroupId":
            suggest = "consumer_group_id"
        elif key == "maximumBatchingWindowInSeconds":
            suggest = "maximum_batching_window_in_seconds"
        elif key == "serverRootCaCertificate":
            suggest = "server_root_ca_certificate"
        elif key == "startingPosition":
            suggest = "starting_position"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceParametersSelfManagedKafkaParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceParametersSelfManagedKafkaParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceParametersSelfManagedKafkaParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topic_name: builtins.str,
                 additional_bootstrap_servers: Optional[Sequence[builtins.str]] = None,
                 batch_size: Optional[builtins.int] = None,
                 consumer_group_id: Optional[builtins.str] = None,
                 credentials: Optional['outputs.PipeSourceParametersSelfManagedKafkaParametersCredentials'] = None,
                 maximum_batching_window_in_seconds: Optional[builtins.int] = None,
                 server_root_ca_certificate: Optional[builtins.str] = None,
                 starting_position: Optional[builtins.str] = None,
                 vpc: Optional['outputs.PipeSourceParametersSelfManagedKafkaParametersVpc'] = None):
        """
        :param builtins.str topic_name: The name of the topic that the pipe will read from. Maximum length of 249.
        :param Sequence[builtins.str] additional_bootstrap_servers: An array of server URLs. Maximum number of 2 items, each of maximum length 300.
        :param builtins.int batch_size: The maximum number of records to include in each batch. Maximum value of 10000.
        :param builtins.str consumer_group_id: The name of the destination queue to consume. Maximum value of 200.
        :param 'PipeSourceParametersSelfManagedKafkaParametersCredentialsArgs' credentials: The credentials needed to access the resource. Detailed below.
        :param builtins.int maximum_batching_window_in_seconds: The maximum length of a time to wait for events. Maximum value of 300.
        :param builtins.str server_root_ca_certificate: The ARN of the Secrets Manager secret used for certification.
        :param builtins.str starting_position: The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
        :param 'PipeSourceParametersSelfManagedKafkaParametersVpcArgs' vpc: This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used. Detailed below.
        """
        pulumi.set(__self__, "topic_name", topic_name)
        if additional_bootstrap_servers is not None:
            pulumi.set(__self__, "additional_bootstrap_servers", additional_bootstrap_servers)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if consumer_group_id is not None:
            pulumi.set(__self__, "consumer_group_id", consumer_group_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)
        if server_root_ca_certificate is not None:
            pulumi.set(__self__, "server_root_ca_certificate", server_root_ca_certificate)
        if starting_position is not None:
            pulumi.set(__self__, "starting_position", starting_position)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> builtins.str:
        """
        The name of the topic that the pipe will read from. Maximum length of 249.
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter(name="additionalBootstrapServers")
    def additional_bootstrap_servers(self) -> Optional[Sequence[builtins.str]]:
        """
        An array of server URLs. Maximum number of 2 items, each of maximum length 300.
        """
        return pulumi.get(self, "additional_bootstrap_servers")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records to include in each batch. Maximum value of 10000.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="consumerGroupId")
    def consumer_group_id(self) -> Optional[builtins.str]:
        """
        The name of the destination queue to consume. Maximum value of 200.
        """
        return pulumi.get(self, "consumer_group_id")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.PipeSourceParametersSelfManagedKafkaParametersCredentials']:
        """
        The credentials needed to access the resource. Detailed below.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum length of a time to wait for events. Maximum value of 300.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")

    @property
    @pulumi.getter(name="serverRootCaCertificate")
    def server_root_ca_certificate(self) -> Optional[builtins.str]:
        """
        The ARN of the Secrets Manager secret used for certification.
        """
        return pulumi.get(self, "server_root_ca_certificate")

    @property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> Optional[builtins.str]:
        """
        The position in a stream from which to start reading. Valid values: TRIM_HORIZON, LATEST.
        """
        return pulumi.get(self, "starting_position")

    @property
    @pulumi.getter
    def vpc(self) -> Optional['outputs.PipeSourceParametersSelfManagedKafkaParametersVpc']:
        """
        This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used. Detailed below.
        """
        return pulumi.get(self, "vpc")


@pulumi.output_type
class PipeSourceParametersSelfManagedKafkaParametersCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"
        elif key == "clientCertificateTlsAuth":
            suggest = "client_certificate_tls_auth"
        elif key == "saslScram256Auth":
            suggest = "sasl_scram256_auth"
        elif key == "saslScram512Auth":
            suggest = "sasl_scram512_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceParametersSelfManagedKafkaParametersCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceParametersSelfManagedKafkaParametersCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceParametersSelfManagedKafkaParametersCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth: Optional[builtins.str] = None,
                 client_certificate_tls_auth: Optional[builtins.str] = None,
                 sasl_scram256_auth: Optional[builtins.str] = None,
                 sasl_scram512_auth: Optional[builtins.str] = None):
        """
        :param builtins.str basic_auth: The ARN of the Secrets Manager secret containing the credentials.
        :param builtins.str client_certificate_tls_auth: The ARN of the Secrets Manager secret containing the credentials.
        :param builtins.str sasl_scram256_auth: The ARN of the Secrets Manager secret containing the credentials.
        :param builtins.str sasl_scram512_auth: The ARN of the Secrets Manager secret containing the credentials.
        """
        if basic_auth is not None:
            pulumi.set(__self__, "basic_auth", basic_auth)
        if client_certificate_tls_auth is not None:
            pulumi.set(__self__, "client_certificate_tls_auth", client_certificate_tls_auth)
        if sasl_scram256_auth is not None:
            pulumi.set(__self__, "sasl_scram256_auth", sasl_scram256_auth)
        if sasl_scram512_auth is not None:
            pulumi.set(__self__, "sasl_scram512_auth", sasl_scram512_auth)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> Optional[builtins.str]:
        """
        The ARN of the Secrets Manager secret containing the credentials.
        """
        return pulumi.get(self, "basic_auth")

    @property
    @pulumi.getter(name="clientCertificateTlsAuth")
    def client_certificate_tls_auth(self) -> Optional[builtins.str]:
        """
        The ARN of the Secrets Manager secret containing the credentials.
        """
        return pulumi.get(self, "client_certificate_tls_auth")

    @property
    @pulumi.getter(name="saslScram256Auth")
    def sasl_scram256_auth(self) -> Optional[builtins.str]:
        """
        The ARN of the Secrets Manager secret containing the credentials.
        """
        return pulumi.get(self, "sasl_scram256_auth")

    @property
    @pulumi.getter(name="saslScram512Auth")
    def sasl_scram512_auth(self) -> Optional[builtins.str]:
        """
        The ARN of the Secrets Manager secret containing the credentials.
        """
        return pulumi.get(self, "sasl_scram512_auth")


@pulumi.output_type
class PipeSourceParametersSelfManagedKafkaParametersVpc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceParametersSelfManagedKafkaParametersVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceParametersSelfManagedKafkaParametersVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceParametersSelfManagedKafkaParametersVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_groups: Optional[Sequence[builtins.str]] = None,
                 subnets: Optional[Sequence[builtins.str]] = None):
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def subnets(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "subnets")


@pulumi.output_type
class PipeSourceParametersSqsQueueParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchSize":
            suggest = "batch_size"
        elif key == "maximumBatchingWindowInSeconds":
            suggest = "maximum_batching_window_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeSourceParametersSqsQueueParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeSourceParametersSqsQueueParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeSourceParametersSqsQueueParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_size: Optional[builtins.int] = None,
                 maximum_batching_window_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.int batch_size: The maximum number of records to include in each batch. Maximum value of 10000.
        :param builtins.int maximum_batching_window_in_seconds: The maximum length of a time to wait for events. Maximum value of 300.
        """
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if maximum_batching_window_in_seconds is not None:
            pulumi.set(__self__, "maximum_batching_window_in_seconds", maximum_batching_window_in_seconds)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[builtins.int]:
        """
        The maximum number of records to include in each batch. Maximum value of 10000.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="maximumBatchingWindowInSeconds")
    def maximum_batching_window_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum length of a time to wait for events. Maximum value of 300.
        """
        return pulumi.get(self, "maximum_batching_window_in_seconds")


@pulumi.output_type
class PipeTargetParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchJobParameters":
            suggest = "batch_job_parameters"
        elif key == "cloudwatchLogsParameters":
            suggest = "cloudwatch_logs_parameters"
        elif key == "ecsTaskParameters":
            suggest = "ecs_task_parameters"
        elif key == "eventbridgeEventBusParameters":
            suggest = "eventbridge_event_bus_parameters"
        elif key == "httpParameters":
            suggest = "http_parameters"
        elif key == "inputTemplate":
            suggest = "input_template"
        elif key == "kinesisStreamParameters":
            suggest = "kinesis_stream_parameters"
        elif key == "lambdaFunctionParameters":
            suggest = "lambda_function_parameters"
        elif key == "redshiftDataParameters":
            suggest = "redshift_data_parameters"
        elif key == "sagemakerPipelineParameters":
            suggest = "sagemaker_pipeline_parameters"
        elif key == "sqsQueueParameters":
            suggest = "sqs_queue_parameters"
        elif key == "stepFunctionStateMachineParameters":
            suggest = "step_function_state_machine_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_job_parameters: Optional['outputs.PipeTargetParametersBatchJobParameters'] = None,
                 cloudwatch_logs_parameters: Optional['outputs.PipeTargetParametersCloudwatchLogsParameters'] = None,
                 ecs_task_parameters: Optional['outputs.PipeTargetParametersEcsTaskParameters'] = None,
                 eventbridge_event_bus_parameters: Optional['outputs.PipeTargetParametersEventbridgeEventBusParameters'] = None,
                 http_parameters: Optional['outputs.PipeTargetParametersHttpParameters'] = None,
                 input_template: Optional[builtins.str] = None,
                 kinesis_stream_parameters: Optional['outputs.PipeTargetParametersKinesisStreamParameters'] = None,
                 lambda_function_parameters: Optional['outputs.PipeTargetParametersLambdaFunctionParameters'] = None,
                 redshift_data_parameters: Optional['outputs.PipeTargetParametersRedshiftDataParameters'] = None,
                 sagemaker_pipeline_parameters: Optional['outputs.PipeTargetParametersSagemakerPipelineParameters'] = None,
                 sqs_queue_parameters: Optional['outputs.PipeTargetParametersSqsQueueParameters'] = None,
                 step_function_state_machine_parameters: Optional['outputs.PipeTargetParametersStepFunctionStateMachineParameters'] = None):
        """
        :param 'PipeTargetParametersBatchJobParametersArgs' batch_job_parameters: The parameters for using an AWS Batch job as a target. Detailed below.
        :param 'PipeTargetParametersCloudwatchLogsParametersArgs' cloudwatch_logs_parameters: The parameters for using an CloudWatch Logs log stream as a target. Detailed below.
        :param 'PipeTargetParametersEcsTaskParametersArgs' ecs_task_parameters: The parameters for using an Amazon ECS task as a target. Detailed below.
        :param 'PipeTargetParametersEventbridgeEventBusParametersArgs' eventbridge_event_bus_parameters: The parameters for using an EventBridge event bus as a target. Detailed below.
        :param 'PipeTargetParametersHttpParametersArgs' http_parameters: These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations. Detailed below.
        :param builtins.str input_template: Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. Maximum length of 8192 characters.
        :param 'PipeTargetParametersKinesisStreamParametersArgs' kinesis_stream_parameters: The parameters for using a Kinesis stream as a source. Detailed below.
        :param 'PipeTargetParametersLambdaFunctionParametersArgs' lambda_function_parameters: The parameters for using a Lambda function as a target. Detailed below.
        :param 'PipeTargetParametersRedshiftDataParametersArgs' redshift_data_parameters: These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement. Detailed below.
        :param 'PipeTargetParametersSagemakerPipelineParametersArgs' sagemaker_pipeline_parameters: The parameters for using a SageMaker AI pipeline as a target. Detailed below.
        :param 'PipeTargetParametersSqsQueueParametersArgs' sqs_queue_parameters: The parameters for using a Amazon SQS stream as a target. Detailed below.
        :param 'PipeTargetParametersStepFunctionStateMachineParametersArgs' step_function_state_machine_parameters: The parameters for using a Step Functions state machine as a target. Detailed below.
        """
        if batch_job_parameters is not None:
            pulumi.set(__self__, "batch_job_parameters", batch_job_parameters)
        if cloudwatch_logs_parameters is not None:
            pulumi.set(__self__, "cloudwatch_logs_parameters", cloudwatch_logs_parameters)
        if ecs_task_parameters is not None:
            pulumi.set(__self__, "ecs_task_parameters", ecs_task_parameters)
        if eventbridge_event_bus_parameters is not None:
            pulumi.set(__self__, "eventbridge_event_bus_parameters", eventbridge_event_bus_parameters)
        if http_parameters is not None:
            pulumi.set(__self__, "http_parameters", http_parameters)
        if input_template is not None:
            pulumi.set(__self__, "input_template", input_template)
        if kinesis_stream_parameters is not None:
            pulumi.set(__self__, "kinesis_stream_parameters", kinesis_stream_parameters)
        if lambda_function_parameters is not None:
            pulumi.set(__self__, "lambda_function_parameters", lambda_function_parameters)
        if redshift_data_parameters is not None:
            pulumi.set(__self__, "redshift_data_parameters", redshift_data_parameters)
        if sagemaker_pipeline_parameters is not None:
            pulumi.set(__self__, "sagemaker_pipeline_parameters", sagemaker_pipeline_parameters)
        if sqs_queue_parameters is not None:
            pulumi.set(__self__, "sqs_queue_parameters", sqs_queue_parameters)
        if step_function_state_machine_parameters is not None:
            pulumi.set(__self__, "step_function_state_machine_parameters", step_function_state_machine_parameters)

    @property
    @pulumi.getter(name="batchJobParameters")
    def batch_job_parameters(self) -> Optional['outputs.PipeTargetParametersBatchJobParameters']:
        """
        The parameters for using an AWS Batch job as a target. Detailed below.
        """
        return pulumi.get(self, "batch_job_parameters")

    @property
    @pulumi.getter(name="cloudwatchLogsParameters")
    def cloudwatch_logs_parameters(self) -> Optional['outputs.PipeTargetParametersCloudwatchLogsParameters']:
        """
        The parameters for using an CloudWatch Logs log stream as a target. Detailed below.
        """
        return pulumi.get(self, "cloudwatch_logs_parameters")

    @property
    @pulumi.getter(name="ecsTaskParameters")
    def ecs_task_parameters(self) -> Optional['outputs.PipeTargetParametersEcsTaskParameters']:
        """
        The parameters for using an Amazon ECS task as a target. Detailed below.
        """
        return pulumi.get(self, "ecs_task_parameters")

    @property
    @pulumi.getter(name="eventbridgeEventBusParameters")
    def eventbridge_event_bus_parameters(self) -> Optional['outputs.PipeTargetParametersEventbridgeEventBusParameters']:
        """
        The parameters for using an EventBridge event bus as a target. Detailed below.
        """
        return pulumi.get(self, "eventbridge_event_bus_parameters")

    @property
    @pulumi.getter(name="httpParameters")
    def http_parameters(self) -> Optional['outputs.PipeTargetParametersHttpParameters']:
        """
        These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations. Detailed below.
        """
        return pulumi.get(self, "http_parameters")

    @property
    @pulumi.getter(name="inputTemplate")
    def input_template(self) -> Optional[builtins.str]:
        """
        Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. Maximum length of 8192 characters.
        """
        return pulumi.get(self, "input_template")

    @property
    @pulumi.getter(name="kinesisStreamParameters")
    def kinesis_stream_parameters(self) -> Optional['outputs.PipeTargetParametersKinesisStreamParameters']:
        """
        The parameters for using a Kinesis stream as a source. Detailed below.
        """
        return pulumi.get(self, "kinesis_stream_parameters")

    @property
    @pulumi.getter(name="lambdaFunctionParameters")
    def lambda_function_parameters(self) -> Optional['outputs.PipeTargetParametersLambdaFunctionParameters']:
        """
        The parameters for using a Lambda function as a target. Detailed below.
        """
        return pulumi.get(self, "lambda_function_parameters")

    @property
    @pulumi.getter(name="redshiftDataParameters")
    def redshift_data_parameters(self) -> Optional['outputs.PipeTargetParametersRedshiftDataParameters']:
        """
        These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement. Detailed below.
        """
        return pulumi.get(self, "redshift_data_parameters")

    @property
    @pulumi.getter(name="sagemakerPipelineParameters")
    def sagemaker_pipeline_parameters(self) -> Optional['outputs.PipeTargetParametersSagemakerPipelineParameters']:
        """
        The parameters for using a SageMaker AI pipeline as a target. Detailed below.
        """
        return pulumi.get(self, "sagemaker_pipeline_parameters")

    @property
    @pulumi.getter(name="sqsQueueParameters")
    def sqs_queue_parameters(self) -> Optional['outputs.PipeTargetParametersSqsQueueParameters']:
        """
        The parameters for using a Amazon SQS stream as a target. Detailed below.
        """
        return pulumi.get(self, "sqs_queue_parameters")

    @property
    @pulumi.getter(name="stepFunctionStateMachineParameters")
    def step_function_state_machine_parameters(self) -> Optional['outputs.PipeTargetParametersStepFunctionStateMachineParameters']:
        """
        The parameters for using a Step Functions state machine as a target. Detailed below.
        """
        return pulumi.get(self, "step_function_state_machine_parameters")


@pulumi.output_type
class PipeTargetParametersBatchJobParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobDefinition":
            suggest = "job_definition"
        elif key == "jobName":
            suggest = "job_name"
        elif key == "arrayProperties":
            suggest = "array_properties"
        elif key == "containerOverrides":
            suggest = "container_overrides"
        elif key == "dependsOns":
            suggest = "depends_ons"
        elif key == "retryStrategy":
            suggest = "retry_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersBatchJobParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersBatchJobParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersBatchJobParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_definition: builtins.str,
                 job_name: builtins.str,
                 array_properties: Optional['outputs.PipeTargetParametersBatchJobParametersArrayProperties'] = None,
                 container_overrides: Optional['outputs.PipeTargetParametersBatchJobParametersContainerOverrides'] = None,
                 depends_ons: Optional[Sequence['outputs.PipeTargetParametersBatchJobParametersDependsOn']] = None,
                 parameters: Optional[Mapping[str, builtins.str]] = None,
                 retry_strategy: Optional['outputs.PipeTargetParametersBatchJobParametersRetryStrategy'] = None):
        """
        :param builtins.str job_definition: The job definition used by this job. This value can be one of name, name:revision, or the Amazon Resource Name (ARN) for the job definition. If name is specified without a revision then the latest active revision is used.
        :param builtins.str job_name: The name of the job. It can be up to 128 letters long.
        :param 'PipeTargetParametersBatchJobParametersArrayPropertiesArgs' array_properties: The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job. Detailed below.
        :param 'PipeTargetParametersBatchJobParametersContainerOverridesArgs' container_overrides: The overrides that are sent to a container. Detailed below.
        :param Sequence['PipeTargetParametersBatchJobParametersDependsOnArgs'] depends_ons: A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a SEQUENTIAL type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an N_TO_N type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin. Detailed below.
        :param Mapping[str, builtins.str] parameters: Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters included here override any corresponding parameter defaults from the job definition. Detailed below.
        :param 'PipeTargetParametersBatchJobParametersRetryStrategyArgs' retry_strategy: The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition. Detailed below.
        """
        pulumi.set(__self__, "job_definition", job_definition)
        pulumi.set(__self__, "job_name", job_name)
        if array_properties is not None:
            pulumi.set(__self__, "array_properties", array_properties)
        if container_overrides is not None:
            pulumi.set(__self__, "container_overrides", container_overrides)
        if depends_ons is not None:
            pulumi.set(__self__, "depends_ons", depends_ons)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if retry_strategy is not None:
            pulumi.set(__self__, "retry_strategy", retry_strategy)

    @property
    @pulumi.getter(name="jobDefinition")
    def job_definition(self) -> builtins.str:
        """
        The job definition used by this job. This value can be one of name, name:revision, or the Amazon Resource Name (ARN) for the job definition. If name is specified without a revision then the latest active revision is used.
        """
        return pulumi.get(self, "job_definition")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> builtins.str:
        """
        The name of the job. It can be up to 128 letters long.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="arrayProperties")
    def array_properties(self) -> Optional['outputs.PipeTargetParametersBatchJobParametersArrayProperties']:
        """
        The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job. Detailed below.
        """
        return pulumi.get(self, "array_properties")

    @property
    @pulumi.getter(name="containerOverrides")
    def container_overrides(self) -> Optional['outputs.PipeTargetParametersBatchJobParametersContainerOverrides']:
        """
        The overrides that are sent to a container. Detailed below.
        """
        return pulumi.get(self, "container_overrides")

    @property
    @pulumi.getter(name="dependsOns")
    def depends_ons(self) -> Optional[Sequence['outputs.PipeTargetParametersBatchJobParametersDependsOn']]:
        """
        A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a SEQUENTIAL type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an N_TO_N type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin. Detailed below.
        """
        return pulumi.get(self, "depends_ons")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters included here override any corresponding parameter defaults from the job definition. Detailed below.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="retryStrategy")
    def retry_strategy(self) -> Optional['outputs.PipeTargetParametersBatchJobParametersRetryStrategy']:
        """
        The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition. Detailed below.
        """
        return pulumi.get(self, "retry_strategy")


@pulumi.output_type
class PipeTargetParametersBatchJobParametersArrayProperties(dict):
    def __init__(__self__, *,
                 size: Optional[builtins.int] = None):
        """
        :param builtins.int size: The size of the array, if this is an array batch job. Minimum value of 2. Maximum value of 10,000.
        """
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.int]:
        """
        The size of the array, if this is an array batch job. Minimum value of 2. Maximum value of 10,000.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class PipeTargetParametersBatchJobParametersContainerOverrides(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "resourceRequirements":
            suggest = "resource_requirements"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersBatchJobParametersContainerOverrides. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersBatchJobParametersContainerOverrides.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersBatchJobParametersContainerOverrides.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Optional[Sequence[builtins.str]] = None,
                 environments: Optional[Sequence['outputs.PipeTargetParametersBatchJobParametersContainerOverridesEnvironment']] = None,
                 instance_type: Optional[builtins.str] = None,
                 resource_requirements: Optional[Sequence['outputs.PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirement']] = None):
        """
        :param Sequence[builtins.str] commands: List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
        :param Sequence['PipeTargetParametersBatchJobParametersContainerOverridesEnvironmentArgs'] environments: The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
        :param builtins.str instance_type: The instance type to use for a multi-node parallel job. This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
        :param Sequence['PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirementArgs'] resource_requirements: The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
        """
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[builtins.str]]:
        """
        List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def environments(self) -> Optional[Sequence['outputs.PipeTargetParametersBatchJobParametersContainerOverridesEnvironment']]:
        """
        The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[builtins.str]:
        """
        The instance type to use for a multi-node parallel job. This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[Sequence['outputs.PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirement']]:
        """
        The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
        """
        return pulumi.get(self, "resource_requirements")


@pulumi.output_type
class PipeTargetParametersBatchJobParametersContainerOverridesEnvironment(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param builtins.str value: Value of parameter to start execution of a SageMaker AI Model Building Pipeline. Maximum length of 1024.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        Value of parameter to start execution of a SageMaker AI Model Building Pipeline. Maximum length of 1024.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PipeTargetParametersBatchJobParametersContainerOverridesResourceRequirement(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str type: The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
        :param builtins.str value: Value of parameter to start execution of a SageMaker AI Model Building Pipeline. Maximum length of 1024.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of parameter to start execution of a SageMaker AI Model Building Pipeline. Maximum length of 1024.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PipeTargetParametersBatchJobParametersDependsOn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobId":
            suggest = "job_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersBatchJobParametersDependsOn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersBatchJobParametersDependsOn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersBatchJobParametersDependsOn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_id: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str job_id: The job ID of the AWS Batch job that's associated with this dependency.
        :param builtins.str type: The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
        """
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[builtins.str]:
        """
        The job ID of the AWS Batch job that's associated with this dependency.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PipeTargetParametersBatchJobParametersRetryStrategy(dict):
    def __init__(__self__, *,
                 attempts: Optional[builtins.int] = None):
        """
        :param builtins.int attempts: The number of times to move a job to the RUNNABLE status. If the value of attempts is greater than one, the job is retried on failure the same number of attempts as the value. Maximum value of 10.
        """
        if attempts is not None:
            pulumi.set(__self__, "attempts", attempts)

    @property
    @pulumi.getter
    def attempts(self) -> Optional[builtins.int]:
        """
        The number of times to move a job to the RUNNABLE status. If the value of attempts is greater than one, the job is retried on failure the same number of attempts as the value. Maximum value of 10.
        """
        return pulumi.get(self, "attempts")


@pulumi.output_type
class PipeTargetParametersCloudwatchLogsParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logStreamName":
            suggest = "log_stream_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersCloudwatchLogsParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersCloudwatchLogsParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersCloudwatchLogsParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_stream_name: Optional[builtins.str] = None,
                 timestamp: Optional[builtins.str] = None):
        """
        :param builtins.str log_stream_name: The name of the log stream.
        :param builtins.str timestamp: The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. This is the JSON path to the field in the event e.g. $.detail.timestamp
        """
        if log_stream_name is not None:
            pulumi.set(__self__, "log_stream_name", log_stream_name)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter(name="logStreamName")
    def log_stream_name(self) -> Optional[builtins.str]:
        """
        The name of the log stream.
        """
        return pulumi.get(self, "log_stream_name")

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[builtins.str]:
        """
        The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. This is the JSON path to the field in the event e.g. $.detail.timestamp
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class PipeTargetParametersEcsTaskParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskDefinitionArn":
            suggest = "task_definition_arn"
        elif key == "capacityProviderStrategies":
            suggest = "capacity_provider_strategies"
        elif key == "enableEcsManagedTags":
            suggest = "enable_ecs_managed_tags"
        elif key == "enableExecuteCommand":
            suggest = "enable_execute_command"
        elif key == "launchType":
            suggest = "launch_type"
        elif key == "networkConfiguration":
            suggest = "network_configuration"
        elif key == "placementConstraints":
            suggest = "placement_constraints"
        elif key == "placementStrategies":
            suggest = "placement_strategies"
        elif key == "platformVersion":
            suggest = "platform_version"
        elif key == "propagateTags":
            suggest = "propagate_tags"
        elif key == "referenceId":
            suggest = "reference_id"
        elif key == "taskCount":
            suggest = "task_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersEcsTaskParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersEcsTaskParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersEcsTaskParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_definition_arn: builtins.str,
                 capacity_provider_strategies: Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersCapacityProviderStrategy']] = None,
                 enable_ecs_managed_tags: Optional[builtins.bool] = None,
                 enable_execute_command: Optional[builtins.bool] = None,
                 group: Optional[builtins.str] = None,
                 launch_type: Optional[builtins.str] = None,
                 network_configuration: Optional['outputs.PipeTargetParametersEcsTaskParametersNetworkConfiguration'] = None,
                 overrides: Optional['outputs.PipeTargetParametersEcsTaskParametersOverrides'] = None,
                 placement_constraints: Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersPlacementConstraint']] = None,
                 placement_strategies: Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersPlacementStrategy']] = None,
                 platform_version: Optional[builtins.str] = None,
                 propagate_tags: Optional[builtins.str] = None,
                 reference_id: Optional[builtins.str] = None,
                 tags: Optional[Mapping[str, builtins.str]] = None,
                 task_count: Optional[builtins.int] = None):
        """
        :param builtins.str task_definition_arn: The ARN of the task definition to use if the event target is an Amazon ECS task.
        :param Sequence['PipeTargetParametersEcsTaskParametersCapacityProviderStrategyArgs'] capacity_provider_strategies: List of capacity provider strategies to use for the task. If a capacityProviderStrategy is specified, the launchType parameter must be omitted. If no capacityProviderStrategy or launchType is specified, the defaultCapacityProviderStrategy for the cluster is used. Detailed below.
        :param builtins.bool enable_ecs_managed_tags: Specifies whether to enable Amazon ECS managed tags for the task. Valid values: true, false.
        :param builtins.bool enable_execute_command: Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task. Valid values: true, false.
        :param builtins.str group: Specifies an Amazon ECS task group for the task. The maximum length is 255 characters.
        :param builtins.str launch_type: Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The FARGATE value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. Valid Values: EC2, FARGATE, EXTERNAL
        :param 'PipeTargetParametersEcsTaskParametersNetworkConfigurationArgs' network_configuration: Use this structure if the Amazon ECS task uses the awsvpc network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if LaunchType is FARGATE because the awsvpc mode is required for Fargate tasks. If you specify NetworkConfiguration when the target ECS task does not use the awsvpc network mode, the task fails. Detailed below.
        :param 'PipeTargetParametersEcsTaskParametersOverridesArgs' overrides: The overrides that are associated with a task. Detailed below.
        :param Sequence['PipeTargetParametersEcsTaskParametersPlacementConstraintArgs'] placement_constraints: An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). Detailed below.
        :param Sequence['PipeTargetParametersEcsTaskParametersPlacementStrategyArgs'] placement_strategies: The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task. Detailed below.
        :param builtins.str platform_version: Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as 1.1.0. This structure is used only if LaunchType is FARGATE.
        :param builtins.str propagate_tags: Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action. Valid Values: TASK_DEFINITION
        :param builtins.str reference_id: The reference ID to use for the task. Maximum length of 1,024.
        :param Mapping[str, builtins.str] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param builtins.int task_count: The number of tasks to create based on TaskDefinition. The default is 1.
        """
        pulumi.set(__self__, "task_definition_arn", task_definition_arn)
        if capacity_provider_strategies is not None:
            pulumi.set(__self__, "capacity_provider_strategies", capacity_provider_strategies)
        if enable_ecs_managed_tags is not None:
            pulumi.set(__self__, "enable_ecs_managed_tags", enable_ecs_managed_tags)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if placement_strategies is not None:
            pulumi.set(__self__, "placement_strategies", placement_strategies)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter(name="taskDefinitionArn")
    def task_definition_arn(self) -> builtins.str:
        """
        The ARN of the task definition to use if the event target is an Amazon ECS task.
        """
        return pulumi.get(self, "task_definition_arn")

    @property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersCapacityProviderStrategy']]:
        """
        List of capacity provider strategies to use for the task. If a capacityProviderStrategy is specified, the launchType parameter must be omitted. If no capacityProviderStrategy or launchType is specified, the defaultCapacityProviderStrategy for the cluster is used. Detailed below.
        """
        return pulumi.get(self, "capacity_provider_strategies")

    @property
    @pulumi.getter(name="enableEcsManagedTags")
    def enable_ecs_managed_tags(self) -> Optional[builtins.bool]:
        """
        Specifies whether to enable Amazon ECS managed tags for the task. Valid values: true, false.
        """
        return pulumi.get(self, "enable_ecs_managed_tags")

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[builtins.bool]:
        """
        Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task. Valid values: true, false.
        """
        return pulumi.get(self, "enable_execute_command")

    @property
    @pulumi.getter
    def group(self) -> Optional[builtins.str]:
        """
        Specifies an Amazon ECS task group for the task. The maximum length is 255 characters.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional[builtins.str]:
        """
        Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The FARGATE value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. Valid Values: EC2, FARGATE, EXTERNAL
        """
        return pulumi.get(self, "launch_type")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.PipeTargetParametersEcsTaskParametersNetworkConfiguration']:
        """
        Use this structure if the Amazon ECS task uses the awsvpc network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if LaunchType is FARGATE because the awsvpc mode is required for Fargate tasks. If you specify NetworkConfiguration when the target ECS task does not use the awsvpc network mode, the task fails. Detailed below.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter
    def overrides(self) -> Optional['outputs.PipeTargetParametersEcsTaskParametersOverrides']:
        """
        The overrides that are associated with a task. Detailed below.
        """
        return pulumi.get(self, "overrides")

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersPlacementConstraint']]:
        """
        An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). Detailed below.
        """
        return pulumi.get(self, "placement_constraints")

    @property
    @pulumi.getter(name="placementStrategies")
    def placement_strategies(self) -> Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersPlacementStrategy']]:
        """
        The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task. Detailed below.
        """
        return pulumi.get(self, "placement_strategies")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[builtins.str]:
        """
        Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as 1.1.0. This structure is used only if LaunchType is FARGATE.
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[builtins.str]:
        """
        Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action. Valid Values: TASK_DEFINITION
        """
        return pulumi.get(self, "propagate_tags")

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[builtins.str]:
        """
        The reference ID to use for the task. Maximum length of 1,024.
        """
        return pulumi.get(self, "reference_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[builtins.int]:
        """
        The number of tasks to create based on TaskDefinition. The default is 1.
        """
        return pulumi.get(self, "task_count")


@pulumi.output_type
class PipeTargetParametersEcsTaskParametersCapacityProviderStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersEcsTaskParametersCapacityProviderStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersEcsTaskParametersCapacityProviderStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersEcsTaskParametersCapacityProviderStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_provider: builtins.str,
                 base: Optional[builtins.int] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str capacity_provider: The short name of the capacity provider. Maximum value of 255.
        :param builtins.int base: The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used. Maximum value of 100,000.
        :param builtins.int weight: The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied. Maximum value of 1,000.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> builtins.str:
        """
        The short name of the capacity provider. Maximum value of 255.
        """
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def base(self) -> Optional[builtins.int]:
        """
        The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used. Maximum value of 100,000.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied. Maximum value of 1,000.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class PipeTargetParametersEcsTaskParametersNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsVpcConfiguration":
            suggest = "aws_vpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersEcsTaskParametersNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersEcsTaskParametersNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersEcsTaskParametersNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_vpc_configuration: Optional['outputs.PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfiguration'] = None):
        """
        :param 'PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfigurationArgs' aws_vpc_configuration: Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode. Detailed below.
        """
        if aws_vpc_configuration is not None:
            pulumi.set(__self__, "aws_vpc_configuration", aws_vpc_configuration)

    @property
    @pulumi.getter(name="awsVpcConfiguration")
    def aws_vpc_configuration(self) -> Optional['outputs.PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfiguration']:
        """
        Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the awsvpc network mode. Detailed below.
        """
        return pulumi.get(self, "aws_vpc_configuration")


@pulumi.output_type
class PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersEcsTaskParametersNetworkConfigurationAwsVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assign_public_ip: Optional[builtins.str] = None,
                 security_groups: Optional[Sequence[builtins.str]] = None,
                 subnets: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str assign_public_ip: Specifies whether the task's elastic network interface receives a public IP address. You can specify ENABLED only when LaunchType in EcsParameters is set to FARGATE. Valid Values: ENABLED, DISABLED.
        """
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[builtins.str]:
        """
        Specifies whether the task's elastic network interface receives a public IP address. You can specify ENABLED only when LaunchType in EcsParameters is set to FARGATE. Valid Values: ENABLED, DISABLED.
        """
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def subnets(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "subnets")


@pulumi.output_type
class PipeTargetParametersEcsTaskParametersOverrides(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerOverrides":
            suggest = "container_overrides"
        elif key == "ephemeralStorage":
            suggest = "ephemeral_storage"
        elif key == "executionRoleArn":
            suggest = "execution_role_arn"
        elif key == "inferenceAcceleratorOverrides":
            suggest = "inference_accelerator_overrides"
        elif key == "taskRoleArn":
            suggest = "task_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersEcsTaskParametersOverrides. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersEcsTaskParametersOverrides.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersEcsTaskParametersOverrides.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_overrides: Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverride']] = None,
                 cpu: Optional[builtins.str] = None,
                 ephemeral_storage: Optional['outputs.PipeTargetParametersEcsTaskParametersOverridesEphemeralStorage'] = None,
                 execution_role_arn: Optional[builtins.str] = None,
                 inference_accelerator_overrides: Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverride']] = None,
                 memory: Optional[builtins.str] = None,
                 task_role_arn: Optional[builtins.str] = None):
        """
        :param Sequence['PipeTargetParametersEcsTaskParametersOverridesContainerOverrideArgs'] container_overrides: One or more container overrides that are sent to a task. Detailed below.
        :param builtins.str cpu: The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
        :param 'PipeTargetParametersEcsTaskParametersOverridesEphemeralStorageArgs' ephemeral_storage: The ephemeral storage setting override for the task.  Detailed below.
        :param builtins.str execution_role_arn: The Amazon Resource Name (ARN) of the task execution IAM role override for the task.
        :param Sequence['PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverrideArgs'] inference_accelerator_overrides: List of Elastic Inference accelerator overrides for the task. Detailed below.
        :param builtins.str memory: The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
        :param builtins.str task_role_arn: The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role.
        """
        if container_overrides is not None:
            pulumi.set(__self__, "container_overrides", container_overrides)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if inference_accelerator_overrides is not None:
            pulumi.set(__self__, "inference_accelerator_overrides", inference_accelerator_overrides)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if task_role_arn is not None:
            pulumi.set(__self__, "task_role_arn", task_role_arn)

    @property
    @pulumi.getter(name="containerOverrides")
    def container_overrides(self) -> Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverride']]:
        """
        One or more container overrides that are sent to a task. Detailed below.
        """
        return pulumi.get(self, "container_overrides")

    @property
    @pulumi.getter
    def cpu(self) -> Optional[builtins.str]:
        """
        The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional['outputs.PipeTargetParametersEcsTaskParametersOverridesEphemeralStorage']:
        """
        The ephemeral storage setting override for the task.  Detailed below.
        """
        return pulumi.get(self, "ephemeral_storage")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the task execution IAM role override for the task.
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="inferenceAcceleratorOverrides")
    def inference_accelerator_overrides(self) -> Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverride']]:
        """
        List of Elastic Inference accelerator overrides for the task. Detailed below.
        """
        return pulumi.get(self, "inference_accelerator_overrides")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.str]:
        """
        The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="taskRoleArn")
    def task_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role.
        """
        return pulumi.get(self, "task_role_arn")


@pulumi.output_type
class PipeTargetParametersEcsTaskParametersOverridesContainerOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentFiles":
            suggest = "environment_files"
        elif key == "memoryReservation":
            suggest = "memory_reservation"
        elif key == "resourceRequirements":
            suggest = "resource_requirements"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersEcsTaskParametersOverridesContainerOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersEcsTaskParametersOverridesContainerOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersEcsTaskParametersOverridesContainerOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 commands: Optional[Sequence[builtins.str]] = None,
                 cpu: Optional[builtins.int] = None,
                 environment_files: Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFile']] = None,
                 environments: Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironment']] = None,
                 memory: Optional[builtins.int] = None,
                 memory_reservation: Optional[builtins.int] = None,
                 name: Optional[builtins.str] = None,
                 resource_requirements: Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirement']] = None):
        """
        :param Sequence[builtins.str] commands: List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
        :param builtins.int cpu: The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
        :param Sequence['PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFileArgs'] environment_files: A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
        :param Sequence['PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentArgs'] environments: The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
        :param builtins.int memory: The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
        :param builtins.int memory_reservation: The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition. You must also specify a container name.
        :param builtins.str name: Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param Sequence['PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirementArgs'] resource_requirements: The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
        """
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if environment_files is not None:
            pulumi.set(__self__, "environment_files", environment_files)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_reservation is not None:
            pulumi.set(__self__, "memory_reservation", memory_reservation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[builtins.str]]:
        """
        List of commands to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def cpu(self) -> Optional[builtins.int]:
        """
        The number of cpu units reserved for the container, instead of the default value from the task definition. You must also specify a container name.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="environmentFiles")
    def environment_files(self) -> Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFile']]:
        """
        A list of files containing the environment variables to pass to a container, instead of the value from the container definition. Detailed below.
        """
        return pulumi.get(self, "environment_files")

    @property
    @pulumi.getter
    def environments(self) -> Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironment']]:
        """
        The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name. Detailed below.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.int]:
        """
        The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> Optional[builtins.int]:
        """
        The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition. You must also specify a container name.
        """
        return pulumi.get(self, "memory_reservation")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[Sequence['outputs.PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirement']]:
        """
        The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU. Detailed below.
        """
        return pulumi.get(self, "resource_requirements")


@pulumi.output_type
class PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironment(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param builtins.str value: Value of parameter to start execution of a SageMaker AI Model Building Pipeline. Maximum length of 1024.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        Value of parameter to start execution of a SageMaker AI Model Building Pipeline. Maximum length of 1024.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PipeTargetParametersEcsTaskParametersOverridesContainerOverrideEnvironmentFile(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str type: The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
        :param builtins.str value: Value of parameter to start execution of a SageMaker AI Model Building Pipeline. Maximum length of 1024.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of parameter to start execution of a SageMaker AI Model Building Pipeline. Maximum length of 1024.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PipeTargetParametersEcsTaskParametersOverridesContainerOverrideResourceRequirement(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str type: The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
        :param builtins.str value: Value of parameter to start execution of a SageMaker AI Model Building Pipeline. Maximum length of 1024.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of parameter to start execution of a SageMaker AI Model Building Pipeline. Maximum length of 1024.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PipeTargetParametersEcsTaskParametersOverridesEphemeralStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeInGib":
            suggest = "size_in_gib"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersEcsTaskParametersOverridesEphemeralStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersEcsTaskParametersOverridesEphemeralStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersEcsTaskParametersOverridesEphemeralStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_in_gib: builtins.int):
        """
        :param builtins.int size_in_gib: The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is 21 GiB and the maximum supported value is 200 GiB.
        """
        pulumi.set(__self__, "size_in_gib", size_in_gib)

    @property
    @pulumi.getter(name="sizeInGib")
    def size_in_gib(self) -> builtins.int:
        """
        The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is 21 GiB and the maximum supported value is 200 GiB.
        """
        return pulumi.get(self, "size_in_gib")


@pulumi.output_type
class PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "deviceType":
            suggest = "device_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersEcsTaskParametersOverridesInferenceAcceleratorOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: Optional[builtins.str] = None,
                 device_type: Optional[builtins.str] = None):
        """
        :param builtins.str device_name: The Elastic Inference accelerator device name to override for the task. This parameter must match a deviceName specified in the task definition.
        :param builtins.str device_type: The Elastic Inference accelerator type to use.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[builtins.str]:
        """
        The Elastic Inference accelerator device name to override for the task. This parameter must match a deviceName specified in the task definition.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[builtins.str]:
        """
        The Elastic Inference accelerator type to use.
        """
        return pulumi.get(self, "device_type")


@pulumi.output_type
class PipeTargetParametersEcsTaskParametersPlacementConstraint(dict):
    def __init__(__self__, *,
                 expression: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str expression: A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is distinctInstance. Maximum length of 2,000.
        :param builtins.str type: The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is distinctInstance. Maximum length of 2,000.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PipeTargetParametersEcsTaskParametersPlacementStrategy(dict):
    def __init__(__self__, *,
                 field: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str field: The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used. Maximum length of 255.
        :param builtins.str type: The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def field(self) -> Optional[builtins.str]:
        """
        The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used. Maximum length of 255.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). Valid Values: random, spread, binpack.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PipeTargetParametersEventbridgeEventBusParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detailType":
            suggest = "detail_type"
        elif key == "endpointId":
            suggest = "endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersEventbridgeEventBusParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersEventbridgeEventBusParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersEventbridgeEventBusParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detail_type: Optional[builtins.str] = None,
                 endpoint_id: Optional[builtins.str] = None,
                 resources: Optional[Sequence[builtins.str]] = None,
                 source: Optional[builtins.str] = None,
                 time: Optional[builtins.str] = None):
        """
        :param builtins.str detail_type: A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
        :param builtins.str endpoint_id: The URL subdomain of the endpoint. For example, if the URL for Endpoint is https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is abcde.veo.
        :param Sequence[builtins.str] resources: List of AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.
        :param builtins.str source: Source resource of the pipe. This field typically requires an ARN (Amazon Resource Name). However, when using a self-managed Kafka cluster, you should use a different format. Instead of an ARN, use 'smk://' followed by the bootstrap server's address.
        :param builtins.str time: The time stamp of the event, per RFC3339. If no time stamp is provided, the time stamp of the PutEvents call is used. This is the JSON path to the field in the event e.g. $.detail.timestamp
        """
        if detail_type is not None:
            pulumi.set(__self__, "detail_type", detail_type)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="detailType")
    def detail_type(self) -> Optional[builtins.str]:
        """
        A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
        """
        return pulumi.get(self, "detail_type")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[builtins.str]:
        """
        The URL subdomain of the endpoint. For example, if the URL for Endpoint is https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is abcde.veo.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[builtins.str]]:
        """
        List of AWS resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        Source resource of the pipe. This field typically requires an ARN (Amazon Resource Name). However, when using a self-managed Kafka cluster, you should use a different format. Instead of an ARN, use 'smk://' followed by the bootstrap server's address.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def time(self) -> Optional[builtins.str]:
        """
        The time stamp of the event, per RFC3339. If no time stamp is provided, the time stamp of the PutEvents call is used. This is the JSON path to the field in the event e.g. $.detail.timestamp
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class PipeTargetParametersHttpParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerParameters":
            suggest = "header_parameters"
        elif key == "pathParameterValues":
            suggest = "path_parameter_values"
        elif key == "queryStringParameters":
            suggest = "query_string_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersHttpParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersHttpParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersHttpParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_parameters: Optional[Mapping[str, builtins.str]] = None,
                 path_parameter_values: Optional[builtins.str] = None,
                 query_string_parameters: Optional[Mapping[str, builtins.str]] = None):
        if header_parameters is not None:
            pulumi.set(__self__, "header_parameters", header_parameters)
        if path_parameter_values is not None:
            pulumi.set(__self__, "path_parameter_values", path_parameter_values)
        if query_string_parameters is not None:
            pulumi.set(__self__, "query_string_parameters", query_string_parameters)

    @property
    @pulumi.getter(name="headerParameters")
    def header_parameters(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "header_parameters")

    @property
    @pulumi.getter(name="pathParameterValues")
    def path_parameter_values(self) -> Optional[builtins.str]:
        return pulumi.get(self, "path_parameter_values")

    @property
    @pulumi.getter(name="queryStringParameters")
    def query_string_parameters(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "query_string_parameters")


@pulumi.output_type
class PipeTargetParametersKinesisStreamParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionKey":
            suggest = "partition_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersKinesisStreamParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersKinesisStreamParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersKinesisStreamParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partition_key: builtins.str):
        """
        :param builtins.str partition_key: Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.
        """
        pulumi.set(__self__, "partition_key", partition_key)

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> builtins.str:
        """
        Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.
        """
        return pulumi.get(self, "partition_key")


@pulumi.output_type
class PipeTargetParametersLambdaFunctionParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invocationType":
            suggest = "invocation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersLambdaFunctionParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersLambdaFunctionParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersLambdaFunctionParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 invocation_type: builtins.str):
        """
        :param builtins.str invocation_type: Specify whether to invoke the function synchronously or asynchronously. Valid Values: REQUEST_RESPONSE, FIRE_AND_FORGET.
        """
        pulumi.set(__self__, "invocation_type", invocation_type)

    @property
    @pulumi.getter(name="invocationType")
    def invocation_type(self) -> builtins.str:
        """
        Specify whether to invoke the function synchronously or asynchronously. Valid Values: REQUEST_RESPONSE, FIRE_AND_FORGET.
        """
        return pulumi.get(self, "invocation_type")


@pulumi.output_type
class PipeTargetParametersRedshiftDataParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbUser":
            suggest = "db_user"
        elif key == "secretManagerArn":
            suggest = "secret_manager_arn"
        elif key == "statementName":
            suggest = "statement_name"
        elif key == "withEvent":
            suggest = "with_event"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersRedshiftDataParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersRedshiftDataParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersRedshiftDataParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: builtins.str,
                 sqls: Sequence[builtins.str],
                 db_user: Optional[builtins.str] = None,
                 secret_manager_arn: Optional[builtins.str] = None,
                 statement_name: Optional[builtins.str] = None,
                 with_event: Optional[builtins.bool] = None):
        """
        :param builtins.str database: The name of the database. Required when authenticating using temporary credentials.
        :param Sequence[builtins.str] sqls: List of SQL statements text to run, each of maximum length of 100,000.
        :param builtins.str db_user: The database user name. Required when authenticating using temporary credentials.
        :param builtins.str secret_manager_arn: The name or ARN of the secret that enables access to the database. Required when authenticating using Secrets Manager.
        :param builtins.str statement_name: The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
        :param builtins.bool with_event: Indicates whether to send an event back to EventBridge after the SQL statement runs.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "sqls", sqls)
        if db_user is not None:
            pulumi.set(__self__, "db_user", db_user)
        if secret_manager_arn is not None:
            pulumi.set(__self__, "secret_manager_arn", secret_manager_arn)
        if statement_name is not None:
            pulumi.set(__self__, "statement_name", statement_name)
        if with_event is not None:
            pulumi.set(__self__, "with_event", with_event)

    @property
    @pulumi.getter
    def database(self) -> builtins.str:
        """
        The name of the database. Required when authenticating using temporary credentials.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def sqls(self) -> Sequence[builtins.str]:
        """
        List of SQL statements text to run, each of maximum length of 100,000.
        """
        return pulumi.get(self, "sqls")

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> Optional[builtins.str]:
        """
        The database user name. Required when authenticating using temporary credentials.
        """
        return pulumi.get(self, "db_user")

    @property
    @pulumi.getter(name="secretManagerArn")
    def secret_manager_arn(self) -> Optional[builtins.str]:
        """
        The name or ARN of the secret that enables access to the database. Required when authenticating using Secrets Manager.
        """
        return pulumi.get(self, "secret_manager_arn")

    @property
    @pulumi.getter(name="statementName")
    def statement_name(self) -> Optional[builtins.str]:
        """
        The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
        """
        return pulumi.get(self, "statement_name")

    @property
    @pulumi.getter(name="withEvent")
    def with_event(self) -> Optional[builtins.bool]:
        """
        Indicates whether to send an event back to EventBridge after the SQL statement runs.
        """
        return pulumi.get(self, "with_event")


@pulumi.output_type
class PipeTargetParametersSagemakerPipelineParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineParameters":
            suggest = "pipeline_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersSagemakerPipelineParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersSagemakerPipelineParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersSagemakerPipelineParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pipeline_parameters: Optional[Sequence['outputs.PipeTargetParametersSagemakerPipelineParametersPipelineParameter']] = None):
        """
        :param Sequence['PipeTargetParametersSagemakerPipelineParametersPipelineParameterArgs'] pipeline_parameters: List of Parameter names and values for SageMaker AI Model Building Pipeline execution. Detailed below.
        """
        if pipeline_parameters is not None:
            pulumi.set(__self__, "pipeline_parameters", pipeline_parameters)

    @property
    @pulumi.getter(name="pipelineParameters")
    def pipeline_parameters(self) -> Optional[Sequence['outputs.PipeTargetParametersSagemakerPipelineParametersPipelineParameter']]:
        """
        List of Parameter names and values for SageMaker AI Model Building Pipeline execution. Detailed below.
        """
        return pulumi.get(self, "pipeline_parameters")


@pulumi.output_type
class PipeTargetParametersSagemakerPipelineParametersPipelineParameter(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param builtins.str value: Value of parameter to start execution of a SageMaker AI Model Building Pipeline. Maximum length of 1024.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of parameter to start execution of a SageMaker AI Model Building Pipeline. Maximum length of 1024.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PipeTargetParametersSqsQueueParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageDeduplicationId":
            suggest = "message_deduplication_id"
        elif key == "messageGroupId":
            suggest = "message_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersSqsQueueParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersSqsQueueParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersSqsQueueParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_deduplication_id: Optional[builtins.str] = None,
                 message_group_id: Optional[builtins.str] = None):
        """
        :param builtins.str message_deduplication_id: This parameter applies only to FIFO (first-in-first-out) queues. The token used for deduplication of sent messages.
        :param builtins.str message_group_id: The FIFO message group ID to use as the target.
        """
        if message_deduplication_id is not None:
            pulumi.set(__self__, "message_deduplication_id", message_deduplication_id)
        if message_group_id is not None:
            pulumi.set(__self__, "message_group_id", message_group_id)

    @property
    @pulumi.getter(name="messageDeduplicationId")
    def message_deduplication_id(self) -> Optional[builtins.str]:
        """
        This parameter applies only to FIFO (first-in-first-out) queues. The token used for deduplication of sent messages.
        """
        return pulumi.get(self, "message_deduplication_id")

    @property
    @pulumi.getter(name="messageGroupId")
    def message_group_id(self) -> Optional[builtins.str]:
        """
        The FIFO message group ID to use as the target.
        """
        return pulumi.get(self, "message_group_id")


@pulumi.output_type
class PipeTargetParametersStepFunctionStateMachineParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invocationType":
            suggest = "invocation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipeTargetParametersStepFunctionStateMachineParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipeTargetParametersStepFunctionStateMachineParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipeTargetParametersStepFunctionStateMachineParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 invocation_type: builtins.str):
        """
        :param builtins.str invocation_type: Specify whether to invoke the function synchronously or asynchronously. Valid Values: REQUEST_RESPONSE, FIRE_AND_FORGET.
        """
        pulumi.set(__self__, "invocation_type", invocation_type)

    @property
    @pulumi.getter(name="invocationType")
    def invocation_type(self) -> builtins.str:
        """
        Specify whether to invoke the function synchronously or asynchronously. Valid Values: REQUEST_RESPONSE, FIRE_AND_FORGET.
        """
        return pulumi.get(self, "invocation_type")


