# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 iam_service_role_arn: pulumi.Input[builtins.str],
                 identity_center_instance_arn: pulumi.Input[builtins.str],
                 attachments_configuration: Optional[pulumi.Input['ApplicationAttachmentsConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input['ApplicationEncryptionConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ApplicationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[builtins.str] display_name: Name of the Amazon Q application.
        :param pulumi.Input[builtins.str] iam_service_role_arn: ARN of an IAM role with permissions to access your Amazon CloudWatch logs and metrics.
        :param pulumi.Input[builtins.str] identity_center_instance_arn: ARN of the IAM Identity Center instance you are either creating for — or connecting to — your Amazon Q Business application.
               
               The following arguments are optional:
        :param pulumi.Input['ApplicationAttachmentsConfigurationArgs'] attachments_configuration: Information about whether file upload functionality is activated or deactivated for your end user. See `attachments_configuration` below.
        :param pulumi.Input[builtins.str] description: Description of the Amazon Q application.
        :param pulumi.Input['ApplicationEncryptionConfigurationArgs'] encryption_configuration: Information about encryption configuration. See `encryption_configuration` below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "iam_service_role_arn", iam_service_role_arn)
        pulumi.set(__self__, "identity_center_instance_arn", identity_center_instance_arn)
        if attachments_configuration is not None:
            pulumi.set(__self__, "attachments_configuration", attachments_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Amazon Q application.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="iamServiceRoleArn")
    def iam_service_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of an IAM role with permissions to access your Amazon CloudWatch logs and metrics.
        """
        return pulumi.get(self, "iam_service_role_arn")

    @iam_service_role_arn.setter
    def iam_service_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "iam_service_role_arn", value)

    @property
    @pulumi.getter(name="identityCenterInstanceArn")
    def identity_center_instance_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the IAM Identity Center instance you are either creating for — or connecting to — your Amazon Q Business application.

        The following arguments are optional:
        """
        return pulumi.get(self, "identity_center_instance_arn")

    @identity_center_instance_arn.setter
    def identity_center_instance_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identity_center_instance_arn", value)

    @property
    @pulumi.getter(name="attachmentsConfiguration")
    def attachments_configuration(self) -> Optional[pulumi.Input['ApplicationAttachmentsConfigurationArgs']]:
        """
        Information about whether file upload functionality is activated or deactivated for your end user. See `attachments_configuration` below.
        """
        return pulumi.get(self, "attachments_configuration")

    @attachments_configuration.setter
    def attachments_configuration(self, value: Optional[pulumi.Input['ApplicationAttachmentsConfigurationArgs']]):
        pulumi.set(self, "attachments_configuration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Amazon Q application.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['ApplicationEncryptionConfigurationArgs']]:
        """
        Information about encryption configuration. See `encryption_configuration` below.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['ApplicationEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ApplicationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ApplicationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ApplicationState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 attachments_configuration: Optional[pulumi.Input['ApplicationAttachmentsConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input['ApplicationEncryptionConfigurationArgs']] = None,
                 iam_service_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 identity_center_application_arn: Optional[pulumi.Input[builtins.str]] = None,
                 identity_center_instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ApplicationTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering Application resources.
        :param pulumi.Input[builtins.str] arn: ARN of the Q Business application.
        :param pulumi.Input['ApplicationAttachmentsConfigurationArgs'] attachments_configuration: Information about whether file upload functionality is activated or deactivated for your end user. See `attachments_configuration` below.
        :param pulumi.Input[builtins.str] description: Description of the Amazon Q application.
        :param pulumi.Input[builtins.str] display_name: Name of the Amazon Q application.
        :param pulumi.Input['ApplicationEncryptionConfigurationArgs'] encryption_configuration: Information about encryption configuration. See `encryption_configuration` below.
        :param pulumi.Input[builtins.str] iam_service_role_arn: ARN of an IAM role with permissions to access your Amazon CloudWatch logs and metrics.
        :param pulumi.Input[builtins.str] identity_center_application_arn: ARN of the AWS IAM Identity Center application attached to your Amazon Q Business application.
        :param pulumi.Input[builtins.str] identity_center_instance_arn: ARN of the IAM Identity Center instance you are either creating for — or connecting to — your Amazon Q Business application.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if attachments_configuration is not None:
            pulumi.set(__self__, "attachments_configuration", attachments_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if iam_service_role_arn is not None:
            pulumi.set(__self__, "iam_service_role_arn", iam_service_role_arn)
        if identity_center_application_arn is not None:
            pulumi.set(__self__, "identity_center_application_arn", identity_center_application_arn)
        if identity_center_instance_arn is not None:
            pulumi.set(__self__, "identity_center_instance_arn", identity_center_instance_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Q Business application.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="attachmentsConfiguration")
    def attachments_configuration(self) -> Optional[pulumi.Input['ApplicationAttachmentsConfigurationArgs']]:
        """
        Information about whether file upload functionality is activated or deactivated for your end user. See `attachments_configuration` below.
        """
        return pulumi.get(self, "attachments_configuration")

    @attachments_configuration.setter
    def attachments_configuration(self, value: Optional[pulumi.Input['ApplicationAttachmentsConfigurationArgs']]):
        pulumi.set(self, "attachments_configuration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Amazon Q application.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Amazon Q application.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['ApplicationEncryptionConfigurationArgs']]:
        """
        Information about encryption configuration. See `encryption_configuration` below.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['ApplicationEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter(name="iamServiceRoleArn")
    def iam_service_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of an IAM role with permissions to access your Amazon CloudWatch logs and metrics.
        """
        return pulumi.get(self, "iam_service_role_arn")

    @iam_service_role_arn.setter
    def iam_service_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_service_role_arn", value)

    @property
    @pulumi.getter(name="identityCenterApplicationArn")
    def identity_center_application_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the AWS IAM Identity Center application attached to your Amazon Q Business application.
        """
        return pulumi.get(self, "identity_center_application_arn")

    @identity_center_application_arn.setter
    def identity_center_application_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identity_center_application_arn", value)

    @property
    @pulumi.getter(name="identityCenterInstanceArn")
    def identity_center_instance_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the IAM Identity Center instance you are either creating for — or connecting to — your Amazon Q Business application.

        The following arguments are optional:
        """
        return pulumi.get(self, "identity_center_instance_arn")

    @identity_center_instance_arn.setter
    def identity_center_instance_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identity_center_instance_arn", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ApplicationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ApplicationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:qbusiness/application:Application")
class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachments_configuration: Optional[pulumi.Input[Union['ApplicationAttachmentsConfigurationArgs', 'ApplicationAttachmentsConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['ApplicationEncryptionConfigurationArgs', 'ApplicationEncryptionConfigurationArgsDict']]] = None,
                 iam_service_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 identity_center_instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ApplicationTimeoutsArgs', 'ApplicationTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Q Business Application resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.qbusiness.Application("example",
            display_name="example-app",
            iam_service_role_arn=example_aws_iam_role["arn"],
            identity_center_instance_arn=example_aws_ssoadmin_instances["arns"][0],
            attachments_configuration={
                "attachments_control_mode": "ENABLED",
            })
        ```

        ## Import

        Using `pulumi import`, import a Q Business Application using the `id`. For example:

        ```sh
        $ pulumi import aws:qbusiness/application:Application example id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ApplicationAttachmentsConfigurationArgs', 'ApplicationAttachmentsConfigurationArgsDict']] attachments_configuration: Information about whether file upload functionality is activated or deactivated for your end user. See `attachments_configuration` below.
        :param pulumi.Input[builtins.str] description: Description of the Amazon Q application.
        :param pulumi.Input[builtins.str] display_name: Name of the Amazon Q application.
        :param pulumi.Input[Union['ApplicationEncryptionConfigurationArgs', 'ApplicationEncryptionConfigurationArgsDict']] encryption_configuration: Information about encryption configuration. See `encryption_configuration` below.
        :param pulumi.Input[builtins.str] iam_service_role_arn: ARN of an IAM role with permissions to access your Amazon CloudWatch logs and metrics.
        :param pulumi.Input[builtins.str] identity_center_instance_arn: ARN of the IAM Identity Center instance you are either creating for — or connecting to — your Amazon Q Business application.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Q Business Application resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.qbusiness.Application("example",
            display_name="example-app",
            iam_service_role_arn=example_aws_iam_role["arn"],
            identity_center_instance_arn=example_aws_ssoadmin_instances["arns"][0],
            attachments_configuration={
                "attachments_control_mode": "ENABLED",
            })
        ```

        ## Import

        Using `pulumi import`, import a Q Business Application using the `id`. For example:

        ```sh
        $ pulumi import aws:qbusiness/application:Application example id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachments_configuration: Optional[pulumi.Input[Union['ApplicationAttachmentsConfigurationArgs', 'ApplicationAttachmentsConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['ApplicationEncryptionConfigurationArgs', 'ApplicationEncryptionConfigurationArgsDict']]] = None,
                 iam_service_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 identity_center_instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ApplicationTimeoutsArgs', 'ApplicationTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            __props__.__dict__["attachments_configuration"] = attachments_configuration
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["encryption_configuration"] = encryption_configuration
            if iam_service_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'iam_service_role_arn'")
            __props__.__dict__["iam_service_role_arn"] = iam_service_role_arn
            if identity_center_instance_arn is None and not opts.urn:
                raise TypeError("Missing required property 'identity_center_instance_arn'")
            __props__.__dict__["identity_center_instance_arn"] = identity_center_instance_arn
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["identity_center_application_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Application, __self__).__init__(
            'aws:qbusiness/application:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            attachments_configuration: Optional[pulumi.Input[Union['ApplicationAttachmentsConfigurationArgs', 'ApplicationAttachmentsConfigurationArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            encryption_configuration: Optional[pulumi.Input[Union['ApplicationEncryptionConfigurationArgs', 'ApplicationEncryptionConfigurationArgsDict']]] = None,
            iam_service_role_arn: Optional[pulumi.Input[builtins.str]] = None,
            identity_center_application_arn: Optional[pulumi.Input[builtins.str]] = None,
            identity_center_instance_arn: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['ApplicationTimeoutsArgs', 'ApplicationTimeoutsArgsDict']]] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the Q Business application.
        :param pulumi.Input[Union['ApplicationAttachmentsConfigurationArgs', 'ApplicationAttachmentsConfigurationArgsDict']] attachments_configuration: Information about whether file upload functionality is activated or deactivated for your end user. See `attachments_configuration` below.
        :param pulumi.Input[builtins.str] description: Description of the Amazon Q application.
        :param pulumi.Input[builtins.str] display_name: Name of the Amazon Q application.
        :param pulumi.Input[Union['ApplicationEncryptionConfigurationArgs', 'ApplicationEncryptionConfigurationArgsDict']] encryption_configuration: Information about encryption configuration. See `encryption_configuration` below.
        :param pulumi.Input[builtins.str] iam_service_role_arn: ARN of an IAM role with permissions to access your Amazon CloudWatch logs and metrics.
        :param pulumi.Input[builtins.str] identity_center_application_arn: ARN of the AWS IAM Identity Center application attached to your Amazon Q Business application.
        :param pulumi.Input[builtins.str] identity_center_instance_arn: ARN of the IAM Identity Center instance you are either creating for — or connecting to — your Amazon Q Business application.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationState.__new__(_ApplicationState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["attachments_configuration"] = attachments_configuration
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["encryption_configuration"] = encryption_configuration
        __props__.__dict__["iam_service_role_arn"] = iam_service_role_arn
        __props__.__dict__["identity_center_application_arn"] = identity_center_application_arn
        __props__.__dict__["identity_center_instance_arn"] = identity_center_instance_arn
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return Application(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Q Business application.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="attachmentsConfiguration")
    def attachments_configuration(self) -> pulumi.Output[Optional['outputs.ApplicationAttachmentsConfiguration']]:
        """
        Information about whether file upload functionality is activated or deactivated for your end user. See `attachments_configuration` below.
        """
        return pulumi.get(self, "attachments_configuration")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the Amazon Q application.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Amazon Q application.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> pulumi.Output[Optional['outputs.ApplicationEncryptionConfiguration']]:
        """
        Information about encryption configuration. See `encryption_configuration` below.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="iamServiceRoleArn")
    def iam_service_role_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of an IAM role with permissions to access your Amazon CloudWatch logs and metrics.
        """
        return pulumi.get(self, "iam_service_role_arn")

    @property
    @pulumi.getter(name="identityCenterApplicationArn")
    def identity_center_application_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the AWS IAM Identity Center application attached to your Amazon Q Business application.
        """
        return pulumi.get(self, "identity_center_application_arn")

    @property
    @pulumi.getter(name="identityCenterInstanceArn")
    def identity_center_instance_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the IAM Identity Center instance you are either creating for — or connecting to — your Amazon Q Business application.

        The following arguments are optional:
        """
        return pulumi.get(self, "identity_center_instance_arn")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ApplicationTimeouts']]:
        return pulumi.get(self, "timeouts")

