# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountSettingsArgs', 'AccountSettings']

@pulumi.input_type
class AccountSettingsArgs:
    def __init__(__self__, *,
                 aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_namespace: Optional[pulumi.Input[builtins.str]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input['AccountSettingsTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AccountSettings resource.
        :param pulumi.Input[builtins.str] aws_account_id: The ID for the AWS account that contains the settings.
        :param pulumi.Input[builtins.str] default_namespace: The default namespace for this Amazon Web Services account. Currently, the default is `default`.
        :param pulumi.Input[builtins.bool] termination_protection_enabled: A boolean value that determines whether or not an Amazon QuickSight account can be deleted. If `true`, it does not allow the account to be deleted and results in an error message if a user tries to make a DeleteAccountSubscription request. If `false`, it will allow the account to be deleted.
        """
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if default_namespace is not None:
            pulumi.set(__self__, "default_namespace", default_namespace)
        if termination_protection_enabled is not None:
            pulumi.set(__self__, "termination_protection_enabled", termination_protection_enabled)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID for the AWS account that contains the settings.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @property
    @pulumi.getter(name="defaultNamespace")
    def default_namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default namespace for this Amazon Web Services account. Currently, the default is `default`.
        """
        return pulumi.get(self, "default_namespace")

    @default_namespace.setter
    def default_namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_namespace", value)

    @property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A boolean value that determines whether or not an Amazon QuickSight account can be deleted. If `true`, it does not allow the account to be deleted and results in an error message if a user tries to make a DeleteAccountSubscription request. If `false`, it will allow the account to be deleted.
        """
        return pulumi.get(self, "termination_protection_enabled")

    @termination_protection_enabled.setter
    def termination_protection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "termination_protection_enabled", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AccountSettingsTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AccountSettingsTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AccountSettingsState:
    def __init__(__self__, *,
                 aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_namespace: Optional[pulumi.Input[builtins.str]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input['AccountSettingsTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering AccountSettings resources.
        :param pulumi.Input[builtins.str] aws_account_id: The ID for the AWS account that contains the settings.
        :param pulumi.Input[builtins.str] default_namespace: The default namespace for this Amazon Web Services account. Currently, the default is `default`.
        :param pulumi.Input[builtins.bool] termination_protection_enabled: A boolean value that determines whether or not an Amazon QuickSight account can be deleted. If `true`, it does not allow the account to be deleted and results in an error message if a user tries to make a DeleteAccountSubscription request. If `false`, it will allow the account to be deleted.
        """
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if default_namespace is not None:
            pulumi.set(__self__, "default_namespace", default_namespace)
        if termination_protection_enabled is not None:
            pulumi.set(__self__, "termination_protection_enabled", termination_protection_enabled)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID for the AWS account that contains the settings.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @property
    @pulumi.getter(name="defaultNamespace")
    def default_namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default namespace for this Amazon Web Services account. Currently, the default is `default`.
        """
        return pulumi.get(self, "default_namespace")

    @default_namespace.setter
    def default_namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_namespace", value)

    @property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A boolean value that determines whether or not an Amazon QuickSight account can be deleted. If `true`, it does not allow the account to be deleted and results in an error message if a user tries to make a DeleteAccountSubscription request. If `false`, it will allow the account to be deleted.
        """
        return pulumi.get(self, "termination_protection_enabled")

    @termination_protection_enabled.setter
    def termination_protection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "termination_protection_enabled", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AccountSettingsTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AccountSettingsTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:quicksight/accountSettings:AccountSettings")
class AccountSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_namespace: Optional[pulumi.Input[builtins.str]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['AccountSettingsTimeoutsArgs', 'AccountSettingsTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS QuickSight Account Settings.

        > Deletion of this resource will not modify any settings, only remove the resource from state.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        subscription = aws.quicksight.AccountSubscription("subscription",
            account_name="quicksight-terraform",
            authentication_method="IAM_AND_QUICKSIGHT",
            edition="ENTERPRISE",
            notification_email="notification@email.com")
        example = aws.quicksight.AccountSettings("example", termination_protection_enabled=False,
        opts = pulumi.ResourceOptions(depends_on=[subscription]))
        ```

        ## Import

        Using `pulumi import`, import QuickSight Account Settings using the AWS account ID. For example:

        ```sh
        $ pulumi import aws:quicksight/accountSettings:AccountSettings example "012345678901"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] aws_account_id: The ID for the AWS account that contains the settings.
        :param pulumi.Input[builtins.str] default_namespace: The default namespace for this Amazon Web Services account. Currently, the default is `default`.
        :param pulumi.Input[builtins.bool] termination_protection_enabled: A boolean value that determines whether or not an Amazon QuickSight account can be deleted. If `true`, it does not allow the account to be deleted and results in an error message if a user tries to make a DeleteAccountSubscription request. If `false`, it will allow the account to be deleted.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AccountSettingsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS QuickSight Account Settings.

        > Deletion of this resource will not modify any settings, only remove the resource from state.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        subscription = aws.quicksight.AccountSubscription("subscription",
            account_name="quicksight-terraform",
            authentication_method="IAM_AND_QUICKSIGHT",
            edition="ENTERPRISE",
            notification_email="notification@email.com")
        example = aws.quicksight.AccountSettings("example", termination_protection_enabled=False,
        opts = pulumi.ResourceOptions(depends_on=[subscription]))
        ```

        ## Import

        Using `pulumi import`, import QuickSight Account Settings using the AWS account ID. For example:

        ```sh
        $ pulumi import aws:quicksight/accountSettings:AccountSettings example "012345678901"
        ```

        :param str resource_name: The name of the resource.
        :param AccountSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_namespace: Optional[pulumi.Input[builtins.str]] = None,
                 termination_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['AccountSettingsTimeoutsArgs', 'AccountSettingsTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountSettingsArgs.__new__(AccountSettingsArgs)

            __props__.__dict__["aws_account_id"] = aws_account_id
            __props__.__dict__["default_namespace"] = default_namespace
            __props__.__dict__["termination_protection_enabled"] = termination_protection_enabled
            __props__.__dict__["timeouts"] = timeouts
        super(AccountSettings, __self__).__init__(
            'aws:quicksight/accountSettings:AccountSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
            default_namespace: Optional[pulumi.Input[builtins.str]] = None,
            termination_protection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            timeouts: Optional[pulumi.Input[Union['AccountSettingsTimeoutsArgs', 'AccountSettingsTimeoutsArgsDict']]] = None) -> 'AccountSettings':
        """
        Get an existing AccountSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] aws_account_id: The ID for the AWS account that contains the settings.
        :param pulumi.Input[builtins.str] default_namespace: The default namespace for this Amazon Web Services account. Currently, the default is `default`.
        :param pulumi.Input[builtins.bool] termination_protection_enabled: A boolean value that determines whether or not an Amazon QuickSight account can be deleted. If `true`, it does not allow the account to be deleted and results in an error message if a user tries to make a DeleteAccountSubscription request. If `false`, it will allow the account to be deleted.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountSettingsState.__new__(_AccountSettingsState)

        __props__.__dict__["aws_account_id"] = aws_account_id
        __props__.__dict__["default_namespace"] = default_namespace
        __props__.__dict__["termination_protection_enabled"] = termination_protection_enabled
        __props__.__dict__["timeouts"] = timeouts
        return AccountSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID for the AWS account that contains the settings.
        """
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="defaultNamespace")
    def default_namespace(self) -> pulumi.Output[builtins.str]:
        """
        The default namespace for this Amazon Web Services account. Currently, the default is `default`.
        """
        return pulumi.get(self, "default_namespace")

    @property
    @pulumi.getter(name="terminationProtectionEnabled")
    def termination_protection_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        A boolean value that determines whether or not an Amazon QuickSight account can be deleted. If `true`, it does not allow the account to be deleted and results in an error message if a user tries to make a DeleteAccountSubscription request. If `false`, it will allow the account to be deleted.
        """
        return pulumi.get(self, "termination_protection_enabled")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AccountSettingsTimeouts']]:
        return pulumi.get(self, "timeouts")

