# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[builtins.str],
                 identity_type: pulumi.Input[builtins.str],
                 user_role: pulumi.Input[builtins.str],
                 aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 iam_arn: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 session_name: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[builtins.str] email: Email address of the user that you want to register.
        :param pulumi.Input[builtins.str] identity_type: Identity type that your Amazon QuickSight account uses to manage the identity of users. Valid values: `IAM`, `QUICKSIGHT`.
        :param pulumi.Input[builtins.str] user_role: Amazon QuickSight role for the user. Value values: `READER`, `AUTHOR`, `ADMIN`, `READER_PRO`, `AUTHOR_PRO`, `ADMIN_PRO`.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] aws_account_id: ID for the AWS account that the user is in. Use the ID for the AWS account that contains your Amazon QuickSight account.
        :param pulumi.Input[builtins.str] iam_arn: ARN of the IAM user or role that you are registering with Amazon QuickSight. Required only for users with an identity type of `IAM`.
        :param pulumi.Input[builtins.str] namespace: The Amazon Quicksight namespace to create the user in. Defaults to `default`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] session_name: Name of the IAM session to use when assuming roles that can embed QuickSight dashboards. Only valid for registering users using an assumed IAM role. Additionally, if registering multiple users using the same IAM role, each user needs to have a unique session name.
        :param pulumi.Input[builtins.str] user_name: Amazon QuickSight user name that you want to create for the user you are registering. Required only for users with an identity type of `QUICKSIGHT`.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "identity_type", identity_type)
        pulumi.set(__self__, "user_role", user_role)
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if iam_arn is not None:
            pulumi.set(__self__, "iam_arn", iam_arn)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if session_name is not None:
            pulumi.set(__self__, "session_name", session_name)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[builtins.str]:
        """
        Email address of the user that you want to register.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> pulumi.Input[builtins.str]:
        """
        Identity type that your Amazon QuickSight account uses to manage the identity of users. Valid values: `IAM`, `QUICKSIGHT`.
        """
        return pulumi.get(self, "identity_type")

    @identity_type.setter
    def identity_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identity_type", value)

    @property
    @pulumi.getter(name="userRole")
    def user_role(self) -> pulumi.Input[builtins.str]:
        """
        Amazon QuickSight role for the user. Value values: `READER`, `AUTHOR`, `ADMIN`, `READER_PRO`, `AUTHOR_PRO`, `ADMIN_PRO`.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_role")

    @user_role.setter
    def user_role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_role", value)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID for the AWS account that the user is in. Use the ID for the AWS account that contains your Amazon QuickSight account.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @property
    @pulumi.getter(name="iamArn")
    def iam_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the IAM user or role that you are registering with Amazon QuickSight. Required only for users with an identity type of `IAM`.
        """
        return pulumi.get(self, "iam_arn")

    @iam_arn.setter
    def iam_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_arn", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Quicksight namespace to create the user in. Defaults to `default`.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sessionName")
    def session_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the IAM session to use when assuming roles that can embed QuickSight dashboards. Only valid for registering users using an assumed IAM role. Additionally, if registering multiple users using the same IAM role, each user needs to have a unique session name.
        """
        return pulumi.get(self, "session_name")

    @session_name.setter
    def session_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_name", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon QuickSight user name that you want to create for the user you are registering. Required only for users with an identity type of `QUICKSIGHT`.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 iam_arn: Optional[pulumi.Input[builtins.str]] = None,
                 identity_type: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 session_name: Optional[pulumi.Input[builtins.str]] = None,
                 user_invitation_url: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 user_role: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) for the user.
        :param pulumi.Input[builtins.str] aws_account_id: ID for the AWS account that the user is in. Use the ID for the AWS account that contains your Amazon QuickSight account.
        :param pulumi.Input[builtins.str] email: Email address of the user that you want to register.
        :param pulumi.Input[builtins.str] iam_arn: ARN of the IAM user or role that you are registering with Amazon QuickSight. Required only for users with an identity type of `IAM`.
        :param pulumi.Input[builtins.str] identity_type: Identity type that your Amazon QuickSight account uses to manage the identity of users. Valid values: `IAM`, `QUICKSIGHT`.
        :param pulumi.Input[builtins.str] namespace: The Amazon Quicksight namespace to create the user in. Defaults to `default`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] session_name: Name of the IAM session to use when assuming roles that can embed QuickSight dashboards. Only valid for registering users using an assumed IAM role. Additionally, if registering multiple users using the same IAM role, each user needs to have a unique session name.
        :param pulumi.Input[builtins.str] user_invitation_url: URL the user visits to complete registration and provide a password. Returned only for users with an identity type of `QUICKSIGHT`.
        :param pulumi.Input[builtins.str] user_name: Amazon QuickSight user name that you want to create for the user you are registering. Required only for users with an identity type of `QUICKSIGHT`.
        :param pulumi.Input[builtins.str] user_role: Amazon QuickSight role for the user. Value values: `READER`, `AUTHOR`, `ADMIN`, `READER_PRO`, `AUTHOR_PRO`, `ADMIN_PRO`.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if iam_arn is not None:
            pulumi.set(__self__, "iam_arn", iam_arn)
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if session_name is not None:
            pulumi.set(__self__, "session_name", session_name)
        if user_invitation_url is not None:
            pulumi.set(__self__, "user_invitation_url", user_invitation_url)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if user_role is not None:
            pulumi.set(__self__, "user_role", user_role)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) for the user.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID for the AWS account that the user is in. Use the ID for the AWS account that contains your Amazon QuickSight account.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Email address of the user that you want to register.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="iamArn")
    def iam_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the IAM user or role that you are registering with Amazon QuickSight. Required only for users with an identity type of `IAM`.
        """
        return pulumi.get(self, "iam_arn")

    @iam_arn.setter
    def iam_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_arn", value)

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identity type that your Amazon QuickSight account uses to manage the identity of users. Valid values: `IAM`, `QUICKSIGHT`.
        """
        return pulumi.get(self, "identity_type")

    @identity_type.setter
    def identity_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identity_type", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Quicksight namespace to create the user in. Defaults to `default`.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sessionName")
    def session_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the IAM session to use when assuming roles that can embed QuickSight dashboards. Only valid for registering users using an assumed IAM role. Additionally, if registering multiple users using the same IAM role, each user needs to have a unique session name.
        """
        return pulumi.get(self, "session_name")

    @session_name.setter
    def session_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_name", value)

    @property
    @pulumi.getter(name="userInvitationUrl")
    def user_invitation_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL the user visits to complete registration and provide a password. Returned only for users with an identity type of `QUICKSIGHT`.
        """
        return pulumi.get(self, "user_invitation_url")

    @user_invitation_url.setter
    def user_invitation_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_invitation_url", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon QuickSight user name that you want to create for the user you are registering. Required only for users with an identity type of `QUICKSIGHT`.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="userRole")
    def user_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon QuickSight role for the user. Value values: `READER`, `AUTHOR`, `ADMIN`, `READER_PRO`, `AUTHOR_PRO`, `ADMIN_PRO`.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_role")

    @user_role.setter
    def user_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_role", value)


@pulumi.type_token("aws:quicksight/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 iam_arn: Optional[pulumi.Input[builtins.str]] = None,
                 identity_type: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 session_name: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 user_role: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing QuickSight User

        ## Example Usage

        ### Create User With IAM Identity Type Using an IAM Role

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.User("example",
            email="author1@example.com",
            identity_type="IAM",
            user_role="AUTHOR",
            iam_arn="arn:aws:iam::123456789012:role/AuthorRole",
            session_name="author1")
        ```

        ### Create User With IAM Identity Type Using an IAM User

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.User("example",
            email="authorpro1@example.com",
            identity_type="IAM",
            user_role="AUTHOR_PRO",
            iam_arn="arn:aws:iam::123456789012:user/authorpro1")
        ```

        ### Create User With QuickSight Identity Type in Non-Default Namespace

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.User("example",
            email="reader1@example.com",
            identity_type="QUICKSIGHT",
            user_role="READER",
            namespace="example",
            user_name="reader1")
        ```

        ## Import

        You cannot import this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] aws_account_id: ID for the AWS account that the user is in. Use the ID for the AWS account that contains your Amazon QuickSight account.
        :param pulumi.Input[builtins.str] email: Email address of the user that you want to register.
        :param pulumi.Input[builtins.str] iam_arn: ARN of the IAM user or role that you are registering with Amazon QuickSight. Required only for users with an identity type of `IAM`.
        :param pulumi.Input[builtins.str] identity_type: Identity type that your Amazon QuickSight account uses to manage the identity of users. Valid values: `IAM`, `QUICKSIGHT`.
        :param pulumi.Input[builtins.str] namespace: The Amazon Quicksight namespace to create the user in. Defaults to `default`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] session_name: Name of the IAM session to use when assuming roles that can embed QuickSight dashboards. Only valid for registering users using an assumed IAM role. Additionally, if registering multiple users using the same IAM role, each user needs to have a unique session name.
        :param pulumi.Input[builtins.str] user_name: Amazon QuickSight user name that you want to create for the user you are registering. Required only for users with an identity type of `QUICKSIGHT`.
        :param pulumi.Input[builtins.str] user_role: Amazon QuickSight role for the user. Value values: `READER`, `AUTHOR`, `ADMIN`, `READER_PRO`, `AUTHOR_PRO`, `ADMIN_PRO`.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing QuickSight User

        ## Example Usage

        ### Create User With IAM Identity Type Using an IAM Role

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.User("example",
            email="author1@example.com",
            identity_type="IAM",
            user_role="AUTHOR",
            iam_arn="arn:aws:iam::123456789012:role/AuthorRole",
            session_name="author1")
        ```

        ### Create User With IAM Identity Type Using an IAM User

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.User("example",
            email="authorpro1@example.com",
            identity_type="IAM",
            user_role="AUTHOR_PRO",
            iam_arn="arn:aws:iam::123456789012:user/authorpro1")
        ```

        ### Create User With QuickSight Identity Type in Non-Default Namespace

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.User("example",
            email="reader1@example.com",
            identity_type="QUICKSIGHT",
            user_role="READER",
            namespace="example",
            user_name="reader1")
        ```

        ## Import

        You cannot import this resource.

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 iam_arn: Optional[pulumi.Input[builtins.str]] = None,
                 identity_type: Optional[pulumi.Input[builtins.str]] = None,
                 namespace: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 session_name: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 user_role: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["aws_account_id"] = aws_account_id
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["iam_arn"] = iam_arn
            if identity_type is None and not opts.urn:
                raise TypeError("Missing required property 'identity_type'")
            __props__.__dict__["identity_type"] = identity_type
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["region"] = region
            __props__.__dict__["session_name"] = session_name
            __props__.__dict__["user_name"] = user_name
            if user_role is None and not opts.urn:
                raise TypeError("Missing required property 'user_role'")
            __props__.__dict__["user_role"] = user_role
            __props__.__dict__["arn"] = None
            __props__.__dict__["user_invitation_url"] = None
        super(User, __self__).__init__(
            'aws:quicksight/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            iam_arn: Optional[pulumi.Input[builtins.str]] = None,
            identity_type: Optional[pulumi.Input[builtins.str]] = None,
            namespace: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            session_name: Optional[pulumi.Input[builtins.str]] = None,
            user_invitation_url: Optional[pulumi.Input[builtins.str]] = None,
            user_name: Optional[pulumi.Input[builtins.str]] = None,
            user_role: Optional[pulumi.Input[builtins.str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: Amazon Resource Name (ARN) for the user.
        :param pulumi.Input[builtins.str] aws_account_id: ID for the AWS account that the user is in. Use the ID for the AWS account that contains your Amazon QuickSight account.
        :param pulumi.Input[builtins.str] email: Email address of the user that you want to register.
        :param pulumi.Input[builtins.str] iam_arn: ARN of the IAM user or role that you are registering with Amazon QuickSight. Required only for users with an identity type of `IAM`.
        :param pulumi.Input[builtins.str] identity_type: Identity type that your Amazon QuickSight account uses to manage the identity of users. Valid values: `IAM`, `QUICKSIGHT`.
        :param pulumi.Input[builtins.str] namespace: The Amazon Quicksight namespace to create the user in. Defaults to `default`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] session_name: Name of the IAM session to use when assuming roles that can embed QuickSight dashboards. Only valid for registering users using an assumed IAM role. Additionally, if registering multiple users using the same IAM role, each user needs to have a unique session name.
        :param pulumi.Input[builtins.str] user_invitation_url: URL the user visits to complete registration and provide a password. Returned only for users with an identity type of `QUICKSIGHT`.
        :param pulumi.Input[builtins.str] user_name: Amazon QuickSight user name that you want to create for the user you are registering. Required only for users with an identity type of `QUICKSIGHT`.
        :param pulumi.Input[builtins.str] user_role: Amazon QuickSight role for the user. Value values: `READER`, `AUTHOR`, `ADMIN`, `READER_PRO`, `AUTHOR_PRO`, `ADMIN_PRO`.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["aws_account_id"] = aws_account_id
        __props__.__dict__["email"] = email
        __props__.__dict__["iam_arn"] = iam_arn
        __props__.__dict__["identity_type"] = identity_type
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["region"] = region
        __props__.__dict__["session_name"] = session_name
        __props__.__dict__["user_invitation_url"] = user_invitation_url
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["user_role"] = user_role
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) for the user.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[builtins.str]:
        """
        ID for the AWS account that the user is in. Use the ID for the AWS account that contains your Amazon QuickSight account.
        """
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[builtins.str]:
        """
        Email address of the user that you want to register.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="iamArn")
    def iam_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ARN of the IAM user or role that you are registering with Amazon QuickSight. Required only for users with an identity type of `IAM`.
        """
        return pulumi.get(self, "iam_arn")

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> pulumi.Output[builtins.str]:
        """
        Identity type that your Amazon QuickSight account uses to manage the identity of users. Valid values: `IAM`, `QUICKSIGHT`.
        """
        return pulumi.get(self, "identity_type")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Quicksight namespace to create the user in. Defaults to `default`.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sessionName")
    def session_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of the IAM session to use when assuming roles that can embed QuickSight dashboards. Only valid for registering users using an assumed IAM role. Additionally, if registering multiple users using the same IAM role, each user needs to have a unique session name.
        """
        return pulumi.get(self, "session_name")

    @property
    @pulumi.getter(name="userInvitationUrl")
    def user_invitation_url(self) -> pulumi.Output[builtins.str]:
        """
        URL the user visits to complete registration and provide a password. Returned only for users with an identity type of `QUICKSIGHT`.
        """
        return pulumi.get(self, "user_invitation_url")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Amazon QuickSight user name that you want to create for the user you are registering. Required only for users with an identity type of `QUICKSIGHT`.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="userRole")
    def user_role(self) -> pulumi.Output[builtins.str]:
        """
        Amazon QuickSight role for the user. Value values: `READER`, `AUTHOR`, `ADMIN`, `READER_PRO`, `AUTHOR_PRO`, `ADMIN_PRO`.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_role")

