# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ClusterMasterUserSecretArgs',
    'ClusterMasterUserSecretArgsDict',
    'ClusterParameterGroupParameterArgs',
    'ClusterParameterGroupParameterArgsDict',
    'ClusterRestoreToPointInTimeArgs',
    'ClusterRestoreToPointInTimeArgsDict',
    'ClusterS3ImportArgs',
    'ClusterS3ImportArgsDict',
    'ClusterScalingConfigurationArgs',
    'ClusterScalingConfigurationArgsDict',
    'ClusterServerlessv2ScalingConfigurationArgs',
    'ClusterServerlessv2ScalingConfigurationArgsDict',
    'ClusterSnapshotCopyTimeoutsArgs',
    'ClusterSnapshotCopyTimeoutsArgsDict',
    'ExportTaskTimeoutsArgs',
    'ExportTaskTimeoutsArgsDict',
    'GlobalClusterGlobalClusterMemberArgs',
    'GlobalClusterGlobalClusterMemberArgsDict',
    'InstanceBlueGreenUpdateArgs',
    'InstanceBlueGreenUpdateArgsDict',
    'InstanceDesiredStateTimeoutsArgs',
    'InstanceDesiredStateTimeoutsArgsDict',
    'InstanceListenerEndpointArgs',
    'InstanceListenerEndpointArgsDict',
    'InstanceMasterUserSecretArgs',
    'InstanceMasterUserSecretArgsDict',
    'InstanceRestoreToPointInTimeArgs',
    'InstanceRestoreToPointInTimeArgsDict',
    'InstanceS3ImportArgs',
    'InstanceS3ImportArgsDict',
    'IntegrationTimeoutsArgs',
    'IntegrationTimeoutsArgsDict',
    'OptionGroupOptionArgs',
    'OptionGroupOptionArgsDict',
    'OptionGroupOptionOptionSettingArgs',
    'OptionGroupOptionOptionSettingArgsDict',
    'ParameterGroupParameterArgs',
    'ParameterGroupParameterArgsDict',
    'ProxyAuthArgs',
    'ProxyAuthArgsDict',
    'ProxyDefaultTargetGroupConnectionPoolConfigArgs',
    'ProxyDefaultTargetGroupConnectionPoolConfigArgsDict',
    'ReservedInstanceRecurringChargeArgs',
    'ReservedInstanceRecurringChargeArgsDict',
    'ShardGroupTimeoutsArgs',
    'ShardGroupTimeoutsArgsDict',
    'GetClustersFilterArgs',
    'GetClustersFilterArgsDict',
    'GetEngineVersionFilterArgs',
    'GetEngineVersionFilterArgsDict',
    'GetInstancesFilterArgs',
    'GetInstancesFilterArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterMasterUserSecretArgsDict(TypedDict):
        kms_key_id: NotRequired[pulumi.Input[builtins.str]]
        """
        ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        """
        secret_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        Amazon Resource Name (ARN) of the secret.
        """
        secret_status: NotRequired[pulumi.Input[builtins.str]]
        """
        Status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
elif False:
    ClusterMasterUserSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMasterUserSecretArgs:
    def __init__(__self__, *,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 secret_arn: Optional[pulumi.Input[builtins.str]] = None,
                 secret_status: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] kms_key_id: ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        :param pulumi.Input[builtins.str] secret_arn: Amazon Resource Name (ARN) of the secret.
        :param pulumi.Input[builtins.str] secret_status: Status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if secret_status is not None:
            pulumi.set(__self__, "secret_status", secret_status)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of the secret.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter(name="secretStatus")
    def secret_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
        return pulumi.get(self, "secret_status")

    @secret_status.setter
    def secret_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_status", value)


if not MYPY:
    class ClusterParameterGroupParameterArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the DB parameter.
        """
        value: pulumi.Input[builtins.str]
        """
        The value of the DB parameter.
        """
        apply_method: NotRequired[pulumi.Input[builtins.str]]
        """
        "immediate" (default), or "pending-reboot". Some
        engines can't apply some parameters without a reboot, and you will need to
        specify "pending-reboot" here.
        """
elif False:
    ClusterParameterGroupParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterParameterGroupParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str],
                 apply_method: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the DB parameter.
        :param pulumi.Input[builtins.str] value: The value of the DB parameter.
        :param pulumi.Input[builtins.str] apply_method: "immediate" (default), or "pending-reboot". Some
               engines can't apply some parameters without a reboot, and you will need to
               specify "pending-reboot" here.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if apply_method is not None:
            pulumi.set(__self__, "apply_method", apply_method)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the DB parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The value of the DB parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="applyMethod")
    def apply_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        "immediate" (default), or "pending-reboot". Some
        engines can't apply some parameters without a reboot, and you will need to
        specify "pending-reboot" here.
        """
        return pulumi.get(self, "apply_method")

    @apply_method.setter
    def apply_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "apply_method", value)


if not MYPY:
    class ClusterRestoreToPointInTimeArgsDict(TypedDict):
        restore_to_time: NotRequired[pulumi.Input[builtins.str]]
        """
        Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
        """
        restore_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Type of restore to be performed.
        Valid options are `full-copy` (default) and `copy-on-write`.
        """
        source_cluster_identifier: NotRequired[pulumi.Input[builtins.str]]
        """
        Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
        """
        source_cluster_resource_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Cluster resource ID of the source database cluster from which to restore. To be used for restoring a deleted cluster in the same account which still has a retained automatic backup available.
        """
        use_latest_restorable_time: NotRequired[pulumi.Input[builtins.bool]]
        """
        Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
        """
elif False:
    ClusterRestoreToPointInTimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterRestoreToPointInTimeArgs:
    def __init__(__self__, *,
                 restore_to_time: Optional[pulumi.Input[builtins.str]] = None,
                 restore_type: Optional[pulumi.Input[builtins.str]] = None,
                 source_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_cluster_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] restore_to_time: Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
        :param pulumi.Input[builtins.str] restore_type: Type of restore to be performed.
               Valid options are `full-copy` (default) and `copy-on-write`.
        :param pulumi.Input[builtins.str] source_cluster_identifier: Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
        :param pulumi.Input[builtins.str] source_cluster_resource_id: Cluster resource ID of the source database cluster from which to restore. To be used for restoring a deleted cluster in the same account which still has a retained automatic backup available.
        :param pulumi.Input[builtins.bool] use_latest_restorable_time: Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
        """
        if restore_to_time is not None:
            pulumi.set(__self__, "restore_to_time", restore_to_time)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if source_cluster_identifier is not None:
            pulumi.set(__self__, "source_cluster_identifier", source_cluster_identifier)
        if source_cluster_resource_id is not None:
            pulumi.set(__self__, "source_cluster_resource_id", source_cluster_resource_id)
        if use_latest_restorable_time is not None:
            pulumi.set(__self__, "use_latest_restorable_time", use_latest_restorable_time)

    @property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
        """
        return pulumi.get(self, "restore_to_time")

    @restore_to_time.setter
    def restore_to_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "restore_to_time", value)

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of restore to be performed.
        Valid options are `full-copy` (default) and `copy-on-write`.
        """
        return pulumi.get(self, "restore_type")

    @restore_type.setter
    def restore_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "restore_type", value)

    @property
    @pulumi.getter(name="sourceClusterIdentifier")
    def source_cluster_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
        """
        return pulumi.get(self, "source_cluster_identifier")

    @source_cluster_identifier.setter
    def source_cluster_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_cluster_identifier", value)

    @property
    @pulumi.getter(name="sourceClusterResourceId")
    def source_cluster_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Cluster resource ID of the source database cluster from which to restore. To be used for restoring a deleted cluster in the same account which still has a retained automatic backup available.
        """
        return pulumi.get(self, "source_cluster_resource_id")

    @source_cluster_resource_id.setter
    def source_cluster_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_cluster_resource_id", value)

    @property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
        """
        return pulumi.get(self, "use_latest_restorable_time")

    @use_latest_restorable_time.setter
    def use_latest_restorable_time(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_latest_restorable_time", value)


if not MYPY:
    class ClusterS3ImportArgsDict(TypedDict):
        bucket_name: pulumi.Input[builtins.str]
        """
        Bucket name where your backup is stored
        """
        ingestion_role: pulumi.Input[builtins.str]
        """
        Role applied to load the data.
        """
        source_engine: pulumi.Input[builtins.str]
        """
        Source engine for the backup
        """
        source_engine_version: pulumi.Input[builtins.str]
        """
        Version of the source engine used to make the backup

        This will not recreate the resource if the S3 object changes in some way. It's only used to initialize the database. This only works currently with the aurora engine. See AWS for currently supported engines and options. See [Aurora S3 Migration Docs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3).
        """
        bucket_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        Can be blank, but is the path to your backup
        """
elif False:
    ClusterS3ImportArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterS3ImportArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[builtins.str],
                 ingestion_role: pulumi.Input[builtins.str],
                 source_engine: pulumi.Input[builtins.str],
                 source_engine_version: pulumi.Input[builtins.str],
                 bucket_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket_name: Bucket name where your backup is stored
        :param pulumi.Input[builtins.str] ingestion_role: Role applied to load the data.
        :param pulumi.Input[builtins.str] source_engine: Source engine for the backup
        :param pulumi.Input[builtins.str] source_engine_version: Version of the source engine used to make the backup
               
               This will not recreate the resource if the S3 object changes in some way. It's only used to initialize the database. This only works currently with the aurora engine. See AWS for currently supported engines and options. See [Aurora S3 Migration Docs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3).
        :param pulumi.Input[builtins.str] bucket_prefix: Can be blank, but is the path to your backup
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "ingestion_role", ingestion_role)
        pulumi.set(__self__, "source_engine", source_engine)
        pulumi.set(__self__, "source_engine_version", source_engine_version)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[builtins.str]:
        """
        Bucket name where your backup is stored
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="ingestionRole")
    def ingestion_role(self) -> pulumi.Input[builtins.str]:
        """
        Role applied to load the data.
        """
        return pulumi.get(self, "ingestion_role")

    @ingestion_role.setter
    def ingestion_role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ingestion_role", value)

    @property
    @pulumi.getter(name="sourceEngine")
    def source_engine(self) -> pulumi.Input[builtins.str]:
        """
        Source engine for the backup
        """
        return pulumi.get(self, "source_engine")

    @source_engine.setter
    def source_engine(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_engine", value)

    @property
    @pulumi.getter(name="sourceEngineVersion")
    def source_engine_version(self) -> pulumi.Input[builtins.str]:
        """
        Version of the source engine used to make the backup

        This will not recreate the resource if the S3 object changes in some way. It's only used to initialize the database. This only works currently with the aurora engine. See AWS for currently supported engines and options. See [Aurora S3 Migration Docs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3).
        """
        return pulumi.get(self, "source_engine_version")

    @source_engine_version.setter
    def source_engine_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_engine_version", value)

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Can be blank, but is the path to your backup
        """
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket_prefix", value)


if not MYPY:
    class ClusterScalingConfigurationArgsDict(TypedDict):
        auto_pause: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to enable automatic pause. A DB cluster can be paused only when it's idle (it has no connections). If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. Defaults to `true`.
        """
        max_capacity: NotRequired[pulumi.Input[builtins.int]]
        """
        Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
        """
        min_capacity: NotRequired[pulumi.Input[builtins.int]]
        """
        Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
        """
        seconds_before_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        Amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. Valid values are `60` through `600`. Defaults to `300`.
        """
        seconds_until_auto_pause: NotRequired[pulumi.Input[builtins.int]]
        """
        Time, in seconds, before an Aurora DB cluster in serverless mode is paused. Valid values are `300` through `86400`. Defaults to `300`.
        """
        timeout_action: NotRequired[pulumi.Input[builtins.str]]
        """
        Action to take when the timeout is reached. Valid values: `ForceApplyCapacityChange`, `RollbackCapacityChange`. Defaults to `RollbackCapacityChange`. See [documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v1.how-it-works.html#aurora-serverless.how-it-works.timeout-action).
        """
elif False:
    ClusterScalingConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterScalingConfigurationArgs:
    def __init__(__self__, *,
                 auto_pause: Optional[pulumi.Input[builtins.bool]] = None,
                 max_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 min_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 seconds_before_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 seconds_until_auto_pause: Optional[pulumi.Input[builtins.int]] = None,
                 timeout_action: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] auto_pause: Whether to enable automatic pause. A DB cluster can be paused only when it's idle (it has no connections). If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. Defaults to `true`.
        :param pulumi.Input[builtins.int] max_capacity: Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
        :param pulumi.Input[builtins.int] min_capacity: Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
        :param pulumi.Input[builtins.int] seconds_before_timeout: Amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. Valid values are `60` through `600`. Defaults to `300`.
        :param pulumi.Input[builtins.int] seconds_until_auto_pause: Time, in seconds, before an Aurora DB cluster in serverless mode is paused. Valid values are `300` through `86400`. Defaults to `300`.
        :param pulumi.Input[builtins.str] timeout_action: Action to take when the timeout is reached. Valid values: `ForceApplyCapacityChange`, `RollbackCapacityChange`. Defaults to `RollbackCapacityChange`. See [documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v1.how-it-works.html#aurora-serverless.how-it-works.timeout-action).
        """
        if auto_pause is not None:
            pulumi.set(__self__, "auto_pause", auto_pause)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if seconds_before_timeout is not None:
            pulumi.set(__self__, "seconds_before_timeout", seconds_before_timeout)
        if seconds_until_auto_pause is not None:
            pulumi.set(__self__, "seconds_until_auto_pause", seconds_until_auto_pause)
        if timeout_action is not None:
            pulumi.set(__self__, "timeout_action", timeout_action)

    @property
    @pulumi.getter(name="autoPause")
    def auto_pause(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable automatic pause. A DB cluster can be paused only when it's idle (it has no connections). If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. Defaults to `true`.
        """
        return pulumi.get(self, "auto_pause")

    @auto_pause.setter
    def auto_pause(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_pause", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_capacity", value)

    @property
    @pulumi.getter(name="secondsBeforeTimeout")
    def seconds_before_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. Valid values are `60` through `600`. Defaults to `300`.
        """
        return pulumi.get(self, "seconds_before_timeout")

    @seconds_before_timeout.setter
    def seconds_before_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "seconds_before_timeout", value)

    @property
    @pulumi.getter(name="secondsUntilAutoPause")
    def seconds_until_auto_pause(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time, in seconds, before an Aurora DB cluster in serverless mode is paused. Valid values are `300` through `86400`. Defaults to `300`.
        """
        return pulumi.get(self, "seconds_until_auto_pause")

    @seconds_until_auto_pause.setter
    def seconds_until_auto_pause(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "seconds_until_auto_pause", value)

    @property
    @pulumi.getter(name="timeoutAction")
    def timeout_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Action to take when the timeout is reached. Valid values: `ForceApplyCapacityChange`, `RollbackCapacityChange`. Defaults to `RollbackCapacityChange`. See [documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v1.how-it-works.html#aurora-serverless.how-it-works.timeout-action).
        """
        return pulumi.get(self, "timeout_action")

    @timeout_action.setter
    def timeout_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout_action", value)


if not MYPY:
    class ClusterServerlessv2ScalingConfigurationArgsDict(TypedDict):
        max_capacity: pulumi.Input[builtins.float]
        """
        Maximum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid capacity values are in a range of `0` up to `256` in steps of `0.5`.
        """
        min_capacity: pulumi.Input[builtins.float]
        """
        Minimum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid capacity values are in a range of `0` up to `256` in steps of `0.5`.
        """
        seconds_until_auto_pause: NotRequired[pulumi.Input[builtins.int]]
        """
        Time, in seconds, before an Aurora DB cluster in `provisioned` DB engine mode is paused. Valid values are `300` through `86400`.
        """
elif False:
    ClusterServerlessv2ScalingConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterServerlessv2ScalingConfigurationArgs:
    def __init__(__self__, *,
                 max_capacity: pulumi.Input[builtins.float],
                 min_capacity: pulumi.Input[builtins.float],
                 seconds_until_auto_pause: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.float] max_capacity: Maximum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid capacity values are in a range of `0` up to `256` in steps of `0.5`.
        :param pulumi.Input[builtins.float] min_capacity: Minimum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid capacity values are in a range of `0` up to `256` in steps of `0.5`.
        :param pulumi.Input[builtins.int] seconds_until_auto_pause: Time, in seconds, before an Aurora DB cluster in `provisioned` DB engine mode is paused. Valid values are `300` through `86400`.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        if seconds_until_auto_pause is not None:
            pulumi.set(__self__, "seconds_until_auto_pause", seconds_until_auto_pause)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Input[builtins.float]:
        """
        Maximum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid capacity values are in a range of `0` up to `256` in steps of `0.5`.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> pulumi.Input[builtins.float]:
        """
        Minimum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid capacity values are in a range of `0` up to `256` in steps of `0.5`.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "min_capacity", value)

    @property
    @pulumi.getter(name="secondsUntilAutoPause")
    def seconds_until_auto_pause(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time, in seconds, before an Aurora DB cluster in `provisioned` DB engine mode is paused. Valid values are `300` through `86400`.
        """
        return pulumi.get(self, "seconds_until_auto_pause")

    @seconds_until_auto_pause.setter
    def seconds_until_auto_pause(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "seconds_until_auto_pause", value)


if not MYPY:
    class ClusterSnapshotCopyTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
elif False:
    ClusterSnapshotCopyTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterSnapshotCopyTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create", value)


if not MYPY:
    class ExportTaskTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        delete: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
elif False:
    ExportTaskTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExportTaskTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[builtins.str]] = None,
                 delete: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[builtins.str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete", value)


if not MYPY:
    class GlobalClusterGlobalClusterMemberArgsDict(TypedDict):
        db_cluster_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        Amazon Resource Name (ARN) of member DB Cluster.
        """
        is_writer: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the member is the primary DB Cluster.
        """
elif False:
    GlobalClusterGlobalClusterMemberArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GlobalClusterGlobalClusterMemberArgs:
    def __init__(__self__, *,
                 db_cluster_arn: Optional[pulumi.Input[builtins.str]] = None,
                 is_writer: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] db_cluster_arn: Amazon Resource Name (ARN) of member DB Cluster.
        :param pulumi.Input[builtins.bool] is_writer: Whether the member is the primary DB Cluster.
        """
        if db_cluster_arn is not None:
            pulumi.set(__self__, "db_cluster_arn", db_cluster_arn)
        if is_writer is not None:
            pulumi.set(__self__, "is_writer", is_writer)

    @property
    @pulumi.getter(name="dbClusterArn")
    def db_cluster_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of member DB Cluster.
        """
        return pulumi.get(self, "db_cluster_arn")

    @db_cluster_arn.setter
    def db_cluster_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_cluster_arn", value)

    @property
    @pulumi.getter(name="isWriter")
    def is_writer(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the member is the primary DB Cluster.
        """
        return pulumi.get(self, "is_writer")

    @is_writer.setter
    def is_writer(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_writer", value)


if not MYPY:
    class InstanceBlueGreenUpdateArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Enables low-downtime updates when `true`.
        Default is `false`.

        [instance-replication]:
        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Replication.html
        [instance-maintenance]:
        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html
        [blue-green]:
        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html
        """
elif False:
    InstanceBlueGreenUpdateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceBlueGreenUpdateArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Enables low-downtime updates when `true`.
               Default is `false`.
               
               [instance-replication]:
               https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Replication.html
               [instance-maintenance]:
               https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html
               [blue-green]:
               https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables low-downtime updates when `true`.
        Default is `false`.

        [instance-replication]:
        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Replication.html
        [instance-maintenance]:
        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html
        [blue-green]:
        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class InstanceDesiredStateTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        update: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
elif False:
    InstanceDesiredStateTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceDesiredStateTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[builtins.str]] = None,
                 update: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[builtins.str] update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update", value)


if not MYPY:
    class InstanceListenerEndpointArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the DNS address of the DB instance.
        """
        hosted_zone_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port on which the DB accepts connections.
        """
elif False:
    InstanceListenerEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceListenerEndpointArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 hosted_zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] address: Specifies the DNS address of the DB instance.
        :param pulumi.Input[builtins.str] hosted_zone_id: Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
        :param pulumi.Input[builtins.int] port: The port on which the DB accepts connections.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the DNS address of the DB instance.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")

    @hosted_zone_id.setter
    def hosted_zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hosted_zone_id", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port on which the DB accepts connections.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class InstanceMasterUserSecretArgsDict(TypedDict):
        kms_key_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN for the KMS encryption key. If creating an
        encrypted replica, set this to the destination KMS ARN.
        """
        secret_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the secret.
        """
        secret_status: NotRequired[pulumi.Input[builtins.str]]
        """
        The status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
elif False:
    InstanceMasterUserSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceMasterUserSecretArgs:
    def __init__(__self__, *,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 secret_arn: Optional[pulumi.Input[builtins.str]] = None,
                 secret_status: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] kms_key_id: The ARN for the KMS encryption key. If creating an
               encrypted replica, set this to the destination KMS ARN.
        :param pulumi.Input[builtins.str] secret_arn: The Amazon Resource Name (ARN) of the secret.
        :param pulumi.Input[builtins.str] secret_status: The status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if secret_status is not None:
            pulumi.set(__self__, "secret_status", secret_status)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN for the KMS encryption key. If creating an
        encrypted replica, set this to the destination KMS ARN.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the secret.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter(name="secretStatus")
    def secret_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
        return pulumi.get(self, "secret_status")

    @secret_status.setter
    def secret_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_status", value)


if not MYPY:
    class InstanceRestoreToPointInTimeArgsDict(TypedDict):
        restore_time: NotRequired[pulumi.Input[builtins.str]]
        """
        The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
        """
        source_db_instance_automated_backups_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the automated backup from which to restore. Required if `source_db_instance_identifier` or `source_dbi_resource_id` is not specified.
        """
        source_db_instance_identifier: NotRequired[pulumi.Input[builtins.str]]
        """
        The identifier of the source DB instance from which to restore. Must match the identifier of an existing DB instance. Required if `source_db_instance_automated_backups_arn` or `source_dbi_resource_id` is not specified.
        """
        source_dbi_resource_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource ID of the source DB instance from which to restore. Required if `source_db_instance_identifier` or `source_db_instance_automated_backups_arn` is not specified.
        """
        use_latest_restorable_time: NotRequired[pulumi.Input[builtins.bool]]
        """
        A boolean value that indicates whether the DB instance is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_time`.
        """
elif False:
    InstanceRestoreToPointInTimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceRestoreToPointInTimeArgs:
    def __init__(__self__, *,
                 restore_time: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_instance_automated_backups_arn: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_instance_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_dbi_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] restore_time: The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
        :param pulumi.Input[builtins.str] source_db_instance_automated_backups_arn: The ARN of the automated backup from which to restore. Required if `source_db_instance_identifier` or `source_dbi_resource_id` is not specified.
        :param pulumi.Input[builtins.str] source_db_instance_identifier: The identifier of the source DB instance from which to restore. Must match the identifier of an existing DB instance. Required if `source_db_instance_automated_backups_arn` or `source_dbi_resource_id` is not specified.
        :param pulumi.Input[builtins.str] source_dbi_resource_id: The resource ID of the source DB instance from which to restore. Required if `source_db_instance_identifier` or `source_db_instance_automated_backups_arn` is not specified.
        :param pulumi.Input[builtins.bool] use_latest_restorable_time: A boolean value that indicates whether the DB instance is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_time`.
        """
        if restore_time is not None:
            pulumi.set(__self__, "restore_time", restore_time)
        if source_db_instance_automated_backups_arn is not None:
            pulumi.set(__self__, "source_db_instance_automated_backups_arn", source_db_instance_automated_backups_arn)
        if source_db_instance_identifier is not None:
            pulumi.set(__self__, "source_db_instance_identifier", source_db_instance_identifier)
        if source_dbi_resource_id is not None:
            pulumi.set(__self__, "source_dbi_resource_id", source_dbi_resource_id)
        if use_latest_restorable_time is not None:
            pulumi.set(__self__, "use_latest_restorable_time", use_latest_restorable_time)

    @property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
        """
        return pulumi.get(self, "restore_time")

    @restore_time.setter
    def restore_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "restore_time", value)

    @property
    @pulumi.getter(name="sourceDbInstanceAutomatedBackupsArn")
    def source_db_instance_automated_backups_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the automated backup from which to restore. Required if `source_db_instance_identifier` or `source_dbi_resource_id` is not specified.
        """
        return pulumi.get(self, "source_db_instance_automated_backups_arn")

    @source_db_instance_automated_backups_arn.setter
    def source_db_instance_automated_backups_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_db_instance_automated_backups_arn", value)

    @property
    @pulumi.getter(name="sourceDbInstanceIdentifier")
    def source_db_instance_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the source DB instance from which to restore. Must match the identifier of an existing DB instance. Required if `source_db_instance_automated_backups_arn` or `source_dbi_resource_id` is not specified.
        """
        return pulumi.get(self, "source_db_instance_identifier")

    @source_db_instance_identifier.setter
    def source_db_instance_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_db_instance_identifier", value)

    @property
    @pulumi.getter(name="sourceDbiResourceId")
    def source_dbi_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID of the source DB instance from which to restore. Required if `source_db_instance_identifier` or `source_db_instance_automated_backups_arn` is not specified.
        """
        return pulumi.get(self, "source_dbi_resource_id")

    @source_dbi_resource_id.setter
    def source_dbi_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_dbi_resource_id", value)

    @property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A boolean value that indicates whether the DB instance is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_time`.
        """
        return pulumi.get(self, "use_latest_restorable_time")

    @use_latest_restorable_time.setter
    def use_latest_restorable_time(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_latest_restorable_time", value)


if not MYPY:
    class InstanceS3ImportArgsDict(TypedDict):
        bucket_name: pulumi.Input[builtins.str]
        """
        The bucket name where your backup is stored
        """
        ingestion_role: pulumi.Input[builtins.str]
        """
        Role applied to load the data.
        """
        source_engine: pulumi.Input[builtins.str]
        """
        Source engine for the backup
        """
        source_engine_version: pulumi.Input[builtins.str]
        """
        Version of the source engine used to make the backup

        This will not recreate the resource if the S3 object changes in some way.  It's only used to initialize the database.
        """
        bucket_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        Can be blank, but is the path to your backup
        """
elif False:
    InstanceS3ImportArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceS3ImportArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[builtins.str],
                 ingestion_role: pulumi.Input[builtins.str],
                 source_engine: pulumi.Input[builtins.str],
                 source_engine_version: pulumi.Input[builtins.str],
                 bucket_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket_name: The bucket name where your backup is stored
        :param pulumi.Input[builtins.str] ingestion_role: Role applied to load the data.
        :param pulumi.Input[builtins.str] source_engine: Source engine for the backup
        :param pulumi.Input[builtins.str] source_engine_version: Version of the source engine used to make the backup
               
               This will not recreate the resource if the S3 object changes in some way.  It's only used to initialize the database.
        :param pulumi.Input[builtins.str] bucket_prefix: Can be blank, but is the path to your backup
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "ingestion_role", ingestion_role)
        pulumi.set(__self__, "source_engine", source_engine)
        pulumi.set(__self__, "source_engine_version", source_engine_version)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[builtins.str]:
        """
        The bucket name where your backup is stored
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="ingestionRole")
    def ingestion_role(self) -> pulumi.Input[builtins.str]:
        """
        Role applied to load the data.
        """
        return pulumi.get(self, "ingestion_role")

    @ingestion_role.setter
    def ingestion_role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ingestion_role", value)

    @property
    @pulumi.getter(name="sourceEngine")
    def source_engine(self) -> pulumi.Input[builtins.str]:
        """
        Source engine for the backup
        """
        return pulumi.get(self, "source_engine")

    @source_engine.setter
    def source_engine(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_engine", value)

    @property
    @pulumi.getter(name="sourceEngineVersion")
    def source_engine_version(self) -> pulumi.Input[builtins.str]:
        """
        Version of the source engine used to make the backup

        This will not recreate the resource if the S3 object changes in some way.  It's only used to initialize the database.
        """
        return pulumi.get(self, "source_engine_version")

    @source_engine_version.setter
    def source_engine_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_engine_version", value)

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Can be blank, but is the path to your backup
        """
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket_prefix", value)


if not MYPY:
    class IntegrationTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        delete: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
elif False:
    IntegrationTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IntegrationTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[builtins.str]] = None,
                 delete: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[builtins.str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete", value)


if not MYPY:
    class OptionGroupOptionArgsDict(TypedDict):
        option_name: pulumi.Input[builtins.str]
        """
        Name of the option (e.g., MEMCACHED).
        """
        db_security_group_memberships: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of DB Security Groups for which the option is enabled.
        """
        option_settings: NotRequired[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionOptionSettingArgsDict']]]]
        """
        The option settings to apply. See `option_settings` Block below for more details.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        Port number when connecting to the option (e.g., 11211). Leaving out or removing `port` from your configuration does not remove or clear a port from the option in AWS. AWS may assign a default port. Not including `port` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any port changes.
        """
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        Version of the option (e.g., 13.1.0.0). Leaving out or removing `version` from your configuration does not remove or clear a version from the option in AWS. AWS may assign a default version. Not including `version` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any version changes.
        """
        vpc_security_group_memberships: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of VPC Security Groups for which the option is enabled.
        """
elif False:
    OptionGroupOptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OptionGroupOptionArgs:
    def __init__(__self__, *,
                 option_name: pulumi.Input[builtins.str],
                 db_security_group_memberships: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 option_settings: Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionOptionSettingArgs']]]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_security_group_memberships: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] option_name: Name of the option (e.g., MEMCACHED).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] db_security_group_memberships: List of DB Security Groups for which the option is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionOptionSettingArgs']]] option_settings: The option settings to apply. See `option_settings` Block below for more details.
        :param pulumi.Input[builtins.int] port: Port number when connecting to the option (e.g., 11211). Leaving out or removing `port` from your configuration does not remove or clear a port from the option in AWS. AWS may assign a default port. Not including `port` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any port changes.
        :param pulumi.Input[builtins.str] version: Version of the option (e.g., 13.1.0.0). Leaving out or removing `version` from your configuration does not remove or clear a version from the option in AWS. AWS may assign a default version. Not including `version` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any version changes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_security_group_memberships: List of VPC Security Groups for which the option is enabled.
        """
        pulumi.set(__self__, "option_name", option_name)
        if db_security_group_memberships is not None:
            pulumi.set(__self__, "db_security_group_memberships", db_security_group_memberships)
        if option_settings is not None:
            pulumi.set(__self__, "option_settings", option_settings)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_security_group_memberships is not None:
            pulumi.set(__self__, "vpc_security_group_memberships", vpc_security_group_memberships)

    @property
    @pulumi.getter(name="optionName")
    def option_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the option (e.g., MEMCACHED).
        """
        return pulumi.get(self, "option_name")

    @option_name.setter
    def option_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "option_name", value)

    @property
    @pulumi.getter(name="dbSecurityGroupMemberships")
    def db_security_group_memberships(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of DB Security Groups for which the option is enabled.
        """
        return pulumi.get(self, "db_security_group_memberships")

    @db_security_group_memberships.setter
    def db_security_group_memberships(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "db_security_group_memberships", value)

    @property
    @pulumi.getter(name="optionSettings")
    def option_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionOptionSettingArgs']]]]:
        """
        The option settings to apply. See `option_settings` Block below for more details.
        """
        return pulumi.get(self, "option_settings")

    @option_settings.setter
    def option_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionOptionSettingArgs']]]]):
        pulumi.set(self, "option_settings", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port number when connecting to the option (e.g., 11211). Leaving out or removing `port` from your configuration does not remove or clear a port from the option in AWS. AWS may assign a default port. Not including `port` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any port changes.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Version of the option (e.g., 13.1.0.0). Leaving out or removing `version` from your configuration does not remove or clear a version from the option in AWS. AWS may assign a default version. Not including `version` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any version changes.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupMemberships")
    def vpc_security_group_memberships(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of VPC Security Groups for which the option is enabled.
        """
        return pulumi.get(self, "vpc_security_group_memberships")

    @vpc_security_group_memberships.setter
    def vpc_security_group_memberships(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vpc_security_group_memberships", value)


if not MYPY:
    class OptionGroupOptionOptionSettingArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Name of the setting.
        """
        value: pulumi.Input[builtins.str]
        """
        Value of the setting.
        """
elif False:
    OptionGroupOptionOptionSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OptionGroupOptionOptionSettingArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: Name of the setting.
        :param pulumi.Input[builtins.str] value: Value of the setting.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the setting.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Value of the setting.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ParameterGroupParameterArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the DB parameter.
        """
        value: pulumi.Input[builtins.str]
        """
        The value of the DB parameter.
        """
        apply_method: NotRequired[pulumi.Input[builtins.str]]
        """
        "immediate" (default), or "pending-reboot". Some
        engines can't apply some parameters without a reboot, and you will need to
        specify "pending-reboot" here.
        """
elif False:
    ParameterGroupParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ParameterGroupParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str],
                 apply_method: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the DB parameter.
        :param pulumi.Input[builtins.str] value: The value of the DB parameter.
        :param pulumi.Input[builtins.str] apply_method: "immediate" (default), or "pending-reboot". Some
               engines can't apply some parameters without a reboot, and you will need to
               specify "pending-reboot" here.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if apply_method is None:
            apply_method = 'immediate'
        if apply_method is not None:
            pulumi.set(__self__, "apply_method", apply_method)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the DB parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The value of the DB parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="applyMethod")
    def apply_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        "immediate" (default), or "pending-reboot". Some
        engines can't apply some parameters without a reboot, and you will need to
        specify "pending-reboot" here.
        """
        return pulumi.get(self, "apply_method")

    @apply_method.setter
    def apply_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "apply_method", value)


if not MYPY:
    class ProxyAuthArgsDict(TypedDict):
        auth_scheme: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of authentication that the proxy uses for connections from the proxy to the underlying database. One of `SECRETS`.
        """
        client_password_auth_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of authentication the proxy uses for connections from clients. Valid values are `MYSQL_CACHING_SHA2_PASSWORD`, `MYSQL_NATIVE_PASSWORD`, `POSTGRES_SCRAM_SHA_256`, `POSTGRES_MD5`, and `SQL_SERVER_AUTHENTICATION`.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        A user-specified description about the authentication used by a proxy to log in as a specific database user.
        """
        iam_auth: NotRequired[pulumi.Input[builtins.str]]
        """
        Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy. One of `DISABLED`, `REQUIRED`.
        """
        secret_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
        """
        username: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the database user to which the proxy connects.
        """
elif False:
    ProxyAuthArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProxyAuthArgs:
    def __init__(__self__, *,
                 auth_scheme: Optional[pulumi.Input[builtins.str]] = None,
                 client_password_auth_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 iam_auth: Optional[pulumi.Input[builtins.str]] = None,
                 secret_arn: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] auth_scheme: The type of authentication that the proxy uses for connections from the proxy to the underlying database. One of `SECRETS`.
        :param pulumi.Input[builtins.str] client_password_auth_type: The type of authentication the proxy uses for connections from clients. Valid values are `MYSQL_CACHING_SHA2_PASSWORD`, `MYSQL_NATIVE_PASSWORD`, `POSTGRES_SCRAM_SHA_256`, `POSTGRES_MD5`, and `SQL_SERVER_AUTHENTICATION`.
        :param pulumi.Input[builtins.str] description: A user-specified description about the authentication used by a proxy to log in as a specific database user.
        :param pulumi.Input[builtins.str] iam_auth: Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy. One of `DISABLED`, `REQUIRED`.
        :param pulumi.Input[builtins.str] secret_arn: The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
        :param pulumi.Input[builtins.str] username: The name of the database user to which the proxy connects.
        """
        if auth_scheme is not None:
            pulumi.set(__self__, "auth_scheme", auth_scheme)
        if client_password_auth_type is not None:
            pulumi.set(__self__, "client_password_auth_type", client_password_auth_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if iam_auth is not None:
            pulumi.set(__self__, "iam_auth", iam_auth)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authScheme")
    def auth_scheme(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of authentication that the proxy uses for connections from the proxy to the underlying database. One of `SECRETS`.
        """
        return pulumi.get(self, "auth_scheme")

    @auth_scheme.setter
    def auth_scheme(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auth_scheme", value)

    @property
    @pulumi.getter(name="clientPasswordAuthType")
    def client_password_auth_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of authentication the proxy uses for connections from clients. Valid values are `MYSQL_CACHING_SHA2_PASSWORD`, `MYSQL_NATIVE_PASSWORD`, `POSTGRES_SCRAM_SHA_256`, `POSTGRES_MD5`, and `SQL_SERVER_AUTHENTICATION`.
        """
        return pulumi.get(self, "client_password_auth_type")

    @client_password_auth_type.setter
    def client_password_auth_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_password_auth_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-specified description about the authentication used by a proxy to log in as a specific database user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="iamAuth")
    def iam_auth(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy. One of `DISABLED`, `REQUIRED`.
        """
        return pulumi.get(self, "iam_auth")

    @iam_auth.setter
    def iam_auth(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_auth", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the database user to which the proxy connects.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ProxyDefaultTargetGroupConnectionPoolConfigArgsDict(TypedDict):
        connection_borrow_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
        """
        init_query: NotRequired[pulumi.Input[builtins.str]]
        """
        One or more SQL statements for the proxy to run when opening each new database connection. Typically used with `SET` statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single `SET` statement, such as `SET x=1, y=2`.
        """
        max_connections_percent: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum size of the connection pool for each target in a target group. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
        """
        max_idle_connections_percent: NotRequired[pulumi.Input[builtins.int]]
        """
        Controls how actively the proxy closes idle database connections in the connection pool. A high value enables the proxy to leave a high percentage of idle connections open. A low value causes the proxy to close idle client connections and return the underlying database connections to the connection pool. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
        """
        session_pinning_filters: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. This setting is only supported for MySQL engine family databases. Currently, the only allowed value is `EXCLUDE_VARIABLE_SETS`.
        """
elif False:
    ProxyDefaultTargetGroupConnectionPoolConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProxyDefaultTargetGroupConnectionPoolConfigArgs:
    def __init__(__self__, *,
                 connection_borrow_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 init_query: Optional[pulumi.Input[builtins.str]] = None,
                 max_connections_percent: Optional[pulumi.Input[builtins.int]] = None,
                 max_idle_connections_percent: Optional[pulumi.Input[builtins.int]] = None,
                 session_pinning_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.int] connection_borrow_timeout: The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
        :param pulumi.Input[builtins.str] init_query: One or more SQL statements for the proxy to run when opening each new database connection. Typically used with `SET` statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single `SET` statement, such as `SET x=1, y=2`.
        :param pulumi.Input[builtins.int] max_connections_percent: The maximum size of the connection pool for each target in a target group. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
        :param pulumi.Input[builtins.int] max_idle_connections_percent: Controls how actively the proxy closes idle database connections in the connection pool. A high value enables the proxy to leave a high percentage of idle connections open. A low value causes the proxy to close idle client connections and return the underlying database connections to the connection pool. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] session_pinning_filters: Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. This setting is only supported for MySQL engine family databases. Currently, the only allowed value is `EXCLUDE_VARIABLE_SETS`.
        """
        if connection_borrow_timeout is not None:
            pulumi.set(__self__, "connection_borrow_timeout", connection_borrow_timeout)
        if init_query is not None:
            pulumi.set(__self__, "init_query", init_query)
        if max_connections_percent is not None:
            pulumi.set(__self__, "max_connections_percent", max_connections_percent)
        if max_idle_connections_percent is not None:
            pulumi.set(__self__, "max_idle_connections_percent", max_idle_connections_percent)
        if session_pinning_filters is not None:
            pulumi.set(__self__, "session_pinning_filters", session_pinning_filters)

    @property
    @pulumi.getter(name="connectionBorrowTimeout")
    def connection_borrow_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
        """
        return pulumi.get(self, "connection_borrow_timeout")

    @connection_borrow_timeout.setter
    def connection_borrow_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "connection_borrow_timeout", value)

    @property
    @pulumi.getter(name="initQuery")
    def init_query(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        One or more SQL statements for the proxy to run when opening each new database connection. Typically used with `SET` statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single `SET` statement, such as `SET x=1, y=2`.
        """
        return pulumi.get(self, "init_query")

    @init_query.setter
    def init_query(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "init_query", value)

    @property
    @pulumi.getter(name="maxConnectionsPercent")
    def max_connections_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum size of the connection pool for each target in a target group. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
        """
        return pulumi.get(self, "max_connections_percent")

    @max_connections_percent.setter
    def max_connections_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_connections_percent", value)

    @property
    @pulumi.getter(name="maxIdleConnectionsPercent")
    def max_idle_connections_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Controls how actively the proxy closes idle database connections in the connection pool. A high value enables the proxy to leave a high percentage of idle connections open. A low value causes the proxy to close idle client connections and return the underlying database connections to the connection pool. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
        """
        return pulumi.get(self, "max_idle_connections_percent")

    @max_idle_connections_percent.setter
    def max_idle_connections_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_idle_connections_percent", value)

    @property
    @pulumi.getter(name="sessionPinningFilters")
    def session_pinning_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. This setting is only supported for MySQL engine family databases. Currently, the only allowed value is `EXCLUDE_VARIABLE_SETS`.
        """
        return pulumi.get(self, "session_pinning_filters")

    @session_pinning_filters.setter
    def session_pinning_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "session_pinning_filters", value)


if not MYPY:
    class ReservedInstanceRecurringChargeArgsDict(TypedDict):
        recurring_charge_amount: NotRequired[pulumi.Input[builtins.int]]
        recurring_charge_frequency: NotRequired[pulumi.Input[builtins.str]]
elif False:
    ReservedInstanceRecurringChargeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReservedInstanceRecurringChargeArgs:
    def __init__(__self__, *,
                 recurring_charge_amount: Optional[pulumi.Input[builtins.int]] = None,
                 recurring_charge_frequency: Optional[pulumi.Input[builtins.str]] = None):
        if recurring_charge_amount is not None:
            pulumi.set(__self__, "recurring_charge_amount", recurring_charge_amount)
        if recurring_charge_frequency is not None:
            pulumi.set(__self__, "recurring_charge_frequency", recurring_charge_frequency)

    @property
    @pulumi.getter(name="recurringChargeAmount")
    def recurring_charge_amount(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "recurring_charge_amount")

    @recurring_charge_amount.setter
    def recurring_charge_amount(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "recurring_charge_amount", value)

    @property
    @pulumi.getter(name="recurringChargeFrequency")
    def recurring_charge_frequency(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "recurring_charge_frequency")

    @recurring_charge_frequency.setter
    def recurring_charge_frequency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recurring_charge_frequency", value)


if not MYPY:
    class ShardGroupTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        delete: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        update: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
elif False:
    ShardGroupTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ShardGroupTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[builtins.str]] = None,
                 delete: Optional[pulumi.Input[builtins.str]] = None,
                 update: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[builtins.str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param pulumi.Input[builtins.str] update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update", value)


if not MYPY:
    class GetClustersFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html).
        """
        values: Sequence[builtins.str]
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
elif False:
    GetClustersFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetClustersFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str name: Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html).
        :param Sequence[builtins.str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetEngineVersionFilterArgsDict(TypedDict):
        name: builtins.str
        values: Sequence[builtins.str]
elif False:
    GetEngineVersionFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetEngineVersionFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str]):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)


if not MYPY:
    class GetInstancesFilterArgsDict(TypedDict):
        name: builtins.str
        """
        Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html) or [RDS DescribeDBInstances API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html).
        """
        values: Sequence[builtins.str]
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
elif False:
    GetInstancesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetInstancesFilterArgs:
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str name: Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html) or [RDS DescribeDBInstances API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html).
        :param Sequence[builtins.str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html) or [RDS DescribeDBInstances API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: builtins.str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[builtins.str]):
        pulumi.set(self, "values", value)


