# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterSnapshotCopyArgs', 'ClusterSnapshotCopy']

@pulumi.input_type
class ClusterSnapshotCopyArgs:
    def __init__(__self__, *,
                 source_db_cluster_snapshot_identifier: pulumi.Input[builtins.str],
                 target_db_cluster_snapshot_identifier: pulumi.Input[builtins.str],
                 copy_tags: Optional[pulumi.Input[builtins.bool]] = None,
                 destination_region: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 presigned_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 shared_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ClusterSnapshotCopyTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a ClusterSnapshotCopy resource.
        :param pulumi.Input[builtins.str] source_db_cluster_snapshot_identifier: Identifier of the source snapshot.
        :param pulumi.Input[builtins.str] target_db_cluster_snapshot_identifier: Identifier for the snapshot.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.bool] copy_tags: Whether to copy existing tags. Defaults to `false`.
        :param pulumi.Input[builtins.str] destination_region: The Destination region to place snapshot copy.
        :param pulumi.Input[builtins.str] kms_key_id: KMS key ID.
        :param pulumi.Input[builtins.str] presigned_url: URL that contains a Signature Version 4 signed request.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] shared_accounts: List of AWS Account IDs to share the snapshot with. Use `all` to make the snapshot public.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "source_db_cluster_snapshot_identifier", source_db_cluster_snapshot_identifier)
        pulumi.set(__self__, "target_db_cluster_snapshot_identifier", target_db_cluster_snapshot_identifier)
        if copy_tags is not None:
            pulumi.set(__self__, "copy_tags", copy_tags)
        if destination_region is not None:
            pulumi.set(__self__, "destination_region", destination_region)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if presigned_url is not None:
            pulumi.set(__self__, "presigned_url", presigned_url)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if shared_accounts is not None:
            pulumi.set(__self__, "shared_accounts", shared_accounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="sourceDbClusterSnapshotIdentifier")
    def source_db_cluster_snapshot_identifier(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of the source snapshot.
        """
        return pulumi.get(self, "source_db_cluster_snapshot_identifier")

    @source_db_cluster_snapshot_identifier.setter
    def source_db_cluster_snapshot_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_db_cluster_snapshot_identifier", value)

    @property
    @pulumi.getter(name="targetDbClusterSnapshotIdentifier")
    def target_db_cluster_snapshot_identifier(self) -> pulumi.Input[builtins.str]:
        """
        Identifier for the snapshot.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_db_cluster_snapshot_identifier")

    @target_db_cluster_snapshot_identifier.setter
    def target_db_cluster_snapshot_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_db_cluster_snapshot_identifier", value)

    @property
    @pulumi.getter(name="copyTags")
    def copy_tags(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to copy existing tags. Defaults to `false`.
        """
        return pulumi.get(self, "copy_tags")

    @copy_tags.setter
    def copy_tags(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "copy_tags", value)

    @property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Destination region to place snapshot copy.
        """
        return pulumi.get(self, "destination_region")

    @destination_region.setter
    def destination_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_region", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        KMS key ID.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="presignedUrl")
    def presigned_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL that contains a Signature Version 4 signed request.
        """
        return pulumi.get(self, "presigned_url")

    @presigned_url.setter
    def presigned_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "presigned_url", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sharedAccounts")
    def shared_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of AWS Account IDs to share the snapshot with. Use `all` to make the snapshot public.
        """
        return pulumi.get(self, "shared_accounts")

    @shared_accounts.setter
    def shared_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "shared_accounts", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ClusterSnapshotCopyTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ClusterSnapshotCopyTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ClusterSnapshotCopyState:
    def __init__(__self__, *,
                 allocated_storage: Optional[pulumi.Input[builtins.int]] = None,
                 copy_tags: Optional[pulumi.Input[builtins.bool]] = None,
                 db_cluster_snapshot_arn: Optional[pulumi.Input[builtins.str]] = None,
                 destination_region: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 license_model: Optional[pulumi.Input[builtins.str]] = None,
                 presigned_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 shared_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 snapshot_type: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 storage_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['ClusterSnapshotCopyTimeoutsArgs']] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClusterSnapshotCopy resources.
        :param pulumi.Input[builtins.int] allocated_storage: Specifies the allocated storage size in gigabytes (GB).
        :param pulumi.Input[builtins.bool] copy_tags: Whether to copy existing tags. Defaults to `false`.
        :param pulumi.Input[builtins.str] db_cluster_snapshot_arn: The Amazon Resource Name (ARN) for the DB cluster snapshot.
        :param pulumi.Input[builtins.str] destination_region: The Destination region to place snapshot copy.
        :param pulumi.Input[builtins.str] engine: Specifies the name of the database engine.
        :param pulumi.Input[builtins.str] engine_version: Specifies the version of the database engine.
        :param pulumi.Input[builtins.str] kms_key_id: KMS key ID.
        :param pulumi.Input[builtins.str] license_model: License model information for the restored DB instance.
        :param pulumi.Input[builtins.str] presigned_url: URL that contains a Signature Version 4 signed request.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] shared_accounts: List of AWS Account IDs to share the snapshot with. Use `all` to make the snapshot public.
        :param pulumi.Input[builtins.str] source_db_cluster_snapshot_identifier: Identifier of the source snapshot.
        :param pulumi.Input[builtins.bool] storage_encrypted: Specifies whether the DB cluster snapshot is encrypted.
        :param pulumi.Input[builtins.str] storage_type: Specifies the storage type associated with DB cluster snapshot.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] target_db_cluster_snapshot_identifier: Identifier for the snapshot.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] vpc_id: Provides the VPC ID associated with the DB cluster snapshot.
        """
        if allocated_storage is not None:
            pulumi.set(__self__, "allocated_storage", allocated_storage)
        if copy_tags is not None:
            pulumi.set(__self__, "copy_tags", copy_tags)
        if db_cluster_snapshot_arn is not None:
            pulumi.set(__self__, "db_cluster_snapshot_arn", db_cluster_snapshot_arn)
        if destination_region is not None:
            pulumi.set(__self__, "destination_region", destination_region)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if presigned_url is not None:
            pulumi.set(__self__, "presigned_url", presigned_url)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if shared_accounts is not None:
            pulumi.set(__self__, "shared_accounts", shared_accounts)
        if snapshot_type is not None:
            pulumi.set(__self__, "snapshot_type", snapshot_type)
        if source_db_cluster_snapshot_identifier is not None:
            pulumi.set(__self__, "source_db_cluster_snapshot_identifier", source_db_cluster_snapshot_identifier)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if target_db_cluster_snapshot_identifier is not None:
            pulumi.set(__self__, "target_db_cluster_snapshot_identifier", target_db_cluster_snapshot_identifier)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the allocated storage size in gigabytes (GB).
        """
        return pulumi.get(self, "allocated_storage")

    @allocated_storage.setter
    def allocated_storage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "allocated_storage", value)

    @property
    @pulumi.getter(name="copyTags")
    def copy_tags(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to copy existing tags. Defaults to `false`.
        """
        return pulumi.get(self, "copy_tags")

    @copy_tags.setter
    def copy_tags(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "copy_tags", value)

    @property
    @pulumi.getter(name="dbClusterSnapshotArn")
    def db_cluster_snapshot_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the DB cluster snapshot.
        """
        return pulumi.get(self, "db_cluster_snapshot_arn")

    @db_cluster_snapshot_arn.setter
    def db_cluster_snapshot_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_cluster_snapshot_arn", value)

    @property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Destination region to place snapshot copy.
        """
        return pulumi.get(self, "destination_region")

    @destination_region.setter
    def destination_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_region", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the database engine.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the version of the database engine.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        KMS key ID.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        License model information for the restored DB instance.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="presignedUrl")
    def presigned_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL that contains a Signature Version 4 signed request.
        """
        return pulumi.get(self, "presigned_url")

    @presigned_url.setter
    def presigned_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "presigned_url", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sharedAccounts")
    def shared_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of AWS Account IDs to share the snapshot with. Use `all` to make the snapshot public.
        """
        return pulumi.get(self, "shared_accounts")

    @shared_accounts.setter
    def shared_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "shared_accounts", value)

    @property
    @pulumi.getter(name="snapshotType")
    def snapshot_type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "snapshot_type")

    @snapshot_type.setter
    def snapshot_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_type", value)

    @property
    @pulumi.getter(name="sourceDbClusterSnapshotIdentifier")
    def source_db_cluster_snapshot_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the source snapshot.
        """
        return pulumi.get(self, "source_db_cluster_snapshot_identifier")

    @source_db_cluster_snapshot_identifier.setter
    def source_db_cluster_snapshot_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_db_cluster_snapshot_identifier", value)

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the DB cluster snapshot is encrypted.
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the storage type associated with DB cluster snapshot.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="targetDbClusterSnapshotIdentifier")
    def target_db_cluster_snapshot_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier for the snapshot.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_db_cluster_snapshot_identifier")

    @target_db_cluster_snapshot_identifier.setter
    def target_db_cluster_snapshot_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_db_cluster_snapshot_identifier", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ClusterSnapshotCopyTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ClusterSnapshotCopyTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provides the VPC ID associated with the DB cluster snapshot.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("aws:rds/clusterSnapshotCopy:ClusterSnapshotCopy")
class ClusterSnapshotCopy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy_tags: Optional[pulumi.Input[builtins.bool]] = None,
                 destination_region: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 presigned_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 shared_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ClusterSnapshotCopyTimeoutsArgs', 'ClusterSnapshotCopyTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Manages an RDS database cluster snapshot copy. For managing RDS database instance snapshot copies, see the `rds.SnapshotCopy` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.Cluster("example",
            cluster_identifier="aurora-cluster-demo",
            database_name="test",
            engine=aws.rds.EngineType.AURORA_MYSQL,
            master_username="tfacctest",
            master_password="avoid-plaintext-passwords",
            skip_final_snapshot=True)
        example_cluster_snapshot = aws.rds.ClusterSnapshot("example",
            db_cluster_identifier=example.cluster_identifier,
            db_cluster_snapshot_identifier="example")
        example_cluster_snapshot_copy = aws.rds.ClusterSnapshotCopy("example",
            source_db_cluster_snapshot_identifier=example_cluster_snapshot.db_cluster_snapshot_arn,
            target_db_cluster_snapshot_identifier="example-copy")
        ```

        ## Import

        Using `pulumi import`, import `aws_rds_cluster_snapshot_copy` using the `id`. For example:

        ```sh
        $ pulumi import aws:rds/clusterSnapshotCopy:ClusterSnapshotCopy example my-snapshot
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] copy_tags: Whether to copy existing tags. Defaults to `false`.
        :param pulumi.Input[builtins.str] destination_region: The Destination region to place snapshot copy.
        :param pulumi.Input[builtins.str] kms_key_id: KMS key ID.
        :param pulumi.Input[builtins.str] presigned_url: URL that contains a Signature Version 4 signed request.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] shared_accounts: List of AWS Account IDs to share the snapshot with. Use `all` to make the snapshot public.
        :param pulumi.Input[builtins.str] source_db_cluster_snapshot_identifier: Identifier of the source snapshot.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] target_db_cluster_snapshot_identifier: Identifier for the snapshot.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterSnapshotCopyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an RDS database cluster snapshot copy. For managing RDS database instance snapshot copies, see the `rds.SnapshotCopy` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.Cluster("example",
            cluster_identifier="aurora-cluster-demo",
            database_name="test",
            engine=aws.rds.EngineType.AURORA_MYSQL,
            master_username="tfacctest",
            master_password="avoid-plaintext-passwords",
            skip_final_snapshot=True)
        example_cluster_snapshot = aws.rds.ClusterSnapshot("example",
            db_cluster_identifier=example.cluster_identifier,
            db_cluster_snapshot_identifier="example")
        example_cluster_snapshot_copy = aws.rds.ClusterSnapshotCopy("example",
            source_db_cluster_snapshot_identifier=example_cluster_snapshot.db_cluster_snapshot_arn,
            target_db_cluster_snapshot_identifier="example-copy")
        ```

        ## Import

        Using `pulumi import`, import `aws_rds_cluster_snapshot_copy` using the `id`. For example:

        ```sh
        $ pulumi import aws:rds/clusterSnapshotCopy:ClusterSnapshotCopy example my-snapshot
        ```

        :param str resource_name: The name of the resource.
        :param ClusterSnapshotCopyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterSnapshotCopyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copy_tags: Optional[pulumi.Input[builtins.bool]] = None,
                 destination_region: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 presigned_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 shared_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ClusterSnapshotCopyTimeoutsArgs', 'ClusterSnapshotCopyTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterSnapshotCopyArgs.__new__(ClusterSnapshotCopyArgs)

            __props__.__dict__["copy_tags"] = copy_tags
            __props__.__dict__["destination_region"] = destination_region
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["presigned_url"] = presigned_url
            __props__.__dict__["region"] = region
            __props__.__dict__["shared_accounts"] = shared_accounts
            if source_db_cluster_snapshot_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'source_db_cluster_snapshot_identifier'")
            __props__.__dict__["source_db_cluster_snapshot_identifier"] = source_db_cluster_snapshot_identifier
            __props__.__dict__["tags"] = tags
            if target_db_cluster_snapshot_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'target_db_cluster_snapshot_identifier'")
            __props__.__dict__["target_db_cluster_snapshot_identifier"] = target_db_cluster_snapshot_identifier
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["allocated_storage"] = None
            __props__.__dict__["db_cluster_snapshot_arn"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["engine_version"] = None
            __props__.__dict__["license_model"] = None
            __props__.__dict__["snapshot_type"] = None
            __props__.__dict__["storage_encrypted"] = None
            __props__.__dict__["storage_type"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["vpc_id"] = None
        super(ClusterSnapshotCopy, __self__).__init__(
            'aws:rds/clusterSnapshotCopy:ClusterSnapshotCopy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocated_storage: Optional[pulumi.Input[builtins.int]] = None,
            copy_tags: Optional[pulumi.Input[builtins.bool]] = None,
            db_cluster_snapshot_arn: Optional[pulumi.Input[builtins.str]] = None,
            destination_region: Optional[pulumi.Input[builtins.str]] = None,
            engine: Optional[pulumi.Input[builtins.str]] = None,
            engine_version: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            license_model: Optional[pulumi.Input[builtins.str]] = None,
            presigned_url: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            shared_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            snapshot_type: Optional[pulumi.Input[builtins.str]] = None,
            source_db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
            storage_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
            storage_type: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target_db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['ClusterSnapshotCopyTimeoutsArgs', 'ClusterSnapshotCopyTimeoutsArgsDict']]] = None,
            vpc_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ClusterSnapshotCopy':
        """
        Get an existing ClusterSnapshotCopy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] allocated_storage: Specifies the allocated storage size in gigabytes (GB).
        :param pulumi.Input[builtins.bool] copy_tags: Whether to copy existing tags. Defaults to `false`.
        :param pulumi.Input[builtins.str] db_cluster_snapshot_arn: The Amazon Resource Name (ARN) for the DB cluster snapshot.
        :param pulumi.Input[builtins.str] destination_region: The Destination region to place snapshot copy.
        :param pulumi.Input[builtins.str] engine: Specifies the name of the database engine.
        :param pulumi.Input[builtins.str] engine_version: Specifies the version of the database engine.
        :param pulumi.Input[builtins.str] kms_key_id: KMS key ID.
        :param pulumi.Input[builtins.str] license_model: License model information for the restored DB instance.
        :param pulumi.Input[builtins.str] presigned_url: URL that contains a Signature Version 4 signed request.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] shared_accounts: List of AWS Account IDs to share the snapshot with. Use `all` to make the snapshot public.
        :param pulumi.Input[builtins.str] source_db_cluster_snapshot_identifier: Identifier of the source snapshot.
        :param pulumi.Input[builtins.bool] storage_encrypted: Specifies whether the DB cluster snapshot is encrypted.
        :param pulumi.Input[builtins.str] storage_type: Specifies the storage type associated with DB cluster snapshot.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] target_db_cluster_snapshot_identifier: Identifier for the snapshot.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] vpc_id: Provides the VPC ID associated with the DB cluster snapshot.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterSnapshotCopyState.__new__(_ClusterSnapshotCopyState)

        __props__.__dict__["allocated_storage"] = allocated_storage
        __props__.__dict__["copy_tags"] = copy_tags
        __props__.__dict__["db_cluster_snapshot_arn"] = db_cluster_snapshot_arn
        __props__.__dict__["destination_region"] = destination_region
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["presigned_url"] = presigned_url
        __props__.__dict__["region"] = region
        __props__.__dict__["shared_accounts"] = shared_accounts
        __props__.__dict__["snapshot_type"] = snapshot_type
        __props__.__dict__["source_db_cluster_snapshot_identifier"] = source_db_cluster_snapshot_identifier
        __props__.__dict__["storage_encrypted"] = storage_encrypted
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["target_db_cluster_snapshot_identifier"] = target_db_cluster_snapshot_identifier
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["vpc_id"] = vpc_id
        return ClusterSnapshotCopy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the allocated storage size in gigabytes (GB).
        """
        return pulumi.get(self, "allocated_storage")

    @property
    @pulumi.getter(name="copyTags")
    def copy_tags(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to copy existing tags. Defaults to `false`.
        """
        return pulumi.get(self, "copy_tags")

    @property
    @pulumi.getter(name="dbClusterSnapshotArn")
    def db_cluster_snapshot_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the DB cluster snapshot.
        """
        return pulumi.get(self, "db_cluster_snapshot_arn")

    @property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Destination region to place snapshot copy.
        """
        return pulumi.get(self, "destination_region")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the database engine.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the version of the database engine.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        KMS key ID.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[builtins.str]:
        """
        License model information for the restored DB instance.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="presignedUrl")
    def presigned_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL that contains a Signature Version 4 signed request.
        """
        return pulumi.get(self, "presigned_url")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sharedAccounts")
    def shared_accounts(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of AWS Account IDs to share the snapshot with. Use `all` to make the snapshot public.
        """
        return pulumi.get(self, "shared_accounts")

    @property
    @pulumi.getter(name="snapshotType")
    def snapshot_type(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "snapshot_type")

    @property
    @pulumi.getter(name="sourceDbClusterSnapshotIdentifier")
    def source_db_cluster_snapshot_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of the source snapshot.
        """
        return pulumi.get(self, "source_db_cluster_snapshot_identifier")

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether the DB cluster snapshot is encrypted.
        """
        return pulumi.get(self, "storage_encrypted")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the storage type associated with DB cluster snapshot.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="targetDbClusterSnapshotIdentifier")
    def target_db_cluster_snapshot_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Identifier for the snapshot.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_db_cluster_snapshot_identifier")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ClusterSnapshotCopyTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[builtins.str]:
        """
        Provides the VPC ID associated with the DB cluster snapshot.
        """
        return pulumi.get(self, "vpc_id")

