# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExportTaskArgs', 'ExportTask']

@pulumi.input_type
class ExportTaskArgs:
    def __init__(__self__, *,
                 export_task_identifier: pulumi.Input[builtins.str],
                 iam_role_arn: pulumi.Input[builtins.str],
                 kms_key_id: pulumi.Input[builtins.str],
                 s3_bucket_name: pulumi.Input[builtins.str],
                 source_arn: pulumi.Input[builtins.str],
                 export_onlies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['ExportTaskTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a ExportTask resource.
        :param pulumi.Input[builtins.str] export_task_identifier: Unique identifier for the snapshot export task.
        :param pulumi.Input[builtins.str] iam_role_arn: ARN of the IAM role to use for writing to the Amazon S3 bucket.
        :param pulumi.Input[builtins.str] kms_key_id: ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
        :param pulumi.Input[builtins.str] s3_bucket_name: Name of the Amazon S3 bucket to export the snapshot to.
        :param pulumi.Input[builtins.str] source_arn: Amazon Resource Name (ARN) of the snapshot to export.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] export_onlies: Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] s3_prefix: Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
        """
        pulumi.set(__self__, "export_task_identifier", export_task_identifier)
        pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        pulumi.set(__self__, "source_arn", source_arn)
        if export_onlies is not None:
            pulumi.set(__self__, "export_onlies", export_onlies)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_prefix is not None:
            pulumi.set(__self__, "s3_prefix", s3_prefix)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="exportTaskIdentifier")
    def export_task_identifier(self) -> pulumi.Input[builtins.str]:
        """
        Unique identifier for the snapshot export task.
        """
        return pulumi.get(self, "export_task_identifier")

    @export_task_identifier.setter
    def export_task_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "export_task_identifier", value)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the IAM role to use for writing to the Amazon S3 bucket.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "iam_role_arn", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Amazon S3 bucket to export the snapshot to.
        """
        return pulumi.get(self, "s3_bucket_name")

    @s3_bucket_name.setter
    def s3_bucket_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "s3_bucket_name", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> pulumi.Input[builtins.str]:
        """
        Amazon Resource Name (ARN) of the snapshot to export.

        The following arguments are optional:
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_arn", value)

    @property
    @pulumi.getter(name="exportOnlies")
    def export_onlies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
        """
        return pulumi.get(self, "export_onlies")

    @export_onlies.setter
    def export_onlies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "export_onlies", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="s3Prefix")
    def s3_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
        """
        return pulumi.get(self, "s3_prefix")

    @s3_prefix.setter
    def s3_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_prefix", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ExportTaskTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ExportTaskTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ExportTaskState:
    def __init__(__self__, *,
                 export_onlies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 export_task_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 failure_cause: Optional[pulumi.Input[builtins.str]] = None,
                 iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 percent_progress: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 s3_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_time: Optional[pulumi.Input[builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[builtins.str]] = None,
                 source_type: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 task_end_time: Optional[pulumi.Input[builtins.str]] = None,
                 task_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['ExportTaskTimeoutsArgs']] = None,
                 warning_message: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExportTask resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] export_onlies: Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
        :param pulumi.Input[builtins.str] export_task_identifier: Unique identifier for the snapshot export task.
        :param pulumi.Input[builtins.str] failure_cause: Reason the export failed, if it failed.
        :param pulumi.Input[builtins.str] iam_role_arn: ARN of the IAM role to use for writing to the Amazon S3 bucket.
        :param pulumi.Input[builtins.str] kms_key_id: ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
        :param pulumi.Input[builtins.int] percent_progress: Progress of the snapshot export task as a percentage.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] s3_bucket_name: Name of the Amazon S3 bucket to export the snapshot to.
        :param pulumi.Input[builtins.str] s3_prefix: Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
        :param pulumi.Input[builtins.str] snapshot_time: Time that the snapshot was created.
        :param pulumi.Input[builtins.str] source_arn: Amazon Resource Name (ARN) of the snapshot to export.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] source_type: Type of source for the export.
        :param pulumi.Input[builtins.str] status: Status of the export task.
        :param pulumi.Input[builtins.str] task_end_time: Time that the snapshot export task completed.
        :param pulumi.Input[builtins.str] task_start_time: Time that the snapshot export task started.
        :param pulumi.Input[builtins.str] warning_message: Warning about the snapshot export task, if any.
        """
        if export_onlies is not None:
            pulumi.set(__self__, "export_onlies", export_onlies)
        if export_task_identifier is not None:
            pulumi.set(__self__, "export_task_identifier", export_task_identifier)
        if failure_cause is not None:
            pulumi.set(__self__, "failure_cause", failure_cause)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if percent_progress is not None:
            pulumi.set(__self__, "percent_progress", percent_progress)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_prefix is not None:
            pulumi.set(__self__, "s3_prefix", s3_prefix)
        if snapshot_time is not None:
            pulumi.set(__self__, "snapshot_time", snapshot_time)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if task_end_time is not None:
            pulumi.set(__self__, "task_end_time", task_end_time)
        if task_start_time is not None:
            pulumi.set(__self__, "task_start_time", task_start_time)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if warning_message is not None:
            pulumi.set(__self__, "warning_message", warning_message)

    @property
    @pulumi.getter(name="exportOnlies")
    def export_onlies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
        """
        return pulumi.get(self, "export_onlies")

    @export_onlies.setter
    def export_onlies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "export_onlies", value)

    @property
    @pulumi.getter(name="exportTaskIdentifier")
    def export_task_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier for the snapshot export task.
        """
        return pulumi.get(self, "export_task_identifier")

    @export_task_identifier.setter
    def export_task_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "export_task_identifier", value)

    @property
    @pulumi.getter(name="failureCause")
    def failure_cause(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reason the export failed, if it failed.
        """
        return pulumi.get(self, "failure_cause")

    @failure_cause.setter
    def failure_cause(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "failure_cause", value)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the IAM role to use for writing to the Amazon S3 bucket.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_role_arn", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Progress of the snapshot export task as a percentage.
        """
        return pulumi.get(self, "percent_progress")

    @percent_progress.setter
    def percent_progress(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "percent_progress", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Amazon S3 bucket to export the snapshot to.
        """
        return pulumi.get(self, "s3_bucket_name")

    @s3_bucket_name.setter
    def s3_bucket_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_bucket_name", value)

    @property
    @pulumi.getter(name="s3Prefix")
    def s3_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
        """
        return pulumi.get(self, "s3_prefix")

    @s3_prefix.setter
    def s3_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_prefix", value)

    @property
    @pulumi.getter(name="snapshotTime")
    def snapshot_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time that the snapshot was created.
        """
        return pulumi.get(self, "snapshot_time")

    @snapshot_time.setter
    def snapshot_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_time", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amazon Resource Name (ARN) of the snapshot to export.

        The following arguments are optional:
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_arn", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of source for the export.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the export task.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="taskEndTime")
    def task_end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time that the snapshot export task completed.
        """
        return pulumi.get(self, "task_end_time")

    @task_end_time.setter
    def task_end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "task_end_time", value)

    @property
    @pulumi.getter(name="taskStartTime")
    def task_start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time that the snapshot export task started.
        """
        return pulumi.get(self, "task_start_time")

    @task_start_time.setter
    def task_start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "task_start_time", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ExportTaskTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ExportTaskTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="warningMessage")
    def warning_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Warning about the snapshot export task, if any.
        """
        return pulumi.get(self, "warning_message")

    @warning_message.setter
    def warning_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "warning_message", value)


@pulumi.type_token("aws:rds/exportTask:ExportTask")
class ExportTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 export_onlies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 export_task_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 s3_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ExportTaskTimeoutsArgs', 'ExportTaskTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS RDS (Relational Database) Export Task.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.ExportTask("example",
            export_task_identifier="example",
            source_arn=example_aws_db_snapshot["dbSnapshotArn"],
            s3_bucket_name=example_aws_s3_bucket["id"],
            iam_role_arn=example_aws_iam_role["arn"],
            kms_key_id=example_aws_kms_key["arn"])
        ```

        ### Complete Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example_bucket = aws.s3.Bucket("example",
            bucket="example",
            force_destroy=True)
        example_bucket_acl = aws.s3.BucketAcl("example",
            bucket=example_bucket.id,
            acl="private")
        example_role = aws.iam.Role("example",
            name="example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Sid": "",
                    "Principal": {
                        "Service": "export.rds.amazonaws.com",
                    },
                }],
            }))
        example = aws.iam.get_policy_document_output(statements=[
            {
                "actions": ["s3:ListAllMyBuckets"],
                "resources": ["*"],
            },
            {
                "actions": [
                    "s3:GetBucketLocation",
                    "s3:ListBucket",
                ],
                "resources": [example_bucket.arn],
            },
            {
                "actions": [
                    "s3:GetObject",
                    "s3:PutObject",
                    "s3:DeleteObject",
                ],
                "resources": [example_bucket.arn.apply(lambda arn: f"{arn}/*")],
            },
        ])
        example_policy = aws.iam.Policy("example",
            name="example",
            policy=example.json)
        example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
            role=example_role.name,
            policy_arn=example_policy.arn)
        example_key = aws.kms.Key("example", deletion_window_in_days=10)
        example_instance = aws.rds.Instance("example",
            identifier="example",
            allocated_storage=10,
            db_name="test",
            engine="mysql",
            engine_version="5.7",
            instance_class=aws.rds.InstanceType.T3_MICRO,
            username="foo",
            password="foobarbaz",
            parameter_group_name="default.mysql5.7",
            skip_final_snapshot=True)
        example_snapshot = aws.rds.Snapshot("example",
            db_instance_identifier=example_instance.identifier,
            db_snapshot_identifier="example")
        example_export_task = aws.rds.ExportTask("example",
            export_task_identifier="example",
            source_arn=example_snapshot.db_snapshot_arn,
            s3_bucket_name=example_bucket.id,
            iam_role_arn=example_role.arn,
            kms_key_id=example_key.arn,
            export_onlies=["database"],
            s3_prefix="my_prefix/example")
        ```

        ## Import

        Using `pulumi import`, import a RDS (Relational Database) Export Task using the `export_task_identifier`. For example:

        ```sh
        $ pulumi import aws:rds/exportTask:ExportTask example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] export_onlies: Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
        :param pulumi.Input[builtins.str] export_task_identifier: Unique identifier for the snapshot export task.
        :param pulumi.Input[builtins.str] iam_role_arn: ARN of the IAM role to use for writing to the Amazon S3 bucket.
        :param pulumi.Input[builtins.str] kms_key_id: ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] s3_bucket_name: Name of the Amazon S3 bucket to export the snapshot to.
        :param pulumi.Input[builtins.str] s3_prefix: Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
        :param pulumi.Input[builtins.str] source_arn: Amazon Resource Name (ARN) of the snapshot to export.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExportTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS RDS (Relational Database) Export Task.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.ExportTask("example",
            export_task_identifier="example",
            source_arn=example_aws_db_snapshot["dbSnapshotArn"],
            s3_bucket_name=example_aws_s3_bucket["id"],
            iam_role_arn=example_aws_iam_role["arn"],
            kms_key_id=example_aws_kms_key["arn"])
        ```

        ### Complete Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example_bucket = aws.s3.Bucket("example",
            bucket="example",
            force_destroy=True)
        example_bucket_acl = aws.s3.BucketAcl("example",
            bucket=example_bucket.id,
            acl="private")
        example_role = aws.iam.Role("example",
            name="example",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Sid": "",
                    "Principal": {
                        "Service": "export.rds.amazonaws.com",
                    },
                }],
            }))
        example = aws.iam.get_policy_document_output(statements=[
            {
                "actions": ["s3:ListAllMyBuckets"],
                "resources": ["*"],
            },
            {
                "actions": [
                    "s3:GetBucketLocation",
                    "s3:ListBucket",
                ],
                "resources": [example_bucket.arn],
            },
            {
                "actions": [
                    "s3:GetObject",
                    "s3:PutObject",
                    "s3:DeleteObject",
                ],
                "resources": [example_bucket.arn.apply(lambda arn: f"{arn}/*")],
            },
        ])
        example_policy = aws.iam.Policy("example",
            name="example",
            policy=example.json)
        example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
            role=example_role.name,
            policy_arn=example_policy.arn)
        example_key = aws.kms.Key("example", deletion_window_in_days=10)
        example_instance = aws.rds.Instance("example",
            identifier="example",
            allocated_storage=10,
            db_name="test",
            engine="mysql",
            engine_version="5.7",
            instance_class=aws.rds.InstanceType.T3_MICRO,
            username="foo",
            password="foobarbaz",
            parameter_group_name="default.mysql5.7",
            skip_final_snapshot=True)
        example_snapshot = aws.rds.Snapshot("example",
            db_instance_identifier=example_instance.identifier,
            db_snapshot_identifier="example")
        example_export_task = aws.rds.ExportTask("example",
            export_task_identifier="example",
            source_arn=example_snapshot.db_snapshot_arn,
            s3_bucket_name=example_bucket.id,
            iam_role_arn=example_role.arn,
            kms_key_id=example_key.arn,
            export_onlies=["database"],
            s3_prefix="my_prefix/example")
        ```

        ## Import

        Using `pulumi import`, import a RDS (Relational Database) Export Task using the `export_task_identifier`. For example:

        ```sh
        $ pulumi import aws:rds/exportTask:ExportTask example example
        ```

        :param str resource_name: The name of the resource.
        :param ExportTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExportTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 export_onlies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 export_task_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 s3_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 source_arn: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ExportTaskTimeoutsArgs', 'ExportTaskTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExportTaskArgs.__new__(ExportTaskArgs)

            __props__.__dict__["export_onlies"] = export_onlies
            if export_task_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'export_task_identifier'")
            __props__.__dict__["export_task_identifier"] = export_task_identifier
            if iam_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'iam_role_arn'")
            __props__.__dict__["iam_role_arn"] = iam_role_arn
            if kms_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'kms_key_id'")
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["region"] = region
            if s3_bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 's3_bucket_name'")
            __props__.__dict__["s3_bucket_name"] = s3_bucket_name
            __props__.__dict__["s3_prefix"] = s3_prefix
            if source_arn is None and not opts.urn:
                raise TypeError("Missing required property 'source_arn'")
            __props__.__dict__["source_arn"] = source_arn
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["failure_cause"] = None
            __props__.__dict__["percent_progress"] = None
            __props__.__dict__["snapshot_time"] = None
            __props__.__dict__["source_type"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["task_end_time"] = None
            __props__.__dict__["task_start_time"] = None
            __props__.__dict__["warning_message"] = None
        super(ExportTask, __self__).__init__(
            'aws:rds/exportTask:ExportTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            export_onlies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            export_task_identifier: Optional[pulumi.Input[builtins.str]] = None,
            failure_cause: Optional[pulumi.Input[builtins.str]] = None,
            iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            percent_progress: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            s3_bucket_name: Optional[pulumi.Input[builtins.str]] = None,
            s3_prefix: Optional[pulumi.Input[builtins.str]] = None,
            snapshot_time: Optional[pulumi.Input[builtins.str]] = None,
            source_arn: Optional[pulumi.Input[builtins.str]] = None,
            source_type: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            task_end_time: Optional[pulumi.Input[builtins.str]] = None,
            task_start_time: Optional[pulumi.Input[builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['ExportTaskTimeoutsArgs', 'ExportTaskTimeoutsArgsDict']]] = None,
            warning_message: Optional[pulumi.Input[builtins.str]] = None) -> 'ExportTask':
        """
        Get an existing ExportTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] export_onlies: Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
        :param pulumi.Input[builtins.str] export_task_identifier: Unique identifier for the snapshot export task.
        :param pulumi.Input[builtins.str] failure_cause: Reason the export failed, if it failed.
        :param pulumi.Input[builtins.str] iam_role_arn: ARN of the IAM role to use for writing to the Amazon S3 bucket.
        :param pulumi.Input[builtins.str] kms_key_id: ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
        :param pulumi.Input[builtins.int] percent_progress: Progress of the snapshot export task as a percentage.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] s3_bucket_name: Name of the Amazon S3 bucket to export the snapshot to.
        :param pulumi.Input[builtins.str] s3_prefix: Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
        :param pulumi.Input[builtins.str] snapshot_time: Time that the snapshot was created.
        :param pulumi.Input[builtins.str] source_arn: Amazon Resource Name (ARN) of the snapshot to export.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] source_type: Type of source for the export.
        :param pulumi.Input[builtins.str] status: Status of the export task.
        :param pulumi.Input[builtins.str] task_end_time: Time that the snapshot export task completed.
        :param pulumi.Input[builtins.str] task_start_time: Time that the snapshot export task started.
        :param pulumi.Input[builtins.str] warning_message: Warning about the snapshot export task, if any.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExportTaskState.__new__(_ExportTaskState)

        __props__.__dict__["export_onlies"] = export_onlies
        __props__.__dict__["export_task_identifier"] = export_task_identifier
        __props__.__dict__["failure_cause"] = failure_cause
        __props__.__dict__["iam_role_arn"] = iam_role_arn
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["percent_progress"] = percent_progress
        __props__.__dict__["region"] = region
        __props__.__dict__["s3_bucket_name"] = s3_bucket_name
        __props__.__dict__["s3_prefix"] = s3_prefix
        __props__.__dict__["snapshot_time"] = snapshot_time
        __props__.__dict__["source_arn"] = source_arn
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["status"] = status
        __props__.__dict__["task_end_time"] = task_end_time
        __props__.__dict__["task_start_time"] = task_start_time
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["warning_message"] = warning_message
        return ExportTask(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="exportOnlies")
    def export_onlies(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
        """
        return pulumi.get(self, "export_onlies")

    @property
    @pulumi.getter(name="exportTaskIdentifier")
    def export_task_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier for the snapshot export task.
        """
        return pulumi.get(self, "export_task_identifier")

    @property
    @pulumi.getter(name="failureCause")
    def failure_cause(self) -> pulumi.Output[builtins.str]:
        """
        Reason the export failed, if it failed.
        """
        return pulumi.get(self, "failure_cause")

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the IAM role to use for writing to the Amazon S3 bucket.
        """
        return pulumi.get(self, "iam_role_arn")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> pulumi.Output[builtins.int]:
        """
        Progress of the snapshot export task as a percentage.
        """
        return pulumi.get(self, "percent_progress")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Amazon S3 bucket to export the snapshot to.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3Prefix")
    def s3_prefix(self) -> pulumi.Output[builtins.str]:
        """
        Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
        """
        return pulumi.get(self, "s3_prefix")

    @property
    @pulumi.getter(name="snapshotTime")
    def snapshot_time(self) -> pulumi.Output[builtins.str]:
        """
        Time that the snapshot was created.
        """
        return pulumi.get(self, "snapshot_time")

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name (ARN) of the snapshot to export.

        The following arguments are optional:
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of source for the export.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Status of the export task.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="taskEndTime")
    def task_end_time(self) -> pulumi.Output[builtins.str]:
        """
        Time that the snapshot export task completed.
        """
        return pulumi.get(self, "task_end_time")

    @property
    @pulumi.getter(name="taskStartTime")
    def task_start_time(self) -> pulumi.Output[builtins.str]:
        """
        Time that the snapshot export task started.
        """
        return pulumi.get(self, "task_start_time")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ExportTaskTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="warningMessage")
    def warning_message(self) -> pulumi.Output[builtins.str]:
        """
        Warning about the snapshot export task, if any.
        """
        return pulumi.get(self, "warning_message")

