# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

@pulumi.output_type
class GetCertificateResult:
    """
    A collection of values returned by getCertificate.
    """
    def __init__(__self__, arn=None, certificate_type=None, customer_override=None, customer_override_valid_till=None, default_for_new_launches=None, id=None, latest_valid_till=None, region=None, thumbprint=None, valid_from=None, valid_till=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if certificate_type and not isinstance(certificate_type, str):
            raise TypeError("Expected argument 'certificate_type' to be a str")
        pulumi.set(__self__, "certificate_type", certificate_type)
        if customer_override and not isinstance(customer_override, bool):
            raise TypeError("Expected argument 'customer_override' to be a bool")
        pulumi.set(__self__, "customer_override", customer_override)
        if customer_override_valid_till and not isinstance(customer_override_valid_till, str):
            raise TypeError("Expected argument 'customer_override_valid_till' to be a str")
        pulumi.set(__self__, "customer_override_valid_till", customer_override_valid_till)
        if default_for_new_launches and not isinstance(default_for_new_launches, bool):
            raise TypeError("Expected argument 'default_for_new_launches' to be a bool")
        pulumi.set(__self__, "default_for_new_launches", default_for_new_launches)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if latest_valid_till and not isinstance(latest_valid_till, bool):
            raise TypeError("Expected argument 'latest_valid_till' to be a bool")
        pulumi.set(__self__, "latest_valid_till", latest_valid_till)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if thumbprint and not isinstance(thumbprint, str):
            raise TypeError("Expected argument 'thumbprint' to be a str")
        pulumi.set(__self__, "thumbprint", thumbprint)
        if valid_from and not isinstance(valid_from, str):
            raise TypeError("Expected argument 'valid_from' to be a str")
        pulumi.set(__self__, "valid_from", valid_from)
        if valid_till and not isinstance(valid_till, str):
            raise TypeError("Expected argument 'valid_till' to be a str")
        pulumi.set(__self__, "valid_till", valid_till)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the certificate.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> builtins.str:
        """
        Type of certificate. For example, `CA`.
        """
        return pulumi.get(self, "certificate_type")

    @property
    @pulumi.getter(name="customerOverride")
    def customer_override(self) -> builtins.bool:
        """
        Boolean whether there is an override for the default certificate identifier.
        """
        return pulumi.get(self, "customer_override")

    @property
    @pulumi.getter(name="customerOverrideValidTill")
    def customer_override_valid_till(self) -> builtins.str:
        """
        If there is an override for the default certificate identifier, when the override expires.
        """
        return pulumi.get(self, "customer_override_valid_till")

    @property
    @pulumi.getter(name="defaultForNewLaunches")
    def default_for_new_launches(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "default_for_new_launches")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="latestValidTill")
    def latest_valid_till(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "latest_valid_till")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def thumbprint(self) -> builtins.str:
        """
        Thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> builtins.str:
        """
        [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of certificate starting validity date.
        """
        return pulumi.get(self, "valid_from")

    @property
    @pulumi.getter(name="validTill")
    def valid_till(self) -> builtins.str:
        """
        [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of certificate ending validity date.
        """
        return pulumi.get(self, "valid_till")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            arn=self.arn,
            certificate_type=self.certificate_type,
            customer_override=self.customer_override,
            customer_override_valid_till=self.customer_override_valid_till,
            default_for_new_launches=self.default_for_new_launches,
            id=self.id,
            latest_valid_till=self.latest_valid_till,
            region=self.region,
            thumbprint=self.thumbprint,
            valid_from=self.valid_from,
            valid_till=self.valid_till)


def get_certificate(default_for_new_launches: Optional[builtins.bool] = None,
                    id: Optional[builtins.str] = None,
                    latest_valid_till: Optional[builtins.bool] = None,
                    region: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    Information about an RDS Certificate.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.rds.get_certificate(latest_valid_till=True)
    ```


    :param builtins.bool default_for_new_launches: When enabled, returns the default certificate for new RDS instances.
    :param builtins.str id: Certificate identifier. For example, `rds-ca-2019`.
    :param builtins.bool latest_valid_till: When enabled, returns the certificate with the latest `ValidTill`.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['defaultForNewLaunches'] = default_for_new_launches
    __args__['id'] = id
    __args__['latestValidTill'] = latest_valid_till
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:rds/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        arn=pulumi.get(__ret__, 'arn'),
        certificate_type=pulumi.get(__ret__, 'certificate_type'),
        customer_override=pulumi.get(__ret__, 'customer_override'),
        customer_override_valid_till=pulumi.get(__ret__, 'customer_override_valid_till'),
        default_for_new_launches=pulumi.get(__ret__, 'default_for_new_launches'),
        id=pulumi.get(__ret__, 'id'),
        latest_valid_till=pulumi.get(__ret__, 'latest_valid_till'),
        region=pulumi.get(__ret__, 'region'),
        thumbprint=pulumi.get(__ret__, 'thumbprint'),
        valid_from=pulumi.get(__ret__, 'valid_from'),
        valid_till=pulumi.get(__ret__, 'valid_till'))
def get_certificate_output(default_for_new_launches: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                           id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           latest_valid_till: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                           region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificateResult]:
    """
    Information about an RDS Certificate.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.rds.get_certificate(latest_valid_till=True)
    ```


    :param builtins.bool default_for_new_launches: When enabled, returns the default certificate for new RDS instances.
    :param builtins.str id: Certificate identifier. For example, `rds-ca-2019`.
    :param builtins.bool latest_valid_till: When enabled, returns the certificate with the latest `ValidTill`.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['defaultForNewLaunches'] = default_for_new_launches
    __args__['id'] = id
    __args__['latestValidTill'] = latest_valid_till
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:rds/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult)
    return __ret__.apply(lambda __response__: GetCertificateResult(
        arn=pulumi.get(__response__, 'arn'),
        certificate_type=pulumi.get(__response__, 'certificate_type'),
        customer_override=pulumi.get(__response__, 'customer_override'),
        customer_override_valid_till=pulumi.get(__response__, 'customer_override_valid_till'),
        default_for_new_launches=pulumi.get(__response__, 'default_for_new_launches'),
        id=pulumi.get(__response__, 'id'),
        latest_valid_till=pulumi.get(__response__, 'latest_valid_till'),
        region=pulumi.get(__response__, 'region'),
        thumbprint=pulumi.get(__response__, 'thumbprint'),
        valid_from=pulumi.get(__response__, 'valid_from'),
        valid_till=pulumi.get(__response__, 'valid_till')))
