# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    """
    A collection of values returned by getCluster.
    """
    def __init__(__self__, arn=None, availability_zones=None, backtrack_window=None, backup_retention_period=None, cluster_identifier=None, cluster_members=None, cluster_resource_id=None, cluster_scalability_type=None, database_insights_mode=None, database_name=None, db_cluster_parameter_group_name=None, db_subnet_group_name=None, db_system_id=None, enabled_cloudwatch_logs_exports=None, endpoint=None, engine=None, engine_mode=None, engine_version=None, final_snapshot_identifier=None, hosted_zone_id=None, iam_database_authentication_enabled=None, iam_roles=None, id=None, kms_key_id=None, master_user_secrets=None, master_username=None, monitoring_interval=None, monitoring_role_arn=None, network_type=None, port=None, preferred_backup_window=None, preferred_maintenance_window=None, reader_endpoint=None, region=None, replication_source_identifier=None, storage_encrypted=None, tags=None, vpc_security_group_ids=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if availability_zones and not isinstance(availability_zones, list):
            raise TypeError("Expected argument 'availability_zones' to be a list")
        pulumi.set(__self__, "availability_zones", availability_zones)
        if backtrack_window and not isinstance(backtrack_window, int):
            raise TypeError("Expected argument 'backtrack_window' to be a int")
        pulumi.set(__self__, "backtrack_window", backtrack_window)
        if backup_retention_period and not isinstance(backup_retention_period, int):
            raise TypeError("Expected argument 'backup_retention_period' to be a int")
        pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if cluster_identifier and not isinstance(cluster_identifier, str):
            raise TypeError("Expected argument 'cluster_identifier' to be a str")
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if cluster_members and not isinstance(cluster_members, list):
            raise TypeError("Expected argument 'cluster_members' to be a list")
        pulumi.set(__self__, "cluster_members", cluster_members)
        if cluster_resource_id and not isinstance(cluster_resource_id, str):
            raise TypeError("Expected argument 'cluster_resource_id' to be a str")
        pulumi.set(__self__, "cluster_resource_id", cluster_resource_id)
        if cluster_scalability_type and not isinstance(cluster_scalability_type, str):
            raise TypeError("Expected argument 'cluster_scalability_type' to be a str")
        pulumi.set(__self__, "cluster_scalability_type", cluster_scalability_type)
        if database_insights_mode and not isinstance(database_insights_mode, str):
            raise TypeError("Expected argument 'database_insights_mode' to be a str")
        pulumi.set(__self__, "database_insights_mode", database_insights_mode)
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if db_cluster_parameter_group_name and not isinstance(db_cluster_parameter_group_name, str):
            raise TypeError("Expected argument 'db_cluster_parameter_group_name' to be a str")
        pulumi.set(__self__, "db_cluster_parameter_group_name", db_cluster_parameter_group_name)
        if db_subnet_group_name and not isinstance(db_subnet_group_name, str):
            raise TypeError("Expected argument 'db_subnet_group_name' to be a str")
        pulumi.set(__self__, "db_subnet_group_name", db_subnet_group_name)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if enabled_cloudwatch_logs_exports and not isinstance(enabled_cloudwatch_logs_exports, list):
            raise TypeError("Expected argument 'enabled_cloudwatch_logs_exports' to be a list")
        pulumi.set(__self__, "enabled_cloudwatch_logs_exports", enabled_cloudwatch_logs_exports)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if engine_mode and not isinstance(engine_mode, str):
            raise TypeError("Expected argument 'engine_mode' to be a str")
        pulumi.set(__self__, "engine_mode", engine_mode)
        if engine_version and not isinstance(engine_version, str):
            raise TypeError("Expected argument 'engine_version' to be a str")
        pulumi.set(__self__, "engine_version", engine_version)
        if final_snapshot_identifier and not isinstance(final_snapshot_identifier, str):
            raise TypeError("Expected argument 'final_snapshot_identifier' to be a str")
        pulumi.set(__self__, "final_snapshot_identifier", final_snapshot_identifier)
        if hosted_zone_id and not isinstance(hosted_zone_id, str):
            raise TypeError("Expected argument 'hosted_zone_id' to be a str")
        pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if iam_database_authentication_enabled and not isinstance(iam_database_authentication_enabled, bool):
            raise TypeError("Expected argument 'iam_database_authentication_enabled' to be a bool")
        pulumi.set(__self__, "iam_database_authentication_enabled", iam_database_authentication_enabled)
        if iam_roles and not isinstance(iam_roles, list):
            raise TypeError("Expected argument 'iam_roles' to be a list")
        pulumi.set(__self__, "iam_roles", iam_roles)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if master_user_secrets and not isinstance(master_user_secrets, list):
            raise TypeError("Expected argument 'master_user_secrets' to be a list")
        pulumi.set(__self__, "master_user_secrets", master_user_secrets)
        if master_username and not isinstance(master_username, str):
            raise TypeError("Expected argument 'master_username' to be a str")
        pulumi.set(__self__, "master_username", master_username)
        if monitoring_interval and not isinstance(monitoring_interval, int):
            raise TypeError("Expected argument 'monitoring_interval' to be a int")
        pulumi.set(__self__, "monitoring_interval", monitoring_interval)
        if monitoring_role_arn and not isinstance(monitoring_role_arn, str):
            raise TypeError("Expected argument 'monitoring_role_arn' to be a str")
        pulumi.set(__self__, "monitoring_role_arn", monitoring_role_arn)
        if network_type and not isinstance(network_type, str):
            raise TypeError("Expected argument 'network_type' to be a str")
        pulumi.set(__self__, "network_type", network_type)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if preferred_backup_window and not isinstance(preferred_backup_window, str):
            raise TypeError("Expected argument 'preferred_backup_window' to be a str")
        pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window and not isinstance(preferred_maintenance_window, str):
            raise TypeError("Expected argument 'preferred_maintenance_window' to be a str")
        pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if reader_endpoint and not isinstance(reader_endpoint, str):
            raise TypeError("Expected argument 'reader_endpoint' to be a str")
        pulumi.set(__self__, "reader_endpoint", reader_endpoint)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if replication_source_identifier and not isinstance(replication_source_identifier, str):
            raise TypeError("Expected argument 'replication_source_identifier' to be a str")
        pulumi.set(__self__, "replication_source_identifier", replication_source_identifier)
        if storage_encrypted and not isinstance(storage_encrypted, bool):
            raise TypeError("Expected argument 'storage_encrypted' to be a bool")
        pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_security_group_ids and not isinstance(vpc_security_group_ids, list):
            raise TypeError("Expected argument 'vpc_security_group_ids' to be a list")
        pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="backtrackWindow")
    def backtrack_window(self) -> builtins.int:
        return pulumi.get(self, "backtrack_window")

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> builtins.int:
        return pulumi.get(self, "backup_retention_period")

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> builtins.str:
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter(name="clusterMembers")
    def cluster_members(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "cluster_members")

    @property
    @pulumi.getter(name="clusterResourceId")
    def cluster_resource_id(self) -> builtins.str:
        return pulumi.get(self, "cluster_resource_id")

    @property
    @pulumi.getter(name="clusterScalabilityType")
    def cluster_scalability_type(self) -> builtins.str:
        return pulumi.get(self, "cluster_scalability_type")

    @property
    @pulumi.getter(name="databaseInsightsMode")
    def database_insights_mode(self) -> builtins.str:
        return pulumi.get(self, "database_insights_mode")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="dbClusterParameterGroupName")
    def db_cluster_parameter_group_name(self) -> builtins.str:
        return pulumi.get(self, "db_cluster_parameter_group_name")

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> builtins.str:
        return pulumi.get(self, "db_subnet_group_name")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> builtins.str:
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="enabledCloudwatchLogsExports")
    def enabled_cloudwatch_logs_exports(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "enabled_cloudwatch_logs_exports")

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def engine(self) -> builtins.str:
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineMode")
    def engine_mode(self) -> builtins.str:
        return pulumi.get(self, "engine_mode")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> builtins.str:
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="finalSnapshotIdentifier")
    def final_snapshot_identifier(self) -> builtins.str:
        return pulumi.get(self, "final_snapshot_identifier")

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> builtins.str:
        return pulumi.get(self, "hosted_zone_id")

    @property
    @pulumi.getter(name="iamDatabaseAuthenticationEnabled")
    def iam_database_authentication_enabled(self) -> builtins.bool:
        return pulumi.get(self, "iam_database_authentication_enabled")

    @property
    @pulumi.getter(name="iamRoles")
    def iam_roles(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "iam_roles")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="masterUserSecrets")
    def master_user_secrets(self) -> Sequence['outputs.GetClusterMasterUserSecretResult']:
        return pulumi.get(self, "master_user_secrets")

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> builtins.str:
        return pulumi.get(self, "master_username")

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> builtins.int:
        return pulumi.get(self, "monitoring_interval")

    @property
    @pulumi.getter(name="monitoringRoleArn")
    def monitoring_role_arn(self) -> builtins.str:
        return pulumi.get(self, "monitoring_role_arn")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> builtins.str:
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> builtins.str:
        return pulumi.get(self, "preferred_backup_window")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> builtins.str:
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="readerEndpoint")
    def reader_endpoint(self) -> builtins.str:
        return pulumi.get(self, "reader_endpoint")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicationSourceIdentifier")
    def replication_source_identifier(self) -> builtins.str:
        return pulumi.get(self, "replication_source_identifier")

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> builtins.bool:
        return pulumi.get(self, "storage_encrypted")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "vpc_security_group_ids")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            arn=self.arn,
            availability_zones=self.availability_zones,
            backtrack_window=self.backtrack_window,
            backup_retention_period=self.backup_retention_period,
            cluster_identifier=self.cluster_identifier,
            cluster_members=self.cluster_members,
            cluster_resource_id=self.cluster_resource_id,
            cluster_scalability_type=self.cluster_scalability_type,
            database_insights_mode=self.database_insights_mode,
            database_name=self.database_name,
            db_cluster_parameter_group_name=self.db_cluster_parameter_group_name,
            db_subnet_group_name=self.db_subnet_group_name,
            db_system_id=self.db_system_id,
            enabled_cloudwatch_logs_exports=self.enabled_cloudwatch_logs_exports,
            endpoint=self.endpoint,
            engine=self.engine,
            engine_mode=self.engine_mode,
            engine_version=self.engine_version,
            final_snapshot_identifier=self.final_snapshot_identifier,
            hosted_zone_id=self.hosted_zone_id,
            iam_database_authentication_enabled=self.iam_database_authentication_enabled,
            iam_roles=self.iam_roles,
            id=self.id,
            kms_key_id=self.kms_key_id,
            master_user_secrets=self.master_user_secrets,
            master_username=self.master_username,
            monitoring_interval=self.monitoring_interval,
            monitoring_role_arn=self.monitoring_role_arn,
            network_type=self.network_type,
            port=self.port,
            preferred_backup_window=self.preferred_backup_window,
            preferred_maintenance_window=self.preferred_maintenance_window,
            reader_endpoint=self.reader_endpoint,
            region=self.region,
            replication_source_identifier=self.replication_source_identifier,
            storage_encrypted=self.storage_encrypted,
            tags=self.tags,
            vpc_security_group_ids=self.vpc_security_group_ids)


def get_cluster(cluster_identifier: Optional[builtins.str] = None,
                region: Optional[builtins.str] = None,
                tags: Optional[Mapping[str, builtins.str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    Provides information about an RDS cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    cluster_name = aws.rds.get_cluster(cluster_identifier="clusterName")
    ```


    :param builtins.str cluster_identifier: Cluster identifier of the RDS cluster.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: A map of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['clusterIdentifier'] = cluster_identifier
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:rds/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        arn=pulumi.get(__ret__, 'arn'),
        availability_zones=pulumi.get(__ret__, 'availability_zones'),
        backtrack_window=pulumi.get(__ret__, 'backtrack_window'),
        backup_retention_period=pulumi.get(__ret__, 'backup_retention_period'),
        cluster_identifier=pulumi.get(__ret__, 'cluster_identifier'),
        cluster_members=pulumi.get(__ret__, 'cluster_members'),
        cluster_resource_id=pulumi.get(__ret__, 'cluster_resource_id'),
        cluster_scalability_type=pulumi.get(__ret__, 'cluster_scalability_type'),
        database_insights_mode=pulumi.get(__ret__, 'database_insights_mode'),
        database_name=pulumi.get(__ret__, 'database_name'),
        db_cluster_parameter_group_name=pulumi.get(__ret__, 'db_cluster_parameter_group_name'),
        db_subnet_group_name=pulumi.get(__ret__, 'db_subnet_group_name'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        enabled_cloudwatch_logs_exports=pulumi.get(__ret__, 'enabled_cloudwatch_logs_exports'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        engine=pulumi.get(__ret__, 'engine'),
        engine_mode=pulumi.get(__ret__, 'engine_mode'),
        engine_version=pulumi.get(__ret__, 'engine_version'),
        final_snapshot_identifier=pulumi.get(__ret__, 'final_snapshot_identifier'),
        hosted_zone_id=pulumi.get(__ret__, 'hosted_zone_id'),
        iam_database_authentication_enabled=pulumi.get(__ret__, 'iam_database_authentication_enabled'),
        iam_roles=pulumi.get(__ret__, 'iam_roles'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        master_user_secrets=pulumi.get(__ret__, 'master_user_secrets'),
        master_username=pulumi.get(__ret__, 'master_username'),
        monitoring_interval=pulumi.get(__ret__, 'monitoring_interval'),
        monitoring_role_arn=pulumi.get(__ret__, 'monitoring_role_arn'),
        network_type=pulumi.get(__ret__, 'network_type'),
        port=pulumi.get(__ret__, 'port'),
        preferred_backup_window=pulumi.get(__ret__, 'preferred_backup_window'),
        preferred_maintenance_window=pulumi.get(__ret__, 'preferred_maintenance_window'),
        reader_endpoint=pulumi.get(__ret__, 'reader_endpoint'),
        region=pulumi.get(__ret__, 'region'),
        replication_source_identifier=pulumi.get(__ret__, 'replication_source_identifier'),
        storage_encrypted=pulumi.get(__ret__, 'storage_encrypted'),
        tags=pulumi.get(__ret__, 'tags'),
        vpc_security_group_ids=pulumi.get(__ret__, 'vpc_security_group_ids'))
def get_cluster_output(cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                       region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterResult]:
    """
    Provides information about an RDS cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    cluster_name = aws.rds.get_cluster(cluster_identifier="clusterName")
    ```


    :param builtins.str cluster_identifier: Cluster identifier of the RDS cluster.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: A map of tags assigned to the resource.
    """
    __args__ = dict()
    __args__['clusterIdentifier'] = cluster_identifier
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:rds/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult)
    return __ret__.apply(lambda __response__: GetClusterResult(
        arn=pulumi.get(__response__, 'arn'),
        availability_zones=pulumi.get(__response__, 'availability_zones'),
        backtrack_window=pulumi.get(__response__, 'backtrack_window'),
        backup_retention_period=pulumi.get(__response__, 'backup_retention_period'),
        cluster_identifier=pulumi.get(__response__, 'cluster_identifier'),
        cluster_members=pulumi.get(__response__, 'cluster_members'),
        cluster_resource_id=pulumi.get(__response__, 'cluster_resource_id'),
        cluster_scalability_type=pulumi.get(__response__, 'cluster_scalability_type'),
        database_insights_mode=pulumi.get(__response__, 'database_insights_mode'),
        database_name=pulumi.get(__response__, 'database_name'),
        db_cluster_parameter_group_name=pulumi.get(__response__, 'db_cluster_parameter_group_name'),
        db_subnet_group_name=pulumi.get(__response__, 'db_subnet_group_name'),
        db_system_id=pulumi.get(__response__, 'db_system_id'),
        enabled_cloudwatch_logs_exports=pulumi.get(__response__, 'enabled_cloudwatch_logs_exports'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        engine=pulumi.get(__response__, 'engine'),
        engine_mode=pulumi.get(__response__, 'engine_mode'),
        engine_version=pulumi.get(__response__, 'engine_version'),
        final_snapshot_identifier=pulumi.get(__response__, 'final_snapshot_identifier'),
        hosted_zone_id=pulumi.get(__response__, 'hosted_zone_id'),
        iam_database_authentication_enabled=pulumi.get(__response__, 'iam_database_authentication_enabled'),
        iam_roles=pulumi.get(__response__, 'iam_roles'),
        id=pulumi.get(__response__, 'id'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        master_user_secrets=pulumi.get(__response__, 'master_user_secrets'),
        master_username=pulumi.get(__response__, 'master_username'),
        monitoring_interval=pulumi.get(__response__, 'monitoring_interval'),
        monitoring_role_arn=pulumi.get(__response__, 'monitoring_role_arn'),
        network_type=pulumi.get(__response__, 'network_type'),
        port=pulumi.get(__response__, 'port'),
        preferred_backup_window=pulumi.get(__response__, 'preferred_backup_window'),
        preferred_maintenance_window=pulumi.get(__response__, 'preferred_maintenance_window'),
        reader_endpoint=pulumi.get(__response__, 'reader_endpoint'),
        region=pulumi.get(__response__, 'region'),
        replication_source_identifier=pulumi.get(__response__, 'replication_source_identifier'),
        storage_encrypted=pulumi.get(__response__, 'storage_encrypted'),
        tags=pulumi.get(__response__, 'tags'),
        vpc_security_group_ids=pulumi.get(__response__, 'vpc_security_group_ids')))
