# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSubnetGroupResult',
    'AwaitableGetSubnetGroupResult',
    'get_subnet_group',
    'get_subnet_group_output',
]

@pulumi.output_type
class GetSubnetGroupResult:
    """
    A collection of values returned by getSubnetGroup.
    """
    def __init__(__self__, arn=None, description=None, id=None, name=None, region=None, status=None, subnet_ids=None, supported_network_types=None, vpc_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if supported_network_types and not isinstance(supported_network_types, list):
            raise TypeError("Expected argument 'supported_network_types' to be a list")
        pulumi.set(__self__, "supported_network_types", supported_network_types)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN for the DB subnet group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Provides the description of the DB subnet group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Provides the status of the DB subnet group.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        Contains a list of subnet identifiers.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="supportedNetworkTypes")
    def supported_network_types(self) -> Sequence[builtins.str]:
        """
        The network type of the DB subnet group.
        """
        return pulumi.get(self, "supported_network_types")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        Provides the VPC ID of the DB subnet group.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetSubnetGroupResult(GetSubnetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubnetGroupResult(
            arn=self.arn,
            description=self.description,
            id=self.id,
            name=self.name,
            region=self.region,
            status=self.status,
            subnet_ids=self.subnet_ids,
            supported_network_types=self.supported_network_types,
            vpc_id=self.vpc_id)


def get_subnet_group(name: Optional[builtins.str] = None,
                     region: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubnetGroupResult:
    """
    Use this data source to get information about an RDS subnet group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    database = aws.rds.get_subnet_group(name="my-test-database-subnet-group")
    ```


    :param builtins.str name: Name of the RDS database subnet group.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:rds/getSubnetGroup:getSubnetGroup', __args__, opts=opts, typ=GetSubnetGroupResult).value

    return AwaitableGetSubnetGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        subnet_ids=pulumi.get(__ret__, 'subnet_ids'),
        supported_network_types=pulumi.get(__ret__, 'supported_network_types'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_subnet_group_output(name: Optional[pulumi.Input[builtins.str]] = None,
                            region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubnetGroupResult]:
    """
    Use this data source to get information about an RDS subnet group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    database = aws.rds.get_subnet_group(name="my-test-database-subnet-group")
    ```


    :param builtins.str name: Name of the RDS database subnet group.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:rds/getSubnetGroup:getSubnetGroup', __args__, opts=opts, typ=GetSubnetGroupResult)
    return __ret__.apply(lambda __response__: GetSubnetGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        subnet_ids=pulumi.get(__response__, 'subnet_ids'),
        supported_network_types=pulumi.get(__response__, 'supported_network_types'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
