# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceDesiredStateArgs', 'InstanceDesiredState']

@pulumi.input_type
class InstanceDesiredStateArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[builtins.str],
                 state: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['InstanceDesiredStateTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a InstanceDesiredState resource.
        :param pulumi.Input[builtins.str] identifier: DB Instance Identifier
        :param pulumi.Input[builtins.str] state: Configured state of the DB Instance. Valid values are `available` and `stopped`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "state", state)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[builtins.str]:
        """
        DB Instance Identifier
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[builtins.str]:
        """
        Configured state of the DB Instance. Valid values are `available` and `stopped`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['InstanceDesiredStateTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['InstanceDesiredStateTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _InstanceDesiredStateState:
    def __init__(__self__, *,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['InstanceDesiredStateTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering InstanceDesiredState resources.
        :param pulumi.Input[builtins.str] identifier: DB Instance Identifier
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] state: Configured state of the DB Instance. Valid values are `available` and `stopped`.
        """
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DB Instance Identifier
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configured state of the DB Instance. Valid values are `available` and `stopped`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['InstanceDesiredStateTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['InstanceDesiredStateTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:rds/instanceDesiredState:InstanceDesiredState")
class InstanceDesiredState(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['InstanceDesiredStateTimeoutsArgs', 'InstanceDesiredStateTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS RDS (Relational Database) RDS Instance State.

        > Destruction of this resource is a no-op and **will not** modify the instance state

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.rds.InstanceDesiredState("test",
            identifier=test_aws_db_instance["identifier"],
            state="available")
        ```

        ## Import

        Using `pulumi import`, import RDS (Relational Database) RDS Instance State using the `example_id_arg`. For example:

        ```sh
        $ pulumi import aws:rds/instanceDesiredState:InstanceDesiredState example rds_instance_state-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] identifier: DB Instance Identifier
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] state: Configured state of the DB Instance. Valid values are `available` and `stopped`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceDesiredStateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS RDS (Relational Database) RDS Instance State.

        > Destruction of this resource is a no-op and **will not** modify the instance state

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.rds.InstanceDesiredState("test",
            identifier=test_aws_db_instance["identifier"],
            state="available")
        ```

        ## Import

        Using `pulumi import`, import RDS (Relational Database) RDS Instance State using the `example_id_arg`. For example:

        ```sh
        $ pulumi import aws:rds/instanceDesiredState:InstanceDesiredState example rds_instance_state-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param InstanceDesiredStateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceDesiredStateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['InstanceDesiredStateTimeoutsArgs', 'InstanceDesiredStateTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceDesiredStateArgs.__new__(InstanceDesiredStateArgs)

            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["region"] = region
            if state is None and not opts.urn:
                raise TypeError("Missing required property 'state'")
            __props__.__dict__["state"] = state
            __props__.__dict__["timeouts"] = timeouts
        super(InstanceDesiredState, __self__).__init__(
            'aws:rds/instanceDesiredState:InstanceDesiredState',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            identifier: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['InstanceDesiredStateTimeoutsArgs', 'InstanceDesiredStateTimeoutsArgsDict']]] = None) -> 'InstanceDesiredState':
        """
        Get an existing InstanceDesiredState resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] identifier: DB Instance Identifier
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] state: Configured state of the DB Instance. Valid values are `available` and `stopped`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceDesiredStateState.__new__(_InstanceDesiredStateState)

        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["region"] = region
        __props__.__dict__["state"] = state
        __props__.__dict__["timeouts"] = timeouts
        return InstanceDesiredState(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        DB Instance Identifier
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Configured state of the DB Instance. Valid values are `available` and `stopped`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.InstanceDesiredStateTimeouts']]:
        return pulumi.get(self, "timeouts")

