# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ShardGroupArgs', 'ShardGroup']

@pulumi.input_type
class ShardGroupArgs:
    def __init__(__self__, *,
                 db_cluster_identifier: pulumi.Input[builtins.str],
                 db_shard_group_identifier: pulumi.Input[builtins.str],
                 max_acu: pulumi.Input[builtins.float],
                 compute_redundancy: Optional[pulumi.Input[builtins.int]] = None,
                 min_acu: Optional[pulumi.Input[builtins.float]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ShardGroupTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a ShardGroup resource.
        :param pulumi.Input[builtins.str] db_cluster_identifier: The name of the primary DB cluster for the DB shard group.
        :param pulumi.Input[builtins.str] db_shard_group_identifier: The name of the DB shard group.
        :param pulumi.Input[builtins.float] max_acu: The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
        :param pulumi.Input[builtins.int] compute_redundancy: Specifies whether to create standby DB shard groups for the DB shard group. Valid values are:
        :param pulumi.Input[builtins.float] min_acu: The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
        :param pulumi.Input[builtins.bool] publicly_accessible: Indicates whether the DB shard group is publicly accessible.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               For more detailed documentation about each argument, refer to the [AWS official documentation](https://docs.aws.amazon.com/cli/latest/reference/rds/create-shard-group.html).
        """
        pulumi.set(__self__, "db_cluster_identifier", db_cluster_identifier)
        pulumi.set(__self__, "db_shard_group_identifier", db_shard_group_identifier)
        pulumi.set(__self__, "max_acu", max_acu)
        if compute_redundancy is not None:
            pulumi.set(__self__, "compute_redundancy", compute_redundancy)
        if min_acu is not None:
            pulumi.set(__self__, "min_acu", min_acu)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The name of the primary DB cluster for the DB shard group.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @db_cluster_identifier.setter
    def db_cluster_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_cluster_identifier", value)

    @property
    @pulumi.getter(name="dbShardGroupIdentifier")
    def db_shard_group_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The name of the DB shard group.
        """
        return pulumi.get(self, "db_shard_group_identifier")

    @db_shard_group_identifier.setter
    def db_shard_group_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_shard_group_identifier", value)

    @property
    @pulumi.getter(name="maxAcu")
    def max_acu(self) -> pulumi.Input[builtins.float]:
        """
        The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
        """
        return pulumi.get(self, "max_acu")

    @max_acu.setter
    def max_acu(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "max_acu", value)

    @property
    @pulumi.getter(name="computeRedundancy")
    def compute_redundancy(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies whether to create standby DB shard groups for the DB shard group. Valid values are:
        """
        return pulumi.get(self, "compute_redundancy")

    @compute_redundancy.setter
    def compute_redundancy(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "compute_redundancy", value)

    @property
    @pulumi.getter(name="minAcu")
    def min_acu(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
        """
        return pulumi.get(self, "min_acu")

    @min_acu.setter
    def min_acu(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "min_acu", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the DB shard group is publicly accessible.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        For more detailed documentation about each argument, refer to the [AWS official documentation](https://docs.aws.amazon.com/cli/latest/reference/rds/create-shard-group.html).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ShardGroupTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ShardGroupTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ShardGroupState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 compute_redundancy: Optional[pulumi.Input[builtins.int]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_shard_group_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_shard_group_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 max_acu: Optional[pulumi.Input[builtins.float]] = None,
                 min_acu: Optional[pulumi.Input[builtins.float]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ShardGroupTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering ShardGroup resources.
        :param pulumi.Input[builtins.str] arn: ARN of the shard group.
        :param pulumi.Input[builtins.int] compute_redundancy: Specifies whether to create standby DB shard groups for the DB shard group. Valid values are:
        :param pulumi.Input[builtins.str] db_cluster_identifier: The name of the primary DB cluster for the DB shard group.
        :param pulumi.Input[builtins.str] db_shard_group_identifier: The name of the DB shard group.
        :param pulumi.Input[builtins.str] db_shard_group_resource_id: The AWS Region-unique, immutable identifier for the DB shard group.
        :param pulumi.Input[builtins.str] endpoint: The connection endpoint for the DB shard group.
        :param pulumi.Input[builtins.float] max_acu: The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
        :param pulumi.Input[builtins.float] min_acu: The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
        :param pulumi.Input[builtins.bool] publicly_accessible: Indicates whether the DB shard group is publicly accessible.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               For more detailed documentation about each argument, refer to the [AWS official documentation](https://docs.aws.amazon.com/cli/latest/reference/rds/create-shard-group.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if compute_redundancy is not None:
            pulumi.set(__self__, "compute_redundancy", compute_redundancy)
        if db_cluster_identifier is not None:
            pulumi.set(__self__, "db_cluster_identifier", db_cluster_identifier)
        if db_shard_group_identifier is not None:
            pulumi.set(__self__, "db_shard_group_identifier", db_shard_group_identifier)
        if db_shard_group_resource_id is not None:
            pulumi.set(__self__, "db_shard_group_resource_id", db_shard_group_resource_id)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if max_acu is not None:
            pulumi.set(__self__, "max_acu", max_acu)
        if min_acu is not None:
            pulumi.set(__self__, "min_acu", min_acu)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the shard group.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="computeRedundancy")
    def compute_redundancy(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies whether to create standby DB shard groups for the DB shard group. Valid values are:
        """
        return pulumi.get(self, "compute_redundancy")

    @compute_redundancy.setter
    def compute_redundancy(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "compute_redundancy", value)

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the primary DB cluster for the DB shard group.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @db_cluster_identifier.setter
    def db_cluster_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_cluster_identifier", value)

    @property
    @pulumi.getter(name="dbShardGroupIdentifier")
    def db_shard_group_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the DB shard group.
        """
        return pulumi.get(self, "db_shard_group_identifier")

    @db_shard_group_identifier.setter
    def db_shard_group_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_shard_group_identifier", value)

    @property
    @pulumi.getter(name="dbShardGroupResourceId")
    def db_shard_group_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS Region-unique, immutable identifier for the DB shard group.
        """
        return pulumi.get(self, "db_shard_group_resource_id")

    @db_shard_group_resource_id.setter
    def db_shard_group_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_shard_group_resource_id", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The connection endpoint for the DB shard group.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="maxAcu")
    def max_acu(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
        """
        return pulumi.get(self, "max_acu")

    @max_acu.setter
    def max_acu(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_acu", value)

    @property
    @pulumi.getter(name="minAcu")
    def min_acu(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
        """
        return pulumi.get(self, "min_acu")

    @min_acu.setter
    def min_acu(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "min_acu", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the DB shard group is publicly accessible.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        For more detailed documentation about each argument, refer to the [AWS official documentation](https://docs.aws.amazon.com/cli/latest/reference/rds/create-shard-group.html).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ShardGroupTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ShardGroupTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:rds/shardGroup:ShardGroup")
class ShardGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_redundancy: Optional[pulumi.Input[builtins.int]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_shard_group_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 max_acu: Optional[pulumi.Input[builtins.float]] = None,
                 min_acu: Optional[pulumi.Input[builtins.float]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ShardGroupTimeoutsArgs', 'ShardGroupTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an Amazon Aurora Limitless Database DB shard group

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.Cluster("example",
            cluster_identifier="example-limitless-cluster",
            engine=aws.rds.EngineType.AURORA_POSTGRESQL,
            engine_version="16.6-limitless",
            engine_mode="",
            storage_type="aurora-iopt1",
            cluster_scalability_type="limitless",
            master_username="foo",
            master_password="must_be_eight_characters",
            performance_insights_enabled=True,
            performance_insights_retention_period=31,
            enabled_cloudwatch_logs_exports=["postgresql"],
            monitoring_interval=5,
            monitoring_role_arn=example_aws_iam_role["arn"])
        example_shard_group = aws.rds.ShardGroup("example",
            db_shard_group_identifier="example-shard-group",
            db_cluster_identifier=example.id,
            max_acu=1200)
        ```

        ## Import

        Using `pulumi import`, import shard group using the `db_shard_group_identifier`. For example:

        ```sh
        $ pulumi import aws:rds/shardGroup:ShardGroup example example-shard-group
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] compute_redundancy: Specifies whether to create standby DB shard groups for the DB shard group. Valid values are:
        :param pulumi.Input[builtins.str] db_cluster_identifier: The name of the primary DB cluster for the DB shard group.
        :param pulumi.Input[builtins.str] db_shard_group_identifier: The name of the DB shard group.
        :param pulumi.Input[builtins.float] max_acu: The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
        :param pulumi.Input[builtins.float] min_acu: The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
        :param pulumi.Input[builtins.bool] publicly_accessible: Indicates whether the DB shard group is publicly accessible.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               For more detailed documentation about each argument, refer to the [AWS official documentation](https://docs.aws.amazon.com/cli/latest/reference/rds/create-shard-group.html).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ShardGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an Amazon Aurora Limitless Database DB shard group

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.Cluster("example",
            cluster_identifier="example-limitless-cluster",
            engine=aws.rds.EngineType.AURORA_POSTGRESQL,
            engine_version="16.6-limitless",
            engine_mode="",
            storage_type="aurora-iopt1",
            cluster_scalability_type="limitless",
            master_username="foo",
            master_password="must_be_eight_characters",
            performance_insights_enabled=True,
            performance_insights_retention_period=31,
            enabled_cloudwatch_logs_exports=["postgresql"],
            monitoring_interval=5,
            monitoring_role_arn=example_aws_iam_role["arn"])
        example_shard_group = aws.rds.ShardGroup("example",
            db_shard_group_identifier="example-shard-group",
            db_cluster_identifier=example.id,
            max_acu=1200)
        ```

        ## Import

        Using `pulumi import`, import shard group using the `db_shard_group_identifier`. For example:

        ```sh
        $ pulumi import aws:rds/shardGroup:ShardGroup example example-shard-group
        ```

        :param str resource_name: The name of the resource.
        :param ShardGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ShardGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_redundancy: Optional[pulumi.Input[builtins.int]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_shard_group_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 max_acu: Optional[pulumi.Input[builtins.float]] = None,
                 min_acu: Optional[pulumi.Input[builtins.float]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ShardGroupTimeoutsArgs', 'ShardGroupTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ShardGroupArgs.__new__(ShardGroupArgs)

            __props__.__dict__["compute_redundancy"] = compute_redundancy
            if db_cluster_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_identifier'")
            __props__.__dict__["db_cluster_identifier"] = db_cluster_identifier
            if db_shard_group_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'db_shard_group_identifier'")
            __props__.__dict__["db_shard_group_identifier"] = db_shard_group_identifier
            if max_acu is None and not opts.urn:
                raise TypeError("Missing required property 'max_acu'")
            __props__.__dict__["max_acu"] = max_acu
            __props__.__dict__["min_acu"] = min_acu
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["db_shard_group_resource_id"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["tags_all"] = None
        super(ShardGroup, __self__).__init__(
            'aws:rds/shardGroup:ShardGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            compute_redundancy: Optional[pulumi.Input[builtins.int]] = None,
            db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
            db_shard_group_identifier: Optional[pulumi.Input[builtins.str]] = None,
            db_shard_group_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            endpoint: Optional[pulumi.Input[builtins.str]] = None,
            max_acu: Optional[pulumi.Input[builtins.float]] = None,
            min_acu: Optional[pulumi.Input[builtins.float]] = None,
            publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['ShardGroupTimeoutsArgs', 'ShardGroupTimeoutsArgsDict']]] = None) -> 'ShardGroup':
        """
        Get an existing ShardGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the shard group.
        :param pulumi.Input[builtins.int] compute_redundancy: Specifies whether to create standby DB shard groups for the DB shard group. Valid values are:
        :param pulumi.Input[builtins.str] db_cluster_identifier: The name of the primary DB cluster for the DB shard group.
        :param pulumi.Input[builtins.str] db_shard_group_identifier: The name of the DB shard group.
        :param pulumi.Input[builtins.str] db_shard_group_resource_id: The AWS Region-unique, immutable identifier for the DB shard group.
        :param pulumi.Input[builtins.str] endpoint: The connection endpoint for the DB shard group.
        :param pulumi.Input[builtins.float] max_acu: The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
        :param pulumi.Input[builtins.float] min_acu: The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
        :param pulumi.Input[builtins.bool] publicly_accessible: Indicates whether the DB shard group is publicly accessible.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               For more detailed documentation about each argument, refer to the [AWS official documentation](https://docs.aws.amazon.com/cli/latest/reference/rds/create-shard-group.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ShardGroupState.__new__(_ShardGroupState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["compute_redundancy"] = compute_redundancy
        __props__.__dict__["db_cluster_identifier"] = db_cluster_identifier
        __props__.__dict__["db_shard_group_identifier"] = db_shard_group_identifier
        __props__.__dict__["db_shard_group_resource_id"] = db_shard_group_resource_id
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["max_acu"] = max_acu
        __props__.__dict__["min_acu"] = min_acu
        __props__.__dict__["publicly_accessible"] = publicly_accessible
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return ShardGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the shard group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="computeRedundancy")
    def compute_redundancy(self) -> pulumi.Output[builtins.int]:
        """
        Specifies whether to create standby DB shard groups for the DB shard group. Valid values are:
        """
        return pulumi.get(self, "compute_redundancy")

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The name of the primary DB cluster for the DB shard group.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @property
    @pulumi.getter(name="dbShardGroupIdentifier")
    def db_shard_group_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The name of the DB shard group.
        """
        return pulumi.get(self, "db_shard_group_identifier")

    @property
    @pulumi.getter(name="dbShardGroupResourceId")
    def db_shard_group_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The AWS Region-unique, immutable identifier for the DB shard group.
        """
        return pulumi.get(self, "db_shard_group_resource_id")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The connection endpoint for the DB shard group.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="maxAcu")
    def max_acu(self) -> pulumi.Output[builtins.float]:
        """
        The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
        """
        return pulumi.get(self, "max_acu")

    @property
    @pulumi.getter(name="minAcu")
    def min_acu(self) -> pulumi.Output[builtins.float]:
        """
        The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
        """
        return pulumi.get(self, "min_acu")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether the DB shard group is publicly accessible.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        For more detailed documentation about each argument, refer to the [AWS official documentation](https://docs.aws.amazon.com/cli/latest/reference/rds/create-shard-group.html).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ShardGroupTimeouts']]:
        return pulumi.get(self, "timeouts")

