# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuthenticationProfileArgs', 'AuthenticationProfile']

@pulumi.input_type
class AuthenticationProfileArgs:
    def __init__(__self__, *,
                 authentication_profile_content: pulumi.Input[builtins.str],
                 authentication_profile_name: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AuthenticationProfile resource.
        :param pulumi.Input[builtins.str] authentication_profile_content: The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
        :param pulumi.Input[builtins.str] authentication_profile_name: The name of the authentication profile.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "authentication_profile_content", authentication_profile_content)
        pulumi.set(__self__, "authentication_profile_name", authentication_profile_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="authenticationProfileContent")
    def authentication_profile_content(self) -> pulumi.Input[builtins.str]:
        """
        The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
        """
        return pulumi.get(self, "authentication_profile_content")

    @authentication_profile_content.setter
    def authentication_profile_content(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authentication_profile_content", value)

    @property
    @pulumi.getter(name="authenticationProfileName")
    def authentication_profile_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the authentication profile.
        """
        return pulumi.get(self, "authentication_profile_name")

    @authentication_profile_name.setter
    def authentication_profile_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authentication_profile_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AuthenticationProfileState:
    def __init__(__self__, *,
                 authentication_profile_content: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthenticationProfile resources.
        :param pulumi.Input[builtins.str] authentication_profile_content: The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
        :param pulumi.Input[builtins.str] authentication_profile_name: The name of the authentication profile.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if authentication_profile_content is not None:
            pulumi.set(__self__, "authentication_profile_content", authentication_profile_content)
        if authentication_profile_name is not None:
            pulumi.set(__self__, "authentication_profile_name", authentication_profile_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="authenticationProfileContent")
    def authentication_profile_content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
        """
        return pulumi.get(self, "authentication_profile_content")

    @authentication_profile_content.setter
    def authentication_profile_content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_profile_content", value)

    @property
    @pulumi.getter(name="authenticationProfileName")
    def authentication_profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the authentication profile.
        """
        return pulumi.get(self, "authentication_profile_name")

    @authentication_profile_name.setter
    def authentication_profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_profile_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:redshift/authenticationProfile:AuthenticationProfile")
class AuthenticationProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_profile_content: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates a Redshift authentication profile

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.redshift.AuthenticationProfile("example",
            authentication_profile_name="example",
            authentication_profile_content=json.dumps({
                "AllowDBUserOverride": "1",
                "Client_ID": "ExampleClientID",
                "App_ID": "example",
            }))
        ```

        ## Import

        Using `pulumi import`, import Redshift Authentication by `authentication_profile_name`. For example:

        ```sh
        $ pulumi import aws:redshift/authenticationProfile:AuthenticationProfile test example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authentication_profile_content: The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
        :param pulumi.Input[builtins.str] authentication_profile_name: The name of the authentication profile.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthenticationProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Redshift authentication profile

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.redshift.AuthenticationProfile("example",
            authentication_profile_name="example",
            authentication_profile_content=json.dumps({
                "AllowDBUserOverride": "1",
                "Client_ID": "ExampleClientID",
                "App_ID": "example",
            }))
        ```

        ## Import

        Using `pulumi import`, import Redshift Authentication by `authentication_profile_name`. For example:

        ```sh
        $ pulumi import aws:redshift/authenticationProfile:AuthenticationProfile test example
        ```

        :param str resource_name: The name of the resource.
        :param AuthenticationProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthenticationProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_profile_content: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthenticationProfileArgs.__new__(AuthenticationProfileArgs)

            if authentication_profile_content is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_profile_content'")
            __props__.__dict__["authentication_profile_content"] = authentication_profile_content
            if authentication_profile_name is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_profile_name'")
            __props__.__dict__["authentication_profile_name"] = authentication_profile_name
            __props__.__dict__["region"] = region
        super(AuthenticationProfile, __self__).__init__(
            'aws:redshift/authenticationProfile:AuthenticationProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_profile_content: Optional[pulumi.Input[builtins.str]] = None,
            authentication_profile_name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'AuthenticationProfile':
        """
        Get an existing AuthenticationProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authentication_profile_content: The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
        :param pulumi.Input[builtins.str] authentication_profile_name: The name of the authentication profile.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthenticationProfileState.__new__(_AuthenticationProfileState)

        __props__.__dict__["authentication_profile_content"] = authentication_profile_content
        __props__.__dict__["authentication_profile_name"] = authentication_profile_name
        __props__.__dict__["region"] = region
        return AuthenticationProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authenticationProfileContent")
    def authentication_profile_content(self) -> pulumi.Output[builtins.str]:
        """
        The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
        """
        return pulumi.get(self, "authentication_profile_content")

    @property
    @pulumi.getter(name="authenticationProfileName")
    def authentication_profile_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the authentication profile.
        """
        return pulumi.get(self, "authentication_profile_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

