# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EndpointAuthorizationArgs', 'EndpointAuthorization']

@pulumi.input_type
class EndpointAuthorizationArgs:
    def __init__(__self__, *,
                 account: pulumi.Input[builtins.str],
                 cluster_identifier: pulumi.Input[builtins.str],
                 force_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a EndpointAuthorization resource.
        :param pulumi.Input[builtins.str] account: The Amazon Web Services account ID to grant access to.
        :param pulumi.Input[builtins.str] cluster_identifier: The cluster identifier of the cluster to grant access to.
        :param pulumi.Input[builtins.bool] force_delete: Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_ids: The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
        """
        pulumi.set(__self__, "account", account)
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if vpc_ids is not None:
            pulumi.set(__self__, "vpc_ids", vpc_ids)

    @property
    @pulumi.getter
    def account(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Web Services account ID to grant access to.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account", value)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The cluster identifier of the cluster to grant access to.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
        """
        return pulumi.get(self, "vpc_ids")

    @vpc_ids.setter
    def vpc_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vpc_ids", value)


@pulumi.input_type
class _EndpointAuthorizationState:
    def __init__(__self__, *,
                 account: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_all_vpcs: Optional[pulumi.Input[builtins.bool]] = None,
                 cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_count: Optional[pulumi.Input[builtins.int]] = None,
                 force_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 grantee: Optional[pulumi.Input[builtins.str]] = None,
                 grantor: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering EndpointAuthorization resources.
        :param pulumi.Input[builtins.str] account: The Amazon Web Services account ID to grant access to.
        :param pulumi.Input[builtins.bool] allowed_all_vpcs: Indicates whether all VPCs in the grantee account are allowed access to the cluster.
        :param pulumi.Input[builtins.str] cluster_identifier: The cluster identifier of the cluster to grant access to.
        :param pulumi.Input[builtins.int] endpoint_count: The number of Redshift-managed VPC endpoints created for the authorization.
        :param pulumi.Input[builtins.bool] force_delete: Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
        :param pulumi.Input[builtins.str] grantee: The Amazon Web Services account ID of the grantee of the cluster.
        :param pulumi.Input[builtins.str] grantor: The Amazon Web Services account ID of the cluster owner.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_ids: The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
        """
        if account is not None:
            pulumi.set(__self__, "account", account)
        if allowed_all_vpcs is not None:
            pulumi.set(__self__, "allowed_all_vpcs", allowed_all_vpcs)
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if endpoint_count is not None:
            pulumi.set(__self__, "endpoint_count", endpoint_count)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if grantee is not None:
            pulumi.set(__self__, "grantee", grantee)
        if grantor is not None:
            pulumi.set(__self__, "grantor", grantor)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if vpc_ids is not None:
            pulumi.set(__self__, "vpc_ids", vpc_ids)

    @property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Web Services account ID to grant access to.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account", value)

    @property
    @pulumi.getter(name="allowedAllVpcs")
    def allowed_all_vpcs(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether all VPCs in the grantee account are allowed access to the cluster.
        """
        return pulumi.get(self, "allowed_all_vpcs")

    @allowed_all_vpcs.setter
    def allowed_all_vpcs(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allowed_all_vpcs", value)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cluster identifier of the cluster to grant access to.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="endpointCount")
    def endpoint_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of Redshift-managed VPC endpoints created for the authorization.
        """
        return pulumi.get(self, "endpoint_count")

    @endpoint_count.setter
    def endpoint_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "endpoint_count", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter
    def grantee(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Web Services account ID of the grantee of the cluster.
        """
        return pulumi.get(self, "grantee")

    @grantee.setter
    def grantee(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "grantee", value)

    @property
    @pulumi.getter
    def grantor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Web Services account ID of the cluster owner.
        """
        return pulumi.get(self, "grantor")

    @grantor.setter
    def grantor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "grantor", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
        """
        return pulumi.get(self, "vpc_ids")

    @vpc_ids.setter
    def vpc_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vpc_ids", value)


@pulumi.type_token("aws:redshift/endpointAuthorization:EndpointAuthorization")
class EndpointAuthorization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Creates a new Amazon Redshift endpoint authorization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshift.EndpointAuthorization("example",
            account="01234567910",
            cluster_identifier=example_aws_redshift_cluster["clusterIdentifier"])
        ```

        ## Import

        Using `pulumi import`, import Redshift endpoint authorization using the `id`. For example:

        ```sh
        $ pulumi import aws:redshift/endpointAuthorization:EndpointAuthorization example 01234567910:cluster-example-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account: The Amazon Web Services account ID to grant access to.
        :param pulumi.Input[builtins.str] cluster_identifier: The cluster identifier of the cluster to grant access to.
        :param pulumi.Input[builtins.bool] force_delete: Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_ids: The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointAuthorizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Amazon Redshift endpoint authorization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshift.EndpointAuthorization("example",
            account="01234567910",
            cluster_identifier=example_aws_redshift_cluster["clusterIdentifier"])
        ```

        ## Import

        Using `pulumi import`, import Redshift endpoint authorization using the `id`. For example:

        ```sh
        $ pulumi import aws:redshift/endpointAuthorization:EndpointAuthorization example 01234567910:cluster-example-id
        ```

        :param str resource_name: The name of the resource.
        :param EndpointAuthorizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointAuthorizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointAuthorizationArgs.__new__(EndpointAuthorizationArgs)

            if account is None and not opts.urn:
                raise TypeError("Missing required property 'account'")
            __props__.__dict__["account"] = account
            if cluster_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_identifier'")
            __props__.__dict__["cluster_identifier"] = cluster_identifier
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["region"] = region
            __props__.__dict__["vpc_ids"] = vpc_ids
            __props__.__dict__["allowed_all_vpcs"] = None
            __props__.__dict__["endpoint_count"] = None
            __props__.__dict__["grantee"] = None
            __props__.__dict__["grantor"] = None
        super(EndpointAuthorization, __self__).__init__(
            'aws:redshift/endpointAuthorization:EndpointAuthorization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account: Optional[pulumi.Input[builtins.str]] = None,
            allowed_all_vpcs: Optional[pulumi.Input[builtins.bool]] = None,
            cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_count: Optional[pulumi.Input[builtins.int]] = None,
            force_delete: Optional[pulumi.Input[builtins.bool]] = None,
            grantee: Optional[pulumi.Input[builtins.str]] = None,
            grantor: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'EndpointAuthorization':
        """
        Get an existing EndpointAuthorization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account: The Amazon Web Services account ID to grant access to.
        :param pulumi.Input[builtins.bool] allowed_all_vpcs: Indicates whether all VPCs in the grantee account are allowed access to the cluster.
        :param pulumi.Input[builtins.str] cluster_identifier: The cluster identifier of the cluster to grant access to.
        :param pulumi.Input[builtins.int] endpoint_count: The number of Redshift-managed VPC endpoints created for the authorization.
        :param pulumi.Input[builtins.bool] force_delete: Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
        :param pulumi.Input[builtins.str] grantee: The Amazon Web Services account ID of the grantee of the cluster.
        :param pulumi.Input[builtins.str] grantor: The Amazon Web Services account ID of the cluster owner.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_ids: The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointAuthorizationState.__new__(_EndpointAuthorizationState)

        __props__.__dict__["account"] = account
        __props__.__dict__["allowed_all_vpcs"] = allowed_all_vpcs
        __props__.__dict__["cluster_identifier"] = cluster_identifier
        __props__.__dict__["endpoint_count"] = endpoint_count
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["grantee"] = grantee
        __props__.__dict__["grantor"] = grantor
        __props__.__dict__["region"] = region
        __props__.__dict__["vpc_ids"] = vpc_ids
        return EndpointAuthorization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def account(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Web Services account ID to grant access to.
        """
        return pulumi.get(self, "account")

    @property
    @pulumi.getter(name="allowedAllVpcs")
    def allowed_all_vpcs(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether all VPCs in the grantee account are allowed access to the cluster.
        """
        return pulumi.get(self, "allowed_all_vpcs")

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The cluster identifier of the cluster to grant access to.
        """
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter(name="endpointCount")
    def endpoint_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of Redshift-managed VPC endpoints created for the authorization.
        """
        return pulumi.get(self, "endpoint_count")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter
    def grantee(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Web Services account ID of the grantee of the cluster.
        """
        return pulumi.get(self, "grantee")

    @property
    @pulumi.getter
    def grantor(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Web Services account ID of the cluster owner.
        """
        return pulumi.get(self, "grantor")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
        """
        return pulumi.get(self, "vpc_ids")

