# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LoggingArgs', 'Logging']

@pulumi.input_type
class LoggingArgs:
    def __init__(__self__, *,
                 cluster_identifier: pulumi.Input[builtins.str],
                 bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 log_destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 log_exports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Logging resource.
        :param pulumi.Input[builtins.str] cluster_identifier: Identifier of the source cluster.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] bucket_name: Name of an existing S3 bucket where the log files are to be stored. Required when `log_destination_type` is `s3`. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions. For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
        :param pulumi.Input[builtins.str] log_destination_type: Log destination type. Valid values are `s3` and `cloudwatch`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] log_exports: Collection of exported log types. Required when `log_destination_type` is `cloudwatch`. Valid values are `connectionlog`, `useractivitylog`, and `userlog`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] s3_key_prefix: Prefix applied to the log file names.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if log_destination_type is not None:
            pulumi.set(__self__, "log_destination_type", log_destination_type)
        if log_exports is not None:
            pulumi.set(__self__, "log_exports", log_exports)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of the source cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of an existing S3 bucket where the log files are to be stored. Required when `log_destination_type` is `s3`. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions. For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="logDestinationType")
    def log_destination_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Log destination type. Valid values are `s3` and `cloudwatch`.
        """
        return pulumi.get(self, "log_destination_type")

    @log_destination_type.setter
    def log_destination_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_destination_type", value)

    @property
    @pulumi.getter(name="logExports")
    def log_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Collection of exported log types. Required when `log_destination_type` is `cloudwatch`. Valid values are `connectionlog`, `useractivitylog`, and `userlog`.
        """
        return pulumi.get(self, "log_exports")

    @log_exports.setter
    def log_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "log_exports", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Prefix applied to the log file names.
        """
        return pulumi.get(self, "s3_key_prefix")

    @s3_key_prefix.setter
    def s3_key_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_key_prefix", value)


@pulumi.input_type
class _LoggingState:
    def __init__(__self__, *,
                 bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 log_destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 log_exports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Logging resources.
        :param pulumi.Input[builtins.str] bucket_name: Name of an existing S3 bucket where the log files are to be stored. Required when `log_destination_type` is `s3`. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions. For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
        :param pulumi.Input[builtins.str] cluster_identifier: Identifier of the source cluster.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] log_destination_type: Log destination type. Valid values are `s3` and `cloudwatch`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] log_exports: Collection of exported log types. Required when `log_destination_type` is `cloudwatch`. Valid values are `connectionlog`, `useractivitylog`, and `userlog`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] s3_key_prefix: Prefix applied to the log file names.
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if log_destination_type is not None:
            pulumi.set(__self__, "log_destination_type", log_destination_type)
        if log_exports is not None:
            pulumi.set(__self__, "log_exports", log_exports)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of an existing S3 bucket where the log files are to be stored. Required when `log_destination_type` is `s3`. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions. For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the source cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="logDestinationType")
    def log_destination_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Log destination type. Valid values are `s3` and `cloudwatch`.
        """
        return pulumi.get(self, "log_destination_type")

    @log_destination_type.setter
    def log_destination_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_destination_type", value)

    @property
    @pulumi.getter(name="logExports")
    def log_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Collection of exported log types. Required when `log_destination_type` is `cloudwatch`. Valid values are `connectionlog`, `useractivitylog`, and `userlog`.
        """
        return pulumi.get(self, "log_exports")

    @log_exports.setter
    def log_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "log_exports", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Prefix applied to the log file names.
        """
        return pulumi.get(self, "s3_key_prefix")

    @s3_key_prefix.setter
    def s3_key_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_key_prefix", value)


@pulumi.type_token("aws:redshift/logging:Logging")
class Logging(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 log_destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 log_exports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Redshift Logging configuration.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshift.Logging("example",
            cluster_identifier=example_aws_redshift_cluster["id"],
            log_destination_type="cloudwatch",
            log_exports=[
                "connectionlog",
                "userlog",
            ])
        ```

        ### S3 Destination Type

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshift.Logging("example",
            cluster_identifier=example_aws_redshift_cluster["id"],
            log_destination_type="s3",
            bucket_name=example_aws_s3_bucket["id"],
            s3_key_prefix="example-prefix/")
        ```

        ## Import

        Using `pulumi import`, import Redshift Logging using the `id`. For example:

        ```sh
        $ pulumi import aws:redshift/logging:Logging example cluster-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bucket_name: Name of an existing S3 bucket where the log files are to be stored. Required when `log_destination_type` is `s3`. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions. For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
        :param pulumi.Input[builtins.str] cluster_identifier: Identifier of the source cluster.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] log_destination_type: Log destination type. Valid values are `s3` and `cloudwatch`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] log_exports: Collection of exported log types. Required when `log_destination_type` is `cloudwatch`. Valid values are `connectionlog`, `useractivitylog`, and `userlog`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] s3_key_prefix: Prefix applied to the log file names.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoggingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Redshift Logging configuration.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshift.Logging("example",
            cluster_identifier=example_aws_redshift_cluster["id"],
            log_destination_type="cloudwatch",
            log_exports=[
                "connectionlog",
                "userlog",
            ])
        ```

        ### S3 Destination Type

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshift.Logging("example",
            cluster_identifier=example_aws_redshift_cluster["id"],
            log_destination_type="s3",
            bucket_name=example_aws_s3_bucket["id"],
            s3_key_prefix="example-prefix/")
        ```

        ## Import

        Using `pulumi import`, import Redshift Logging using the `id`. For example:

        ```sh
        $ pulumi import aws:redshift/logging:Logging example cluster-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param LoggingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoggingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 log_destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 log_exports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoggingArgs.__new__(LoggingArgs)

            __props__.__dict__["bucket_name"] = bucket_name
            if cluster_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_identifier'")
            __props__.__dict__["cluster_identifier"] = cluster_identifier
            __props__.__dict__["log_destination_type"] = log_destination_type
            __props__.__dict__["log_exports"] = log_exports
            __props__.__dict__["region"] = region
            __props__.__dict__["s3_key_prefix"] = s3_key_prefix
        super(Logging, __self__).__init__(
            'aws:redshift/logging:Logging',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket_name: Optional[pulumi.Input[builtins.str]] = None,
            cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
            log_destination_type: Optional[pulumi.Input[builtins.str]] = None,
            log_exports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            s3_key_prefix: Optional[pulumi.Input[builtins.str]] = None) -> 'Logging':
        """
        Get an existing Logging resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] bucket_name: Name of an existing S3 bucket where the log files are to be stored. Required when `log_destination_type` is `s3`. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions. For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
        :param pulumi.Input[builtins.str] cluster_identifier: Identifier of the source cluster.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] log_destination_type: Log destination type. Valid values are `s3` and `cloudwatch`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] log_exports: Collection of exported log types. Required when `log_destination_type` is `cloudwatch`. Valid values are `connectionlog`, `useractivitylog`, and `userlog`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] s3_key_prefix: Prefix applied to the log file names.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoggingState.__new__(_LoggingState)

        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["cluster_identifier"] = cluster_identifier
        __props__.__dict__["log_destination_type"] = log_destination_type
        __props__.__dict__["log_exports"] = log_exports
        __props__.__dict__["region"] = region
        __props__.__dict__["s3_key_prefix"] = s3_key_prefix
        return Logging(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of an existing S3 bucket where the log files are to be stored. Required when `log_destination_type` is `s3`. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions. For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of the source cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter(name="logDestinationType")
    def log_destination_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Log destination type. Valid values are `s3` and `cloudwatch`.
        """
        return pulumi.get(self, "log_destination_type")

    @property
    @pulumi.getter(name="logExports")
    def log_exports(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Collection of exported log types. Required when `log_destination_type` is `cloudwatch`. Valid values are `connectionlog`, `useractivitylog`, and `userlog`.
        """
        return pulumi.get(self, "log_exports")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Prefix applied to the log file names.
        """
        return pulumi.get(self, "s3_key_prefix")

