# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CustomDomainAssociationArgs', 'CustomDomainAssociation']

@pulumi.input_type
class CustomDomainAssociationArgs:
    def __init__(__self__, *,
                 custom_domain_certificate_arn: pulumi.Input[builtins.str],
                 custom_domain_name: pulumi.Input[builtins.str],
                 workgroup_name: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CustomDomainAssociation resource.
        :param pulumi.Input[builtins.str] custom_domain_certificate_arn: ARN of the certificate for the custom domain association.
        :param pulumi.Input[builtins.str] custom_domain_name: Custom domain to associate with the workgroup.
        :param pulumi.Input[builtins.str] workgroup_name: Name of the workgroup.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "custom_domain_certificate_arn", custom_domain_certificate_arn)
        pulumi.set(__self__, "custom_domain_name", custom_domain_name)
        pulumi.set(__self__, "workgroup_name", workgroup_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="customDomainCertificateArn")
    def custom_domain_certificate_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the certificate for the custom domain association.
        """
        return pulumi.get(self, "custom_domain_certificate_arn")

    @custom_domain_certificate_arn.setter
    def custom_domain_certificate_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "custom_domain_certificate_arn", value)

    @property
    @pulumi.getter(name="customDomainName")
    def custom_domain_name(self) -> pulumi.Input[builtins.str]:
        """
        Custom domain to associate with the workgroup.
        """
        return pulumi.get(self, "custom_domain_name")

    @custom_domain_name.setter
    def custom_domain_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "custom_domain_name", value)

    @property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the workgroup.
        """
        return pulumi.get(self, "workgroup_name")

    @workgroup_name.setter
    def workgroup_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workgroup_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _CustomDomainAssociationState:
    def __init__(__self__, *,
                 custom_domain_certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
                 custom_domain_certificate_expiry_time: Optional[pulumi.Input[builtins.str]] = None,
                 custom_domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 workgroup_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomDomainAssociation resources.
        :param pulumi.Input[builtins.str] custom_domain_certificate_arn: ARN of the certificate for the custom domain association.
        :param pulumi.Input[builtins.str] custom_domain_certificate_expiry_time: Expiration time for the certificate.
        :param pulumi.Input[builtins.str] custom_domain_name: Custom domain to associate with the workgroup.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] workgroup_name: Name of the workgroup.
        """
        if custom_domain_certificate_arn is not None:
            pulumi.set(__self__, "custom_domain_certificate_arn", custom_domain_certificate_arn)
        if custom_domain_certificate_expiry_time is not None:
            pulumi.set(__self__, "custom_domain_certificate_expiry_time", custom_domain_certificate_expiry_time)
        if custom_domain_name is not None:
            pulumi.set(__self__, "custom_domain_name", custom_domain_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if workgroup_name is not None:
            pulumi.set(__self__, "workgroup_name", workgroup_name)

    @property
    @pulumi.getter(name="customDomainCertificateArn")
    def custom_domain_certificate_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the certificate for the custom domain association.
        """
        return pulumi.get(self, "custom_domain_certificate_arn")

    @custom_domain_certificate_arn.setter
    def custom_domain_certificate_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_domain_certificate_arn", value)

    @property
    @pulumi.getter(name="customDomainCertificateExpiryTime")
    def custom_domain_certificate_expiry_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Expiration time for the certificate.
        """
        return pulumi.get(self, "custom_domain_certificate_expiry_time")

    @custom_domain_certificate_expiry_time.setter
    def custom_domain_certificate_expiry_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_domain_certificate_expiry_time", value)

    @property
    @pulumi.getter(name="customDomainName")
    def custom_domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Custom domain to associate with the workgroup.
        """
        return pulumi.get(self, "custom_domain_name")

    @custom_domain_name.setter
    def custom_domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_domain_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the workgroup.
        """
        return pulumi.get(self, "workgroup_name")

    @workgroup_name.setter
    def workgroup_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workgroup_name", value)


@pulumi.type_token("aws:redshiftserverless/customDomainAssociation:CustomDomainAssociation")
class CustomDomainAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_domain_certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
                 custom_domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 workgroup_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Redshift Serverless Custom Domain Association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.acm.Certificate("example", domain_name="example.com")
        example_namespace = aws.redshiftserverless.Namespace("example", namespace_name="example-namespace")
        example_workgroup = aws.redshiftserverless.Workgroup("example",
            workgroup_name="example-workgroup",
            namespace_name=example_namespace.namespace_name)
        example_custom_domain_association = aws.redshiftserverless.CustomDomainAssociation("example",
            workgroup_name=example_workgroup.workgroup_name,
            custom_domain_name="example.com",
            custom_domain_certificate_arn=example.arn)
        ```

        ## Import

        Using `pulumi import`, import Redshift Serverless Custom Domain Association using the `workgroup_name` and `custom_domain_name`, separated by the coma. For example:

        ```sh
        $ pulumi import aws:redshiftserverless/customDomainAssociation:CustomDomainAssociation example example-workgroup,example.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] custom_domain_certificate_arn: ARN of the certificate for the custom domain association.
        :param pulumi.Input[builtins.str] custom_domain_name: Custom domain to associate with the workgroup.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] workgroup_name: Name of the workgroup.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomDomainAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Redshift Serverless Custom Domain Association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.acm.Certificate("example", domain_name="example.com")
        example_namespace = aws.redshiftserverless.Namespace("example", namespace_name="example-namespace")
        example_workgroup = aws.redshiftserverless.Workgroup("example",
            workgroup_name="example-workgroup",
            namespace_name=example_namespace.namespace_name)
        example_custom_domain_association = aws.redshiftserverless.CustomDomainAssociation("example",
            workgroup_name=example_workgroup.workgroup_name,
            custom_domain_name="example.com",
            custom_domain_certificate_arn=example.arn)
        ```

        ## Import

        Using `pulumi import`, import Redshift Serverless Custom Domain Association using the `workgroup_name` and `custom_domain_name`, separated by the coma. For example:

        ```sh
        $ pulumi import aws:redshiftserverless/customDomainAssociation:CustomDomainAssociation example example-workgroup,example.com
        ```

        :param str resource_name: The name of the resource.
        :param CustomDomainAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomDomainAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_domain_certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
                 custom_domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 workgroup_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomDomainAssociationArgs.__new__(CustomDomainAssociationArgs)

            if custom_domain_certificate_arn is None and not opts.urn:
                raise TypeError("Missing required property 'custom_domain_certificate_arn'")
            __props__.__dict__["custom_domain_certificate_arn"] = custom_domain_certificate_arn
            if custom_domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'custom_domain_name'")
            __props__.__dict__["custom_domain_name"] = custom_domain_name
            __props__.__dict__["region"] = region
            if workgroup_name is None and not opts.urn:
                raise TypeError("Missing required property 'workgroup_name'")
            __props__.__dict__["workgroup_name"] = workgroup_name
            __props__.__dict__["custom_domain_certificate_expiry_time"] = None
        super(CustomDomainAssociation, __self__).__init__(
            'aws:redshiftserverless/customDomainAssociation:CustomDomainAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_domain_certificate_arn: Optional[pulumi.Input[builtins.str]] = None,
            custom_domain_certificate_expiry_time: Optional[pulumi.Input[builtins.str]] = None,
            custom_domain_name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            workgroup_name: Optional[pulumi.Input[builtins.str]] = None) -> 'CustomDomainAssociation':
        """
        Get an existing CustomDomainAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] custom_domain_certificate_arn: ARN of the certificate for the custom domain association.
        :param pulumi.Input[builtins.str] custom_domain_certificate_expiry_time: Expiration time for the certificate.
        :param pulumi.Input[builtins.str] custom_domain_name: Custom domain to associate with the workgroup.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] workgroup_name: Name of the workgroup.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomDomainAssociationState.__new__(_CustomDomainAssociationState)

        __props__.__dict__["custom_domain_certificate_arn"] = custom_domain_certificate_arn
        __props__.__dict__["custom_domain_certificate_expiry_time"] = custom_domain_certificate_expiry_time
        __props__.__dict__["custom_domain_name"] = custom_domain_name
        __props__.__dict__["region"] = region
        __props__.__dict__["workgroup_name"] = workgroup_name
        return CustomDomainAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customDomainCertificateArn")
    def custom_domain_certificate_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the certificate for the custom domain association.
        """
        return pulumi.get(self, "custom_domain_certificate_arn")

    @property
    @pulumi.getter(name="customDomainCertificateExpiryTime")
    def custom_domain_certificate_expiry_time(self) -> pulumi.Output[builtins.str]:
        """
        Expiration time for the certificate.
        """
        return pulumi.get(self, "custom_domain_certificate_expiry_time")

    @property
    @pulumi.getter(name="customDomainName")
    def custom_domain_name(self) -> pulumi.Output[builtins.str]:
        """
        Custom domain to associate with the workgroup.
        """
        return pulumi.get(self, "custom_domain_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the workgroup.
        """
        return pulumi.get(self, "workgroup_name")

