# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'IndexTimeouts',
    'SearchResourceResult',
    'SearchResourceCountResult',
    'SearchResourcePropertyResult',
    'ViewFilters',
    'ViewIncludedProperty',
]

@pulumi.output_type
class IndexTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class SearchResourceResult(dict):
    def __init__(__self__, *,
                 arn: builtins.str,
                 last_reported_at: builtins.str,
                 owning_account_id: builtins.str,
                 properties: Sequence['outputs.SearchResourcePropertyResult'],
                 region: builtins.str,
                 resource_type: builtins.str,
                 service: builtins.str):
        """
        :param builtins.str arn: Amazon resource name of resource.
        :param builtins.str last_reported_at: The date and time that the information about this resource property was last updated.
        :param builtins.str owning_account_id: Amazon Web Services account that owns the resource.
        :param Sequence['SearchResourcePropertyArgs'] properties: Structure with additional type-specific details about the resource.  See `properties` below.
        :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param builtins.str resource_type: Type of the resource.
        :param builtins.str service: Amazon Web Service that owns the resource and is responsible for creating and updating it.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "last_reported_at", last_reported_at)
        pulumi.set(__self__, "owning_account_id", owning_account_id)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        Amazon resource name of resource.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="lastReportedAt")
    def last_reported_at(self) -> builtins.str:
        """
        The date and time that the information about this resource property was last updated.
        """
        return pulumi.get(self, "last_reported_at")

    @property
    @pulumi.getter(name="owningAccountId")
    def owning_account_id(self) -> builtins.str:
        """
        Amazon Web Services account that owns the resource.
        """
        return pulumi.get(self, "owning_account_id")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.SearchResourcePropertyResult']:
        """
        Structure with additional type-specific details about the resource.  See `properties` below.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def service(self) -> builtins.str:
        """
        Amazon Web Service that owns the resource and is responsible for creating and updating it.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class SearchResourceCountResult(dict):
    def __init__(__self__, *,
                 complete: builtins.bool,
                 total_resources: builtins.int):
        """
        :param builtins.bool complete: Indicates whether the TotalResources value represents an exhaustive count of search results. If True, it indicates that the search was exhaustive. Every resource that matches the query was counted. If False, then the search reached the limit of 1,000 matching results, and stopped counting.
        :param builtins.int total_resources: Number of resources that match the search query. This value can't exceed 1,000. If there are more than 1,000 resources that match the query, then only 1,000 are counted and the Complete field is set to false. We recommend that you refine your query to return a smaller number of results.
        """
        pulumi.set(__self__, "complete", complete)
        pulumi.set(__self__, "total_resources", total_resources)

    @property
    @pulumi.getter
    def complete(self) -> builtins.bool:
        """
        Indicates whether the TotalResources value represents an exhaustive count of search results. If True, it indicates that the search was exhaustive. Every resource that matches the query was counted. If False, then the search reached the limit of 1,000 matching results, and stopped counting.
        """
        return pulumi.get(self, "complete")

    @property
    @pulumi.getter(name="totalResources")
    def total_resources(self) -> builtins.int:
        """
        Number of resources that match the search query. This value can't exceed 1,000. If there are more than 1,000 resources that match the query, then only 1,000 are counted and the Complete field is set to false. We recommend that you refine your query to return a smaller number of results.
        """
        return pulumi.get(self, "total_resources")


@pulumi.output_type
class SearchResourcePropertyResult(dict):
    def __init__(__self__, *,
                 data: builtins.str,
                 last_reported_at: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str data: Details about this property. The content of this field is a JSON object that varies based on the resource type.
        :param builtins.str last_reported_at: The date and time that the information about this resource property was last updated.
        :param builtins.str name: Name of this property of the resource.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "last_reported_at", last_reported_at)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def data(self) -> builtins.str:
        """
        Details about this property. The content of this field is a JSON object that varies based on the resource type.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="lastReportedAt")
    def last_reported_at(self) -> builtins.str:
        """
        The date and time that the information about this resource property was last updated.
        """
        return pulumi.get(self, "last_reported_at")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of this property of the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ViewFilters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterString":
            suggest = "filter_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ViewFilters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ViewFilters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ViewFilters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_string: builtins.str):
        """
        :param builtins.str filter_string: The string that contains the search keywords, prefixes, and operators to control the results that can be returned by a search operation. For more details, see [Search query syntax](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html).
        """
        pulumi.set(__self__, "filter_string", filter_string)

    @property
    @pulumi.getter(name="filterString")
    def filter_string(self) -> builtins.str:
        """
        The string that contains the search keywords, prefixes, and operators to control the results that can be returned by a search operation. For more details, see [Search query syntax](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html).
        """
        return pulumi.get(self, "filter_string")


@pulumi.output_type
class ViewIncludedProperty(dict):
    def __init__(__self__, *,
                 name: builtins.str):
        """
        :param builtins.str name: The name of the property that is included in this view. Valid values: `tags`.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the property that is included in this view. Valid values: `tags`.
        """
        return pulumi.get(self, "name")


