# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetQueryLogConfigResult',
    'AwaitableGetQueryLogConfigResult',
    'get_query_log_config',
    'get_query_log_config_output',
]

@pulumi.output_type
class GetQueryLogConfigResult:
    """
    A collection of values returned by getQueryLogConfig.
    """
    def __init__(__self__, arn=None, destination_arn=None, filters=None, id=None, name=None, owner_id=None, region=None, resolver_query_log_config_id=None, share_status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if destination_arn and not isinstance(destination_arn, str):
            raise TypeError("Expected argument 'destination_arn' to be a str")
        pulumi.set(__self__, "destination_arn", destination_arn)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resolver_query_log_config_id and not isinstance(resolver_query_log_config_id, str):
            raise TypeError("Expected argument 'resolver_query_log_config_id' to be a str")
        pulumi.set(__self__, "resolver_query_log_config_id", resolver_query_log_config_id)
        if share_status and not isinstance(share_status, str):
            raise TypeError("Expected argument 'share_status' to be a str")
        pulumi.set(__self__, "share_status", share_status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        Computed ARN of the Route53 Resolver Query Logging Configuration.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> builtins.str:
        """
        The ARN of the resource that you want Resolver to send query logs: an Amazon S3 bucket, a CloudWatch Logs log group or a Kinesis Data Firehose delivery stream.
        """
        return pulumi.get(self, "destination_arn")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetQueryLogConfigFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the query logging configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> builtins.str:
        """
        The AWS account ID for the account that created the query logging configuration.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resolverQueryLogConfigId")
    def resolver_query_log_config_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resolver_query_log_config_id")

    @property
    @pulumi.getter(name="shareStatus")
    def share_status(self) -> builtins.str:
        """
        An indication of whether the query logging configuration is shared with other AWS accounts or was shared with the current account by another AWS account.
        """
        return pulumi.get(self, "share_status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Map of tags to assign to the service.
        """
        return pulumi.get(self, "tags")


class AwaitableGetQueryLogConfigResult(GetQueryLogConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueryLogConfigResult(
            arn=self.arn,
            destination_arn=self.destination_arn,
            filters=self.filters,
            id=self.id,
            name=self.name,
            owner_id=self.owner_id,
            region=self.region,
            resolver_query_log_config_id=self.resolver_query_log_config_id,
            share_status=self.share_status,
            tags=self.tags)


def get_query_log_config(filters: Optional[Sequence[Union['GetQueryLogConfigFilterArgs', 'GetQueryLogConfigFilterArgsDict']]] = None,
                         name: Optional[builtins.str] = None,
                         region: Optional[builtins.str] = None,
                         resolver_query_log_config_id: Optional[builtins.str] = None,
                         tags: Optional[Mapping[str, builtins.str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueryLogConfigResult:
    """
    `route53.ResolverQueryLogConfig` provides details about a specific Route53 Resolver Query Logging Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_query_log_config(resolver_query_log_config_id="rqlc-1abc2345ef678g91h")
    ```

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_query_log_config(filters=[
        {
            "name": "Name",
            "values": ["shared-query-log-config"],
        },
        {
            "name": "ShareStatus",
            "values": ["SHARED_WITH_ME"],
        },
    ])
    ```


    :param Sequence[Union['GetQueryLogConfigFilterArgs', 'GetQueryLogConfigFilterArgsDict']] filters: One or more name/value pairs to use as filters. There are
           several valid keys, for a full reference, check out
           [Route53resolver Filter value in the AWS API reference][1].
    :param builtins.str name: The name of the query logging configuration.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str resolver_query_log_config_id: ID of the Route53 Resolver Query Logging Configuration.
    :param Mapping[str, builtins.str] tags: Map of tags to assign to the service.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['region'] = region
    __args__['resolverQueryLogConfigId'] = resolver_query_log_config_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:route53/getQueryLogConfig:getQueryLogConfig', __args__, opts=opts, typ=GetQueryLogConfigResult).value

    return AwaitableGetQueryLogConfigResult(
        arn=pulumi.get(__ret__, 'arn'),
        destination_arn=pulumi.get(__ret__, 'destination_arn'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        region=pulumi.get(__ret__, 'region'),
        resolver_query_log_config_id=pulumi.get(__ret__, 'resolver_query_log_config_id'),
        share_status=pulumi.get(__ret__, 'share_status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_query_log_config_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetQueryLogConfigFilterArgs', 'GetQueryLogConfigFilterArgsDict']]]]] = None,
                                name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                resolver_query_log_config_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetQueryLogConfigResult]:
    """
    `route53.ResolverQueryLogConfig` provides details about a specific Route53 Resolver Query Logging Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_query_log_config(resolver_query_log_config_id="rqlc-1abc2345ef678g91h")
    ```

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_query_log_config(filters=[
        {
            "name": "Name",
            "values": ["shared-query-log-config"],
        },
        {
            "name": "ShareStatus",
            "values": ["SHARED_WITH_ME"],
        },
    ])
    ```


    :param Sequence[Union['GetQueryLogConfigFilterArgs', 'GetQueryLogConfigFilterArgsDict']] filters: One or more name/value pairs to use as filters. There are
           several valid keys, for a full reference, check out
           [Route53resolver Filter value in the AWS API reference][1].
    :param builtins.str name: The name of the query logging configuration.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str resolver_query_log_config_id: ID of the Route53 Resolver Query Logging Configuration.
    :param Mapping[str, builtins.str] tags: Map of tags to assign to the service.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['region'] = region
    __args__['resolverQueryLogConfigId'] = resolver_query_log_config_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:route53/getQueryLogConfig:getQueryLogConfig', __args__, opts=opts, typ=GetQueryLogConfigResult)
    return __ret__.apply(lambda __response__: GetQueryLogConfigResult(
        arn=pulumi.get(__response__, 'arn'),
        destination_arn=pulumi.get(__response__, 'destination_arn'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        region=pulumi.get(__response__, 'region'),
        resolver_query_log_config_id=pulumi.get(__response__, 'resolver_query_log_config_id'),
        share_status=pulumi.get(__response__, 'share_status'),
        tags=pulumi.get(__response__, 'tags')))
