# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRecordsResult',
    'AwaitableGetRecordsResult',
    'get_records',
    'get_records_output',
]

@pulumi.output_type
class GetRecordsResult:
    """
    A collection of values returned by getRecords.
    """
    def __init__(__self__, id=None, name_regex=None, resource_record_sets=None, zone_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if resource_record_sets and not isinstance(resource_record_sets, list):
            raise TypeError("Expected argument 'resource_record_sets' to be a list")
        pulumi.set(__self__, "resource_record_sets", resource_record_sets)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="resourceRecordSets")
    def resource_record_sets(self) -> Sequence['outputs.GetRecordsResourceRecordSetResult']:
        """
        The resource records sets.
        """
        return pulumi.get(self, "resource_record_sets")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        return pulumi.get(self, "zone_id")


class AwaitableGetRecordsResult(GetRecordsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRecordsResult(
            id=self.id,
            name_regex=self.name_regex,
            resource_record_sets=self.resource_record_sets,
            zone_id=self.zone_id)


def get_records(name_regex: Optional[builtins.str] = None,
                zone_id: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRecordsResult:
    """
    Use this data source to get the details of resource records in a Route 53 hosted zone.

    ## Example Usage

    ### Basic Usage

    Return all records in the zone.

    ```python
    import pulumi
    import pulumi_aws as aws

    selected = aws.route53.get_zone(name="test.com.",
        private_zone=True)
    example = aws.route53.get_records(zone_id=selected.zone_id)
    ```

    ### Basic Usage with filter

    Return the records that starts with `www`.

    ```python
    import pulumi
    import pulumi_aws as aws

    selected = aws.route53.get_zone(name="test.com.",
        private_zone=True)
    example = aws.route53.get_records(zone_id=selected.zone_id,
        name_regex="^www")
    ```


    :param builtins.str name_regex: Regex string to apply to the resource record names returned by AWS.
    :param builtins.str zone_id: The ID of the hosted zone that contains the resource record sets that you want to list.
    """
    __args__ = dict()
    __args__['nameRegex'] = name_regex
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:route53/getRecords:getRecords', __args__, opts=opts, typ=GetRecordsResult).value

    return AwaitableGetRecordsResult(
        id=pulumi.get(__ret__, 'id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        resource_record_sets=pulumi.get(__ret__, 'resource_record_sets'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_records_output(name_regex: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       zone_id: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRecordsResult]:
    """
    Use this data source to get the details of resource records in a Route 53 hosted zone.

    ## Example Usage

    ### Basic Usage

    Return all records in the zone.

    ```python
    import pulumi
    import pulumi_aws as aws

    selected = aws.route53.get_zone(name="test.com.",
        private_zone=True)
    example = aws.route53.get_records(zone_id=selected.zone_id)
    ```

    ### Basic Usage with filter

    Return the records that starts with `www`.

    ```python
    import pulumi
    import pulumi_aws as aws

    selected = aws.route53.get_zone(name="test.com.",
        private_zone=True)
    example = aws.route53.get_records(zone_id=selected.zone_id,
        name_regex="^www")
    ```


    :param builtins.str name_regex: Regex string to apply to the resource record names returned by AWS.
    :param builtins.str zone_id: The ID of the hosted zone that contains the resource record sets that you want to list.
    """
    __args__ = dict()
    __args__['nameRegex'] = name_regex
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:route53/getRecords:getRecords', __args__, opts=opts, typ=GetRecordsResult)
    return __ret__.apply(lambda __response__: GetRecordsResult(
        id=pulumi.get(__response__, 'id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        resource_record_sets=pulumi.get(__response__, 'resource_record_sets'),
        zone_id=pulumi.get(__response__, 'zone_id')))
