# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetResolverRulesResult',
    'AwaitableGetResolverRulesResult',
    'get_resolver_rules',
    'get_resolver_rules_output',
]

@pulumi.output_type
class GetResolverRulesResult:
    """
    A collection of values returned by getResolverRules.
    """
    def __init__(__self__, id=None, name_regex=None, owner_id=None, region=None, resolver_endpoint_id=None, resolver_rule_ids=None, rule_type=None, share_status=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resolver_endpoint_id and not isinstance(resolver_endpoint_id, str):
            raise TypeError("Expected argument 'resolver_endpoint_id' to be a str")
        pulumi.set(__self__, "resolver_endpoint_id", resolver_endpoint_id)
        if resolver_rule_ids and not isinstance(resolver_rule_ids, list):
            raise TypeError("Expected argument 'resolver_rule_ids' to be a list")
        pulumi.set(__self__, "resolver_rule_ids", resolver_rule_ids)
        if rule_type and not isinstance(rule_type, str):
            raise TypeError("Expected argument 'rule_type' to be a str")
        pulumi.set(__self__, "rule_type", rule_type)
        if share_status and not isinstance(share_status, str):
            raise TypeError("Expected argument 'share_status' to be a str")
        pulumi.set(__self__, "share_status", share_status)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resolverEndpointId")
    def resolver_endpoint_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resolver_endpoint_id")

    @property
    @pulumi.getter(name="resolverRuleIds")
    def resolver_rule_ids(self) -> Sequence[builtins.str]:
        """
        IDs of the matched resolver rules.
        """
        return pulumi.get(self, "resolver_rule_ids")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter(name="shareStatus")
    def share_status(self) -> Optional[builtins.str]:
        return pulumi.get(self, "share_status")


class AwaitableGetResolverRulesResult(GetResolverRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResolverRulesResult(
            id=self.id,
            name_regex=self.name_regex,
            owner_id=self.owner_id,
            region=self.region,
            resolver_endpoint_id=self.resolver_endpoint_id,
            resolver_rule_ids=self.resolver_rule_ids,
            rule_type=self.rule_type,
            share_status=self.share_status)


def get_resolver_rules(name_regex: Optional[builtins.str] = None,
                       owner_id: Optional[builtins.str] = None,
                       region: Optional[builtins.str] = None,
                       resolver_endpoint_id: Optional[builtins.str] = None,
                       rule_type: Optional[builtins.str] = None,
                       share_status: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResolverRulesResult:
    """
    `route53_get_resolver_rules` provides details about a set of Route53 Resolver rules.

    ## Example Usage

    ### Retrieving the default resolver rule

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_resolver_rules(owner_id="Route 53 Resolver",
        rule_type="RECURSIVE",
        share_status="NOT_SHARED")
    ```

    ### Retrieving forward rules shared with me

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_resolver_rules(rule_type="FORWARD",
        share_status="SHARED_WITH_ME")
    ```

    ### Retrieving rules by name regex

    Resolver rules whose name contains `abc`.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_resolver_rules(name_regex=".*abc.*")
    ```


    :param builtins.str name_regex: Regex string to filter resolver rule names.
           The filtering is done locally, so could have a performance impact if the result is large.
           This argument should be used along with other arguments to limit the number of results returned.
    :param builtins.str owner_id: When the desired resolver rules are shared with another AWS account, the account ID of the account that the rules are shared with.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str resolver_endpoint_id: ID of the outbound resolver endpoint for the desired resolver rules.
    :param builtins.str rule_type: Rule type of the desired resolver rules. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`.
    :param builtins.str share_status: Whether the desired resolver rules are shared and, if so, whether the current account is sharing the rules with another account, or another account is sharing the rules with the current account. Valid values are `NOT_SHARED`, `SHARED_BY_ME` or `SHARED_WITH_ME`
    """
    __args__ = dict()
    __args__['nameRegex'] = name_regex
    __args__['ownerId'] = owner_id
    __args__['region'] = region
    __args__['resolverEndpointId'] = resolver_endpoint_id
    __args__['ruleType'] = rule_type
    __args__['shareStatus'] = share_status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:route53/getResolverRules:getResolverRules', __args__, opts=opts, typ=GetResolverRulesResult).value

    return AwaitableGetResolverRulesResult(
        id=pulumi.get(__ret__, 'id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        region=pulumi.get(__ret__, 'region'),
        resolver_endpoint_id=pulumi.get(__ret__, 'resolver_endpoint_id'),
        resolver_rule_ids=pulumi.get(__ret__, 'resolver_rule_ids'),
        rule_type=pulumi.get(__ret__, 'rule_type'),
        share_status=pulumi.get(__ret__, 'share_status'))
def get_resolver_rules_output(name_regex: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              owner_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              resolver_endpoint_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              rule_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              share_status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResolverRulesResult]:
    """
    `route53_get_resolver_rules` provides details about a set of Route53 Resolver rules.

    ## Example Usage

    ### Retrieving the default resolver rule

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_resolver_rules(owner_id="Route 53 Resolver",
        rule_type="RECURSIVE",
        share_status="NOT_SHARED")
    ```

    ### Retrieving forward rules shared with me

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_resolver_rules(rule_type="FORWARD",
        share_status="SHARED_WITH_ME")
    ```

    ### Retrieving rules by name regex

    Resolver rules whose name contains `abc`.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_resolver_rules(name_regex=".*abc.*")
    ```


    :param builtins.str name_regex: Regex string to filter resolver rule names.
           The filtering is done locally, so could have a performance impact if the result is large.
           This argument should be used along with other arguments to limit the number of results returned.
    :param builtins.str owner_id: When the desired resolver rules are shared with another AWS account, the account ID of the account that the rules are shared with.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str resolver_endpoint_id: ID of the outbound resolver endpoint for the desired resolver rules.
    :param builtins.str rule_type: Rule type of the desired resolver rules. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`.
    :param builtins.str share_status: Whether the desired resolver rules are shared and, if so, whether the current account is sharing the rules with another account, or another account is sharing the rules with the current account. Valid values are `NOT_SHARED`, `SHARED_BY_ME` or `SHARED_WITH_ME`
    """
    __args__ = dict()
    __args__['nameRegex'] = name_regex
    __args__['ownerId'] = owner_id
    __args__['region'] = region
    __args__['resolverEndpointId'] = resolver_endpoint_id
    __args__['ruleType'] = rule_type
    __args__['shareStatus'] = share_status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:route53/getResolverRules:getResolverRules', __args__, opts=opts, typ=GetResolverRulesResult)
    return __ret__.apply(lambda __response__: GetResolverRulesResult(
        id=pulumi.get(__response__, 'id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        region=pulumi.get(__response__, 'region'),
        resolver_endpoint_id=pulumi.get(__response__, 'resolver_endpoint_id'),
        resolver_rule_ids=pulumi.get(__response__, 'resolver_rule_ids'),
        rule_type=pulumi.get(__response__, 'rule_type'),
        share_status=pulumi.get(__response__, 'share_status')))
