# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RecordsExclusiveArgs', 'RecordsExclusive']

@pulumi.input_type
class RecordsExclusiveArgs:
    def __init__(__self__, *,
                 zone_id: pulumi.Input[builtins.str],
                 resource_record_sets: Optional[pulumi.Input[Sequence[pulumi.Input['RecordsExclusiveResourceRecordSetArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['RecordsExclusiveTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a RecordsExclusive resource.
        :param pulumi.Input[builtins.str] zone_id: ID of the hosted zone containing the resource record sets.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['RecordsExclusiveResourceRecordSetArgs']]] resource_record_sets: A list of all resource record sets associated with the hosted zone.
               See `resource_record_set` below.
        """
        pulumi.set(__self__, "zone_id", zone_id)
        if resource_record_sets is not None:
            pulumi.set(__self__, "resource_record_sets", resource_record_sets)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the hosted zone containing the resource record sets.

        The following arguments are optional:
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="resourceRecordSets")
    def resource_record_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordsExclusiveResourceRecordSetArgs']]]]:
        """
        A list of all resource record sets associated with the hosted zone.
        See `resource_record_set` below.
        """
        return pulumi.get(self, "resource_record_sets")

    @resource_record_sets.setter
    def resource_record_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordsExclusiveResourceRecordSetArgs']]]]):
        pulumi.set(self, "resource_record_sets", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RecordsExclusiveTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RecordsExclusiveTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _RecordsExclusiveState:
    def __init__(__self__, *,
                 resource_record_sets: Optional[pulumi.Input[Sequence[pulumi.Input['RecordsExclusiveResourceRecordSetArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['RecordsExclusiveTimeoutsArgs']] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RecordsExclusive resources.
        :param pulumi.Input[Sequence[pulumi.Input['RecordsExclusiveResourceRecordSetArgs']]] resource_record_sets: A list of all resource record sets associated with the hosted zone.
               See `resource_record_set` below.
        :param pulumi.Input[builtins.str] zone_id: ID of the hosted zone containing the resource record sets.
               
               The following arguments are optional:
        """
        if resource_record_sets is not None:
            pulumi.set(__self__, "resource_record_sets", resource_record_sets)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="resourceRecordSets")
    def resource_record_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordsExclusiveResourceRecordSetArgs']]]]:
        """
        A list of all resource record sets associated with the hosted zone.
        See `resource_record_set` below.
        """
        return pulumi.get(self, "resource_record_sets")

    @resource_record_sets.setter
    def resource_record_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordsExclusiveResourceRecordSetArgs']]]]):
        pulumi.set(self, "resource_record_sets", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RecordsExclusiveTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RecordsExclusiveTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the hosted zone containing the resource record sets.

        The following arguments are optional:
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("aws:route53/recordsExclusive:RecordsExclusive")
class RecordsExclusive(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_record_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecordsExclusiveResourceRecordSetArgs', 'RecordsExclusiveResourceRecordSetArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['RecordsExclusiveTimeoutsArgs', 'RecordsExclusiveTimeoutsArgsDict']]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Using `pulumi import`, import Route 53 Records Exclusive using the `zone_id`. For example:

        ```sh
        $ pulumi import aws:route53/recordsExclusive:RecordsExclusive example ABCD1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RecordsExclusiveResourceRecordSetArgs', 'RecordsExclusiveResourceRecordSetArgsDict']]]] resource_record_sets: A list of all resource record sets associated with the hosted zone.
               See `resource_record_set` below.
        :param pulumi.Input[builtins.str] zone_id: ID of the hosted zone containing the resource record sets.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecordsExclusiveArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Using `pulumi import`, import Route 53 Records Exclusive using the `zone_id`. For example:

        ```sh
        $ pulumi import aws:route53/recordsExclusive:RecordsExclusive example ABCD1234
        ```

        :param str resource_name: The name of the resource.
        :param RecordsExclusiveArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecordsExclusiveArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_record_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecordsExclusiveResourceRecordSetArgs', 'RecordsExclusiveResourceRecordSetArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['RecordsExclusiveTimeoutsArgs', 'RecordsExclusiveTimeoutsArgsDict']]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecordsExclusiveArgs.__new__(RecordsExclusiveArgs)

            __props__.__dict__["resource_record_sets"] = resource_record_sets
            __props__.__dict__["timeouts"] = timeouts
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(RecordsExclusive, __self__).__init__(
            'aws:route53/recordsExclusive:RecordsExclusive',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            resource_record_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RecordsExclusiveResourceRecordSetArgs', 'RecordsExclusiveResourceRecordSetArgsDict']]]]] = None,
            timeouts: Optional[pulumi.Input[Union['RecordsExclusiveTimeoutsArgs', 'RecordsExclusiveTimeoutsArgsDict']]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'RecordsExclusive':
        """
        Get an existing RecordsExclusive resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RecordsExclusiveResourceRecordSetArgs', 'RecordsExclusiveResourceRecordSetArgsDict']]]] resource_record_sets: A list of all resource record sets associated with the hosted zone.
               See `resource_record_set` below.
        :param pulumi.Input[builtins.str] zone_id: ID of the hosted zone containing the resource record sets.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecordsExclusiveState.__new__(_RecordsExclusiveState)

        __props__.__dict__["resource_record_sets"] = resource_record_sets
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["zone_id"] = zone_id
        return RecordsExclusive(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="resourceRecordSets")
    def resource_record_sets(self) -> pulumi.Output[Optional[Sequence['outputs.RecordsExclusiveResourceRecordSet']]]:
        """
        A list of all resource record sets associated with the hosted zone.
        See `resource_record_set` below.
        """
        return pulumi.get(self, "resource_record_sets")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.RecordsExclusiveTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the hosted zone containing the resource record sets.

        The following arguments are optional:
        """
        return pulumi.get(self, "zone_id")

