# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[builtins.str],
                 admin_contact: Optional[pulumi.Input['DomainAdminContactArgs']] = None,
                 admin_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[builtins.bool]] = None,
                 billing_contacts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainBillingContactArgs']]]] = None,
                 billing_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 duration_in_years: Optional[pulumi.Input[builtins.int]] = None,
                 name_servers: Optional[pulumi.Input[Sequence[pulumi.Input['DomainNameServerArgs']]]] = None,
                 registrant_contact: Optional[pulumi.Input['DomainRegistrantContactArgs']] = None,
                 registrant_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tech_contact: Optional[pulumi.Input['DomainTechContactArgs']] = None,
                 tech_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input['DomainTimeoutsArgs']] = None,
                 transfer_lock: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[builtins.str] domain_name: The name of the domain.
        :param pulumi.Input['DomainAdminContactArgs'] admin_contact: Details about the domain administrative contact. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] admin_privacy: Whether domain administrative contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[builtins.bool] auto_renew: Whether the domain registration is set to renew automatically. Default: `true`.
        :param pulumi.Input[Sequence[pulumi.Input['DomainBillingContactArgs']]] billing_contacts: Details about the domain billing contact. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] billing_privacy: Whether domain billing contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[builtins.int] duration_in_years: The number of years that you want to register the domain for. Domains are registered for a minimum of one year. Increasing the duration renews the domain.
        :param pulumi.Input[Sequence[pulumi.Input['DomainNameServerArgs']]] name_servers: The list of nameservers for the domain. See `name_server` Blocks for more details.
        :param pulumi.Input['DomainRegistrantContactArgs'] registrant_contact: Details about the domain registrant. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] registrant_privacy: Whether domain registrant contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['DomainTechContactArgs'] tech_contact: Details about the domain technical contact. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] tech_privacy: Whether domain technical contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[builtins.bool] transfer_lock: Whether the domain is locked for transfer. Default: `true`.
               
               > **NOTE:** You must specify the same privacy setting for `admin_privacy`, `registrant_privacy` and `tech_privacy`.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if admin_contact is not None:
            pulumi.set(__self__, "admin_contact", admin_contact)
        if admin_privacy is not None:
            pulumi.set(__self__, "admin_privacy", admin_privacy)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if billing_contacts is not None:
            pulumi.set(__self__, "billing_contacts", billing_contacts)
        if billing_privacy is not None:
            pulumi.set(__self__, "billing_privacy", billing_privacy)
        if duration_in_years is not None:
            pulumi.set(__self__, "duration_in_years", duration_in_years)
        if name_servers is not None:
            pulumi.set(__self__, "name_servers", name_servers)
        if registrant_contact is not None:
            pulumi.set(__self__, "registrant_contact", registrant_contact)
        if registrant_privacy is not None:
            pulumi.set(__self__, "registrant_privacy", registrant_privacy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tech_contact is not None:
            pulumi.set(__self__, "tech_contact", tech_contact)
        if tech_privacy is not None:
            pulumi.set(__self__, "tech_privacy", tech_privacy)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if transfer_lock is not None:
            pulumi.set(__self__, "transfer_lock", transfer_lock)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="adminContact")
    def admin_contact(self) -> Optional[pulumi.Input['DomainAdminContactArgs']]:
        """
        Details about the domain administrative contact. See Contact Blocks for more details.
        """
        return pulumi.get(self, "admin_contact")

    @admin_contact.setter
    def admin_contact(self, value: Optional[pulumi.Input['DomainAdminContactArgs']]):
        pulumi.set(self, "admin_contact", value)

    @property
    @pulumi.getter(name="adminPrivacy")
    def admin_privacy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether domain administrative contact information is concealed from WHOIS queries. Default: `true`.
        """
        return pulumi.get(self, "admin_privacy")

    @admin_privacy.setter
    def admin_privacy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "admin_privacy", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the domain registration is set to renew automatically. Default: `true`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="billingContacts")
    def billing_contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainBillingContactArgs']]]]:
        """
        Details about the domain billing contact. See Contact Blocks for more details.
        """
        return pulumi.get(self, "billing_contacts")

    @billing_contacts.setter
    def billing_contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainBillingContactArgs']]]]):
        pulumi.set(self, "billing_contacts", value)

    @property
    @pulumi.getter(name="billingPrivacy")
    def billing_privacy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether domain billing contact information is concealed from WHOIS queries. Default: `true`.
        """
        return pulumi.get(self, "billing_privacy")

    @billing_privacy.setter
    def billing_privacy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "billing_privacy", value)

    @property
    @pulumi.getter(name="durationInYears")
    def duration_in_years(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of years that you want to register the domain for. Domains are registered for a minimum of one year. Increasing the duration renews the domain.
        """
        return pulumi.get(self, "duration_in_years")

    @duration_in_years.setter
    def duration_in_years(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "duration_in_years", value)

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainNameServerArgs']]]]:
        """
        The list of nameservers for the domain. See `name_server` Blocks for more details.
        """
        return pulumi.get(self, "name_servers")

    @name_servers.setter
    def name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainNameServerArgs']]]]):
        pulumi.set(self, "name_servers", value)

    @property
    @pulumi.getter(name="registrantContact")
    def registrant_contact(self) -> Optional[pulumi.Input['DomainRegistrantContactArgs']]:
        """
        Details about the domain registrant. See Contact Blocks for more details.
        """
        return pulumi.get(self, "registrant_contact")

    @registrant_contact.setter
    def registrant_contact(self, value: Optional[pulumi.Input['DomainRegistrantContactArgs']]):
        pulumi.set(self, "registrant_contact", value)

    @property
    @pulumi.getter(name="registrantPrivacy")
    def registrant_privacy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether domain registrant contact information is concealed from WHOIS queries. Default: `true`.
        """
        return pulumi.get(self, "registrant_privacy")

    @registrant_privacy.setter
    def registrant_privacy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "registrant_privacy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="techContact")
    def tech_contact(self) -> Optional[pulumi.Input['DomainTechContactArgs']]:
        """
        Details about the domain technical contact. See Contact Blocks for more details.
        """
        return pulumi.get(self, "tech_contact")

    @tech_contact.setter
    def tech_contact(self, value: Optional[pulumi.Input['DomainTechContactArgs']]):
        pulumi.set(self, "tech_contact", value)

    @property
    @pulumi.getter(name="techPrivacy")
    def tech_privacy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether domain technical contact information is concealed from WHOIS queries. Default: `true`.
        """
        return pulumi.get(self, "tech_privacy")

    @tech_privacy.setter
    def tech_privacy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tech_privacy", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DomainTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DomainTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="transferLock")
    def transfer_lock(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the domain is locked for transfer. Default: `true`.

        > **NOTE:** You must specify the same privacy setting for `admin_privacy`, `registrant_privacy` and `tech_privacy`.
        """
        return pulumi.get(self, "transfer_lock")

    @transfer_lock.setter
    def transfer_lock(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "transfer_lock", value)


@pulumi.input_type
class _DomainState:
    def __init__(__self__, *,
                 abuse_contact_email: Optional[pulumi.Input[builtins.str]] = None,
                 abuse_contact_phone: Optional[pulumi.Input[builtins.str]] = None,
                 admin_contact: Optional[pulumi.Input['DomainAdminContactArgs']] = None,
                 admin_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[builtins.bool]] = None,
                 billing_contacts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainBillingContactArgs']]]] = None,
                 billing_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 creation_date: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 duration_in_years: Optional[pulumi.Input[builtins.int]] = None,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 hosted_zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 name_servers: Optional[pulumi.Input[Sequence[pulumi.Input['DomainNameServerArgs']]]] = None,
                 registrant_contact: Optional[pulumi.Input['DomainRegistrantContactArgs']] = None,
                 registrant_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 registrar_name: Optional[pulumi.Input[builtins.str]] = None,
                 registrar_url: Optional[pulumi.Input[builtins.str]] = None,
                 status_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tech_contact: Optional[pulumi.Input['DomainTechContactArgs']] = None,
                 tech_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input['DomainTimeoutsArgs']] = None,
                 transfer_lock: Optional[pulumi.Input[builtins.bool]] = None,
                 updated_date: Optional[pulumi.Input[builtins.str]] = None,
                 whois_server: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Domain resources.
        :param pulumi.Input[builtins.str] abuse_contact_email: Email address to contact to report incorrect contact information for a domain, to report that the domain is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.
        :param pulumi.Input[builtins.str] abuse_contact_phone: Phone number for reporting abuse.
        :param pulumi.Input['DomainAdminContactArgs'] admin_contact: Details about the domain administrative contact. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] admin_privacy: Whether domain administrative contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[builtins.bool] auto_renew: Whether the domain registration is set to renew automatically. Default: `true`.
        :param pulumi.Input[Sequence[pulumi.Input['DomainBillingContactArgs']]] billing_contacts: Details about the domain billing contact. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] billing_privacy: Whether domain billing contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[builtins.str] creation_date: The date when the domain was created as found in the response to a WHOIS query.
        :param pulumi.Input[builtins.str] domain_name: The name of the domain.
        :param pulumi.Input[builtins.int] duration_in_years: The number of years that you want to register the domain for. Domains are registered for a minimum of one year. Increasing the duration renews the domain.
        :param pulumi.Input[builtins.str] expiration_date: The date when the registration for the domain is set to expire.
        :param pulumi.Input[builtins.str] hosted_zone_id: The ID of the public Route 53 hosted zone created for the domain. This hosted zone is deleted when the domain is deregistered.
        :param pulumi.Input[Sequence[pulumi.Input['DomainNameServerArgs']]] name_servers: The list of nameservers for the domain. See `name_server` Blocks for more details.
        :param pulumi.Input['DomainRegistrantContactArgs'] registrant_contact: Details about the domain registrant. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] registrant_privacy: Whether domain registrant contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[builtins.str] registrar_name: Name of the registrar of the domain as identified in the registry.
        :param pulumi.Input[builtins.str] registrar_url: Web address of the registrar.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] status_lists: List of [domain name status codes](https://www.icann.org/resources/pages/epp-status-codes-2014-06-16-en).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['DomainTechContactArgs'] tech_contact: Details about the domain technical contact. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] tech_privacy: Whether domain technical contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[builtins.bool] transfer_lock: Whether the domain is locked for transfer. Default: `true`.
               
               > **NOTE:** You must specify the same privacy setting for `admin_privacy`, `registrant_privacy` and `tech_privacy`.
        :param pulumi.Input[builtins.str] updated_date: The last updated date of the domain as found in the response to a WHOIS query.
        :param pulumi.Input[builtins.str] whois_server: The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
        """
        if abuse_contact_email is not None:
            pulumi.set(__self__, "abuse_contact_email", abuse_contact_email)
        if abuse_contact_phone is not None:
            pulumi.set(__self__, "abuse_contact_phone", abuse_contact_phone)
        if admin_contact is not None:
            pulumi.set(__self__, "admin_contact", admin_contact)
        if admin_privacy is not None:
            pulumi.set(__self__, "admin_privacy", admin_privacy)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if billing_contacts is not None:
            pulumi.set(__self__, "billing_contacts", billing_contacts)
        if billing_privacy is not None:
            pulumi.set(__self__, "billing_privacy", billing_privacy)
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if duration_in_years is not None:
            pulumi.set(__self__, "duration_in_years", duration_in_years)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if name_servers is not None:
            pulumi.set(__self__, "name_servers", name_servers)
        if registrant_contact is not None:
            pulumi.set(__self__, "registrant_contact", registrant_contact)
        if registrant_privacy is not None:
            pulumi.set(__self__, "registrant_privacy", registrant_privacy)
        if registrar_name is not None:
            pulumi.set(__self__, "registrar_name", registrar_name)
        if registrar_url is not None:
            pulumi.set(__self__, "registrar_url", registrar_url)
        if status_lists is not None:
            pulumi.set(__self__, "status_lists", status_lists)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tech_contact is not None:
            pulumi.set(__self__, "tech_contact", tech_contact)
        if tech_privacy is not None:
            pulumi.set(__self__, "tech_privacy", tech_privacy)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if transfer_lock is not None:
            pulumi.set(__self__, "transfer_lock", transfer_lock)
        if updated_date is not None:
            pulumi.set(__self__, "updated_date", updated_date)
        if whois_server is not None:
            pulumi.set(__self__, "whois_server", whois_server)

    @property
    @pulumi.getter(name="abuseContactEmail")
    def abuse_contact_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Email address to contact to report incorrect contact information for a domain, to report that the domain is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.
        """
        return pulumi.get(self, "abuse_contact_email")

    @abuse_contact_email.setter
    def abuse_contact_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "abuse_contact_email", value)

    @property
    @pulumi.getter(name="abuseContactPhone")
    def abuse_contact_phone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Phone number for reporting abuse.
        """
        return pulumi.get(self, "abuse_contact_phone")

    @abuse_contact_phone.setter
    def abuse_contact_phone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "abuse_contact_phone", value)

    @property
    @pulumi.getter(name="adminContact")
    def admin_contact(self) -> Optional[pulumi.Input['DomainAdminContactArgs']]:
        """
        Details about the domain administrative contact. See Contact Blocks for more details.
        """
        return pulumi.get(self, "admin_contact")

    @admin_contact.setter
    def admin_contact(self, value: Optional[pulumi.Input['DomainAdminContactArgs']]):
        pulumi.set(self, "admin_contact", value)

    @property
    @pulumi.getter(name="adminPrivacy")
    def admin_privacy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether domain administrative contact information is concealed from WHOIS queries. Default: `true`.
        """
        return pulumi.get(self, "admin_privacy")

    @admin_privacy.setter
    def admin_privacy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "admin_privacy", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the domain registration is set to renew automatically. Default: `true`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="billingContacts")
    def billing_contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainBillingContactArgs']]]]:
        """
        Details about the domain billing contact. See Contact Blocks for more details.
        """
        return pulumi.get(self, "billing_contacts")

    @billing_contacts.setter
    def billing_contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainBillingContactArgs']]]]):
        pulumi.set(self, "billing_contacts", value)

    @property
    @pulumi.getter(name="billingPrivacy")
    def billing_privacy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether domain billing contact information is concealed from WHOIS queries. Default: `true`.
        """
        return pulumi.get(self, "billing_privacy")

    @billing_privacy.setter
    def billing_privacy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "billing_privacy", value)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date when the domain was created as found in the response to a WHOIS query.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_date", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="durationInYears")
    def duration_in_years(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of years that you want to register the domain for. Domains are registered for a minimum of one year. Increasing the duration renews the domain.
        """
        return pulumi.get(self, "duration_in_years")

    @duration_in_years.setter
    def duration_in_years(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "duration_in_years", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date when the registration for the domain is set to expire.
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the public Route 53 hosted zone created for the domain. This hosted zone is deleted when the domain is deregistered.
        """
        return pulumi.get(self, "hosted_zone_id")

    @hosted_zone_id.setter
    def hosted_zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hosted_zone_id", value)

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainNameServerArgs']]]]:
        """
        The list of nameservers for the domain. See `name_server` Blocks for more details.
        """
        return pulumi.get(self, "name_servers")

    @name_servers.setter
    def name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainNameServerArgs']]]]):
        pulumi.set(self, "name_servers", value)

    @property
    @pulumi.getter(name="registrantContact")
    def registrant_contact(self) -> Optional[pulumi.Input['DomainRegistrantContactArgs']]:
        """
        Details about the domain registrant. See Contact Blocks for more details.
        """
        return pulumi.get(self, "registrant_contact")

    @registrant_contact.setter
    def registrant_contact(self, value: Optional[pulumi.Input['DomainRegistrantContactArgs']]):
        pulumi.set(self, "registrant_contact", value)

    @property
    @pulumi.getter(name="registrantPrivacy")
    def registrant_privacy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether domain registrant contact information is concealed from WHOIS queries. Default: `true`.
        """
        return pulumi.get(self, "registrant_privacy")

    @registrant_privacy.setter
    def registrant_privacy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "registrant_privacy", value)

    @property
    @pulumi.getter(name="registrarName")
    def registrar_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the registrar of the domain as identified in the registry.
        """
        return pulumi.get(self, "registrar_name")

    @registrar_name.setter
    def registrar_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registrar_name", value)

    @property
    @pulumi.getter(name="registrarUrl")
    def registrar_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Web address of the registrar.
        """
        return pulumi.get(self, "registrar_url")

    @registrar_url.setter
    def registrar_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registrar_url", value)

    @property
    @pulumi.getter(name="statusLists")
    def status_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of [domain name status codes](https://www.icann.org/resources/pages/epp-status-codes-2014-06-16-en).
        """
        return pulumi.get(self, "status_lists")

    @status_lists.setter
    def status_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "status_lists", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="techContact")
    def tech_contact(self) -> Optional[pulumi.Input['DomainTechContactArgs']]:
        """
        Details about the domain technical contact. See Contact Blocks for more details.
        """
        return pulumi.get(self, "tech_contact")

    @tech_contact.setter
    def tech_contact(self, value: Optional[pulumi.Input['DomainTechContactArgs']]):
        pulumi.set(self, "tech_contact", value)

    @property
    @pulumi.getter(name="techPrivacy")
    def tech_privacy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether domain technical contact information is concealed from WHOIS queries. Default: `true`.
        """
        return pulumi.get(self, "tech_privacy")

    @tech_privacy.setter
    def tech_privacy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tech_privacy", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DomainTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DomainTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="transferLock")
    def transfer_lock(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the domain is locked for transfer. Default: `true`.

        > **NOTE:** You must specify the same privacy setting for `admin_privacy`, `registrant_privacy` and `tech_privacy`.
        """
        return pulumi.get(self, "transfer_lock")

    @transfer_lock.setter
    def transfer_lock(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "transfer_lock", value)

    @property
    @pulumi.getter(name="updatedDate")
    def updated_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last updated date of the domain as found in the response to a WHOIS query.
        """
        return pulumi.get(self, "updated_date")

    @updated_date.setter
    def updated_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_date", value)

    @property
    @pulumi.getter(name="whoisServer")
    def whois_server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
        """
        return pulumi.get(self, "whois_server")

    @whois_server.setter
    def whois_server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "whois_server", value)


@pulumi.type_token("aws:route53domains/domain:Domain")
class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_contact: Optional[pulumi.Input[Union['DomainAdminContactArgs', 'DomainAdminContactArgsDict']]] = None,
                 admin_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[builtins.bool]] = None,
                 billing_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainBillingContactArgs', 'DomainBillingContactArgsDict']]]]] = None,
                 billing_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 duration_in_years: Optional[pulumi.Input[builtins.int]] = None,
                 name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainNameServerArgs', 'DomainNameServerArgsDict']]]]] = None,
                 registrant_contact: Optional[pulumi.Input[Union['DomainRegistrantContactArgs', 'DomainRegistrantContactArgsDict']]] = None,
                 registrant_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tech_contact: Optional[pulumi.Input[Union['DomainTechContactArgs', 'DomainTechContactArgsDict']]] = None,
                 tech_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['DomainTimeoutsArgs', 'DomainTimeoutsArgsDict']]] = None,
                 transfer_lock: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.route53domains.Domain("example",
            domain_name="example.com",
            auto_renew=False,
            admin_contact={
                "address_line1": "101 Main Street",
                "city": "San Francisco",
                "contact_type": "COMPANY",
                "country_code": "US",
                "email": "pulumi-acctest@example.com",
                "fax": "+1.4155551234",
                "first_name": "Terraform",
                "last_name": "Team",
                "organization_name": "HashiCorp",
                "phone_number": "+1.4155551234",
                "state": "CA",
                "zip_code": "94105",
            },
            registrant_contact={
                "address_line1": "101 Main Street",
                "city": "San Francisco",
                "contact_type": "COMPANY",
                "country_code": "US",
                "email": "pulumi-acctest@example.com",
                "fax": "+1.4155551234",
                "first_name": "Terraform",
                "last_name": "Team",
                "organization_name": "HashiCorp",
                "phone_number": "+1.4155551234",
                "state": "CA",
                "zip_code": "94105",
            },
            tech_contact={
                "address_line1": "101 Main Street",
                "city": "San Francisco",
                "contact_type": "COMPANY",
                "country_code": "US",
                "email": "pulumi-acctest@example.com",
                "fax": "+1.4155551234",
                "first_name": "Terraform",
                "last_name": "Team",
                "organization_name": "HashiCorp",
                "phone_number": "+1.4155551234",
                "state": "CA",
                "zip_code": "94105",
            },
            tags={
                "Environment": "test",
            })
        ```

        ## Import

        Using `pulumi import`, import domains using the `domain_name`. For example:

        ```sh
        $ pulumi import aws:route53domains/domain:Domain example example.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DomainAdminContactArgs', 'DomainAdminContactArgsDict']] admin_contact: Details about the domain administrative contact. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] admin_privacy: Whether domain administrative contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[builtins.bool] auto_renew: Whether the domain registration is set to renew automatically. Default: `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainBillingContactArgs', 'DomainBillingContactArgsDict']]]] billing_contacts: Details about the domain billing contact. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] billing_privacy: Whether domain billing contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[builtins.str] domain_name: The name of the domain.
        :param pulumi.Input[builtins.int] duration_in_years: The number of years that you want to register the domain for. Domains are registered for a minimum of one year. Increasing the duration renews the domain.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainNameServerArgs', 'DomainNameServerArgsDict']]]] name_servers: The list of nameservers for the domain. See `name_server` Blocks for more details.
        :param pulumi.Input[Union['DomainRegistrantContactArgs', 'DomainRegistrantContactArgsDict']] registrant_contact: Details about the domain registrant. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] registrant_privacy: Whether domain registrant contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['DomainTechContactArgs', 'DomainTechContactArgsDict']] tech_contact: Details about the domain technical contact. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] tech_privacy: Whether domain technical contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[builtins.bool] transfer_lock: Whether the domain is locked for transfer. Default: `true`.
               
               > **NOTE:** You must specify the same privacy setting for `admin_privacy`, `registrant_privacy` and `tech_privacy`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.route53domains.Domain("example",
            domain_name="example.com",
            auto_renew=False,
            admin_contact={
                "address_line1": "101 Main Street",
                "city": "San Francisco",
                "contact_type": "COMPANY",
                "country_code": "US",
                "email": "pulumi-acctest@example.com",
                "fax": "+1.4155551234",
                "first_name": "Terraform",
                "last_name": "Team",
                "organization_name": "HashiCorp",
                "phone_number": "+1.4155551234",
                "state": "CA",
                "zip_code": "94105",
            },
            registrant_contact={
                "address_line1": "101 Main Street",
                "city": "San Francisco",
                "contact_type": "COMPANY",
                "country_code": "US",
                "email": "pulumi-acctest@example.com",
                "fax": "+1.4155551234",
                "first_name": "Terraform",
                "last_name": "Team",
                "organization_name": "HashiCorp",
                "phone_number": "+1.4155551234",
                "state": "CA",
                "zip_code": "94105",
            },
            tech_contact={
                "address_line1": "101 Main Street",
                "city": "San Francisco",
                "contact_type": "COMPANY",
                "country_code": "US",
                "email": "pulumi-acctest@example.com",
                "fax": "+1.4155551234",
                "first_name": "Terraform",
                "last_name": "Team",
                "organization_name": "HashiCorp",
                "phone_number": "+1.4155551234",
                "state": "CA",
                "zip_code": "94105",
            },
            tags={
                "Environment": "test",
            })
        ```

        ## Import

        Using `pulumi import`, import domains using the `domain_name`. For example:

        ```sh
        $ pulumi import aws:route53domains/domain:Domain example example.com
        ```

        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_contact: Optional[pulumi.Input[Union['DomainAdminContactArgs', 'DomainAdminContactArgsDict']]] = None,
                 admin_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_renew: Optional[pulumi.Input[builtins.bool]] = None,
                 billing_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainBillingContactArgs', 'DomainBillingContactArgsDict']]]]] = None,
                 billing_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 duration_in_years: Optional[pulumi.Input[builtins.int]] = None,
                 name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainNameServerArgs', 'DomainNameServerArgsDict']]]]] = None,
                 registrant_contact: Optional[pulumi.Input[Union['DomainRegistrantContactArgs', 'DomainRegistrantContactArgsDict']]] = None,
                 registrant_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tech_contact: Optional[pulumi.Input[Union['DomainTechContactArgs', 'DomainTechContactArgsDict']]] = None,
                 tech_privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['DomainTimeoutsArgs', 'DomainTimeoutsArgsDict']]] = None,
                 transfer_lock: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["admin_contact"] = admin_contact
            __props__.__dict__["admin_privacy"] = admin_privacy
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["billing_contacts"] = billing_contacts
            __props__.__dict__["billing_privacy"] = billing_privacy
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["duration_in_years"] = duration_in_years
            __props__.__dict__["name_servers"] = name_servers
            __props__.__dict__["registrant_contact"] = registrant_contact
            __props__.__dict__["registrant_privacy"] = registrant_privacy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tech_contact"] = tech_contact
            __props__.__dict__["tech_privacy"] = tech_privacy
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["transfer_lock"] = transfer_lock
            __props__.__dict__["abuse_contact_email"] = None
            __props__.__dict__["abuse_contact_phone"] = None
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["expiration_date"] = None
            __props__.__dict__["hosted_zone_id"] = None
            __props__.__dict__["registrar_name"] = None
            __props__.__dict__["registrar_url"] = None
            __props__.__dict__["status_lists"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["updated_date"] = None
            __props__.__dict__["whois_server"] = None
        super(Domain, __self__).__init__(
            'aws:route53domains/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            abuse_contact_email: Optional[pulumi.Input[builtins.str]] = None,
            abuse_contact_phone: Optional[pulumi.Input[builtins.str]] = None,
            admin_contact: Optional[pulumi.Input[Union['DomainAdminContactArgs', 'DomainAdminContactArgsDict']]] = None,
            admin_privacy: Optional[pulumi.Input[builtins.bool]] = None,
            auto_renew: Optional[pulumi.Input[builtins.bool]] = None,
            billing_contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainBillingContactArgs', 'DomainBillingContactArgsDict']]]]] = None,
            billing_privacy: Optional[pulumi.Input[builtins.bool]] = None,
            creation_date: Optional[pulumi.Input[builtins.str]] = None,
            domain_name: Optional[pulumi.Input[builtins.str]] = None,
            duration_in_years: Optional[pulumi.Input[builtins.int]] = None,
            expiration_date: Optional[pulumi.Input[builtins.str]] = None,
            hosted_zone_id: Optional[pulumi.Input[builtins.str]] = None,
            name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainNameServerArgs', 'DomainNameServerArgsDict']]]]] = None,
            registrant_contact: Optional[pulumi.Input[Union['DomainRegistrantContactArgs', 'DomainRegistrantContactArgsDict']]] = None,
            registrant_privacy: Optional[pulumi.Input[builtins.bool]] = None,
            registrar_name: Optional[pulumi.Input[builtins.str]] = None,
            registrar_url: Optional[pulumi.Input[builtins.str]] = None,
            status_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tech_contact: Optional[pulumi.Input[Union['DomainTechContactArgs', 'DomainTechContactArgsDict']]] = None,
            tech_privacy: Optional[pulumi.Input[builtins.bool]] = None,
            timeouts: Optional[pulumi.Input[Union['DomainTimeoutsArgs', 'DomainTimeoutsArgsDict']]] = None,
            transfer_lock: Optional[pulumi.Input[builtins.bool]] = None,
            updated_date: Optional[pulumi.Input[builtins.str]] = None,
            whois_server: Optional[pulumi.Input[builtins.str]] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] abuse_contact_email: Email address to contact to report incorrect contact information for a domain, to report that the domain is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.
        :param pulumi.Input[builtins.str] abuse_contact_phone: Phone number for reporting abuse.
        :param pulumi.Input[Union['DomainAdminContactArgs', 'DomainAdminContactArgsDict']] admin_contact: Details about the domain administrative contact. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] admin_privacy: Whether domain administrative contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[builtins.bool] auto_renew: Whether the domain registration is set to renew automatically. Default: `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainBillingContactArgs', 'DomainBillingContactArgsDict']]]] billing_contacts: Details about the domain billing contact. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] billing_privacy: Whether domain billing contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[builtins.str] creation_date: The date when the domain was created as found in the response to a WHOIS query.
        :param pulumi.Input[builtins.str] domain_name: The name of the domain.
        :param pulumi.Input[builtins.int] duration_in_years: The number of years that you want to register the domain for. Domains are registered for a minimum of one year. Increasing the duration renews the domain.
        :param pulumi.Input[builtins.str] expiration_date: The date when the registration for the domain is set to expire.
        :param pulumi.Input[builtins.str] hosted_zone_id: The ID of the public Route 53 hosted zone created for the domain. This hosted zone is deleted when the domain is deregistered.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainNameServerArgs', 'DomainNameServerArgsDict']]]] name_servers: The list of nameservers for the domain. See `name_server` Blocks for more details.
        :param pulumi.Input[Union['DomainRegistrantContactArgs', 'DomainRegistrantContactArgsDict']] registrant_contact: Details about the domain registrant. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] registrant_privacy: Whether domain registrant contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[builtins.str] registrar_name: Name of the registrar of the domain as identified in the registry.
        :param pulumi.Input[builtins.str] registrar_url: Web address of the registrar.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] status_lists: List of [domain name status codes](https://www.icann.org/resources/pages/epp-status-codes-2014-06-16-en).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['DomainTechContactArgs', 'DomainTechContactArgsDict']] tech_contact: Details about the domain technical contact. See Contact Blocks for more details.
        :param pulumi.Input[builtins.bool] tech_privacy: Whether domain technical contact information is concealed from WHOIS queries. Default: `true`.
        :param pulumi.Input[builtins.bool] transfer_lock: Whether the domain is locked for transfer. Default: `true`.
               
               > **NOTE:** You must specify the same privacy setting for `admin_privacy`, `registrant_privacy` and `tech_privacy`.
        :param pulumi.Input[builtins.str] updated_date: The last updated date of the domain as found in the response to a WHOIS query.
        :param pulumi.Input[builtins.str] whois_server: The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainState.__new__(_DomainState)

        __props__.__dict__["abuse_contact_email"] = abuse_contact_email
        __props__.__dict__["abuse_contact_phone"] = abuse_contact_phone
        __props__.__dict__["admin_contact"] = admin_contact
        __props__.__dict__["admin_privacy"] = admin_privacy
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["billing_contacts"] = billing_contacts
        __props__.__dict__["billing_privacy"] = billing_privacy
        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["duration_in_years"] = duration_in_years
        __props__.__dict__["expiration_date"] = expiration_date
        __props__.__dict__["hosted_zone_id"] = hosted_zone_id
        __props__.__dict__["name_servers"] = name_servers
        __props__.__dict__["registrant_contact"] = registrant_contact
        __props__.__dict__["registrant_privacy"] = registrant_privacy
        __props__.__dict__["registrar_name"] = registrar_name
        __props__.__dict__["registrar_url"] = registrar_url
        __props__.__dict__["status_lists"] = status_lists
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tech_contact"] = tech_contact
        __props__.__dict__["tech_privacy"] = tech_privacy
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["transfer_lock"] = transfer_lock
        __props__.__dict__["updated_date"] = updated_date
        __props__.__dict__["whois_server"] = whois_server
        return Domain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="abuseContactEmail")
    def abuse_contact_email(self) -> pulumi.Output[builtins.str]:
        """
        Email address to contact to report incorrect contact information for a domain, to report that the domain is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.
        """
        return pulumi.get(self, "abuse_contact_email")

    @property
    @pulumi.getter(name="abuseContactPhone")
    def abuse_contact_phone(self) -> pulumi.Output[builtins.str]:
        """
        Phone number for reporting abuse.
        """
        return pulumi.get(self, "abuse_contact_phone")

    @property
    @pulumi.getter(name="adminContact")
    def admin_contact(self) -> pulumi.Output[Optional['outputs.DomainAdminContact']]:
        """
        Details about the domain administrative contact. See Contact Blocks for more details.
        """
        return pulumi.get(self, "admin_contact")

    @property
    @pulumi.getter(name="adminPrivacy")
    def admin_privacy(self) -> pulumi.Output[builtins.bool]:
        """
        Whether domain administrative contact information is concealed from WHOIS queries. Default: `true`.
        """
        return pulumi.get(self, "admin_privacy")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the domain registration is set to renew automatically. Default: `true`.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="billingContacts")
    def billing_contacts(self) -> pulumi.Output[Sequence['outputs.DomainBillingContact']]:
        """
        Details about the domain billing contact. See Contact Blocks for more details.
        """
        return pulumi.get(self, "billing_contacts")

    @property
    @pulumi.getter(name="billingPrivacy")
    def billing_privacy(self) -> pulumi.Output[builtins.bool]:
        """
        Whether domain billing contact information is concealed from WHOIS queries. Default: `true`.
        """
        return pulumi.get(self, "billing_privacy")

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[builtins.str]:
        """
        The date when the domain was created as found in the response to a WHOIS query.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="durationInYears")
    def duration_in_years(self) -> pulumi.Output[builtins.int]:
        """
        The number of years that you want to register the domain for. Domains are registered for a minimum of one year. Increasing the duration renews the domain.
        """
        return pulumi.get(self, "duration_in_years")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[builtins.str]:
        """
        The date when the registration for the domain is set to expire.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the public Route 53 hosted zone created for the domain. This hosted zone is deleted when the domain is deregistered.
        """
        return pulumi.get(self, "hosted_zone_id")

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> pulumi.Output[Sequence['outputs.DomainNameServer']]:
        """
        The list of nameservers for the domain. See `name_server` Blocks for more details.
        """
        return pulumi.get(self, "name_servers")

    @property
    @pulumi.getter(name="registrantContact")
    def registrant_contact(self) -> pulumi.Output[Optional['outputs.DomainRegistrantContact']]:
        """
        Details about the domain registrant. See Contact Blocks for more details.
        """
        return pulumi.get(self, "registrant_contact")

    @property
    @pulumi.getter(name="registrantPrivacy")
    def registrant_privacy(self) -> pulumi.Output[builtins.bool]:
        """
        Whether domain registrant contact information is concealed from WHOIS queries. Default: `true`.
        """
        return pulumi.get(self, "registrant_privacy")

    @property
    @pulumi.getter(name="registrarName")
    def registrar_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the registrar of the domain as identified in the registry.
        """
        return pulumi.get(self, "registrar_name")

    @property
    @pulumi.getter(name="registrarUrl")
    def registrar_url(self) -> pulumi.Output[builtins.str]:
        """
        Web address of the registrar.
        """
        return pulumi.get(self, "registrar_url")

    @property
    @pulumi.getter(name="statusLists")
    def status_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of [domain name status codes](https://www.icann.org/resources/pages/epp-status-codes-2014-06-16-en).
        """
        return pulumi.get(self, "status_lists")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="techContact")
    def tech_contact(self) -> pulumi.Output[Optional['outputs.DomainTechContact']]:
        """
        Details about the domain technical contact. See Contact Blocks for more details.
        """
        return pulumi.get(self, "tech_contact")

    @property
    @pulumi.getter(name="techPrivacy")
    def tech_privacy(self) -> pulumi.Output[builtins.bool]:
        """
        Whether domain technical contact information is concealed from WHOIS queries. Default: `true`.
        """
        return pulumi.get(self, "tech_privacy")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.DomainTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="transferLock")
    def transfer_lock(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the domain is locked for transfer. Default: `true`.

        > **NOTE:** You must specify the same privacy setting for `admin_privacy`, `registrant_privacy` and `tech_privacy`.
        """
        return pulumi.get(self, "transfer_lock")

    @property
    @pulumi.getter(name="updatedDate")
    def updated_date(self) -> pulumi.Output[builtins.str]:
        """
        The last updated date of the domain as found in the response to a WHOIS query.
        """
        return pulumi.get(self, "updated_date")

    @property
    @pulumi.getter(name="whoisServer")
    def whois_server(self) -> pulumi.Output[builtins.str]:
        """
        The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
        """
        return pulumi.get(self, "whois_server")

