# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DelegationSignerRecordSigningAttributes',
    'DelegationSignerRecordTimeouts',
    'DomainAdminContact',
    'DomainAdminContactExtraParam',
    'DomainBillingContact',
    'DomainBillingContactExtraParam',
    'DomainNameServer',
    'DomainRegistrantContact',
    'DomainRegistrantContactExtraParam',
    'DomainTechContact',
    'DomainTechContactExtraParam',
    'DomainTimeouts',
    'RegisteredDomainAdminContact',
    'RegisteredDomainBillingContact',
    'RegisteredDomainNameServer',
    'RegisteredDomainRegistrantContact',
    'RegisteredDomainTechContact',
]

@pulumi.output_type
class DelegationSignerRecordSigningAttributes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DelegationSignerRecordSigningAttributes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DelegationSignerRecordSigningAttributes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DelegationSignerRecordSigningAttributes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: builtins.int,
                 flags: builtins.int,
                 public_key: builtins.str):
        """
        :param builtins.int algorithm: Algorithm which was used to generate the digest from the public key.
        :param builtins.int flags: Defines the type of key. It can be either a KSK (key-signing-key, value `257`) or ZSK (zone-signing-key, value `256`).
        :param builtins.str public_key: The base64-encoded public key part of the key pair that is passed to the registry.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "flags", flags)
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def algorithm(self) -> builtins.int:
        """
        Algorithm which was used to generate the digest from the public key.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def flags(self) -> builtins.int:
        """
        Defines the type of key. It can be either a KSK (key-signing-key, value `257`) or ZSK (zone-signing-key, value `256`).
        """
        return pulumi.get(self, "flags")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> builtins.str:
        """
        The base64-encoded public key part of the key pair that is passed to the registry.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class DelegationSignerRecordTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class DomainAdminContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "contactType":
            suggest = "contact_type"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "extraParams":
            suggest = "extra_params"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "organizationName":
            suggest = "organization_name"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "zipCode":
            suggest = "zip_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainAdminContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainAdminContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainAdminContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_line1: Optional[builtins.str] = None,
                 address_line2: Optional[builtins.str] = None,
                 city: Optional[builtins.str] = None,
                 contact_type: Optional[builtins.str] = None,
                 country_code: Optional[builtins.str] = None,
                 email: Optional[builtins.str] = None,
                 extra_params: Optional[Sequence['outputs.DomainAdminContactExtraParam']] = None,
                 fax: Optional[builtins.str] = None,
                 first_name: Optional[builtins.str] = None,
                 last_name: Optional[builtins.str] = None,
                 organization_name: Optional[builtins.str] = None,
                 phone_number: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 zip_code: Optional[builtins.str] = None):
        """
        :param builtins.str address_line1: First line of the contact's address.
        :param builtins.str address_line2: Second line of contact's address, if any.
        :param builtins.str city: The city of the contact's address.
        :param builtins.str contact_type: Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        :param builtins.str country_code: Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        :param builtins.str email: Email address of the contact.
        :param Sequence['DomainAdminContactExtraParamArgs'] extra_params: A list of name-value pairs for parameters required by certain top-level domains.
        :param builtins.str fax: Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str first_name: First name of contact.
        :param builtins.str last_name: Last name of contact.
        :param builtins.str organization_name: Name of the organization for contact types other than `PERSON`.
        :param builtins.str phone_number: The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str state: The state or province of the contact's city.
        :param builtins.str zip_code: The zip or postal code of the contact's address.
        """
        if address_line1 is not None:
            pulumi.set(__self__, "address_line1", address_line1)
        if address_line2 is not None:
            pulumi.set(__self__, "address_line2", address_line2)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if contact_type is not None:
            pulumi.set(__self__, "contact_type", contact_type)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if extra_params is not None:
            pulumi.set(__self__, "extra_params", extra_params)
        if fax is not None:
            pulumi.set(__self__, "fax", fax)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> Optional[builtins.str]:
        """
        First line of the contact's address.
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> Optional[builtins.str]:
        """
        Second line of contact's address, if any.
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter
    def city(self) -> Optional[builtins.str]:
        """
        The city of the contact's address.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="contactType")
    def contact_type(self) -> Optional[builtins.str]:
        """
        Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        """
        return pulumi.get(self, "contact_type")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[builtins.str]:
        """
        Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        Email address of the contact.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="extraParams")
    def extra_params(self) -> Optional[Sequence['outputs.DomainAdminContactExtraParam']]:
        """
        A list of name-value pairs for parameters required by certain top-level domains.
        """
        return pulumi.get(self, "extra_params")

    @property
    @pulumi.getter
    def fax(self) -> Optional[builtins.str]:
        """
        Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "fax")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[builtins.str]:
        """
        First name of contact.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[builtins.str]:
        """
        Last name of contact.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[builtins.str]:
        """
        Name of the organization for contact types other than `PERSON`.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[builtins.str]:
        """
        The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state or province of the contact's city.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[builtins.str]:
        """
        The zip or postal code of the contact's address.
        """
        return pulumi.get(self, "zip_code")


@pulumi.output_type
class DomainAdminContactExtraParam(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of an additional parameter that is required by a top-level domain.
        :param builtins.str value: The value that corresponds with the name of an extra parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of an additional parameter that is required by a top-level domain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value that corresponds with the name of an extra parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DomainBillingContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "contactType":
            suggest = "contact_type"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "extraParams":
            suggest = "extra_params"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "organizationName":
            suggest = "organization_name"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "zipCode":
            suggest = "zip_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainBillingContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainBillingContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainBillingContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_line1: builtins.str,
                 address_line2: builtins.str,
                 city: builtins.str,
                 contact_type: builtins.str,
                 country_code: builtins.str,
                 email: builtins.str,
                 extra_params: Sequence['outputs.DomainBillingContactExtraParam'],
                 fax: builtins.str,
                 first_name: builtins.str,
                 last_name: builtins.str,
                 organization_name: builtins.str,
                 phone_number: builtins.str,
                 state: builtins.str,
                 zip_code: builtins.str):
        """
        :param builtins.str address_line1: First line of the contact's address.
        :param builtins.str address_line2: Second line of contact's address, if any.
        :param builtins.str city: The city of the contact's address.
        :param builtins.str contact_type: Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        :param builtins.str country_code: Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        :param builtins.str email: Email address of the contact.
        :param Sequence['DomainBillingContactExtraParamArgs'] extra_params: A list of name-value pairs for parameters required by certain top-level domains.
        :param builtins.str fax: Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str first_name: First name of contact.
        :param builtins.str last_name: Last name of contact.
        :param builtins.str organization_name: Name of the organization for contact types other than `PERSON`.
        :param builtins.str phone_number: The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str state: The state or province of the contact's city.
        :param builtins.str zip_code: The zip or postal code of the contact's address.
        """
        pulumi.set(__self__, "address_line1", address_line1)
        pulumi.set(__self__, "address_line2", address_line2)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "contact_type", contact_type)
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "extra_params", extra_params)
        pulumi.set(__self__, "fax", fax)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "organization_name", organization_name)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> builtins.str:
        """
        First line of the contact's address.
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> builtins.str:
        """
        Second line of contact's address, if any.
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter
    def city(self) -> builtins.str:
        """
        The city of the contact's address.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="contactType")
    def contact_type(self) -> builtins.str:
        """
        Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        """
        return pulumi.get(self, "contact_type")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> builtins.str:
        """
        Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        Email address of the contact.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="extraParams")
    def extra_params(self) -> Sequence['outputs.DomainBillingContactExtraParam']:
        """
        A list of name-value pairs for parameters required by certain top-level domains.
        """
        return pulumi.get(self, "extra_params")

    @property
    @pulumi.getter
    def fax(self) -> builtins.str:
        """
        Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "fax")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> builtins.str:
        """
        First name of contact.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> builtins.str:
        """
        Last name of contact.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> builtins.str:
        """
        Name of the organization for contact types other than `PERSON`.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> builtins.str:
        """
        The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The state or province of the contact's city.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> builtins.str:
        """
        The zip or postal code of the contact's address.
        """
        return pulumi.get(self, "zip_code")


@pulumi.output_type
class DomainBillingContactExtraParam(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of an additional parameter that is required by a top-level domain.
        :param builtins.str value: The value that corresponds with the name of an extra parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of an additional parameter that is required by a top-level domain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value that corresponds with the name of an extra parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DomainNameServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "glueIps":
            suggest = "glue_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainNameServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainNameServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainNameServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 glue_ips: Sequence[builtins.str],
                 name: builtins.str):
        """
        :param Sequence[builtins.str] glue_ips: Glue IP addresses of a name server. The list can contain only one IPv4 and one IPv6 address.
        :param builtins.str name: The fully qualified host name of the name server.
        """
        pulumi.set(__self__, "glue_ips", glue_ips)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="glueIps")
    def glue_ips(self) -> Sequence[builtins.str]:
        """
        Glue IP addresses of a name server. The list can contain only one IPv4 and one IPv6 address.
        """
        return pulumi.get(self, "glue_ips")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The fully qualified host name of the name server.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DomainRegistrantContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "contactType":
            suggest = "contact_type"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "extraParams":
            suggest = "extra_params"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "organizationName":
            suggest = "organization_name"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "zipCode":
            suggest = "zip_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRegistrantContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRegistrantContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRegistrantContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_line1: Optional[builtins.str] = None,
                 address_line2: Optional[builtins.str] = None,
                 city: Optional[builtins.str] = None,
                 contact_type: Optional[builtins.str] = None,
                 country_code: Optional[builtins.str] = None,
                 email: Optional[builtins.str] = None,
                 extra_params: Optional[Sequence['outputs.DomainRegistrantContactExtraParam']] = None,
                 fax: Optional[builtins.str] = None,
                 first_name: Optional[builtins.str] = None,
                 last_name: Optional[builtins.str] = None,
                 organization_name: Optional[builtins.str] = None,
                 phone_number: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 zip_code: Optional[builtins.str] = None):
        """
        :param builtins.str address_line1: First line of the contact's address.
        :param builtins.str address_line2: Second line of contact's address, if any.
        :param builtins.str city: The city of the contact's address.
        :param builtins.str contact_type: Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        :param builtins.str country_code: Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        :param builtins.str email: Email address of the contact.
        :param Sequence['DomainRegistrantContactExtraParamArgs'] extra_params: A list of name-value pairs for parameters required by certain top-level domains.
        :param builtins.str fax: Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str first_name: First name of contact.
        :param builtins.str last_name: Last name of contact.
        :param builtins.str organization_name: Name of the organization for contact types other than `PERSON`.
        :param builtins.str phone_number: The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str state: The state or province of the contact's city.
        :param builtins.str zip_code: The zip or postal code of the contact's address.
        """
        if address_line1 is not None:
            pulumi.set(__self__, "address_line1", address_line1)
        if address_line2 is not None:
            pulumi.set(__self__, "address_line2", address_line2)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if contact_type is not None:
            pulumi.set(__self__, "contact_type", contact_type)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if extra_params is not None:
            pulumi.set(__self__, "extra_params", extra_params)
        if fax is not None:
            pulumi.set(__self__, "fax", fax)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> Optional[builtins.str]:
        """
        First line of the contact's address.
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> Optional[builtins.str]:
        """
        Second line of contact's address, if any.
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter
    def city(self) -> Optional[builtins.str]:
        """
        The city of the contact's address.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="contactType")
    def contact_type(self) -> Optional[builtins.str]:
        """
        Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        """
        return pulumi.get(self, "contact_type")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[builtins.str]:
        """
        Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        Email address of the contact.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="extraParams")
    def extra_params(self) -> Optional[Sequence['outputs.DomainRegistrantContactExtraParam']]:
        """
        A list of name-value pairs for parameters required by certain top-level domains.
        """
        return pulumi.get(self, "extra_params")

    @property
    @pulumi.getter
    def fax(self) -> Optional[builtins.str]:
        """
        Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "fax")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[builtins.str]:
        """
        First name of contact.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[builtins.str]:
        """
        Last name of contact.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[builtins.str]:
        """
        Name of the organization for contact types other than `PERSON`.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[builtins.str]:
        """
        The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state or province of the contact's city.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[builtins.str]:
        """
        The zip or postal code of the contact's address.
        """
        return pulumi.get(self, "zip_code")


@pulumi.output_type
class DomainRegistrantContactExtraParam(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of an additional parameter that is required by a top-level domain.
        :param builtins.str value: The value that corresponds with the name of an extra parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of an additional parameter that is required by a top-level domain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value that corresponds with the name of an extra parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DomainTechContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "contactType":
            suggest = "contact_type"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "extraParams":
            suggest = "extra_params"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "organizationName":
            suggest = "organization_name"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "zipCode":
            suggest = "zip_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainTechContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainTechContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainTechContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_line1: Optional[builtins.str] = None,
                 address_line2: Optional[builtins.str] = None,
                 city: Optional[builtins.str] = None,
                 contact_type: Optional[builtins.str] = None,
                 country_code: Optional[builtins.str] = None,
                 email: Optional[builtins.str] = None,
                 extra_params: Optional[Sequence['outputs.DomainTechContactExtraParam']] = None,
                 fax: Optional[builtins.str] = None,
                 first_name: Optional[builtins.str] = None,
                 last_name: Optional[builtins.str] = None,
                 organization_name: Optional[builtins.str] = None,
                 phone_number: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 zip_code: Optional[builtins.str] = None):
        """
        :param builtins.str address_line1: First line of the contact's address.
        :param builtins.str address_line2: Second line of contact's address, if any.
        :param builtins.str city: The city of the contact's address.
        :param builtins.str contact_type: Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        :param builtins.str country_code: Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        :param builtins.str email: Email address of the contact.
        :param Sequence['DomainTechContactExtraParamArgs'] extra_params: A list of name-value pairs for parameters required by certain top-level domains.
        :param builtins.str fax: Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str first_name: First name of contact.
        :param builtins.str last_name: Last name of contact.
        :param builtins.str organization_name: Name of the organization for contact types other than `PERSON`.
        :param builtins.str phone_number: The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str state: The state or province of the contact's city.
        :param builtins.str zip_code: The zip or postal code of the contact's address.
        """
        if address_line1 is not None:
            pulumi.set(__self__, "address_line1", address_line1)
        if address_line2 is not None:
            pulumi.set(__self__, "address_line2", address_line2)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if contact_type is not None:
            pulumi.set(__self__, "contact_type", contact_type)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if extra_params is not None:
            pulumi.set(__self__, "extra_params", extra_params)
        if fax is not None:
            pulumi.set(__self__, "fax", fax)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> Optional[builtins.str]:
        """
        First line of the contact's address.
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> Optional[builtins.str]:
        """
        Second line of contact's address, if any.
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter
    def city(self) -> Optional[builtins.str]:
        """
        The city of the contact's address.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="contactType")
    def contact_type(self) -> Optional[builtins.str]:
        """
        Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        """
        return pulumi.get(self, "contact_type")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[builtins.str]:
        """
        Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        Email address of the contact.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="extraParams")
    def extra_params(self) -> Optional[Sequence['outputs.DomainTechContactExtraParam']]:
        """
        A list of name-value pairs for parameters required by certain top-level domains.
        """
        return pulumi.get(self, "extra_params")

    @property
    @pulumi.getter
    def fax(self) -> Optional[builtins.str]:
        """
        Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "fax")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[builtins.str]:
        """
        First name of contact.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[builtins.str]:
        """
        Last name of contact.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[builtins.str]:
        """
        Name of the organization for contact types other than `PERSON`.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[builtins.str]:
        """
        The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state or province of the contact's city.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[builtins.str]:
        """
        The zip or postal code of the contact's address.
        """
        return pulumi.get(self, "zip_code")


@pulumi.output_type
class DomainTechContactExtraParam(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: The name of an additional parameter that is required by a top-level domain.
        :param builtins.str value: The value that corresponds with the name of an extra parameter.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of an additional parameter that is required by a top-level domain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value that corresponds with the name of an extra parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DomainTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class RegisteredDomainAdminContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "contactType":
            suggest = "contact_type"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "extraParams":
            suggest = "extra_params"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "organizationName":
            suggest = "organization_name"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "zipCode":
            suggest = "zip_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegisteredDomainAdminContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegisteredDomainAdminContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegisteredDomainAdminContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_line1: Optional[builtins.str] = None,
                 address_line2: Optional[builtins.str] = None,
                 city: Optional[builtins.str] = None,
                 contact_type: Optional[builtins.str] = None,
                 country_code: Optional[builtins.str] = None,
                 email: Optional[builtins.str] = None,
                 extra_params: Optional[Mapping[str, builtins.str]] = None,
                 fax: Optional[builtins.str] = None,
                 first_name: Optional[builtins.str] = None,
                 last_name: Optional[builtins.str] = None,
                 organization_name: Optional[builtins.str] = None,
                 phone_number: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 zip_code: Optional[builtins.str] = None):
        """
        :param builtins.str address_line1: First line of the contact's address.
        :param builtins.str address_line2: Second line of contact's address, if any.
        :param builtins.str city: The city of the contact's address.
        :param builtins.str contact_type: Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        :param builtins.str country_code: Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        :param builtins.str email: Email address of the contact.
        :param Mapping[str, builtins.str] extra_params: A key-value map of parameters required by certain top-level domains.
        :param builtins.str fax: Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str first_name: First name of contact.
        :param builtins.str last_name: Last name of contact.
        :param builtins.str organization_name: Name of the organization for contact types other than `PERSON`.
        :param builtins.str phone_number: The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str state: The state or province of the contact's city.
        :param builtins.str zip_code: The zip or postal code of the contact's address.
        """
        if address_line1 is not None:
            pulumi.set(__self__, "address_line1", address_line1)
        if address_line2 is not None:
            pulumi.set(__self__, "address_line2", address_line2)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if contact_type is not None:
            pulumi.set(__self__, "contact_type", contact_type)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if extra_params is not None:
            pulumi.set(__self__, "extra_params", extra_params)
        if fax is not None:
            pulumi.set(__self__, "fax", fax)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> Optional[builtins.str]:
        """
        First line of the contact's address.
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> Optional[builtins.str]:
        """
        Second line of contact's address, if any.
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter
    def city(self) -> Optional[builtins.str]:
        """
        The city of the contact's address.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="contactType")
    def contact_type(self) -> Optional[builtins.str]:
        """
        Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        """
        return pulumi.get(self, "contact_type")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[builtins.str]:
        """
        Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        Email address of the contact.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="extraParams")
    def extra_params(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A key-value map of parameters required by certain top-level domains.
        """
        return pulumi.get(self, "extra_params")

    @property
    @pulumi.getter
    def fax(self) -> Optional[builtins.str]:
        """
        Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "fax")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[builtins.str]:
        """
        First name of contact.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[builtins.str]:
        """
        Last name of contact.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[builtins.str]:
        """
        Name of the organization for contact types other than `PERSON`.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[builtins.str]:
        """
        The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state or province of the contact's city.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[builtins.str]:
        """
        The zip or postal code of the contact's address.
        """
        return pulumi.get(self, "zip_code")


@pulumi.output_type
class RegisteredDomainBillingContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "contactType":
            suggest = "contact_type"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "extraParams":
            suggest = "extra_params"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "organizationName":
            suggest = "organization_name"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "zipCode":
            suggest = "zip_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegisteredDomainBillingContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegisteredDomainBillingContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegisteredDomainBillingContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_line1: Optional[builtins.str] = None,
                 address_line2: Optional[builtins.str] = None,
                 city: Optional[builtins.str] = None,
                 contact_type: Optional[builtins.str] = None,
                 country_code: Optional[builtins.str] = None,
                 email: Optional[builtins.str] = None,
                 extra_params: Optional[Mapping[str, builtins.str]] = None,
                 fax: Optional[builtins.str] = None,
                 first_name: Optional[builtins.str] = None,
                 last_name: Optional[builtins.str] = None,
                 organization_name: Optional[builtins.str] = None,
                 phone_number: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 zip_code: Optional[builtins.str] = None):
        """
        :param builtins.str address_line1: First line of the contact's address.
        :param builtins.str address_line2: Second line of contact's address, if any.
        :param builtins.str city: The city of the contact's address.
        :param builtins.str contact_type: Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        :param builtins.str country_code: Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        :param builtins.str email: Email address of the contact.
        :param Mapping[str, builtins.str] extra_params: A key-value map of parameters required by certain top-level domains.
        :param builtins.str fax: Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str first_name: First name of contact.
        :param builtins.str last_name: Last name of contact.
        :param builtins.str organization_name: Name of the organization for contact types other than `PERSON`.
        :param builtins.str phone_number: The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str state: The state or province of the contact's city.
        :param builtins.str zip_code: The zip or postal code of the contact's address.
        """
        if address_line1 is not None:
            pulumi.set(__self__, "address_line1", address_line1)
        if address_line2 is not None:
            pulumi.set(__self__, "address_line2", address_line2)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if contact_type is not None:
            pulumi.set(__self__, "contact_type", contact_type)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if extra_params is not None:
            pulumi.set(__self__, "extra_params", extra_params)
        if fax is not None:
            pulumi.set(__self__, "fax", fax)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> Optional[builtins.str]:
        """
        First line of the contact's address.
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> Optional[builtins.str]:
        """
        Second line of contact's address, if any.
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter
    def city(self) -> Optional[builtins.str]:
        """
        The city of the contact's address.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="contactType")
    def contact_type(self) -> Optional[builtins.str]:
        """
        Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        """
        return pulumi.get(self, "contact_type")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[builtins.str]:
        """
        Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        Email address of the contact.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="extraParams")
    def extra_params(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A key-value map of parameters required by certain top-level domains.
        """
        return pulumi.get(self, "extra_params")

    @property
    @pulumi.getter
    def fax(self) -> Optional[builtins.str]:
        """
        Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "fax")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[builtins.str]:
        """
        First name of contact.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[builtins.str]:
        """
        Last name of contact.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[builtins.str]:
        """
        Name of the organization for contact types other than `PERSON`.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[builtins.str]:
        """
        The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state or province of the contact's city.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[builtins.str]:
        """
        The zip or postal code of the contact's address.
        """
        return pulumi.get(self, "zip_code")


@pulumi.output_type
class RegisteredDomainNameServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "glueIps":
            suggest = "glue_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegisteredDomainNameServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegisteredDomainNameServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegisteredDomainNameServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 glue_ips: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: The fully qualified host name of the name server.
        :param Sequence[builtins.str] glue_ips: Glue IP addresses of a name server. The list can contain only one IPv4 and one IPv6 address.
        """
        pulumi.set(__self__, "name", name)
        if glue_ips is not None:
            pulumi.set(__self__, "glue_ips", glue_ips)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The fully qualified host name of the name server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="glueIps")
    def glue_ips(self) -> Optional[Sequence[builtins.str]]:
        """
        Glue IP addresses of a name server. The list can contain only one IPv4 and one IPv6 address.
        """
        return pulumi.get(self, "glue_ips")


@pulumi.output_type
class RegisteredDomainRegistrantContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "contactType":
            suggest = "contact_type"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "extraParams":
            suggest = "extra_params"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "organizationName":
            suggest = "organization_name"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "zipCode":
            suggest = "zip_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegisteredDomainRegistrantContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegisteredDomainRegistrantContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegisteredDomainRegistrantContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_line1: Optional[builtins.str] = None,
                 address_line2: Optional[builtins.str] = None,
                 city: Optional[builtins.str] = None,
                 contact_type: Optional[builtins.str] = None,
                 country_code: Optional[builtins.str] = None,
                 email: Optional[builtins.str] = None,
                 extra_params: Optional[Mapping[str, builtins.str]] = None,
                 fax: Optional[builtins.str] = None,
                 first_name: Optional[builtins.str] = None,
                 last_name: Optional[builtins.str] = None,
                 organization_name: Optional[builtins.str] = None,
                 phone_number: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 zip_code: Optional[builtins.str] = None):
        """
        :param builtins.str address_line1: First line of the contact's address.
        :param builtins.str address_line2: Second line of contact's address, if any.
        :param builtins.str city: The city of the contact's address.
        :param builtins.str contact_type: Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        :param builtins.str country_code: Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        :param builtins.str email: Email address of the contact.
        :param Mapping[str, builtins.str] extra_params: A key-value map of parameters required by certain top-level domains.
        :param builtins.str fax: Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str first_name: First name of contact.
        :param builtins.str last_name: Last name of contact.
        :param builtins.str organization_name: Name of the organization for contact types other than `PERSON`.
        :param builtins.str phone_number: The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str state: The state or province of the contact's city.
        :param builtins.str zip_code: The zip or postal code of the contact's address.
        """
        if address_line1 is not None:
            pulumi.set(__self__, "address_line1", address_line1)
        if address_line2 is not None:
            pulumi.set(__self__, "address_line2", address_line2)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if contact_type is not None:
            pulumi.set(__self__, "contact_type", contact_type)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if extra_params is not None:
            pulumi.set(__self__, "extra_params", extra_params)
        if fax is not None:
            pulumi.set(__self__, "fax", fax)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> Optional[builtins.str]:
        """
        First line of the contact's address.
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> Optional[builtins.str]:
        """
        Second line of contact's address, if any.
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter
    def city(self) -> Optional[builtins.str]:
        """
        The city of the contact's address.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="contactType")
    def contact_type(self) -> Optional[builtins.str]:
        """
        Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        """
        return pulumi.get(self, "contact_type")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[builtins.str]:
        """
        Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        Email address of the contact.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="extraParams")
    def extra_params(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A key-value map of parameters required by certain top-level domains.
        """
        return pulumi.get(self, "extra_params")

    @property
    @pulumi.getter
    def fax(self) -> Optional[builtins.str]:
        """
        Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "fax")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[builtins.str]:
        """
        First name of contact.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[builtins.str]:
        """
        Last name of contact.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[builtins.str]:
        """
        Name of the organization for contact types other than `PERSON`.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[builtins.str]:
        """
        The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state or province of the contact's city.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[builtins.str]:
        """
        The zip or postal code of the contact's address.
        """
        return pulumi.get(self, "zip_code")


@pulumi.output_type
class RegisteredDomainTechContact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLine1":
            suggest = "address_line1"
        elif key == "addressLine2":
            suggest = "address_line2"
        elif key == "contactType":
            suggest = "contact_type"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "extraParams":
            suggest = "extra_params"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"
        elif key == "organizationName":
            suggest = "organization_name"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "zipCode":
            suggest = "zip_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegisteredDomainTechContact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegisteredDomainTechContact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegisteredDomainTechContact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_line1: Optional[builtins.str] = None,
                 address_line2: Optional[builtins.str] = None,
                 city: Optional[builtins.str] = None,
                 contact_type: Optional[builtins.str] = None,
                 country_code: Optional[builtins.str] = None,
                 email: Optional[builtins.str] = None,
                 extra_params: Optional[Mapping[str, builtins.str]] = None,
                 fax: Optional[builtins.str] = None,
                 first_name: Optional[builtins.str] = None,
                 last_name: Optional[builtins.str] = None,
                 organization_name: Optional[builtins.str] = None,
                 phone_number: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None,
                 zip_code: Optional[builtins.str] = None):
        """
        :param builtins.str address_line1: First line of the contact's address.
        :param builtins.str address_line2: Second line of contact's address, if any.
        :param builtins.str city: The city of the contact's address.
        :param builtins.str contact_type: Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        :param builtins.str country_code: Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        :param builtins.str email: Email address of the contact.
        :param Mapping[str, builtins.str] extra_params: A key-value map of parameters required by certain top-level domains.
        :param builtins.str fax: Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str first_name: First name of contact.
        :param builtins.str last_name: Last name of contact.
        :param builtins.str organization_name: Name of the organization for contact types other than `PERSON`.
        :param builtins.str phone_number: The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        :param builtins.str state: The state or province of the contact's city.
        :param builtins.str zip_code: The zip or postal code of the contact's address.
        """
        if address_line1 is not None:
            pulumi.set(__self__, "address_line1", address_line1)
        if address_line2 is not None:
            pulumi.set(__self__, "address_line2", address_line2)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if contact_type is not None:
            pulumi.set(__self__, "contact_type", contact_type)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if extra_params is not None:
            pulumi.set(__self__, "extra_params", extra_params)
        if fax is not None:
            pulumi.set(__self__, "fax", fax)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if organization_name is not None:
            pulumi.set(__self__, "organization_name", organization_name)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> Optional[builtins.str]:
        """
        First line of the contact's address.
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> Optional[builtins.str]:
        """
        Second line of contact's address, if any.
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter
    def city(self) -> Optional[builtins.str]:
        """
        The city of the contact's address.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="contactType")
    def contact_type(self) -> Optional[builtins.str]:
        """
        Indicates whether the contact is a person, company, association, or public organization. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-ContactType) for valid values.
        """
        return pulumi.get(self, "contact_type")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[builtins.str]:
        """
        Code for the country of the contact's address. See the [AWS API documentation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html#Route53Domains-Type-domains_ContactDetail-CountryCode) for valid values.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        Email address of the contact.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="extraParams")
    def extra_params(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A key-value map of parameters required by certain top-level domains.
        """
        return pulumi.get(self, "extra_params")

    @property
    @pulumi.getter
    def fax(self) -> Optional[builtins.str]:
        """
        Fax number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "fax")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[builtins.str]:
        """
        First name of contact.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[builtins.str]:
        """
        Last name of contact.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="organizationName")
    def organization_name(self) -> Optional[builtins.str]:
        """
        Name of the organization for contact types other than `PERSON`.
        """
        return pulumi.get(self, "organization_name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[builtins.str]:
        """
        The phone number of the contact. Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state or province of the contact's city.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[builtins.str]:
        """
        The zip or postal code of the contact's address.
        """
        return pulumi.get(self, "zip_code")


