# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RecoveryGroupArgs', 'RecoveryGroup']

@pulumi.input_type
class RecoveryGroupArgs:
    def __init__(__self__, *,
                 recovery_group_name: pulumi.Input[builtins.str],
                 cells: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a RecoveryGroup resource.
        :param pulumi.Input[builtins.str] recovery_group_name: A unique name describing the recovery group.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cells: List of cell arns to add as nested fault domains within this recovery group
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        """
        pulumi.set(__self__, "recovery_group_name", recovery_group_name)
        if cells is not None:
            pulumi.set(__self__, "cells", cells)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="recoveryGroupName")
    def recovery_group_name(self) -> pulumi.Input[builtins.str]:
        """
        A unique name describing the recovery group.

        The following arguments are optional:
        """
        return pulumi.get(self, "recovery_group_name")

    @recovery_group_name.setter
    def recovery_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "recovery_group_name", value)

    @property
    @pulumi.getter
    def cells(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of cell arns to add as nested fault domains within this recovery group
        """
        return pulumi.get(self, "cells")

    @cells.setter
    def cells(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cells", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RecoveryGroupState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 cells: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 recovery_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering RecoveryGroup resources.
        :param pulumi.Input[builtins.str] arn: ARN of the recovery group
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cells: List of cell arns to add as nested fault domains within this recovery group
        :param pulumi.Input[builtins.str] recovery_group_name: A unique name describing the recovery group.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cells is not None:
            pulumi.set(__self__, "cells", cells)
        if recovery_group_name is not None:
            pulumi.set(__self__, "recovery_group_name", recovery_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the recovery group
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def cells(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of cell arns to add as nested fault domains within this recovery group
        """
        return pulumi.get(self, "cells")

    @cells.setter
    def cells(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cells", value)

    @property
    @pulumi.getter(name="recoveryGroupName")
    def recovery_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name describing the recovery group.

        The following arguments are optional:
        """
        return pulumi.get(self, "recovery_group_name")

    @recovery_group_name.setter
    def recovery_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recovery_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:route53recoveryreadiness/recoveryGroup:RecoveryGroup")
class RecoveryGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cells: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 recovery_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an AWS Route 53 Recovery Readiness Recovery Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.route53recoveryreadiness.RecoveryGroup("example", recovery_group_name="my-high-availability-app")
        ```

        ## Import

        Using `pulumi import`, import Route53 Recovery Readiness recovery groups using the recovery group name. For example:

        ```sh
        $ pulumi import aws:route53recoveryreadiness/recoveryGroup:RecoveryGroup my-high-availability-app my-high-availability-app
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cells: List of cell arns to add as nested fault domains within this recovery group
        :param pulumi.Input[builtins.str] recovery_group_name: A unique name describing the recovery group.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecoveryGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AWS Route 53 Recovery Readiness Recovery Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.route53recoveryreadiness.RecoveryGroup("example", recovery_group_name="my-high-availability-app")
        ```

        ## Import

        Using `pulumi import`, import Route53 Recovery Readiness recovery groups using the recovery group name. For example:

        ```sh
        $ pulumi import aws:route53recoveryreadiness/recoveryGroup:RecoveryGroup my-high-availability-app my-high-availability-app
        ```

        :param str resource_name: The name of the resource.
        :param RecoveryGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecoveryGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cells: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 recovery_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecoveryGroupArgs.__new__(RecoveryGroupArgs)

            __props__.__dict__["cells"] = cells
            if recovery_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_group_name'")
            __props__.__dict__["recovery_group_name"] = recovery_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(RecoveryGroup, __self__).__init__(
            'aws:route53recoveryreadiness/recoveryGroup:RecoveryGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            cells: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            recovery_group_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'RecoveryGroup':
        """
        Get an existing RecoveryGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the recovery group
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cells: List of cell arns to add as nested fault domains within this recovery group
        :param pulumi.Input[builtins.str] recovery_group_name: A unique name describing the recovery group.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecoveryGroupState.__new__(_RecoveryGroupState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["cells"] = cells
        __props__.__dict__["recovery_group_name"] = recovery_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return RecoveryGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the recovery group
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def cells(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of cell arns to add as nested fault domains within this recovery group
        """
        return pulumi.get(self, "cells")

    @property
    @pulumi.getter(name="recoveryGroupName")
    def recovery_group_name(self) -> pulumi.Output[builtins.str]:
        """
        A unique name describing the recovery group.

        The following arguments are optional:
        """
        return pulumi.get(self, "recovery_group_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

