# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MultiRegionAccessPointPolicyArgs', 'MultiRegionAccessPointPolicy']

@pulumi.input_type
class MultiRegionAccessPointPolicyArgs:
    def __init__(__self__, *,
                 details: pulumi.Input['MultiRegionAccessPointPolicyDetailsArgs'],
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MultiRegionAccessPointPolicy resource.
        :param pulumi.Input['MultiRegionAccessPointPolicyDetailsArgs'] details: A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
        :param pulumi.Input[builtins.str] account_id: The AWS account ID for the owner of the Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "details", details)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def details(self) -> pulumi.Input['MultiRegionAccessPointPolicyDetailsArgs']:
        """
        A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: pulumi.Input['MultiRegionAccessPointPolicyDetailsArgs']):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS account ID for the owner of the Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _MultiRegionAccessPointPolicyState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 details: Optional[pulumi.Input['MultiRegionAccessPointPolicyDetailsArgs']] = None,
                 established: Optional[pulumi.Input[builtins.str]] = None,
                 proposed: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MultiRegionAccessPointPolicy resources.
        :param pulumi.Input[builtins.str] account_id: The AWS account ID for the owner of the Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
        :param pulumi.Input['MultiRegionAccessPointPolicyDetailsArgs'] details: A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
        :param pulumi.Input[builtins.str] established: The last established policy for the Multi-Region Access Point.
        :param pulumi.Input[builtins.str] proposed: The proposed policy for the Multi-Region Access Point.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if established is not None:
            pulumi.set(__self__, "established", established)
        if proposed is not None:
            pulumi.set(__self__, "proposed", proposed)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS account ID for the owner of the Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input['MultiRegionAccessPointPolicyDetailsArgs']]:
        """
        A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input['MultiRegionAccessPointPolicyDetailsArgs']]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def established(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last established policy for the Multi-Region Access Point.
        """
        return pulumi.get(self, "established")

    @established.setter
    def established(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "established", value)

    @property
    @pulumi.getter
    def proposed(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The proposed policy for the Multi-Region Access Point.
        """
        return pulumi.get(self, "proposed")

    @proposed.setter
    def proposed(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "proposed", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:s3control/multiRegionAccessPointPolicy:MultiRegionAccessPointPolicy")
class MultiRegionAccessPointPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 details: Optional[pulumi.Input[Union['MultiRegionAccessPointPolicyDetailsArgs', 'MultiRegionAccessPointPolicyDetailsArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to manage an S3 Multi-Region Access Point access control policy.

        ## Example Usage

        ## Import

        Using `pulumi import`, import Multi-Region Access Point Policies using the `account_id` and `name` of the Multi-Region Access Point separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:s3control/multiRegionAccessPointPolicy:MultiRegionAccessPointPolicy example 123456789012:example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The AWS account ID for the owner of the Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
        :param pulumi.Input[Union['MultiRegionAccessPointPolicyDetailsArgs', 'MultiRegionAccessPointPolicyDetailsArgsDict']] details: A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MultiRegionAccessPointPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage an S3 Multi-Region Access Point access control policy.

        ## Example Usage

        ## Import

        Using `pulumi import`, import Multi-Region Access Point Policies using the `account_id` and `name` of the Multi-Region Access Point separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:s3control/multiRegionAccessPointPolicy:MultiRegionAccessPointPolicy example 123456789012:example
        ```

        :param str resource_name: The name of the resource.
        :param MultiRegionAccessPointPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MultiRegionAccessPointPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 details: Optional[pulumi.Input[Union['MultiRegionAccessPointPolicyDetailsArgs', 'MultiRegionAccessPointPolicyDetailsArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MultiRegionAccessPointPolicyArgs.__new__(MultiRegionAccessPointPolicyArgs)

            __props__.__dict__["account_id"] = account_id
            if details is None and not opts.urn:
                raise TypeError("Missing required property 'details'")
            __props__.__dict__["details"] = details
            __props__.__dict__["region"] = region
            __props__.__dict__["established"] = None
            __props__.__dict__["proposed"] = None
        super(MultiRegionAccessPointPolicy, __self__).__init__(
            'aws:s3control/multiRegionAccessPointPolicy:MultiRegionAccessPointPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            details: Optional[pulumi.Input[Union['MultiRegionAccessPointPolicyDetailsArgs', 'MultiRegionAccessPointPolicyDetailsArgsDict']]] = None,
            established: Optional[pulumi.Input[builtins.str]] = None,
            proposed: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'MultiRegionAccessPointPolicy':
        """
        Get an existing MultiRegionAccessPointPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The AWS account ID for the owner of the Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
        :param pulumi.Input[Union['MultiRegionAccessPointPolicyDetailsArgs', 'MultiRegionAccessPointPolicyDetailsArgsDict']] details: A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
        :param pulumi.Input[builtins.str] established: The last established policy for the Multi-Region Access Point.
        :param pulumi.Input[builtins.str] proposed: The proposed policy for the Multi-Region Access Point.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MultiRegionAccessPointPolicyState.__new__(_MultiRegionAccessPointPolicyState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["details"] = details
        __props__.__dict__["established"] = established
        __props__.__dict__["proposed"] = proposed
        __props__.__dict__["region"] = region
        return MultiRegionAccessPointPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        The AWS account ID for the owner of the Multi-Region Access Point. Defaults to automatically determined account ID of the AWS provider.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def details(self) -> pulumi.Output['outputs.MultiRegionAccessPointPolicyDetails']:
        """
        A configuration block containing details about the policy for the Multi-Region Access Point. See Details Configuration Block below for more details
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def established(self) -> pulumi.Output[builtins.str]:
        """
        The last established policy for the Multi-Region Access Point.
        """
        return pulumi.get(self, "established")

    @property
    @pulumi.getter
    def proposed(self) -> pulumi.Output[builtins.str]:
        """
        The proposed policy for the Multi-Region Access Point.
        """
        return pulumi.get(self, "proposed")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

