# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataQualityJobDefinitionArgs', 'DataQualityJobDefinition']

@pulumi.input_type
class DataQualityJobDefinitionArgs:
    def __init__(__self__, *,
                 data_quality_app_specification: pulumi.Input['DataQualityJobDefinitionDataQualityAppSpecificationArgs'],
                 data_quality_job_input: pulumi.Input['DataQualityJobDefinitionDataQualityJobInputArgs'],
                 data_quality_job_output_config: pulumi.Input['DataQualityJobDefinitionDataQualityJobOutputConfigArgs'],
                 job_resources: pulumi.Input['DataQualityJobDefinitionJobResourcesArgs'],
                 role_arn: pulumi.Input[builtins.str],
                 data_quality_baseline_config: Optional[pulumi.Input['DataQualityJobDefinitionDataQualityBaselineConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input['DataQualityJobDefinitionNetworkConfigArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 stopping_condition: Optional[pulumi.Input['DataQualityJobDefinitionStoppingConditionArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a DataQualityJobDefinition resource.
        :param pulumi.Input['DataQualityJobDefinitionDataQualityAppSpecificationArgs'] data_quality_app_specification: Specifies the container that runs the monitoring job. Fields are documented below.
        :param pulumi.Input['DataQualityJobDefinitionDataQualityJobInputArgs'] data_quality_job_input: A list of inputs for the monitoring job. Fields are documented below.
        :param pulumi.Input['DataQualityJobDefinitionDataQualityJobOutputConfigArgs'] data_quality_job_output_config: The output configuration for monitoring jobs. Fields are documented below.
        :param pulumi.Input['DataQualityJobDefinitionJobResourcesArgs'] job_resources: Identifies the resources to deploy for a monitoring job. Fields are documented below.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI can assume to perform tasks on your behalf.
        :param pulumi.Input['DataQualityJobDefinitionDataQualityBaselineConfigArgs'] data_quality_baseline_config: Configures the constraints and baselines for the monitoring job. Fields are documented below.
        :param pulumi.Input[builtins.str] name: The name of the data quality job definition. If omitted, the provider will assign a random, unique name.
        :param pulumi.Input['DataQualityJobDefinitionNetworkConfigArgs'] network_config: Specifies networking configuration for the monitoring job. Fields are documented below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['DataQualityJobDefinitionStoppingConditionArgs'] stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping. Fields are documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "data_quality_app_specification", data_quality_app_specification)
        pulumi.set(__self__, "data_quality_job_input", data_quality_job_input)
        pulumi.set(__self__, "data_quality_job_output_config", data_quality_job_output_config)
        pulumi.set(__self__, "job_resources", job_resources)
        pulumi.set(__self__, "role_arn", role_arn)
        if data_quality_baseline_config is not None:
            pulumi.set(__self__, "data_quality_baseline_config", data_quality_baseline_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if stopping_condition is not None:
            pulumi.set(__self__, "stopping_condition", stopping_condition)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataQualityAppSpecification")
    def data_quality_app_specification(self) -> pulumi.Input['DataQualityJobDefinitionDataQualityAppSpecificationArgs']:
        """
        Specifies the container that runs the monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "data_quality_app_specification")

    @data_quality_app_specification.setter
    def data_quality_app_specification(self, value: pulumi.Input['DataQualityJobDefinitionDataQualityAppSpecificationArgs']):
        pulumi.set(self, "data_quality_app_specification", value)

    @property
    @pulumi.getter(name="dataQualityJobInput")
    def data_quality_job_input(self) -> pulumi.Input['DataQualityJobDefinitionDataQualityJobInputArgs']:
        """
        A list of inputs for the monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "data_quality_job_input")

    @data_quality_job_input.setter
    def data_quality_job_input(self, value: pulumi.Input['DataQualityJobDefinitionDataQualityJobInputArgs']):
        pulumi.set(self, "data_quality_job_input", value)

    @property
    @pulumi.getter(name="dataQualityJobOutputConfig")
    def data_quality_job_output_config(self) -> pulumi.Input['DataQualityJobDefinitionDataQualityJobOutputConfigArgs']:
        """
        The output configuration for monitoring jobs. Fields are documented below.
        """
        return pulumi.get(self, "data_quality_job_output_config")

    @data_quality_job_output_config.setter
    def data_quality_job_output_config(self, value: pulumi.Input['DataQualityJobDefinitionDataQualityJobOutputConfigArgs']):
        pulumi.set(self, "data_quality_job_output_config", value)

    @property
    @pulumi.getter(name="jobResources")
    def job_resources(self) -> pulumi.Input['DataQualityJobDefinitionJobResourcesArgs']:
        """
        Identifies the resources to deploy for a monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "job_resources")

    @job_resources.setter
    def job_resources(self, value: pulumi.Input['DataQualityJobDefinitionJobResourcesArgs']):
        pulumi.set(self, "job_resources", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI can assume to perform tasks on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="dataQualityBaselineConfig")
    def data_quality_baseline_config(self) -> Optional[pulumi.Input['DataQualityJobDefinitionDataQualityBaselineConfigArgs']]:
        """
        Configures the constraints and baselines for the monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "data_quality_baseline_config")

    @data_quality_baseline_config.setter
    def data_quality_baseline_config(self, value: Optional[pulumi.Input['DataQualityJobDefinitionDataQualityBaselineConfigArgs']]):
        pulumi.set(self, "data_quality_baseline_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the data quality job definition. If omitted, the provider will assign a random, unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['DataQualityJobDefinitionNetworkConfigArgs']]:
        """
        Specifies networking configuration for the monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['DataQualityJobDefinitionNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="stoppingCondition")
    def stopping_condition(self) -> Optional[pulumi.Input['DataQualityJobDefinitionStoppingConditionArgs']]:
        """
        A time limit for how long the monitoring job is allowed to run before stopping. Fields are documented below.
        """
        return pulumi.get(self, "stopping_condition")

    @stopping_condition.setter
    def stopping_condition(self, value: Optional[pulumi.Input['DataQualityJobDefinitionStoppingConditionArgs']]):
        pulumi.set(self, "stopping_condition", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DataQualityJobDefinitionState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 data_quality_app_specification: Optional[pulumi.Input['DataQualityJobDefinitionDataQualityAppSpecificationArgs']] = None,
                 data_quality_baseline_config: Optional[pulumi.Input['DataQualityJobDefinitionDataQualityBaselineConfigArgs']] = None,
                 data_quality_job_input: Optional[pulumi.Input['DataQualityJobDefinitionDataQualityJobInputArgs']] = None,
                 data_quality_job_output_config: Optional[pulumi.Input['DataQualityJobDefinitionDataQualityJobOutputConfigArgs']] = None,
                 job_resources: Optional[pulumi.Input['DataQualityJobDefinitionJobResourcesArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input['DataQualityJobDefinitionNetworkConfigArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 stopping_condition: Optional[pulumi.Input['DataQualityJobDefinitionStoppingConditionArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DataQualityJobDefinition resources.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) assigned by AWS to this data quality job definition.
        :param pulumi.Input['DataQualityJobDefinitionDataQualityAppSpecificationArgs'] data_quality_app_specification: Specifies the container that runs the monitoring job. Fields are documented below.
        :param pulumi.Input['DataQualityJobDefinitionDataQualityBaselineConfigArgs'] data_quality_baseline_config: Configures the constraints and baselines for the monitoring job. Fields are documented below.
        :param pulumi.Input['DataQualityJobDefinitionDataQualityJobInputArgs'] data_quality_job_input: A list of inputs for the monitoring job. Fields are documented below.
        :param pulumi.Input['DataQualityJobDefinitionDataQualityJobOutputConfigArgs'] data_quality_job_output_config: The output configuration for monitoring jobs. Fields are documented below.
        :param pulumi.Input['DataQualityJobDefinitionJobResourcesArgs'] job_resources: Identifies the resources to deploy for a monitoring job. Fields are documented below.
        :param pulumi.Input[builtins.str] name: The name of the data quality job definition. If omitted, the provider will assign a random, unique name.
        :param pulumi.Input['DataQualityJobDefinitionNetworkConfigArgs'] network_config: Specifies networking configuration for the monitoring job. Fields are documented below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI can assume to perform tasks on your behalf.
        :param pulumi.Input['DataQualityJobDefinitionStoppingConditionArgs'] stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping. Fields are documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if data_quality_app_specification is not None:
            pulumi.set(__self__, "data_quality_app_specification", data_quality_app_specification)
        if data_quality_baseline_config is not None:
            pulumi.set(__self__, "data_quality_baseline_config", data_quality_baseline_config)
        if data_quality_job_input is not None:
            pulumi.set(__self__, "data_quality_job_input", data_quality_job_input)
        if data_quality_job_output_config is not None:
            pulumi.set(__self__, "data_quality_job_output_config", data_quality_job_output_config)
        if job_resources is not None:
            pulumi.set(__self__, "job_resources", job_resources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if stopping_condition is not None:
            pulumi.set(__self__, "stopping_condition", stopping_condition)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) assigned by AWS to this data quality job definition.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="dataQualityAppSpecification")
    def data_quality_app_specification(self) -> Optional[pulumi.Input['DataQualityJobDefinitionDataQualityAppSpecificationArgs']]:
        """
        Specifies the container that runs the monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "data_quality_app_specification")

    @data_quality_app_specification.setter
    def data_quality_app_specification(self, value: Optional[pulumi.Input['DataQualityJobDefinitionDataQualityAppSpecificationArgs']]):
        pulumi.set(self, "data_quality_app_specification", value)

    @property
    @pulumi.getter(name="dataQualityBaselineConfig")
    def data_quality_baseline_config(self) -> Optional[pulumi.Input['DataQualityJobDefinitionDataQualityBaselineConfigArgs']]:
        """
        Configures the constraints and baselines for the monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "data_quality_baseline_config")

    @data_quality_baseline_config.setter
    def data_quality_baseline_config(self, value: Optional[pulumi.Input['DataQualityJobDefinitionDataQualityBaselineConfigArgs']]):
        pulumi.set(self, "data_quality_baseline_config", value)

    @property
    @pulumi.getter(name="dataQualityJobInput")
    def data_quality_job_input(self) -> Optional[pulumi.Input['DataQualityJobDefinitionDataQualityJobInputArgs']]:
        """
        A list of inputs for the monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "data_quality_job_input")

    @data_quality_job_input.setter
    def data_quality_job_input(self, value: Optional[pulumi.Input['DataQualityJobDefinitionDataQualityJobInputArgs']]):
        pulumi.set(self, "data_quality_job_input", value)

    @property
    @pulumi.getter(name="dataQualityJobOutputConfig")
    def data_quality_job_output_config(self) -> Optional[pulumi.Input['DataQualityJobDefinitionDataQualityJobOutputConfigArgs']]:
        """
        The output configuration for monitoring jobs. Fields are documented below.
        """
        return pulumi.get(self, "data_quality_job_output_config")

    @data_quality_job_output_config.setter
    def data_quality_job_output_config(self, value: Optional[pulumi.Input['DataQualityJobDefinitionDataQualityJobOutputConfigArgs']]):
        pulumi.set(self, "data_quality_job_output_config", value)

    @property
    @pulumi.getter(name="jobResources")
    def job_resources(self) -> Optional[pulumi.Input['DataQualityJobDefinitionJobResourcesArgs']]:
        """
        Identifies the resources to deploy for a monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "job_resources")

    @job_resources.setter
    def job_resources(self, value: Optional[pulumi.Input['DataQualityJobDefinitionJobResourcesArgs']]):
        pulumi.set(self, "job_resources", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the data quality job definition. If omitted, the provider will assign a random, unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['DataQualityJobDefinitionNetworkConfigArgs']]:
        """
        Specifies networking configuration for the monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['DataQualityJobDefinitionNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI can assume to perform tasks on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="stoppingCondition")
    def stopping_condition(self) -> Optional[pulumi.Input['DataQualityJobDefinitionStoppingConditionArgs']]:
        """
        A time limit for how long the monitoring job is allowed to run before stopping. Fields are documented below.
        """
        return pulumi.get(self, "stopping_condition")

    @stopping_condition.setter
    def stopping_condition(self, value: Optional[pulumi.Input['DataQualityJobDefinitionStoppingConditionArgs']]):
        pulumi.set(self, "stopping_condition", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:sagemaker/dataQualityJobDefinition:DataQualityJobDefinition")
class DataQualityJobDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_quality_app_specification: Optional[pulumi.Input[Union['DataQualityJobDefinitionDataQualityAppSpecificationArgs', 'DataQualityJobDefinitionDataQualityAppSpecificationArgsDict']]] = None,
                 data_quality_baseline_config: Optional[pulumi.Input[Union['DataQualityJobDefinitionDataQualityBaselineConfigArgs', 'DataQualityJobDefinitionDataQualityBaselineConfigArgsDict']]] = None,
                 data_quality_job_input: Optional[pulumi.Input[Union['DataQualityJobDefinitionDataQualityJobInputArgs', 'DataQualityJobDefinitionDataQualityJobInputArgsDict']]] = None,
                 data_quality_job_output_config: Optional[pulumi.Input[Union['DataQualityJobDefinitionDataQualityJobOutputConfigArgs', 'DataQualityJobDefinitionDataQualityJobOutputConfigArgsDict']]] = None,
                 job_resources: Optional[pulumi.Input[Union['DataQualityJobDefinitionJobResourcesArgs', 'DataQualityJobDefinitionJobResourcesArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input[Union['DataQualityJobDefinitionNetworkConfigArgs', 'DataQualityJobDefinitionNetworkConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 stopping_condition: Optional[pulumi.Input[Union['DataQualityJobDefinitionStoppingConditionArgs', 'DataQualityJobDefinitionStoppingConditionArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a SageMaker AI data quality job definition resource.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.sagemaker.DataQualityJobDefinition("test",
            name="my-data-quality-job-definition",
            data_quality_app_specification={
                "image_uri": monitor["registryPath"],
            },
            data_quality_job_input={
                "endpoint_input": {
                    "endpoint_name": my_endpoint["name"],
                },
            },
            data_quality_job_output_config={
                "monitoring_outputs": {
                    "s3_output": {
                        "s3_uri": f"https://{my_bucket['bucketRegionalDomainName']}/output",
                    },
                },
            },
            job_resources={
                "cluster_config": {
                    "instance_count": 1,
                    "instance_type": "ml.t3.medium",
                    "volume_size_in_gb": 20,
                },
            },
            role_arn=my_role["arn"])
        ```

        ## Import

        Using `pulumi import`, import data quality job definitions using the `name`. For example:

        ```sh
        $ pulumi import aws:sagemaker/dataQualityJobDefinition:DataQualityJobDefinition test_data_quality_job_definition data-quality-job-definition-foo
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DataQualityJobDefinitionDataQualityAppSpecificationArgs', 'DataQualityJobDefinitionDataQualityAppSpecificationArgsDict']] data_quality_app_specification: Specifies the container that runs the monitoring job. Fields are documented below.
        :param pulumi.Input[Union['DataQualityJobDefinitionDataQualityBaselineConfigArgs', 'DataQualityJobDefinitionDataQualityBaselineConfigArgsDict']] data_quality_baseline_config: Configures the constraints and baselines for the monitoring job. Fields are documented below.
        :param pulumi.Input[Union['DataQualityJobDefinitionDataQualityJobInputArgs', 'DataQualityJobDefinitionDataQualityJobInputArgsDict']] data_quality_job_input: A list of inputs for the monitoring job. Fields are documented below.
        :param pulumi.Input[Union['DataQualityJobDefinitionDataQualityJobOutputConfigArgs', 'DataQualityJobDefinitionDataQualityJobOutputConfigArgsDict']] data_quality_job_output_config: The output configuration for monitoring jobs. Fields are documented below.
        :param pulumi.Input[Union['DataQualityJobDefinitionJobResourcesArgs', 'DataQualityJobDefinitionJobResourcesArgsDict']] job_resources: Identifies the resources to deploy for a monitoring job. Fields are documented below.
        :param pulumi.Input[builtins.str] name: The name of the data quality job definition. If omitted, the provider will assign a random, unique name.
        :param pulumi.Input[Union['DataQualityJobDefinitionNetworkConfigArgs', 'DataQualityJobDefinitionNetworkConfigArgsDict']] network_config: Specifies networking configuration for the monitoring job. Fields are documented below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI can assume to perform tasks on your behalf.
        :param pulumi.Input[Union['DataQualityJobDefinitionStoppingConditionArgs', 'DataQualityJobDefinitionStoppingConditionArgsDict']] stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping. Fields are documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataQualityJobDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SageMaker AI data quality job definition resource.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.sagemaker.DataQualityJobDefinition("test",
            name="my-data-quality-job-definition",
            data_quality_app_specification={
                "image_uri": monitor["registryPath"],
            },
            data_quality_job_input={
                "endpoint_input": {
                    "endpoint_name": my_endpoint["name"],
                },
            },
            data_quality_job_output_config={
                "monitoring_outputs": {
                    "s3_output": {
                        "s3_uri": f"https://{my_bucket['bucketRegionalDomainName']}/output",
                    },
                },
            },
            job_resources={
                "cluster_config": {
                    "instance_count": 1,
                    "instance_type": "ml.t3.medium",
                    "volume_size_in_gb": 20,
                },
            },
            role_arn=my_role["arn"])
        ```

        ## Import

        Using `pulumi import`, import data quality job definitions using the `name`. For example:

        ```sh
        $ pulumi import aws:sagemaker/dataQualityJobDefinition:DataQualityJobDefinition test_data_quality_job_definition data-quality-job-definition-foo
        ```

        :param str resource_name: The name of the resource.
        :param DataQualityJobDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataQualityJobDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_quality_app_specification: Optional[pulumi.Input[Union['DataQualityJobDefinitionDataQualityAppSpecificationArgs', 'DataQualityJobDefinitionDataQualityAppSpecificationArgsDict']]] = None,
                 data_quality_baseline_config: Optional[pulumi.Input[Union['DataQualityJobDefinitionDataQualityBaselineConfigArgs', 'DataQualityJobDefinitionDataQualityBaselineConfigArgsDict']]] = None,
                 data_quality_job_input: Optional[pulumi.Input[Union['DataQualityJobDefinitionDataQualityJobInputArgs', 'DataQualityJobDefinitionDataQualityJobInputArgsDict']]] = None,
                 data_quality_job_output_config: Optional[pulumi.Input[Union['DataQualityJobDefinitionDataQualityJobOutputConfigArgs', 'DataQualityJobDefinitionDataQualityJobOutputConfigArgsDict']]] = None,
                 job_resources: Optional[pulumi.Input[Union['DataQualityJobDefinitionJobResourcesArgs', 'DataQualityJobDefinitionJobResourcesArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input[Union['DataQualityJobDefinitionNetworkConfigArgs', 'DataQualityJobDefinitionNetworkConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 stopping_condition: Optional[pulumi.Input[Union['DataQualityJobDefinitionStoppingConditionArgs', 'DataQualityJobDefinitionStoppingConditionArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataQualityJobDefinitionArgs.__new__(DataQualityJobDefinitionArgs)

            if data_quality_app_specification is None and not opts.urn:
                raise TypeError("Missing required property 'data_quality_app_specification'")
            __props__.__dict__["data_quality_app_specification"] = data_quality_app_specification
            __props__.__dict__["data_quality_baseline_config"] = data_quality_baseline_config
            if data_quality_job_input is None and not opts.urn:
                raise TypeError("Missing required property 'data_quality_job_input'")
            __props__.__dict__["data_quality_job_input"] = data_quality_job_input
            if data_quality_job_output_config is None and not opts.urn:
                raise TypeError("Missing required property 'data_quality_job_output_config'")
            __props__.__dict__["data_quality_job_output_config"] = data_quality_job_output_config
            if job_resources is None and not opts.urn:
                raise TypeError("Missing required property 'job_resources'")
            __props__.__dict__["job_resources"] = job_resources
            __props__.__dict__["name"] = name
            __props__.__dict__["network_config"] = network_config
            __props__.__dict__["region"] = region
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["stopping_condition"] = stopping_condition
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(DataQualityJobDefinition, __self__).__init__(
            'aws:sagemaker/dataQualityJobDefinition:DataQualityJobDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            data_quality_app_specification: Optional[pulumi.Input[Union['DataQualityJobDefinitionDataQualityAppSpecificationArgs', 'DataQualityJobDefinitionDataQualityAppSpecificationArgsDict']]] = None,
            data_quality_baseline_config: Optional[pulumi.Input[Union['DataQualityJobDefinitionDataQualityBaselineConfigArgs', 'DataQualityJobDefinitionDataQualityBaselineConfigArgsDict']]] = None,
            data_quality_job_input: Optional[pulumi.Input[Union['DataQualityJobDefinitionDataQualityJobInputArgs', 'DataQualityJobDefinitionDataQualityJobInputArgsDict']]] = None,
            data_quality_job_output_config: Optional[pulumi.Input[Union['DataQualityJobDefinitionDataQualityJobOutputConfigArgs', 'DataQualityJobDefinitionDataQualityJobOutputConfigArgsDict']]] = None,
            job_resources: Optional[pulumi.Input[Union['DataQualityJobDefinitionJobResourcesArgs', 'DataQualityJobDefinitionJobResourcesArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_config: Optional[pulumi.Input[Union['DataQualityJobDefinitionNetworkConfigArgs', 'DataQualityJobDefinitionNetworkConfigArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            role_arn: Optional[pulumi.Input[builtins.str]] = None,
            stopping_condition: Optional[pulumi.Input[Union['DataQualityJobDefinitionStoppingConditionArgs', 'DataQualityJobDefinitionStoppingConditionArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'DataQualityJobDefinition':
        """
        Get an existing DataQualityJobDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) assigned by AWS to this data quality job definition.
        :param pulumi.Input[Union['DataQualityJobDefinitionDataQualityAppSpecificationArgs', 'DataQualityJobDefinitionDataQualityAppSpecificationArgsDict']] data_quality_app_specification: Specifies the container that runs the monitoring job. Fields are documented below.
        :param pulumi.Input[Union['DataQualityJobDefinitionDataQualityBaselineConfigArgs', 'DataQualityJobDefinitionDataQualityBaselineConfigArgsDict']] data_quality_baseline_config: Configures the constraints and baselines for the monitoring job. Fields are documented below.
        :param pulumi.Input[Union['DataQualityJobDefinitionDataQualityJobInputArgs', 'DataQualityJobDefinitionDataQualityJobInputArgsDict']] data_quality_job_input: A list of inputs for the monitoring job. Fields are documented below.
        :param pulumi.Input[Union['DataQualityJobDefinitionDataQualityJobOutputConfigArgs', 'DataQualityJobDefinitionDataQualityJobOutputConfigArgsDict']] data_quality_job_output_config: The output configuration for monitoring jobs. Fields are documented below.
        :param pulumi.Input[Union['DataQualityJobDefinitionJobResourcesArgs', 'DataQualityJobDefinitionJobResourcesArgsDict']] job_resources: Identifies the resources to deploy for a monitoring job. Fields are documented below.
        :param pulumi.Input[builtins.str] name: The name of the data quality job definition. If omitted, the provider will assign a random, unique name.
        :param pulumi.Input[Union['DataQualityJobDefinitionNetworkConfigArgs', 'DataQualityJobDefinitionNetworkConfigArgsDict']] network_config: Specifies networking configuration for the monitoring job. Fields are documented below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI can assume to perform tasks on your behalf.
        :param pulumi.Input[Union['DataQualityJobDefinitionStoppingConditionArgs', 'DataQualityJobDefinitionStoppingConditionArgsDict']] stopping_condition: A time limit for how long the monitoring job is allowed to run before stopping. Fields are documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataQualityJobDefinitionState.__new__(_DataQualityJobDefinitionState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["data_quality_app_specification"] = data_quality_app_specification
        __props__.__dict__["data_quality_baseline_config"] = data_quality_baseline_config
        __props__.__dict__["data_quality_job_input"] = data_quality_job_input
        __props__.__dict__["data_quality_job_output_config"] = data_quality_job_output_config
        __props__.__dict__["job_resources"] = job_resources
        __props__.__dict__["name"] = name
        __props__.__dict__["network_config"] = network_config
        __props__.__dict__["region"] = region
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["stopping_condition"] = stopping_condition
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return DataQualityJobDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) assigned by AWS to this data quality job definition.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dataQualityAppSpecification")
    def data_quality_app_specification(self) -> pulumi.Output['outputs.DataQualityJobDefinitionDataQualityAppSpecification']:
        """
        Specifies the container that runs the monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "data_quality_app_specification")

    @property
    @pulumi.getter(name="dataQualityBaselineConfig")
    def data_quality_baseline_config(self) -> pulumi.Output[Optional['outputs.DataQualityJobDefinitionDataQualityBaselineConfig']]:
        """
        Configures the constraints and baselines for the monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "data_quality_baseline_config")

    @property
    @pulumi.getter(name="dataQualityJobInput")
    def data_quality_job_input(self) -> pulumi.Output['outputs.DataQualityJobDefinitionDataQualityJobInput']:
        """
        A list of inputs for the monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "data_quality_job_input")

    @property
    @pulumi.getter(name="dataQualityJobOutputConfig")
    def data_quality_job_output_config(self) -> pulumi.Output['outputs.DataQualityJobDefinitionDataQualityJobOutputConfig']:
        """
        The output configuration for monitoring jobs. Fields are documented below.
        """
        return pulumi.get(self, "data_quality_job_output_config")

    @property
    @pulumi.getter(name="jobResources")
    def job_resources(self) -> pulumi.Output['outputs.DataQualityJobDefinitionJobResources']:
        """
        Identifies the resources to deploy for a monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "job_resources")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the data quality job definition. If omitted, the provider will assign a random, unique name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Output[Optional['outputs.DataQualityJobDefinitionNetworkConfig']]:
        """
        Specifies networking configuration for the monitoring job. Fields are documented below.
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI can assume to perform tasks on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="stoppingCondition")
    def stopping_condition(self) -> pulumi.Output['outputs.DataQualityJobDefinitionStoppingCondition']:
        """
        A time limit for how long the monitoring job is allowed to run before stopping. Fields are documented below.
        """
        return pulumi.get(self, "stopping_condition")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

