# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPrebuiltEcrImageResult',
    'AwaitableGetPrebuiltEcrImageResult',
    'get_prebuilt_ecr_image',
    'get_prebuilt_ecr_image_output',
]

@pulumi.output_type
class GetPrebuiltEcrImageResult:
    """
    A collection of values returned by getPrebuiltEcrImage.
    """
    def __init__(__self__, dns_suffix=None, id=None, image_tag=None, region=None, registry_id=None, registry_path=None, repository_name=None):
        if dns_suffix and not isinstance(dns_suffix, str):
            raise TypeError("Expected argument 'dns_suffix' to be a str")
        pulumi.set(__self__, "dns_suffix", dns_suffix)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_tag and not isinstance(image_tag, str):
            raise TypeError("Expected argument 'image_tag' to be a str")
        pulumi.set(__self__, "image_tag", image_tag)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if registry_id and not isinstance(registry_id, str):
            raise TypeError("Expected argument 'registry_id' to be a str")
        pulumi.set(__self__, "registry_id", registry_id)
        if registry_path and not isinstance(registry_path, str):
            raise TypeError("Expected argument 'registry_path' to be a str")
        pulumi.set(__self__, "registry_path", registry_path)
        if repository_name and not isinstance(repository_name, str):
            raise TypeError("Expected argument 'repository_name' to be a str")
        pulumi.set(__self__, "repository_name", repository_name)

    @property
    @pulumi.getter(name="dnsSuffix")
    def dns_suffix(self) -> Optional[builtins.str]:
        return pulumi.get(self, "dns_suffix")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageTag")
    def image_tag(self) -> Optional[builtins.str]:
        return pulumi.get(self, "image_tag")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> builtins.str:
        """
        Account ID containing the image. For example, `469771592824`.
        """
        return pulumi.get(self, "registry_id")

    @property
    @pulumi.getter(name="registryPath")
    def registry_path(self) -> builtins.str:
        """
        Docker image URL. For example, `341280168497.dkr.ecr.ca-central-1.amazonaws.com/sagemaker-sparkml-serving:2.4`.
        """
        return pulumi.get(self, "registry_path")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> builtins.str:
        return pulumi.get(self, "repository_name")


class AwaitableGetPrebuiltEcrImageResult(GetPrebuiltEcrImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrebuiltEcrImageResult(
            dns_suffix=self.dns_suffix,
            id=self.id,
            image_tag=self.image_tag,
            region=self.region,
            registry_id=self.registry_id,
            registry_path=self.registry_path,
            repository_name=self.repository_name)


def get_prebuilt_ecr_image(dns_suffix: Optional[builtins.str] = None,
                           image_tag: Optional[builtins.str] = None,
                           region: Optional[builtins.str] = None,
                           repository_name: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrebuiltEcrImageResult:
    """
    Get information about prebuilt Amazon SageMaker AI  Docker images.

    > **NOTE:** The AWS provider creates a validly constructed `registry_path` but does not verify that the `registry_path` corresponds to an existing image. For example, using a `registry_path` containing an `image_tag` that does not correspond to a Docker image in the ECR repository, will result in an error.

    ## Example Usage

    Basic usage:

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.sagemaker.get_prebuilt_ecr_image(repository_name="sagemaker-scikit-learn",
        image_tag="2.2-1.0.11.0")
    ```


    :param builtins.str dns_suffix: DNS suffix to use in the registry path. If not specified, the AWS provider sets it to the DNS suffix for the current region.
    :param builtins.str image_tag: Image tag for the Docker image. If not specified, the AWS provider sets the value to `1`, which for many repositories indicates the latest version. Some repositories, such as XGBoost, do not support `1` or `latest` and specific version must be used.
    :param builtins.str region: Region to use in the registry path. Defaults to the Region set in the provider configuration.
    :param builtins.str repository_name: Name of the repository, which is generally the algorithm or library. Values include `autogluon-inference`, `autogluon-training`, `blazingtext`, `djl-inference`, `factorization-machines`, `forecasting-deepar`, `huggingface-pytorch-inference`, `huggingface-pytorch-inference-neuron`, `huggingface-pytorch-inference-neuronx`, `huggingface-pytorch-tgi-inference`, `huggingface-pytorch-training`, `huggingface-pytorch-training-neuronx`, `huggingface-pytorch-trcomp-training`, `huggingface-tensorflow-inference`, `huggingface-tensorflow-training`, `huggingface-tensorflow-trcomp-training`, `image-classification`, `image-classification-neo`, `ipinsights`, `kmeans`, `knn`, `lda`, `linear-learner`, `mxnet-inference`, `mxnet-inference-eia`, `mxnet-training`, `ntm`, `object-detection`, `object2vec`, `pca`, `pytorch-inference`, `pytorch-inference-eia`, `pytorch-inference-graviton`, `pytorch-inference-neuronx`, `pytorch-training`, `pytorch-training-neuronx`, `pytorch-trcomp-training`, `randomcutforest`, `sagemaker-base-python`, `sagemaker-chainer`, `sagemaker-clarify-processing`, `sagemaker-data-wrangler-container`, `sagemaker-debugger-rules`, `sagemaker-geospatial-v1-0`, `sagemaker-inference-mxnet`, `sagemaker-inference-pytorch`, `sagemaker-inference-tensorflow`, `sagemaker-model-monitor-analyzer`, `sagemaker-mxnet`, `sagemaker-mxnet-eia`, `sagemaker-mxnet-serving`, `sagemaker-mxnet-serving-eia`, `sagemaker-neo-mxnet`, `sagemaker-neo-pytorch`, `sagemaker-neo-tensorflow`, `sagemaker-pytorch`, `sagemaker-rl-coach-container`, `sagemaker-rl-mxnet`, `sagemaker-rl-ray-container`, `sagemaker-rl-tensorflow`, `sagemaker-rl-vw-container`, `sagemaker-scikit-learn`, `sagemaker-spark-processing`, `sagemaker-sparkml-serving`, `sagemaker-tensorflow`, `sagemaker-tensorflow-eia`, `sagemaker-tensorflow-scriptmode`, `sagemaker-tensorflow-serving`, `sagemaker-tensorflow-serving-eia`, `sagemaker-tritonserver`, `sagemaker-xgboost`, `semantic-segmentation`, `seq2seq`, `stabilityai-pytorch-inference`, `tei`, `tei-cpu`, `tensorflow-inference`, `tensorflow-inference-eia`, `tensorflow-inference-graviton`, `tensorflow-training`, and `xgboost-neo`.
    """
    __args__ = dict()
    __args__['dnsSuffix'] = dns_suffix
    __args__['imageTag'] = image_tag
    __args__['region'] = region
    __args__['repositoryName'] = repository_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:sagemaker/getPrebuiltEcrImage:getPrebuiltEcrImage', __args__, opts=opts, typ=GetPrebuiltEcrImageResult).value

    return AwaitableGetPrebuiltEcrImageResult(
        dns_suffix=pulumi.get(__ret__, 'dns_suffix'),
        id=pulumi.get(__ret__, 'id'),
        image_tag=pulumi.get(__ret__, 'image_tag'),
        region=pulumi.get(__ret__, 'region'),
        registry_id=pulumi.get(__ret__, 'registry_id'),
        registry_path=pulumi.get(__ret__, 'registry_path'),
        repository_name=pulumi.get(__ret__, 'repository_name'))
def get_prebuilt_ecr_image_output(dns_suffix: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  image_tag: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  repository_name: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrebuiltEcrImageResult]:
    """
    Get information about prebuilt Amazon SageMaker AI  Docker images.

    > **NOTE:** The AWS provider creates a validly constructed `registry_path` but does not verify that the `registry_path` corresponds to an existing image. For example, using a `registry_path` containing an `image_tag` that does not correspond to a Docker image in the ECR repository, will result in an error.

    ## Example Usage

    Basic usage:

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.sagemaker.get_prebuilt_ecr_image(repository_name="sagemaker-scikit-learn",
        image_tag="2.2-1.0.11.0")
    ```


    :param builtins.str dns_suffix: DNS suffix to use in the registry path. If not specified, the AWS provider sets it to the DNS suffix for the current region.
    :param builtins.str image_tag: Image tag for the Docker image. If not specified, the AWS provider sets the value to `1`, which for many repositories indicates the latest version. Some repositories, such as XGBoost, do not support `1` or `latest` and specific version must be used.
    :param builtins.str region: Region to use in the registry path. Defaults to the Region set in the provider configuration.
    :param builtins.str repository_name: Name of the repository, which is generally the algorithm or library. Values include `autogluon-inference`, `autogluon-training`, `blazingtext`, `djl-inference`, `factorization-machines`, `forecasting-deepar`, `huggingface-pytorch-inference`, `huggingface-pytorch-inference-neuron`, `huggingface-pytorch-inference-neuronx`, `huggingface-pytorch-tgi-inference`, `huggingface-pytorch-training`, `huggingface-pytorch-training-neuronx`, `huggingface-pytorch-trcomp-training`, `huggingface-tensorflow-inference`, `huggingface-tensorflow-training`, `huggingface-tensorflow-trcomp-training`, `image-classification`, `image-classification-neo`, `ipinsights`, `kmeans`, `knn`, `lda`, `linear-learner`, `mxnet-inference`, `mxnet-inference-eia`, `mxnet-training`, `ntm`, `object-detection`, `object2vec`, `pca`, `pytorch-inference`, `pytorch-inference-eia`, `pytorch-inference-graviton`, `pytorch-inference-neuronx`, `pytorch-training`, `pytorch-training-neuronx`, `pytorch-trcomp-training`, `randomcutforest`, `sagemaker-base-python`, `sagemaker-chainer`, `sagemaker-clarify-processing`, `sagemaker-data-wrangler-container`, `sagemaker-debugger-rules`, `sagemaker-geospatial-v1-0`, `sagemaker-inference-mxnet`, `sagemaker-inference-pytorch`, `sagemaker-inference-tensorflow`, `sagemaker-model-monitor-analyzer`, `sagemaker-mxnet`, `sagemaker-mxnet-eia`, `sagemaker-mxnet-serving`, `sagemaker-mxnet-serving-eia`, `sagemaker-neo-mxnet`, `sagemaker-neo-pytorch`, `sagemaker-neo-tensorflow`, `sagemaker-pytorch`, `sagemaker-rl-coach-container`, `sagemaker-rl-mxnet`, `sagemaker-rl-ray-container`, `sagemaker-rl-tensorflow`, `sagemaker-rl-vw-container`, `sagemaker-scikit-learn`, `sagemaker-spark-processing`, `sagemaker-sparkml-serving`, `sagemaker-tensorflow`, `sagemaker-tensorflow-eia`, `sagemaker-tensorflow-scriptmode`, `sagemaker-tensorflow-serving`, `sagemaker-tensorflow-serving-eia`, `sagemaker-tritonserver`, `sagemaker-xgboost`, `semantic-segmentation`, `seq2seq`, `stabilityai-pytorch-inference`, `tei`, `tei-cpu`, `tensorflow-inference`, `tensorflow-inference-eia`, `tensorflow-inference-graviton`, `tensorflow-training`, and `xgboost-neo`.
    """
    __args__ = dict()
    __args__['dnsSuffix'] = dns_suffix
    __args__['imageTag'] = image_tag
    __args__['region'] = region
    __args__['repositoryName'] = repository_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:sagemaker/getPrebuiltEcrImage:getPrebuiltEcrImage', __args__, opts=opts, typ=GetPrebuiltEcrImageResult)
    return __ret__.apply(lambda __response__: GetPrebuiltEcrImageResult(
        dns_suffix=pulumi.get(__response__, 'dns_suffix'),
        id=pulumi.get(__response__, 'id'),
        image_tag=pulumi.get(__response__, 'image_tag'),
        region=pulumi.get(__response__, 'region'),
        registry_id=pulumi.get(__response__, 'registry_id'),
        registry_path=pulumi.get(__response__, 'registry_path'),
        repository_name=pulumi.get(__response__, 'repository_name')))
