# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ScheduleFlexibleTimeWindow',
    'ScheduleTarget',
    'ScheduleTargetDeadLetterConfig',
    'ScheduleTargetEcsParameters',
    'ScheduleTargetEcsParametersCapacityProviderStrategy',
    'ScheduleTargetEcsParametersNetworkConfiguration',
    'ScheduleTargetEcsParametersPlacementConstraint',
    'ScheduleTargetEcsParametersPlacementStrategy',
    'ScheduleTargetEventbridgeParameters',
    'ScheduleTargetKinesisParameters',
    'ScheduleTargetRetryPolicy',
    'ScheduleTargetSagemakerPipelineParameters',
    'ScheduleTargetSagemakerPipelineParametersPipelineParameter',
    'ScheduleTargetSqsParameters',
]

@pulumi.output_type
class ScheduleFlexibleTimeWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumWindowInMinutes":
            suggest = "maximum_window_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleFlexibleTimeWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleFlexibleTimeWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleFlexibleTimeWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: builtins.str,
                 maximum_window_in_minutes: Optional[builtins.int] = None):
        """
        :param builtins.str mode: Determines whether the schedule is invoked within a flexible time window. One of: `OFF`, `FLEXIBLE`.
        :param builtins.int maximum_window_in_minutes: Maximum time window during which a schedule can be invoked. Ranges from `1` to `1440` minutes.
        """
        pulumi.set(__self__, "mode", mode)
        if maximum_window_in_minutes is not None:
            pulumi.set(__self__, "maximum_window_in_minutes", maximum_window_in_minutes)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        Determines whether the schedule is invoked within a flexible time window. One of: `OFF`, `FLEXIBLE`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="maximumWindowInMinutes")
    def maximum_window_in_minutes(self) -> Optional[builtins.int]:
        """
        Maximum time window during which a schedule can be invoked. Ranges from `1` to `1440` minutes.
        """
        return pulumi.get(self, "maximum_window_in_minutes")


@pulumi.output_type
class ScheduleTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "deadLetterConfig":
            suggest = "dead_letter_config"
        elif key == "ecsParameters":
            suggest = "ecs_parameters"
        elif key == "eventbridgeParameters":
            suggest = "eventbridge_parameters"
        elif key == "kinesisParameters":
            suggest = "kinesis_parameters"
        elif key == "retryPolicy":
            suggest = "retry_policy"
        elif key == "sagemakerPipelineParameters":
            suggest = "sagemaker_pipeline_parameters"
        elif key == "sqsParameters":
            suggest = "sqs_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: builtins.str,
                 role_arn: builtins.str,
                 dead_letter_config: Optional['outputs.ScheduleTargetDeadLetterConfig'] = None,
                 ecs_parameters: Optional['outputs.ScheduleTargetEcsParameters'] = None,
                 eventbridge_parameters: Optional['outputs.ScheduleTargetEventbridgeParameters'] = None,
                 input: Optional[builtins.str] = None,
                 kinesis_parameters: Optional['outputs.ScheduleTargetKinesisParameters'] = None,
                 retry_policy: Optional['outputs.ScheduleTargetRetryPolicy'] = None,
                 sagemaker_pipeline_parameters: Optional['outputs.ScheduleTargetSagemakerPipelineParameters'] = None,
                 sqs_parameters: Optional['outputs.ScheduleTargetSqsParameters'] = None):
        """
        :param builtins.str arn: ARN of the target of this schedule, such as a SQS queue or ECS cluster. For universal targets, this is a [Service ARN specific to the target service](https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html#supported-universal-targets).
        :param builtins.str role_arn: ARN of the IAM role that EventBridge Scheduler will use for this target when the schedule is invoked. Read more in [Set up the execution role](https://docs.aws.amazon.com/scheduler/latest/UserGuide/setting-up.html#setting-up-execution-role).
               
               The following arguments are optional:
        :param 'ScheduleTargetDeadLetterConfigArgs' dead_letter_config: Information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue. Detailed below.
        :param 'ScheduleTargetEcsParametersArgs' ecs_parameters: Templated target type for the Amazon ECS [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation. Detailed below.
        :param 'ScheduleTargetEventbridgeParametersArgs' eventbridge_parameters: Templated target type for the EventBridge [`PutEvents`](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) API operation. Detailed below.
        :param builtins.str input: Text, or well-formed JSON, passed to the target. Read more in [Universal target](https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html).
        :param 'ScheduleTargetKinesisParametersArgs' kinesis_parameters: Templated target type for the Amazon Kinesis [`PutRecord`](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html) API operation. Detailed below.
        :param 'ScheduleTargetRetryPolicyArgs' retry_policy: Information about the retry policy settings. Detailed below.
        :param 'ScheduleTargetSagemakerPipelineParametersArgs' sagemaker_pipeline_parameters: Templated target type for the Amazon SageMaker AI [`StartPipelineExecution`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html) API operation. Detailed below.
        :param 'ScheduleTargetSqsParametersArgs' sqs_parameters: The templated target type for the Amazon SQS [`SendMessage`](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html) API operation. Detailed below.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "role_arn", role_arn)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if ecs_parameters is not None:
            pulumi.set(__self__, "ecs_parameters", ecs_parameters)
        if eventbridge_parameters is not None:
            pulumi.set(__self__, "eventbridge_parameters", eventbridge_parameters)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if kinesis_parameters is not None:
            pulumi.set(__self__, "kinesis_parameters", kinesis_parameters)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if sagemaker_pipeline_parameters is not None:
            pulumi.set(__self__, "sagemaker_pipeline_parameters", sagemaker_pipeline_parameters)
        if sqs_parameters is not None:
            pulumi.set(__self__, "sqs_parameters", sqs_parameters)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the target of this schedule, such as a SQS queue or ECS cluster. For universal targets, this is a [Service ARN specific to the target service](https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html#supported-universal-targets).
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        ARN of the IAM role that EventBridge Scheduler will use for this target when the schedule is invoked. Read more in [Set up the execution role](https://docs.aws.amazon.com/scheduler/latest/UserGuide/setting-up.html#setting-up-execution-role).

        The following arguments are optional:
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional['outputs.ScheduleTargetDeadLetterConfig']:
        """
        Information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue. Detailed below.
        """
        return pulumi.get(self, "dead_letter_config")

    @property
    @pulumi.getter(name="ecsParameters")
    def ecs_parameters(self) -> Optional['outputs.ScheduleTargetEcsParameters']:
        """
        Templated target type for the Amazon ECS [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation. Detailed below.
        """
        return pulumi.get(self, "ecs_parameters")

    @property
    @pulumi.getter(name="eventbridgeParameters")
    def eventbridge_parameters(self) -> Optional['outputs.ScheduleTargetEventbridgeParameters']:
        """
        Templated target type for the EventBridge [`PutEvents`](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) API operation. Detailed below.
        """
        return pulumi.get(self, "eventbridge_parameters")

    @property
    @pulumi.getter
    def input(self) -> Optional[builtins.str]:
        """
        Text, or well-formed JSON, passed to the target. Read more in [Universal target](https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html).
        """
        return pulumi.get(self, "input")

    @property
    @pulumi.getter(name="kinesisParameters")
    def kinesis_parameters(self) -> Optional['outputs.ScheduleTargetKinesisParameters']:
        """
        Templated target type for the Amazon Kinesis [`PutRecord`](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html) API operation. Detailed below.
        """
        return pulumi.get(self, "kinesis_parameters")

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional['outputs.ScheduleTargetRetryPolicy']:
        """
        Information about the retry policy settings. Detailed below.
        """
        return pulumi.get(self, "retry_policy")

    @property
    @pulumi.getter(name="sagemakerPipelineParameters")
    def sagemaker_pipeline_parameters(self) -> Optional['outputs.ScheduleTargetSagemakerPipelineParameters']:
        """
        Templated target type for the Amazon SageMaker AI [`StartPipelineExecution`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html) API operation. Detailed below.
        """
        return pulumi.get(self, "sagemaker_pipeline_parameters")

    @property
    @pulumi.getter(name="sqsParameters")
    def sqs_parameters(self) -> Optional['outputs.ScheduleTargetSqsParameters']:
        """
        The templated target type for the Amazon SQS [`SendMessage`](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html) API operation. Detailed below.
        """
        return pulumi.get(self, "sqs_parameters")


@pulumi.output_type
class ScheduleTargetDeadLetterConfig(dict):
    def __init__(__self__, *,
                 arn: builtins.str):
        """
        :param builtins.str arn: ARN of the SQS queue specified as the destination for the dead-letter queue.
        """
        pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the SQS queue specified as the destination for the dead-letter queue.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class ScheduleTargetEcsParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskDefinitionArn":
            suggest = "task_definition_arn"
        elif key == "capacityProviderStrategies":
            suggest = "capacity_provider_strategies"
        elif key == "enableEcsManagedTags":
            suggest = "enable_ecs_managed_tags"
        elif key == "enableExecuteCommand":
            suggest = "enable_execute_command"
        elif key == "launchType":
            suggest = "launch_type"
        elif key == "networkConfiguration":
            suggest = "network_configuration"
        elif key == "placementConstraints":
            suggest = "placement_constraints"
        elif key == "placementStrategies":
            suggest = "placement_strategies"
        elif key == "platformVersion":
            suggest = "platform_version"
        elif key == "propagateTags":
            suggest = "propagate_tags"
        elif key == "referenceId":
            suggest = "reference_id"
        elif key == "taskCount":
            suggest = "task_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleTargetEcsParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleTargetEcsParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleTargetEcsParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_definition_arn: builtins.str,
                 capacity_provider_strategies: Optional[Sequence['outputs.ScheduleTargetEcsParametersCapacityProviderStrategy']] = None,
                 enable_ecs_managed_tags: Optional[builtins.bool] = None,
                 enable_execute_command: Optional[builtins.bool] = None,
                 group: Optional[builtins.str] = None,
                 launch_type: Optional[builtins.str] = None,
                 network_configuration: Optional['outputs.ScheduleTargetEcsParametersNetworkConfiguration'] = None,
                 placement_constraints: Optional[Sequence['outputs.ScheduleTargetEcsParametersPlacementConstraint']] = None,
                 placement_strategies: Optional[Sequence['outputs.ScheduleTargetEcsParametersPlacementStrategy']] = None,
                 platform_version: Optional[builtins.str] = None,
                 propagate_tags: Optional[builtins.str] = None,
                 reference_id: Optional[builtins.str] = None,
                 tags: Optional[Mapping[str, builtins.str]] = None,
                 task_count: Optional[builtins.int] = None):
        """
        :param builtins.str task_definition_arn: ARN of the task definition to use.
               
               The following arguments are optional:
        :param Sequence['ScheduleTargetEcsParametersCapacityProviderStrategyArgs'] capacity_provider_strategies: Up to `6` capacity provider strategies to use for the task. Detailed below.
        :param builtins.bool enable_ecs_managed_tags: Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the Amazon ECS Developer Guide.
        :param builtins.bool enable_execute_command: Specifies whether to enable the execute command functionality for the containers in this task.
        :param builtins.str group: Specifies an ECS task group for the task. At most 255 characters.
        :param builtins.str launch_type: Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. One of: `EC2`, `FARGATE`, `EXTERNAL`.
        :param 'ScheduleTargetEcsParametersNetworkConfigurationArgs' network_configuration: Configures the networking associated with the task. Detailed below.
        :param Sequence['ScheduleTargetEcsParametersPlacementConstraintArgs'] placement_constraints: A set of up to 10 placement constraints to use for the task. Detailed below.
        :param Sequence['ScheduleTargetEcsParametersPlacementStrategyArgs'] placement_strategies: A set of up to 5 placement strategies. Detailed below.
        :param builtins.str platform_version: Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`.
        :param builtins.str propagate_tags: Specifies whether to propagate the tags from the task definition to the task. One of: `TASK_DEFINITION`.
        :param builtins.str reference_id: Reference ID to use for the task.
        :param Mapping[str, builtins.str] tags: The metadata that you apply to the task. Each tag consists of a key and an optional value. For more information, see [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) in the Amazon ECS API Reference.
        :param builtins.int task_count: The number of tasks to create. Ranges from `1` (default) to `10`.
        """
        pulumi.set(__self__, "task_definition_arn", task_definition_arn)
        if capacity_provider_strategies is not None:
            pulumi.set(__self__, "capacity_provider_strategies", capacity_provider_strategies)
        if enable_ecs_managed_tags is not None:
            pulumi.set(__self__, "enable_ecs_managed_tags", enable_ecs_managed_tags)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if placement_strategies is not None:
            pulumi.set(__self__, "placement_strategies", placement_strategies)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter(name="taskDefinitionArn")
    def task_definition_arn(self) -> builtins.str:
        """
        ARN of the task definition to use.

        The following arguments are optional:
        """
        return pulumi.get(self, "task_definition_arn")

    @property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> Optional[Sequence['outputs.ScheduleTargetEcsParametersCapacityProviderStrategy']]:
        """
        Up to `6` capacity provider strategies to use for the task. Detailed below.
        """
        return pulumi.get(self, "capacity_provider_strategies")

    @property
    @pulumi.getter(name="enableEcsManagedTags")
    def enable_ecs_managed_tags(self) -> Optional[builtins.bool]:
        """
        Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the Amazon ECS Developer Guide.
        """
        return pulumi.get(self, "enable_ecs_managed_tags")

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[builtins.bool]:
        """
        Specifies whether to enable the execute command functionality for the containers in this task.
        """
        return pulumi.get(self, "enable_execute_command")

    @property
    @pulumi.getter
    def group(self) -> Optional[builtins.str]:
        """
        Specifies an ECS task group for the task. At most 255 characters.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional[builtins.str]:
        """
        Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. One of: `EC2`, `FARGATE`, `EXTERNAL`.
        """
        return pulumi.get(self, "launch_type")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.ScheduleTargetEcsParametersNetworkConfiguration']:
        """
        Configures the networking associated with the task. Detailed below.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[Sequence['outputs.ScheduleTargetEcsParametersPlacementConstraint']]:
        """
        A set of up to 10 placement constraints to use for the task. Detailed below.
        """
        return pulumi.get(self, "placement_constraints")

    @property
    @pulumi.getter(name="placementStrategies")
    def placement_strategies(self) -> Optional[Sequence['outputs.ScheduleTargetEcsParametersPlacementStrategy']]:
        """
        A set of up to 5 placement strategies. Detailed below.
        """
        return pulumi.get(self, "placement_strategies")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[builtins.str]:
        """
        Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`.
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[builtins.str]:
        """
        Specifies whether to propagate the tags from the task definition to the task. One of: `TASK_DEFINITION`.
        """
        return pulumi.get(self, "propagate_tags")

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[builtins.str]:
        """
        Reference ID to use for the task.
        """
        return pulumi.get(self, "reference_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The metadata that you apply to the task. Each tag consists of a key and an optional value. For more information, see [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) in the Amazon ECS API Reference.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[builtins.int]:
        """
        The number of tasks to create. Ranges from `1` (default) to `10`.
        """
        return pulumi.get(self, "task_count")


@pulumi.output_type
class ScheduleTargetEcsParametersCapacityProviderStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleTargetEcsParametersCapacityProviderStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleTargetEcsParametersCapacityProviderStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleTargetEcsParametersCapacityProviderStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_provider: builtins.str,
                 base: Optional[builtins.int] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str capacity_provider: Short name of the capacity provider.
        :param builtins.int base: How many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Ranges from `0` (default) to `100000`.
        :param builtins.int weight: Designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied. Ranges from from `0` to `1000`.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> builtins.str:
        """
        Short name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def base(self) -> Optional[builtins.int]:
        """
        How many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Ranges from `0` (default) to `100000`.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        Designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied. Ranges from from `0` to `1000`.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ScheduleTargetEcsParametersNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleTargetEcsParametersNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleTargetEcsParametersNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleTargetEcsParametersNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnets: Sequence[builtins.str],
                 assign_public_ip: Optional[builtins.bool] = None,
                 security_groups: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] subnets: Set of 1 to 16 subnets to be associated with the task. These subnets must all be in the same VPC.
        :param builtins.bool assign_public_ip: Specifies whether the task's elastic network interface receives a public IP address. This attribute is a boolean type, where `true` maps to `ENABLED` and `false` to `DISABLED`. You can specify `true` only when the `launch_type` is set to `FARGATE`.
        :param Sequence[builtins.str] security_groups: Set of 1 to 5 Security Group ID-s to be associated with the task. These security groups must all be in the same VPC.
        """
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[builtins.str]:
        """
        Set of 1 to 16 subnets to be associated with the task. These subnets must all be in the same VPC.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[builtins.bool]:
        """
        Specifies whether the task's elastic network interface receives a public IP address. This attribute is a boolean type, where `true` maps to `ENABLED` and `false` to `DISABLED`. You can specify `true` only when the `launch_type` is set to `FARGATE`.
        """
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        Set of 1 to 5 Security Group ID-s to be associated with the task. These security groups must all be in the same VPC.
        """
        return pulumi.get(self, "security_groups")


@pulumi.output_type
class ScheduleTargetEcsParametersPlacementConstraint(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 expression: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of constraint. One of: `distinctInstance`, `memberOf`.
        :param builtins.str expression: A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is `distinctInstance`. For more information, see [Cluster query language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the Amazon ECS Developer Guide.
        """
        pulumi.set(__self__, "type", type)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of constraint. One of: `distinctInstance`, `memberOf`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is `distinctInstance`. For more information, see [Cluster query language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the Amazon ECS Developer Guide.
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class ScheduleTargetEcsParametersPlacementStrategy(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 field: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of placement strategy. One of: `random`, `spread`, `binpack`.
        :param builtins.str field: The field to apply the placement strategy against.
        """
        pulumi.set(__self__, "type", type)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of placement strategy. One of: `random`, `spread`, `binpack`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def field(self) -> Optional[builtins.str]:
        """
        The field to apply the placement strategy against.
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class ScheduleTargetEventbridgeParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detailType":
            suggest = "detail_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleTargetEventbridgeParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleTargetEventbridgeParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleTargetEventbridgeParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detail_type: builtins.str,
                 source: builtins.str):
        """
        :param builtins.str detail_type: Free-form string used to decide what fields to expect in the event detail. Up to 128 characters.
        :param builtins.str source: Source of the event.
        """
        pulumi.set(__self__, "detail_type", detail_type)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="detailType")
    def detail_type(self) -> builtins.str:
        """
        Free-form string used to decide what fields to expect in the event detail. Up to 128 characters.
        """
        return pulumi.get(self, "detail_type")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        """
        Source of the event.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class ScheduleTargetKinesisParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionKey":
            suggest = "partition_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleTargetKinesisParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleTargetKinesisParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleTargetKinesisParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partition_key: builtins.str):
        """
        :param builtins.str partition_key: Specifies the shard to which EventBridge Scheduler sends the event. Up to 256 characters.
        """
        pulumi.set(__self__, "partition_key", partition_key)

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> builtins.str:
        """
        Specifies the shard to which EventBridge Scheduler sends the event. Up to 256 characters.
        """
        return pulumi.get(self, "partition_key")


@pulumi.output_type
class ScheduleTargetRetryPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumEventAgeInSeconds":
            suggest = "maximum_event_age_in_seconds"
        elif key == "maximumRetryAttempts":
            suggest = "maximum_retry_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleTargetRetryPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleTargetRetryPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleTargetRetryPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_event_age_in_seconds: Optional[builtins.int] = None,
                 maximum_retry_attempts: Optional[builtins.int] = None):
        """
        :param builtins.int maximum_event_age_in_seconds: Maximum amount of time, in seconds, to continue to make retry attempts. Ranges from `60` to `86400` (default).
        :param builtins.int maximum_retry_attempts: Maximum number of retry attempts to make before the request fails. Ranges from `0` to `185` (default).
        """
        if maximum_event_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_event_age_in_seconds", maximum_event_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)

    @property
    @pulumi.getter(name="maximumEventAgeInSeconds")
    def maximum_event_age_in_seconds(self) -> Optional[builtins.int]:
        """
        Maximum amount of time, in seconds, to continue to make retry attempts. Ranges from `60` to `86400` (default).
        """
        return pulumi.get(self, "maximum_event_age_in_seconds")

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[builtins.int]:
        """
        Maximum number of retry attempts to make before the request fails. Ranges from `0` to `185` (default).
        """
        return pulumi.get(self, "maximum_retry_attempts")


@pulumi.output_type
class ScheduleTargetSagemakerPipelineParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineParameters":
            suggest = "pipeline_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleTargetSagemakerPipelineParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleTargetSagemakerPipelineParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleTargetSagemakerPipelineParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pipeline_parameters: Optional[Sequence['outputs.ScheduleTargetSagemakerPipelineParametersPipelineParameter']] = None):
        """
        :param Sequence['ScheduleTargetSagemakerPipelineParametersPipelineParameterArgs'] pipeline_parameters: Set of up to 200 parameter names and values to use when executing the SageMaker AI Model Building Pipeline. Detailed below.
        """
        if pipeline_parameters is not None:
            pulumi.set(__self__, "pipeline_parameters", pipeline_parameters)

    @property
    @pulumi.getter(name="pipelineParameters")
    def pipeline_parameters(self) -> Optional[Sequence['outputs.ScheduleTargetSagemakerPipelineParametersPipelineParameter']]:
        """
        Set of up to 200 parameter names and values to use when executing the SageMaker AI Model Building Pipeline. Detailed below.
        """
        return pulumi.get(self, "pipeline_parameters")


@pulumi.output_type
class ScheduleTargetSagemakerPipelineParametersPipelineParameter(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of parameter to start execution of a SageMaker AI Model Building Pipeline.
        :param builtins.str value: Value of parameter to start execution of a SageMaker AI Model Building Pipeline.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of parameter to start execution of a SageMaker AI Model Building Pipeline.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of parameter to start execution of a SageMaker AI Model Building Pipeline.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScheduleTargetSqsParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageGroupId":
            suggest = "message_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleTargetSqsParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleTargetSqsParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleTargetSqsParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_group_id: Optional[builtins.str] = None):
        """
        :param builtins.str message_group_id: FIFO message group ID to use as the target.
        """
        if message_group_id is not None:
            pulumi.set(__self__, "message_group_id", message_group_id)

    @property
    @pulumi.getter(name="messageGroupId")
    def message_group_id(self) -> Optional[builtins.str]:
        """
        FIFO message group ID to use as the target.
        """
        return pulumi.get(self, "message_group_id")


