# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['StandardsControlAssociationArgs', 'StandardsControlAssociation']

@pulumi.input_type
class StandardsControlAssociationArgs:
    def __init__(__self__, *,
                 association_status: pulumi.Input[builtins.str],
                 security_control_id: pulumi.Input[builtins.str],
                 standards_arn: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 updated_reason: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a StandardsControlAssociation resource.
        :param pulumi.Input[builtins.str] association_status: The desired enablement status of the control in the standard. Valid values: `ENABLED`, `DISABLED`.
        :param pulumi.Input[builtins.str] security_control_id: The unique identifier for the security control whose enablement status you want to update.
        :param pulumi.Input[builtins.str] standards_arn: The Amazon Resource Name (ARN) of the standard in which you want to update the control's enablement status.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] updated_reason: The reason for updating the control's enablement status in the standard. Required when `association_status` is `DISABLED`.
        """
        pulumi.set(__self__, "association_status", association_status)
        pulumi.set(__self__, "security_control_id", security_control_id)
        pulumi.set(__self__, "standards_arn", standards_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if updated_reason is not None:
            pulumi.set(__self__, "updated_reason", updated_reason)

    @property
    @pulumi.getter(name="associationStatus")
    def association_status(self) -> pulumi.Input[builtins.str]:
        """
        The desired enablement status of the control in the standard. Valid values: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "association_status")

    @association_status.setter
    def association_status(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "association_status", value)

    @property
    @pulumi.getter(name="securityControlId")
    def security_control_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique identifier for the security control whose enablement status you want to update.
        """
        return pulumi.get(self, "security_control_id")

    @security_control_id.setter
    def security_control_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "security_control_id", value)

    @property
    @pulumi.getter(name="standardsArn")
    def standards_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the standard in which you want to update the control's enablement status.

        The following arguments are optional:
        """
        return pulumi.get(self, "standards_arn")

    @standards_arn.setter
    def standards_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "standards_arn", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="updatedReason")
    def updated_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reason for updating the control's enablement status in the standard. Required when `association_status` is `DISABLED`.
        """
        return pulumi.get(self, "updated_reason")

    @updated_reason.setter
    def updated_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_reason", value)


@pulumi.input_type
class _StandardsControlAssociationState:
    def __init__(__self__, *,
                 association_status: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_control_id: Optional[pulumi.Input[builtins.str]] = None,
                 standards_arn: Optional[pulumi.Input[builtins.str]] = None,
                 updated_reason: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering StandardsControlAssociation resources.
        :param pulumi.Input[builtins.str] association_status: The desired enablement status of the control in the standard. Valid values: `ENABLED`, `DISABLED`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] security_control_id: The unique identifier for the security control whose enablement status you want to update.
        :param pulumi.Input[builtins.str] standards_arn: The Amazon Resource Name (ARN) of the standard in which you want to update the control's enablement status.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] updated_reason: The reason for updating the control's enablement status in the standard. Required when `association_status` is `DISABLED`.
        """
        if association_status is not None:
            pulumi.set(__self__, "association_status", association_status)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_control_id is not None:
            pulumi.set(__self__, "security_control_id", security_control_id)
        if standards_arn is not None:
            pulumi.set(__self__, "standards_arn", standards_arn)
        if updated_reason is not None:
            pulumi.set(__self__, "updated_reason", updated_reason)

    @property
    @pulumi.getter(name="associationStatus")
    def association_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The desired enablement status of the control in the standard. Valid values: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "association_status")

    @association_status.setter
    def association_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "association_status", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityControlId")
    def security_control_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier for the security control whose enablement status you want to update.
        """
        return pulumi.get(self, "security_control_id")

    @security_control_id.setter
    def security_control_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_control_id", value)

    @property
    @pulumi.getter(name="standardsArn")
    def standards_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the standard in which you want to update the control's enablement status.

        The following arguments are optional:
        """
        return pulumi.get(self, "standards_arn")

    @standards_arn.setter
    def standards_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "standards_arn", value)

    @property
    @pulumi.getter(name="updatedReason")
    def updated_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reason for updating the control's enablement status in the standard. Required when `association_status` is `DISABLED`.
        """
        return pulumi.get(self, "updated_reason")

    @updated_reason.setter
    def updated_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_reason", value)


@pulumi.type_token("aws:securityhub/standardsControlAssociation:StandardsControlAssociation")
class StandardsControlAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 association_status: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_control_id: Optional[pulumi.Input[builtins.str]] = None,
                 standards_arn: Optional[pulumi.Input[builtins.str]] = None,
                 updated_reason: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securityhub.Account("example")
        cis_aws_foundations_benchmark = aws.securityhub.StandardsSubscription("cis_aws_foundations_benchmark", standards_arn="arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0",
        opts = pulumi.ResourceOptions(depends_on=[example]))
        cis_aws_foundations_benchmark_disable_iam1 = aws.securityhub.StandardsControlAssociation("cis_aws_foundations_benchmark_disable_iam_1",
            standards_arn=cis_aws_foundations_benchmark.standards_arn,
            security_control_id="IAM.1",
            association_status="DISABLED",
            updated_reason="Not needed")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] association_status: The desired enablement status of the control in the standard. Valid values: `ENABLED`, `DISABLED`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] security_control_id: The unique identifier for the security control whose enablement status you want to update.
        :param pulumi.Input[builtins.str] standards_arn: The Amazon Resource Name (ARN) of the standard in which you want to update the control's enablement status.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] updated_reason: The reason for updating the control's enablement status in the standard. Required when `association_status` is `DISABLED`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StandardsControlAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securityhub.Account("example")
        cis_aws_foundations_benchmark = aws.securityhub.StandardsSubscription("cis_aws_foundations_benchmark", standards_arn="arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0",
        opts = pulumi.ResourceOptions(depends_on=[example]))
        cis_aws_foundations_benchmark_disable_iam1 = aws.securityhub.StandardsControlAssociation("cis_aws_foundations_benchmark_disable_iam_1",
            standards_arn=cis_aws_foundations_benchmark.standards_arn,
            security_control_id="IAM.1",
            association_status="DISABLED",
            updated_reason="Not needed")
        ```

        :param str resource_name: The name of the resource.
        :param StandardsControlAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StandardsControlAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 association_status: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_control_id: Optional[pulumi.Input[builtins.str]] = None,
                 standards_arn: Optional[pulumi.Input[builtins.str]] = None,
                 updated_reason: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StandardsControlAssociationArgs.__new__(StandardsControlAssociationArgs)

            if association_status is None and not opts.urn:
                raise TypeError("Missing required property 'association_status'")
            __props__.__dict__["association_status"] = association_status
            __props__.__dict__["region"] = region
            if security_control_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_control_id'")
            __props__.__dict__["security_control_id"] = security_control_id
            if standards_arn is None and not opts.urn:
                raise TypeError("Missing required property 'standards_arn'")
            __props__.__dict__["standards_arn"] = standards_arn
            __props__.__dict__["updated_reason"] = updated_reason
        super(StandardsControlAssociation, __self__).__init__(
            'aws:securityhub/standardsControlAssociation:StandardsControlAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            association_status: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            security_control_id: Optional[pulumi.Input[builtins.str]] = None,
            standards_arn: Optional[pulumi.Input[builtins.str]] = None,
            updated_reason: Optional[pulumi.Input[builtins.str]] = None) -> 'StandardsControlAssociation':
        """
        Get an existing StandardsControlAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] association_status: The desired enablement status of the control in the standard. Valid values: `ENABLED`, `DISABLED`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] security_control_id: The unique identifier for the security control whose enablement status you want to update.
        :param pulumi.Input[builtins.str] standards_arn: The Amazon Resource Name (ARN) of the standard in which you want to update the control's enablement status.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] updated_reason: The reason for updating the control's enablement status in the standard. Required when `association_status` is `DISABLED`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StandardsControlAssociationState.__new__(_StandardsControlAssociationState)

        __props__.__dict__["association_status"] = association_status
        __props__.__dict__["region"] = region
        __props__.__dict__["security_control_id"] = security_control_id
        __props__.__dict__["standards_arn"] = standards_arn
        __props__.__dict__["updated_reason"] = updated_reason
        return StandardsControlAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associationStatus")
    def association_status(self) -> pulumi.Output[builtins.str]:
        """
        The desired enablement status of the control in the standard. Valid values: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "association_status")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityControlId")
    def security_control_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for the security control whose enablement status you want to update.
        """
        return pulumi.get(self, "security_control_id")

    @property
    @pulumi.getter(name="standardsArn")
    def standards_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the standard in which you want to update the control's enablement status.

        The following arguments are optional:
        """
        return pulumi.get(self, "standards_arn")

    @property
    @pulumi.getter(name="updatedReason")
    def updated_reason(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The reason for updating the control's enablement status in the standard. Required when `association_status` is `DISABLED`.
        """
        return pulumi.get(self, "updated_reason")

