# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AppregistryAttributeGroupAssociationArgs', 'AppregistryAttributeGroupAssociation']

@pulumi.input_type
class AppregistryAttributeGroupAssociationArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[builtins.str],
                 attribute_group_id: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AppregistryAttributeGroupAssociation resource.
        :param pulumi.Input[builtins.str] application_id: ID of the application.
        :param pulumi.Input[builtins.str] attribute_group_id: ID of the attribute group to associate with the application.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "attribute_group_id", attribute_group_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the application.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="attributeGroupId")
    def attribute_group_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the attribute group to associate with the application.
        """
        return pulumi.get(self, "attribute_group_id")

    @attribute_group_id.setter
    def attribute_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "attribute_group_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AppregistryAttributeGroupAssociationState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 attribute_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppregistryAttributeGroupAssociation resources.
        :param pulumi.Input[builtins.str] application_id: ID of the application.
        :param pulumi.Input[builtins.str] attribute_group_id: ID of the attribute group to associate with the application.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if attribute_group_id is not None:
            pulumi.set(__self__, "attribute_group_id", attribute_group_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the application.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="attributeGroupId")
    def attribute_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the attribute group to associate with the application.
        """
        return pulumi.get(self, "attribute_group_id")

    @attribute_group_id.setter
    def attribute_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attribute_group_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:servicecatalog/appregistryAttributeGroupAssociation:AppregistryAttributeGroupAssociation")
class AppregistryAttributeGroupAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 attribute_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Service Catalog AppRegistry Attribute Group Association.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.servicecatalog.AppregistryApplication("example", name="example-app")
        example_appregistry_attribute_group = aws.servicecatalog.AppregistryAttributeGroup("example",
            name="example",
            description="example description",
            attributes=json.dumps({
                "app": "exampleapp",
                "group": "examplegroup",
            }))
        example_appregistry_attribute_group_association = aws.servicecatalog.AppregistryAttributeGroupAssociation("example",
            application_id=example.id,
            attribute_group_id=example_appregistry_attribute_group.id)
        ```

        ## Import

        Using `pulumi import`, import Service Catalog AppRegistry Attribute Group Association using `application_id` and `attribute_group_id` arguments separated by a comma (`,`). For example:

        ```sh
        $ pulumi import aws:servicecatalog/appregistryAttributeGroupAssociation:AppregistryAttributeGroupAssociation example 12456778723424sdffsdfsdq34,12234t3564dsfsdf34asff4ww3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: ID of the application.
        :param pulumi.Input[builtins.str] attribute_group_id: ID of the attribute group to associate with the application.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppregistryAttributeGroupAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Service Catalog AppRegistry Attribute Group Association.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.servicecatalog.AppregistryApplication("example", name="example-app")
        example_appregistry_attribute_group = aws.servicecatalog.AppregistryAttributeGroup("example",
            name="example",
            description="example description",
            attributes=json.dumps({
                "app": "exampleapp",
                "group": "examplegroup",
            }))
        example_appregistry_attribute_group_association = aws.servicecatalog.AppregistryAttributeGroupAssociation("example",
            application_id=example.id,
            attribute_group_id=example_appregistry_attribute_group.id)
        ```

        ## Import

        Using `pulumi import`, import Service Catalog AppRegistry Attribute Group Association using `application_id` and `attribute_group_id` arguments separated by a comma (`,`). For example:

        ```sh
        $ pulumi import aws:servicecatalog/appregistryAttributeGroupAssociation:AppregistryAttributeGroupAssociation example 12456778723424sdffsdfsdq34,12234t3564dsfsdf34asff4ww3
        ```

        :param str resource_name: The name of the resource.
        :param AppregistryAttributeGroupAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppregistryAttributeGroupAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 attribute_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppregistryAttributeGroupAssociationArgs.__new__(AppregistryAttributeGroupAssociationArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            if attribute_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'attribute_group_id'")
            __props__.__dict__["attribute_group_id"] = attribute_group_id
            __props__.__dict__["region"] = region
        super(AppregistryAttributeGroupAssociation, __self__).__init__(
            'aws:servicecatalog/appregistryAttributeGroupAssociation:AppregistryAttributeGroupAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[builtins.str]] = None,
            attribute_group_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'AppregistryAttributeGroupAssociation':
        """
        Get an existing AppregistryAttributeGroupAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: ID of the application.
        :param pulumi.Input[builtins.str] attribute_group_id: ID of the attribute group to associate with the application.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppregistryAttributeGroupAssociationState.__new__(_AppregistryAttributeGroupAssociationState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["attribute_group_id"] = attribute_group_id
        __props__.__dict__["region"] = region
        return AppregistryAttributeGroupAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the application.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="attributeGroupId")
    def attribute_group_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the attribute group to associate with the application.
        """
        return pulumi.get(self, "attribute_group_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

