# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAppregistryAttributeGroupAssociationsResult',
    'AwaitableGetAppregistryAttributeGroupAssociationsResult',
    'get_appregistry_attribute_group_associations',
    'get_appregistry_attribute_group_associations_output',
]

@pulumi.output_type
class GetAppregistryAttributeGroupAssociationsResult:
    """
    A collection of values returned by getAppregistryAttributeGroupAssociations.
    """
    def __init__(__self__, attribute_group_ids=None, id=None, name=None, region=None):
        if attribute_group_ids and not isinstance(attribute_group_ids, list):
            raise TypeError("Expected argument 'attribute_group_ids' to be a list")
        pulumi.set(__self__, "attribute_group_ids", attribute_group_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="attributeGroupIds")
    def attribute_group_ids(self) -> Sequence[builtins.str]:
        """
        Set of attribute group IDs this application is associated with.
        """
        return pulumi.get(self, "attribute_group_ids")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetAppregistryAttributeGroupAssociationsResult(GetAppregistryAttributeGroupAssociationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppregistryAttributeGroupAssociationsResult(
            attribute_group_ids=self.attribute_group_ids,
            id=self.id,
            name=self.name,
            region=self.region)


def get_appregistry_attribute_group_associations(id: Optional[builtins.str] = None,
                                                 name: Optional[builtins.str] = None,
                                                 region: Optional[builtins.str] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppregistryAttributeGroupAssociationsResult:
    """
    Data source for managing AWS Service Catalog AppRegistry Attribute Group Associations.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.servicecatalog.get_appregistry_attribute_group_associations(id="12456778723424sdffsdfsdq34,12234t3564dsfsdf34asff4ww3")
    ```


    :param builtins.str id: ID of the application to which attribute groups are associated.
    :param builtins.str name: Name of the application to which attribute groups are associated.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
           > Exactly one of `id`or `name` must be set.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:servicecatalog/getAppregistryAttributeGroupAssociations:getAppregistryAttributeGroupAssociations', __args__, opts=opts, typ=GetAppregistryAttributeGroupAssociationsResult).value

    return AwaitableGetAppregistryAttributeGroupAssociationsResult(
        attribute_group_ids=pulumi.get(__ret__, 'attribute_group_ids'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'))
def get_appregistry_attribute_group_associations_output(id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                        name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                        region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppregistryAttributeGroupAssociationsResult]:
    """
    Data source for managing AWS Service Catalog AppRegistry Attribute Group Associations.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.servicecatalog.get_appregistry_attribute_group_associations(id="12456778723424sdffsdfsdq34,12234t3564dsfsdf34asff4ww3")
    ```


    :param builtins.str id: ID of the application to which attribute groups are associated.
    :param builtins.str name: Name of the application to which attribute groups are associated.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
           > Exactly one of `id`or `name` must be set.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:servicecatalog/getAppregistryAttributeGroupAssociations:getAppregistryAttributeGroupAssociations', __args__, opts=opts, typ=GetAppregistryAttributeGroupAssociationsResult)
    return __ret__.apply(lambda __response__: GetAppregistryAttributeGroupAssociationsResult(
        attribute_group_ids=pulumi.get(__response__, 'attribute_group_ids'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region')))
