# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetConstraintResult',
    'AwaitableGetConstraintResult',
    'get_constraint',
    'get_constraint_output',
]

@pulumi.output_type
class GetConstraintResult:
    """
    A collection of values returned by getConstraint.
    """
    def __init__(__self__, accept_language=None, description=None, id=None, owner=None, parameters=None, portfolio_id=None, product_id=None, region=None, status=None, type=None):
        if accept_language and not isinstance(accept_language, str):
            raise TypeError("Expected argument 'accept_language' to be a str")
        pulumi.set(__self__, "accept_language", accept_language)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if parameters and not isinstance(parameters, str):
            raise TypeError("Expected argument 'parameters' to be a str")
        pulumi.set(__self__, "parameters", parameters)
        if portfolio_id and not isinstance(portfolio_id, str):
            raise TypeError("Expected argument 'portfolio_id' to be a str")
        pulumi.set(__self__, "portfolio_id", portfolio_id)
        if product_id and not isinstance(product_id, str):
            raise TypeError("Expected argument 'product_id' to be a str")
        pulumi.set(__self__, "product_id", product_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> Optional[builtins.str]:
        return pulumi.get(self, "accept_language")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the constraint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def owner(self) -> builtins.str:
        """
        Owner of the constraint.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def parameters(self) -> builtins.str:
        """
        Constraint parameters in JSON format.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="portfolioId")
    def portfolio_id(self) -> builtins.str:
        """
        Portfolio identifier.
        """
        return pulumi.get(self, "portfolio_id")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> builtins.str:
        """
        Product identifier.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Constraint status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of constraint. Valid values are `LAUNCH`, `NOTIFICATION`, `RESOURCE_UPDATE`, `STACKSET`, and `TEMPLATE`.
        """
        return pulumi.get(self, "type")


class AwaitableGetConstraintResult(GetConstraintResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConstraintResult(
            accept_language=self.accept_language,
            description=self.description,
            id=self.id,
            owner=self.owner,
            parameters=self.parameters,
            portfolio_id=self.portfolio_id,
            product_id=self.product_id,
            region=self.region,
            status=self.status,
            type=self.type)


def get_constraint(accept_language: Optional[builtins.str] = None,
                   description: Optional[builtins.str] = None,
                   id: Optional[builtins.str] = None,
                   region: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConstraintResult:
    """
    Provides information on a Service Catalog Constraint.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.servicecatalog.get_constraint(accept_language="en",
        id="cons-hrvy0335")
    ```


    :param builtins.str accept_language: Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
    :param builtins.str description: Description of the constraint.
    :param builtins.str id: Constraint identifier.
           
           The following arguments are optional:
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['acceptLanguage'] = accept_language
    __args__['description'] = description
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:servicecatalog/getConstraint:getConstraint', __args__, opts=opts, typ=GetConstraintResult).value

    return AwaitableGetConstraintResult(
        accept_language=pulumi.get(__ret__, 'accept_language'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        owner=pulumi.get(__ret__, 'owner'),
        parameters=pulumi.get(__ret__, 'parameters'),
        portfolio_id=pulumi.get(__ret__, 'portfolio_id'),
        product_id=pulumi.get(__ret__, 'product_id'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'))
def get_constraint_output(accept_language: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          description: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          id: Optional[pulumi.Input[builtins.str]] = None,
                          region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConstraintResult]:
    """
    Provides information on a Service Catalog Constraint.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.servicecatalog.get_constraint(accept_language="en",
        id="cons-hrvy0335")
    ```


    :param builtins.str accept_language: Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
    :param builtins.str description: Description of the constraint.
    :param builtins.str id: Constraint identifier.
           
           The following arguments are optional:
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['acceptLanguage'] = accept_language
    __args__['description'] = description
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:servicecatalog/getConstraint:getConstraint', __args__, opts=opts, typ=GetConstraintResult)
    return __ret__.apply(lambda __response__: GetConstraintResult(
        accept_language=pulumi.get(__response__, 'accept_language'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        owner=pulumi.get(__response__, 'owner'),
        parameters=pulumi.get(__response__, 'parameters'),
        portfolio_id=pulumi.get(__response__, 'portfolio_id'),
        product_id=pulumi.get(__response__, 'product_id'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type')))
