# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDnsNamespaceResult',
    'AwaitableGetDnsNamespaceResult',
    'get_dns_namespace',
    'get_dns_namespace_output',
]

@pulumi.output_type
class GetDnsNamespaceResult:
    """
    A collection of values returned by getDnsNamespace.
    """
    def __init__(__self__, arn=None, description=None, hosted_zone=None, id=None, name=None, region=None, tags=None, type=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if hosted_zone and not isinstance(hosted_zone, str):
            raise TypeError("Expected argument 'hosted_zone' to be a str")
        pulumi.set(__self__, "hosted_zone", hosted_zone)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the namespace.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the namespace.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="hostedZone")
    def hosted_zone(self) -> builtins.str:
        """
        ID for the hosted zone that Amazon Route 53 creates when you create a namespace.
        """
        return pulumi.get(self, "hosted_zone")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Map of tags for the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")


class AwaitableGetDnsNamespaceResult(GetDnsNamespaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsNamespaceResult(
            arn=self.arn,
            description=self.description,
            hosted_zone=self.hosted_zone,
            id=self.id,
            name=self.name,
            region=self.region,
            tags=self.tags,
            type=self.type)


def get_dns_namespace(name: Optional[builtins.str] = None,
                      region: Optional[builtins.str] = None,
                      tags: Optional[Mapping[str, builtins.str]] = None,
                      type: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsNamespaceResult:
    """
    Retrieves information about a Service Discovery private or public DNS namespace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.servicediscovery.get_dns_namespace(name="example.service.local",
        type="DNS_PRIVATE")
    ```


    :param builtins.str name: Name of the namespace.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags for the resource.
    :param builtins.str type: Type of the namespace. Allowed values are `DNS_PUBLIC` or `DNS_PRIVATE`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:servicediscovery/getDnsNamespace:getDnsNamespace', __args__, opts=opts, typ=GetDnsNamespaceResult).value

    return AwaitableGetDnsNamespaceResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        hosted_zone=pulumi.get(__ret__, 'hosted_zone'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'))
def get_dns_namespace_output(name: Optional[pulumi.Input[builtins.str]] = None,
                             region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                             type: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDnsNamespaceResult]:
    """
    Retrieves information about a Service Discovery private or public DNS namespace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.servicediscovery.get_dns_namespace(name="example.service.local",
        type="DNS_PRIVATE")
    ```


    :param builtins.str name: Name of the namespace.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags for the resource.
    :param builtins.str type: Type of the namespace. Allowed values are `DNS_PUBLIC` or `DNS_PRIVATE`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:servicediscovery/getDnsNamespace:getDnsNamespace', __args__, opts=opts, typ=GetDnsNamespaceResult)
    return __ret__.apply(lambda __response__: GetDnsNamespaceResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        hosted_zone=pulumi.get(__response__, 'hosted_zone'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type')))
