# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServiceResult',
    'AwaitableGetServiceResult',
    'get_service',
    'get_service_output',
]

@pulumi.output_type
class GetServiceResult:
    """
    A collection of values returned by getService.
    """
    def __init__(__self__, arn=None, description=None, dns_configs=None, health_check_configs=None, health_check_custom_configs=None, id=None, name=None, namespace_id=None, region=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dns_configs and not isinstance(dns_configs, list):
            raise TypeError("Expected argument 'dns_configs' to be a list")
        pulumi.set(__self__, "dns_configs", dns_configs)
        if health_check_configs and not isinstance(health_check_configs, list):
            raise TypeError("Expected argument 'health_check_configs' to be a list")
        pulumi.set(__self__, "health_check_configs", health_check_configs)
        if health_check_custom_configs and not isinstance(health_check_custom_configs, list):
            raise TypeError("Expected argument 'health_check_custom_configs' to be a list")
        pulumi.set(__self__, "health_check_custom_configs", health_check_custom_configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace_id and not isinstance(namespace_id, str):
            raise TypeError("Expected argument 'namespace_id' to be a str")
        pulumi.set(__self__, "namespace_id", namespace_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the service.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the service.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsConfigs")
    def dns_configs(self) -> Sequence['outputs.GetServiceDnsConfigResult']:
        """
        Complex type that contains information about the resource record sets that you want Amazon Route 53 to create when you register an instance. See `dns_config` Block for details.
        """
        return pulumi.get(self, "dns_configs")

    @property
    @pulumi.getter(name="healthCheckConfigs")
    def health_check_configs(self) -> Sequence['outputs.GetServiceHealthCheckConfigResult']:
        """
        Complex type that contains settings for an optional health check. Only for Public DNS namespaces. See `health_check_config` Block for details.
        """
        return pulumi.get(self, "health_check_configs")

    @property
    @pulumi.getter(name="healthCheckCustomConfigs")
    def health_check_custom_configs(self) -> Sequence['outputs.GetServiceHealthCheckCustomConfigResult']:
        """
        A complex type that contains settings for ECS managed health checks. See `health_check_custom_config` Block for details.
        """
        return pulumi.get(self, "health_check_custom_configs")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> builtins.str:
        """
        ID of the namespace to use for DNS configuration.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")


class AwaitableGetServiceResult(GetServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceResult(
            arn=self.arn,
            description=self.description,
            dns_configs=self.dns_configs,
            health_check_configs=self.health_check_configs,
            health_check_custom_configs=self.health_check_custom_configs,
            id=self.id,
            name=self.name,
            namespace_id=self.namespace_id,
            region=self.region,
            tags=self.tags)


def get_service(name: Optional[builtins.str] = None,
                namespace_id: Optional[builtins.str] = None,
                region: Optional[builtins.str] = None,
                tags: Optional[Mapping[str, builtins.str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceResult:
    """
    Retrieves information about a Service Discovery Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.servicediscovery.get_service(name="example",
        namespace_id="NAMESPACE_ID_VALUE")
    ```


    :param builtins.str name: Name of the service.
    :param builtins.str namespace_id: ID of the namespace that the service belongs to.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespaceId'] = namespace_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:servicediscovery/getService:getService', __args__, opts=opts, typ=GetServiceResult).value

    return AwaitableGetServiceResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        dns_configs=pulumi.get(__ret__, 'dns_configs'),
        health_check_configs=pulumi.get(__ret__, 'health_check_configs'),
        health_check_custom_configs=pulumi.get(__ret__, 'health_check_custom_configs'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        namespace_id=pulumi.get(__ret__, 'namespace_id'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_service_output(name: Optional[pulumi.Input[builtins.str]] = None,
                       namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                       region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceResult]:
    """
    Retrieves information about a Service Discovery Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.servicediscovery.get_service(name="example",
        namespace_id="NAMESPACE_ID_VALUE")
    ```


    :param builtins.str name: Name of the service.
    :param builtins.str namespace_id: ID of the namespace that the service belongs to.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespaceId'] = namespace_id
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:servicediscovery/getService:getService', __args__, opts=opts, typ=GetServiceResult)
    return __ret__.apply(lambda __response__: GetServiceResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        dns_configs=pulumi.get(__response__, 'dns_configs'),
        health_check_configs=pulumi.get(__response__, 'health_check_configs'),
        health_check_custom_configs=pulumi.get(__response__, 'health_check_custom_configs'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        namespace_id=pulumi.get(__response__, 'namespace_id'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
